<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message containing information of one individual backend.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Backend</code>
 */
class Backend extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies the balancing mode for the backend.
     * When choosing a balancing mode, you need to consider the loadBalancingScheme, and protocol for the backend service, as well as the type of backend (instance group or NEG).
     * - If the load balancing mode is CONNECTION, then the load is spread based on how many concurrent connections the backend can handle.
     * You can use the CONNECTION balancing mode if the protocol for the backend service is SSL, TCP, or UDP.
     * If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and TCP Proxy load balancers), you must also specify exactly one of the following parameters: maxConnections (except for regional managed instance groups), maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
     * If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/UDP Load Balancers) or EXTERNAL  (Network Load Balancing), you cannot specify any additional parameters.
     * - If the load balancing mode is RATE, the load is spread based on the rate of HTTP requests per second (RPS).
     * You can use the RATE balancing mode if the protocol for the backend service is HTTP, HTTP2, or HTTPS. You must specify exactly one of the following parameters: maxRate (except for regional managed instance groups), maxRatePerInstance, or maxRatePerEndpoint.
     * - If the load balancing mode is UTILIZATION, the load is spread based on the backend utilization of instances in an instance group.
     * You can use the UTILIZATION balancing mode if the loadBalancingScheme of the backend service is EXTERNAL (except Network Load Balancing), INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED and the backends are instance groups. There are no restrictions on the backend service protocol.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Backend.BalancingMode balancing_mode = 161850761;</code>
     */
    private $balancing_mode = 0;
    /**
     * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION). Default value is 1, which means the group will serve up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. Valid range is 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
     * This cannot be used for Internal TCP/UDP Load Balancing and Network Load Balancing.
     *
     * Generated from protobuf field <code>float capacity_scaler = 47522701;</code>
     */
    private $capacity_scaler = 0.0;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
     *
     * Generated from protobuf field <code>bool failover = 138892530;</code>
     */
    private $failover = false;
    /**
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type of backend that a backend service supports depends on the backend service's loadBalancingScheme.
     * - When the loadBalancingScheme for the backend service is EXTERNAL (except Network Load Balancing),  INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED , the backend can be either an instance group or a NEG. The backends on the backend service must be either all instance groups or all NEGs. You cannot mix instance group and NEG backends on the same backend service.
     * - When the loadBalancingScheme for the backend service is EXTERNAL for Network Load Balancing or INTERNAL for Internal TCP/UDP Load Balancing, the backend must be an instance group. NEGs are not supported.
     * For regional services, the backend must be in the same region as the backend service.
     * You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
     *
     * Generated from protobuf field <code>string group = 98629247;</code>
     */
    private $group = '';
    /**
     * Defines a target maximum number of simultaneous connections that the backend can handle. Valid for network endpoint group and instance group backends (except for regional managed instance groups). If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter, maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections = 110652154;</code>
     */
    private $max_connections = 0;
    /**
     * Defines a target maximum number of simultaneous connections for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a maximum number of target maximum simultaneous connections for the NEG. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter, maxConnections, or maxConnectionsPerInstance.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections_per_endpoint = 216904604;</code>
     */
    private $max_connections_per_endpoint = 0;
    /**
     * Defines a target maximum number of simultaneous connections for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum number of simultaneous connections for the whole instance group. If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter,  maxConnections, or maxConnectionsPerEndpoint.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections_per_instance = 104671900;</code>
     */
    private $max_connections_per_instance = 0;
    /**
     * Defines a maximum number of HTTP requests per second (RPS) that the backend can handle. Valid for network endpoint group and instance group backends (except for regional managed instance groups). Must not be defined if the backend is a managed instance group that uses autoscaling based on load balancing.
     * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is RATE, you must specify maxRate, maxRatePerInstance, or maxRatePerEndpoint.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_rate = 139599579;</code>
     */
    private $max_rate = 0;
    /**
     * Defines a maximum target for requests per second (RPS) for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a target maximum rate for the NEG.
     * If the backend's balancingMode is RATE, you must specify either this parameter, maxRate (except for regional managed instance groups), or maxRatePerInstance.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>float max_rate_per_endpoint = 129832283;</code>
     */
    private $max_rate_per_endpoint = 0.0;
    /**
     * Defines a maximum target for requests per second (RPS) for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum rate for the whole instance group.
     * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is RATE, you must specify either this parameter, maxRate (except for regional managed instance groups), or maxRatePerEndpoint.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>float max_rate_per_instance = 17599579;</code>
     */
    private $max_rate_per_instance = 0.0;
    /**
     * Defines the maximum average backend utilization of a backend VM in an instance group. The valid range is [0.0, 1.0]. This is an optional parameter if the backend's balancingMode is UTILIZATION.
     * This parameter can be used in conjunction with maxRate, maxRatePerInstance, maxConnections (except for regional managed instance groups), or maxConnectionsPerInstance.
     *
     * Generated from protobuf field <code>float max_utilization = 148192199;</code>
     */
    private $max_utilization = 0.0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $balancing_mode
     *           Specifies the balancing mode for the backend.
     *           When choosing a balancing mode, you need to consider the loadBalancingScheme, and protocol for the backend service, as well as the type of backend (instance group or NEG).
     *           - If the load balancing mode is CONNECTION, then the load is spread based on how many concurrent connections the backend can handle.
     *           You can use the CONNECTION balancing mode if the protocol for the backend service is SSL, TCP, or UDP.
     *           If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and TCP Proxy load balancers), you must also specify exactly one of the following parameters: maxConnections (except for regional managed instance groups), maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
     *           If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/UDP Load Balancers) or EXTERNAL  (Network Load Balancing), you cannot specify any additional parameters.
     *           - If the load balancing mode is RATE, the load is spread based on the rate of HTTP requests per second (RPS).
     *           You can use the RATE balancing mode if the protocol for the backend service is HTTP, HTTP2, or HTTPS. You must specify exactly one of the following parameters: maxRate (except for regional managed instance groups), maxRatePerInstance, or maxRatePerEndpoint.
     *           - If the load balancing mode is UTILIZATION, the load is spread based on the backend utilization of instances in an instance group.
     *           You can use the UTILIZATION balancing mode if the loadBalancingScheme of the backend service is EXTERNAL (except Network Load Balancing), INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED and the backends are instance groups. There are no restrictions on the backend service protocol.
     *     @type float $capacity_scaler
     *           A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION). Default value is 1, which means the group will serve up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. Valid range is 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
     *           This cannot be used for Internal TCP/UDP Load Balancing and Network Load Balancing.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type bool $failover
     *           This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
     *     @type string $group
     *           The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type of backend that a backend service supports depends on the backend service's loadBalancingScheme.
     *           - When the loadBalancingScheme for the backend service is EXTERNAL (except Network Load Balancing),  INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED , the backend can be either an instance group or a NEG. The backends on the backend service must be either all instance groups or all NEGs. You cannot mix instance group and NEG backends on the same backend service.
     *           - When the loadBalancingScheme for the backend service is EXTERNAL for Network Load Balancing or INTERNAL for Internal TCP/UDP Load Balancing, the backend must be an instance group. NEGs are not supported.
     *           For regional services, the backend must be in the same region as the backend service.
     *           You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
     *     @type int $max_connections
     *           Defines a target maximum number of simultaneous connections that the backend can handle. Valid for network endpoint group and instance group backends (except for regional managed instance groups). If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter, maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
     *           Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *     @type int $max_connections_per_endpoint
     *           Defines a target maximum number of simultaneous connections for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a maximum number of target maximum simultaneous connections for the NEG. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter, maxConnections, or maxConnectionsPerInstance.
     *           Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *     @type int $max_connections_per_instance
     *           Defines a target maximum number of simultaneous connections for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum number of simultaneous connections for the whole instance group. If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter,  maxConnections, or maxConnectionsPerEndpoint.
     *           Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *     @type int $max_rate
     *           Defines a maximum number of HTTP requests per second (RPS) that the backend can handle. Valid for network endpoint group and instance group backends (except for regional managed instance groups). Must not be defined if the backend is a managed instance group that uses autoscaling based on load balancing.
     *           If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is RATE, you must specify maxRate, maxRatePerInstance, or maxRatePerEndpoint.
     *           Not available if the backend's balancingMode is CONNECTION.
     *     @type float $max_rate_per_endpoint
     *           Defines a maximum target for requests per second (RPS) for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a target maximum rate for the NEG.
     *           If the backend's balancingMode is RATE, you must specify either this parameter, maxRate (except for regional managed instance groups), or maxRatePerInstance.
     *           Not available if the backend's balancingMode is CONNECTION.
     *     @type float $max_rate_per_instance
     *           Defines a maximum target for requests per second (RPS) for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum rate for the whole instance group.
     *           If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is RATE, you must specify either this parameter, maxRate (except for regional managed instance groups), or maxRatePerEndpoint.
     *           Not available if the backend's balancingMode is CONNECTION.
     *     @type float $max_utilization
     *           Defines the maximum average backend utilization of a backend VM in an instance group. The valid range is [0.0, 1.0]. This is an optional parameter if the backend's balancingMode is UTILIZATION.
     *           This parameter can be used in conjunction with maxRate, maxRatePerInstance, maxConnections (except for regional managed instance groups), or maxConnectionsPerInstance.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies the balancing mode for the backend.
     * When choosing a balancing mode, you need to consider the loadBalancingScheme, and protocol for the backend service, as well as the type of backend (instance group or NEG).
     * - If the load balancing mode is CONNECTION, then the load is spread based on how many concurrent connections the backend can handle.
     * You can use the CONNECTION balancing mode if the protocol for the backend service is SSL, TCP, or UDP.
     * If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and TCP Proxy load balancers), you must also specify exactly one of the following parameters: maxConnections (except for regional managed instance groups), maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
     * If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/UDP Load Balancers) or EXTERNAL  (Network Load Balancing), you cannot specify any additional parameters.
     * - If the load balancing mode is RATE, the load is spread based on the rate of HTTP requests per second (RPS).
     * You can use the RATE balancing mode if the protocol for the backend service is HTTP, HTTP2, or HTTPS. You must specify exactly one of the following parameters: maxRate (except for regional managed instance groups), maxRatePerInstance, or maxRatePerEndpoint.
     * - If the load balancing mode is UTILIZATION, the load is spread based on the backend utilization of instances in an instance group.
     * You can use the UTILIZATION balancing mode if the loadBalancingScheme of the backend service is EXTERNAL (except Network Load Balancing), INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED and the backends are instance groups. There are no restrictions on the backend service protocol.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Backend.BalancingMode balancing_mode = 161850761;</code>
     * @return int
     */
    public function getBalancingMode()
    {
        return $this->balancing_mode;
    }

    /**
     * Specifies the balancing mode for the backend.
     * When choosing a balancing mode, you need to consider the loadBalancingScheme, and protocol for the backend service, as well as the type of backend (instance group or NEG).
     * - If the load balancing mode is CONNECTION, then the load is spread based on how many concurrent connections the backend can handle.
     * You can use the CONNECTION balancing mode if the protocol for the backend service is SSL, TCP, or UDP.
     * If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and TCP Proxy load balancers), you must also specify exactly one of the following parameters: maxConnections (except for regional managed instance groups), maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
     * If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/UDP Load Balancers) or EXTERNAL  (Network Load Balancing), you cannot specify any additional parameters.
     * - If the load balancing mode is RATE, the load is spread based on the rate of HTTP requests per second (RPS).
     * You can use the RATE balancing mode if the protocol for the backend service is HTTP, HTTP2, or HTTPS. You must specify exactly one of the following parameters: maxRate (except for regional managed instance groups), maxRatePerInstance, or maxRatePerEndpoint.
     * - If the load balancing mode is UTILIZATION, the load is spread based on the backend utilization of instances in an instance group.
     * You can use the UTILIZATION balancing mode if the loadBalancingScheme of the backend service is EXTERNAL (except Network Load Balancing), INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED and the backends are instance groups. There are no restrictions on the backend service protocol.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Backend.BalancingMode balancing_mode = 161850761;</code>
     * @param int $var
     * @return $this
     */
    public function setBalancingMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Backend\BalancingMode::class);
        $this->balancing_mode = $var;

        return $this;
    }

    /**
     * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION). Default value is 1, which means the group will serve up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. Valid range is 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
     * This cannot be used for Internal TCP/UDP Load Balancing and Network Load Balancing.
     *
     * Generated from protobuf field <code>float capacity_scaler = 47522701;</code>
     * @return float
     */
    public function getCapacityScaler()
    {
        return $this->capacity_scaler;
    }

    /**
     * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION). Default value is 1, which means the group will serve up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. Valid range is 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
     * This cannot be used for Internal TCP/UDP Load Balancing and Network Load Balancing.
     *
     * Generated from protobuf field <code>float capacity_scaler = 47522701;</code>
     * @param float $var
     * @return $this
     */
    public function setCapacityScaler($var)
    {
        GPBUtil::checkFloat($var);
        $this->capacity_scaler = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
     *
     * Generated from protobuf field <code>bool failover = 138892530;</code>
     * @return bool
     */
    public function getFailover()
    {
        return $this->failover;
    }

    /**
     * This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
     *
     * Generated from protobuf field <code>bool failover = 138892530;</code>
     * @param bool $var
     * @return $this
     */
    public function setFailover($var)
    {
        GPBUtil::checkBool($var);
        $this->failover = $var;

        return $this;
    }

    /**
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type of backend that a backend service supports depends on the backend service's loadBalancingScheme.
     * - When the loadBalancingScheme for the backend service is EXTERNAL (except Network Load Balancing),  INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED , the backend can be either an instance group or a NEG. The backends on the backend service must be either all instance groups or all NEGs. You cannot mix instance group and NEG backends on the same backend service.
     * - When the loadBalancingScheme for the backend service is EXTERNAL for Network Load Balancing or INTERNAL for Internal TCP/UDP Load Balancing, the backend must be an instance group. NEGs are not supported.
     * For regional services, the backend must be in the same region as the backend service.
     * You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
     *
     * Generated from protobuf field <code>string group = 98629247;</code>
     * @return string
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type of backend that a backend service supports depends on the backend service's loadBalancingScheme.
     * - When the loadBalancingScheme for the backend service is EXTERNAL (except Network Load Balancing),  INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED , the backend can be either an instance group or a NEG. The backends on the backend service must be either all instance groups or all NEGs. You cannot mix instance group and NEG backends on the same backend service.
     * - When the loadBalancingScheme for the backend service is EXTERNAL for Network Load Balancing or INTERNAL for Internal TCP/UDP Load Balancing, the backend must be an instance group. NEGs are not supported.
     * For regional services, the backend must be in the same region as the backend service.
     * You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
     *
     * Generated from protobuf field <code>string group = 98629247;</code>
     * @param string $var
     * @return $this
     */
    public function setGroup($var)
    {
        GPBUtil::checkString($var, True);
        $this->group = $var;

        return $this;
    }

    /**
     * Defines a target maximum number of simultaneous connections that the backend can handle. Valid for network endpoint group and instance group backends (except for regional managed instance groups). If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter, maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections = 110652154;</code>
     * @return int
     */
    public function getMaxConnections()
    {
        return $this->max_connections;
    }

    /**
     * Defines a target maximum number of simultaneous connections that the backend can handle. Valid for network endpoint group and instance group backends (except for regional managed instance groups). If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter, maxConnectionsPerInstance, or maxConnectionsPerEndpoint.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections = 110652154;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxConnections($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_connections = $var;

        return $this;
    }

    /**
     * Defines a target maximum number of simultaneous connections for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a maximum number of target maximum simultaneous connections for the NEG. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter, maxConnections, or maxConnectionsPerInstance.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections_per_endpoint = 216904604;</code>
     * @return int
     */
    public function getMaxConnectionsPerEndpoint()
    {
        return $this->max_connections_per_endpoint;
    }

    /**
     * Defines a target maximum number of simultaneous connections for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a maximum number of target maximum simultaneous connections for the NEG. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter, maxConnections, or maxConnectionsPerInstance.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections_per_endpoint = 216904604;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxConnectionsPerEndpoint($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_connections_per_endpoint = $var;

        return $this;
    }

    /**
     * Defines a target maximum number of simultaneous connections for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum number of simultaneous connections for the whole instance group. If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter,  maxConnections, or maxConnectionsPerEndpoint.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections_per_instance = 104671900;</code>
     * @return int
     */
    public function getMaxConnectionsPerInstance()
    {
        return $this->max_connections_per_instance;
    }

    /**
     * Defines a target maximum number of simultaneous connections for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum number of simultaneous connections for the whole instance group. If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is CONNECTION, and backend is attached to a backend service whose loadBalancingScheme is EXTERNAL (except Network Load Balancing), you must specify either this parameter,  maxConnections, or maxConnectionsPerEndpoint.
     * Not available if the backend's balancingMode is RATE. Cannot be specified for Network Load Balancing or Internal TCP/UDP Load Balancing, even though those load balancers require a balancing mode of CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_connections_per_instance = 104671900;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxConnectionsPerInstance($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_connections_per_instance = $var;

        return $this;
    }

    /**
     * Defines a maximum number of HTTP requests per second (RPS) that the backend can handle. Valid for network endpoint group and instance group backends (except for regional managed instance groups). Must not be defined if the backend is a managed instance group that uses autoscaling based on load balancing.
     * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is RATE, you must specify maxRate, maxRatePerInstance, or maxRatePerEndpoint.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_rate = 139599579;</code>
     * @return int
     */
    public function getMaxRate()
    {
        return $this->max_rate;
    }

    /**
     * Defines a maximum number of HTTP requests per second (RPS) that the backend can handle. Valid for network endpoint group and instance group backends (except for regional managed instance groups). Must not be defined if the backend is a managed instance group that uses autoscaling based on load balancing.
     * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is RATE, you must specify maxRate, maxRatePerInstance, or maxRatePerEndpoint.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>int32 max_rate = 139599579;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxRate($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_rate = $var;

        return $this;
    }

    /**
     * Defines a maximum target for requests per second (RPS) for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a target maximum rate for the NEG.
     * If the backend's balancingMode is RATE, you must specify either this parameter, maxRate (except for regional managed instance groups), or maxRatePerInstance.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>float max_rate_per_endpoint = 129832283;</code>
     * @return float
     */
    public function getMaxRatePerEndpoint()
    {
        return $this->max_rate_per_endpoint;
    }

    /**
     * Defines a maximum target for requests per second (RPS) for an endpoint of a NEG. This is multiplied by the number of endpoints in the NEG to implicitly calculate a target maximum rate for the NEG.
     * If the backend's balancingMode is RATE, you must specify either this parameter, maxRate (except for regional managed instance groups), or maxRatePerInstance.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>float max_rate_per_endpoint = 129832283;</code>
     * @param float $var
     * @return $this
     */
    public function setMaxRatePerEndpoint($var)
    {
        GPBUtil::checkFloat($var);
        $this->max_rate_per_endpoint = $var;

        return $this;
    }

    /**
     * Defines a maximum target for requests per second (RPS) for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum rate for the whole instance group.
     * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is RATE, you must specify either this parameter, maxRate (except for regional managed instance groups), or maxRatePerEndpoint.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>float max_rate_per_instance = 17599579;</code>
     * @return float
     */
    public function getMaxRatePerInstance()
    {
        return $this->max_rate_per_instance;
    }

    /**
     * Defines a maximum target for requests per second (RPS) for a single VM in a backend instance group. This is multiplied by the number of instances in the instance group to implicitly calculate a target maximum rate for the whole instance group.
     * If the backend's balancingMode is UTILIZATION, this is an optional parameter. If the backend's balancingMode is RATE, you must specify either this parameter, maxRate (except for regional managed instance groups), or maxRatePerEndpoint.
     * Not available if the backend's balancingMode is CONNECTION.
     *
     * Generated from protobuf field <code>float max_rate_per_instance = 17599579;</code>
     * @param float $var
     * @return $this
     */
    public function setMaxRatePerInstance($var)
    {
        GPBUtil::checkFloat($var);
        $this->max_rate_per_instance = $var;

        return $this;
    }

    /**
     * Defines the maximum average backend utilization of a backend VM in an instance group. The valid range is [0.0, 1.0]. This is an optional parameter if the backend's balancingMode is UTILIZATION.
     * This parameter can be used in conjunction with maxRate, maxRatePerInstance, maxConnections (except for regional managed instance groups), or maxConnectionsPerInstance.
     *
     * Generated from protobuf field <code>float max_utilization = 148192199;</code>
     * @return float
     */
    public function getMaxUtilization()
    {
        return $this->max_utilization;
    }

    /**
     * Defines the maximum average backend utilization of a backend VM in an instance group. The valid range is [0.0, 1.0]. This is an optional parameter if the backend's balancingMode is UTILIZATION.
     * This parameter can be used in conjunction with maxRate, maxRatePerInstance, maxConnections (except for regional managed instance groups), or maxConnectionsPerInstance.
     *
     * Generated from protobuf field <code>float max_utilization = 148192199;</code>
     * @param float $var
     * @return $this
     */
    public function setMaxUtilization($var)
    {
        GPBUtil::checkFloat($var);
        $this->max_utilization = $var;

        return $this;
    }

}

