<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/documentai/v1/document_processor_service.proto

namespace Google\Cloud\DocumentAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for the
 * [ProcessDocument][google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument]
 * method.
 *
 * Generated from protobuf message <code>google.cloud.documentai.v1.ProcessRequest</code>
 */
class ProcessRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the
     * [Processor][google.cloud.documentai.v1.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion]
     * to use for processing. If a
     * [Processor][google.cloud.documentai.v1.Processor] is specified, the server
     * will use its [default
     * version][google.cloud.documentai.v1.Processor.default_processor_version].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $name = '';
    /**
     * Whether human review should be skipped for this request. Default to
     * `false`.
     *
     * Generated from protobuf field <code>bool skip_human_review = 3;</code>
     */
    private $skip_human_review = false;
    /**
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    private $field_mask = null;
    /**
     * Inference-time options for the process API
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.ProcessOptions process_options = 7;</code>
     */
    private $process_options = null;
    /**
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    protected $source;

    /**
     * @param string $name Required. The resource name of the
     *                     [Processor][google.cloud.documentai.v1.Processor] or
     *                     [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion]
     *                     to use for processing. If a
     *                     [Processor][google.cloud.documentai.v1.Processor] is specified, the server
     *                     will use its [default
     *                     version][google.cloud.documentai.v1.Processor.default_processor_version].
     *                     Format: `projects/{project}/locations/{location}/processors/{processor}`,
     *                     or
     *                     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     *
     * @return \Google\Cloud\DocumentAI\V1\ProcessRequest
     *
     * @experimental
     */
    public static function build(string $name): self
    {
        return (new self())
            ->setName($name);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\DocumentAI\V1\Document $inline_document
     *           An inline document proto.
     *     @type \Google\Cloud\DocumentAI\V1\RawDocument $raw_document
     *           A raw document content (bytes).
     *     @type \Google\Cloud\DocumentAI\V1\GcsDocument $gcs_document
     *           A raw document on Google Cloud Storage.
     *     @type string $name
     *           Required. The resource name of the
     *           [Processor][google.cloud.documentai.v1.Processor] or
     *           [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion]
     *           to use for processing. If a
     *           [Processor][google.cloud.documentai.v1.Processor] is specified, the server
     *           will use its [default
     *           version][google.cloud.documentai.v1.Processor.default_processor_version].
     *           Format: `projects/{project}/locations/{location}/processors/{processor}`,
     *           or
     *           `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     *     @type bool $skip_human_review
     *           Whether human review should be skipped for this request. Default to
     *           `false`.
     *     @type \Google\Protobuf\FieldMask $field_mask
     *           Specifies which fields to include in the
     *           [ProcessResponse.document][google.cloud.documentai.v1.ProcessResponse.document]
     *           output. Only supports top-level document and pages field, so it must be in
     *           the form of `{document_field_name}` or `pages.{page_field_name}`.
     *     @type \Google\Cloud\DocumentAI\V1\ProcessOptions $process_options
     *           Inference-time options for the process API
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. The labels with user-defined metadata for the request.
     *           Label keys and values can be no longer than 63 characters
     *           (Unicode codepoints) and can only contain lowercase letters, numeric
     *           characters, underscores, and dashes. International characters are allowed.
     *           Label values are optional. Label keys must start with a letter.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Documentai\V1\DocumentProcessorService::initOnce();
        parent::__construct($data);
    }

    /**
     * An inline document proto.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.Document inline_document = 4;</code>
     * @return \Google\Cloud\DocumentAI\V1\Document|null
     */
    public function getInlineDocument()
    {
        return $this->readOneof(4);
    }

    public function hasInlineDocument()
    {
        return $this->hasOneof(4);
    }

    /**
     * An inline document proto.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.Document inline_document = 4;</code>
     * @param \Google\Cloud\DocumentAI\V1\Document $var
     * @return $this
     */
    public function setInlineDocument($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DocumentAI\V1\Document::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * A raw document content (bytes).
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.RawDocument raw_document = 5;</code>
     * @return \Google\Cloud\DocumentAI\V1\RawDocument|null
     */
    public function getRawDocument()
    {
        return $this->readOneof(5);
    }

    public function hasRawDocument()
    {
        return $this->hasOneof(5);
    }

    /**
     * A raw document content (bytes).
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.RawDocument raw_document = 5;</code>
     * @param \Google\Cloud\DocumentAI\V1\RawDocument $var
     * @return $this
     */
    public function setRawDocument($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DocumentAI\V1\RawDocument::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * A raw document on Google Cloud Storage.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.GcsDocument gcs_document = 8;</code>
     * @return \Google\Cloud\DocumentAI\V1\GcsDocument|null
     */
    public function getGcsDocument()
    {
        return $this->readOneof(8);
    }

    public function hasGcsDocument()
    {
        return $this->hasOneof(8);
    }

    /**
     * A raw document on Google Cloud Storage.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.GcsDocument gcs_document = 8;</code>
     * @param \Google\Cloud\DocumentAI\V1\GcsDocument $var
     * @return $this
     */
    public function setGcsDocument($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DocumentAI\V1\GcsDocument::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Required. The resource name of the
     * [Processor][google.cloud.documentai.v1.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion]
     * to use for processing. If a
     * [Processor][google.cloud.documentai.v1.Processor] is specified, the server
     * will use its [default
     * version][google.cloud.documentai.v1.Processor.default_processor_version].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The resource name of the
     * [Processor][google.cloud.documentai.v1.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion]
     * to use for processing. If a
     * [Processor][google.cloud.documentai.v1.Processor] is specified, the server
     * will use its [default
     * version][google.cloud.documentai.v1.Processor.default_processor_version].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Whether human review should be skipped for this request. Default to
     * `false`.
     *
     * Generated from protobuf field <code>bool skip_human_review = 3;</code>
     * @return bool
     */
    public function getSkipHumanReview()
    {
        return $this->skip_human_review;
    }

    /**
     * Whether human review should be skipped for this request. Default to
     * `false`.
     *
     * Generated from protobuf field <code>bool skip_human_review = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setSkipHumanReview($var)
    {
        GPBUtil::checkBool($var);
        $this->skip_human_review = $var;

        return $this;
    }

    /**
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask field_mask = 6;</code>
     * @return \Google\Protobuf\FieldMask|null
     */
    public function getFieldMask()
    {
        return $this->field_mask;
    }

    public function hasFieldMask()
    {
        return isset($this->field_mask);
    }

    public function clearFieldMask()
    {
        unset($this->field_mask);
    }

    /**
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask field_mask = 6;</code>
     * @param \Google\Protobuf\FieldMask $var
     * @return $this
     */
    public function setFieldMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\FieldMask::class);
        $this->field_mask = $var;

        return $this;
    }

    /**
     * Inference-time options for the process API
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.ProcessOptions process_options = 7;</code>
     * @return \Google\Cloud\DocumentAI\V1\ProcessOptions|null
     */
    public function getProcessOptions()
    {
        return $this->process_options;
    }

    public function hasProcessOptions()
    {
        return isset($this->process_options);
    }

    public function clearProcessOptions()
    {
        unset($this->process_options);
    }

    /**
     * Inference-time options for the process API
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.ProcessOptions process_options = 7;</code>
     * @param \Google\Cloud\DocumentAI\V1\ProcessOptions $var
     * @return $this
     */
    public function setProcessOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DocumentAI\V1\ProcessOptions::class);
        $this->process_options = $var;

        return $this;
    }

    /**
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

}

