<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1beta/engine.proto

namespace Google\Cloud\DiscoveryEngine\V1beta\Engine\ChatEngineConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configurations for generating a Dialogflow agent.
 * Note that these configurations are one-time consumed by
 * and passed to Dialogflow service. It means they cannot be retrieved using
 * [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
 * or
 * [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
 * API after engine creation.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig</code>
 */
class AgentCreationConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the company, organization or other entity that the agent
     * represents. Used for knowledge connector LLM prompt and for knowledge
     * search.
     *
     * Generated from protobuf field <code>string business = 1;</code>
     */
    protected $business = '';
    /**
     * Required. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes.
     *
     * Generated from protobuf field <code>string default_language_code = 2;</code>
     */
    protected $default_language_code = '';
    /**
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $time_zone = '';
    /**
     * Agent location for Agent creation, supported values: global/us/eu.
     * If not provided, us Engine will create Agent using us-central-1 by
     * default; eu Engine will create Agent using eu-west-1 by default.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     */
    protected $location = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $business
     *           Name of the company, organization or other entity that the agent
     *           represents. Used for knowledge connector LLM prompt and for knowledge
     *           search.
     *     @type string $default_language_code
     *           Required. The default language of the agent as a language tag.
     *           See [Language
     *           Support](https://cloud.google.com/dialogflow/docs/reference/language)
     *           for a list of the currently supported language codes.
     *     @type string $time_zone
     *           Required. The time zone of the agent from the [time zone
     *           database](https://www.iana.org/time-zones), e.g., America/New_York,
     *           Europe/Paris.
     *     @type string $location
     *           Agent location for Agent creation, supported values: global/us/eu.
     *           If not provided, us Engine will create Agent using us-central-1 by
     *           default; eu Engine will create Agent using eu-west-1 by default.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1Beta\Engine::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of the company, organization or other entity that the agent
     * represents. Used for knowledge connector LLM prompt and for knowledge
     * search.
     *
     * Generated from protobuf field <code>string business = 1;</code>
     * @return string
     */
    public function getBusiness()
    {
        return $this->business;
    }

    /**
     * Name of the company, organization or other entity that the agent
     * represents. Used for knowledge connector LLM prompt and for knowledge
     * search.
     *
     * Generated from protobuf field <code>string business = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setBusiness($var)
    {
        GPBUtil::checkString($var, True);
        $this->business = $var;

        return $this;
    }

    /**
     * Required. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes.
     *
     * Generated from protobuf field <code>string default_language_code = 2;</code>
     * @return string
     */
    public function getDefaultLanguageCode()
    {
        return $this->default_language_code;
    }

    /**
     * Required. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes.
     *
     * Generated from protobuf field <code>string default_language_code = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDefaultLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->default_language_code = $var;

        return $this;
    }

    /**
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * Agent location for Agent creation, supported values: global/us/eu.
     * If not provided, us Engine will create Agent using us-central-1 by
     * default; eu Engine will create Agent using eu-west-1 by default.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Agent location for Agent creation, supported values: global/us/eu.
     * If not provided, us Engine will create Agent using us-central-1 by
     * default; eu Engine will create Agent using eu-west-1 by default.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

}


