<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Parameters that describe the nodes in a cluster.
 * GKE Autopilot clusters do not
 * recognize parameters in `NodeConfig`. Use
 * [AutoprovisioningNodePoolDefaults][google.container.v1.AutoprovisioningNodePoolDefaults]
 * instead.
 *
 * Generated from protobuf message <code>google.container.v1.NodeConfig</code>
 */
class NodeConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     * If unspecified, the default machine type is `e2-medium`.
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     */
    private $machine_type = '';
    /**
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     * If unspecified, the default disk size is 100GB.
     *
     * Generated from protobuf field <code>int32 disk_size_gb = 2;</code>
     */
    private $disk_size_gb = 0;
    /**
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     * The following scopes are recommended, but not required, and by default are
     * not included:
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     *
     * Generated from protobuf field <code>repeated string oauth_scopes = 3;</code>
     */
    private $oauth_scopes;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     *
     * Generated from protobuf field <code>string service_account = 9;</code>
     */
    private $service_account = '';
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     * The total size of all keys and values must be less than 512 KB.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4;</code>
     */
    private $metadata;
    /**
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     *
     * Generated from protobuf field <code>string image_type = 5;</code>
     */
    private $image_type = '';
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     */
    private $labels;
    /**
     * The number of local SSD disks to be attached to the node.
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     *
     * Generated from protobuf field <code>int32 local_ssd_count = 7;</code>
     */
    private $local_ssd_count = 0;
    /**
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     *
     * Generated from protobuf field <code>repeated string tags = 8;</code>
     */
    private $tags;
    /**
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     *
     * Generated from protobuf field <code>bool preemptible = 10;</code>
     */
    private $preemptible = false;
    /**
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    private $accelerators;
    /**
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     * If unspecified, the default disk type is 'pd-standard'
     *
     * Generated from protobuf field <code>string disk_type = 12;</code>
     */
    private $disk_type = '';
    /**
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     *
     * Generated from protobuf field <code>string min_cpu_platform = 13;</code>
     */
    private $min_cpu_platform = '';
    /**
     * The workload metadata configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    private $workload_metadata_config = null;
    /**
     * List of kubernetes taints to be applied to each node.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    private $taints;
    /**
     * Sandbox configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    private $sandbox_config = null;
    /**
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     *
     * Generated from protobuf field <code>string node_group = 18;</code>
     */
    private $node_group = '';
    /**
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    private $reservation_affinity = null;
    /**
     * Shielded Instance options.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    private $shielded_instance_config = null;
    /**
     * Parameters that can be configured on Linux nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     */
    private $linux_node_config = null;
    /**
     * Node kubelet configs.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     */
    private $kubelet_config = null;
    /**
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     *
     * Generated from protobuf field <code>string boot_disk_kms_key = 23;</code>
     */
    private $boot_disk_kms_key = '';
    /**
     * Google Container File System (image streaming) configs.
     *
     * Generated from protobuf field <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     */
    private $gcfs_config = null;
    /**
     * Advanced features for the Compute Engine VM.
     *
     * Generated from protobuf field <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     */
    private $advanced_machine_features = null;
    /**
     * Enable or disable gvnic in the node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    private $gvnic = null;
    /**
     * Spot flag for enabling Spot VM, which is a rebrand of
     * the existing preemptible flag.
     *
     * Generated from protobuf field <code>bool spot = 32;</code>
     */
    private $spot = false;
    /**
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     *
     * Generated from protobuf field <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     */
    private $confidential_nodes = null;
    /**
     * Enable or disable NCCL fast socket for the node pool.
     *
     * Generated from protobuf field <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     */
    private $fast_socket = null;
    /**
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     *
     * Generated from protobuf field <code>map<string, string> resource_labels = 37;</code>
     */
    private $resource_labels;
    /**
     * Logging configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     */
    private $logging_config = null;
    /**
     * Parameters that can be configured on Windows nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     */
    private $windows_node_config = null;
    /**
     * Parameters for using raw-block Local NVMe SSDs.
     *
     * Generated from protobuf field <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     */
    private $local_nvme_ssd_block_config = null;
    /**
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     *
     * Generated from protobuf field <code>.google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;</code>
     */
    private $ephemeral_storage_local_ssd_config = null;
    /**
     * Parameters for node pools to be backed by shared sole tenant node groups.
     *
     * Generated from protobuf field <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     */
    private $sole_tenant_config = null;
    /**
     * A map of resource manager tag keys and values to be attached to the nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     */
    private $resource_manager_tags = null;
    /**
     * Optional. Reserved for future use.
     *
     * Generated from protobuf field <code>bool enable_confidential_storage = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enable_confidential_storage = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $machine_type
     *           The name of a Google Compute Engine [machine
     *           type](https://cloud.google.com/compute/docs/machine-types)
     *           If unspecified, the default machine type is `e2-medium`.
     *     @type int $disk_size_gb
     *           Size of the disk attached to each node, specified in GB.
     *           The smallest allowed disk size is 10GB.
     *           If unspecified, the default disk size is 100GB.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $oauth_scopes
     *           The set of Google API scopes to be made available on all of the
     *           node VMs under the "default" service account.
     *           The following scopes are recommended, but not required, and by default are
     *           not included:
     *           * `https://www.googleapis.com/auth/compute` is required for mounting
     *           persistent storage on your nodes.
     *           * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     *           communicating with **gcr.io**
     *           (the [Google Container
     *           Registry](https://cloud.google.com/container-registry/)).
     *           If unspecified, no scopes are added, unless Cloud Logging or Cloud
     *           Monitoring are enabled, in which case their required scopes will be added.
     *     @type string $service_account
     *           The Google Cloud Platform Service Account to be used by the node VMs.
     *           Specify the email address of the Service Account; otherwise, if no Service
     *           Account is specified, the "default" service account is used.
     *     @type array|\Google\Protobuf\Internal\MapField $metadata
     *           The metadata key/value pairs assigned to instances in the cluster.
     *           Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     *           in length. These are reflected as part of a URL in the metadata server.
     *           Additionally, to avoid ambiguity, keys must not conflict with any other
     *           metadata keys for the project or be one of the reserved keys:
     *            - "cluster-location"
     *            - "cluster-name"
     *            - "cluster-uid"
     *            - "configure-sh"
     *            - "containerd-configure-sh"
     *            - "enable-os-login"
     *            - "gci-ensure-gke-docker"
     *            - "gci-metrics-enabled"
     *            - "gci-update-strategy"
     *            - "instance-template"
     *            - "kube-env"
     *            - "startup-script"
     *            - "user-data"
     *            - "disable-address-manager"
     *            - "windows-startup-script-ps1"
     *            - "common-psm1"
     *            - "k8s-node-setup-psm1"
     *            - "install-ssh-psm1"
     *            - "user-profile-psm1"
     *           Values are free-form strings, and only have meaning as interpreted by
     *           the image running in the instance. The only restriction placed on them is
     *           that each value's size must be less than or equal to 32 KB.
     *           The total size of all keys and values must be less than 512 KB.
     *     @type string $image_type
     *           The image type to use for this node. Note that for a given image type,
     *           the latest version of it will be used. Please see
     *           https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     *           available image types.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *           These will added in addition to any default label(s) that
     *           Kubernetes may apply to the node.
     *           In case of conflict in label keys, the applied set may differ depending on
     *           the Kubernetes version -- it's best to assume the behavior is undefined
     *           and conflicts should be avoided.
     *           For more information, including usage and the valid values, see:
     *           https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     *     @type int $local_ssd_count
     *           The number of local SSD disks to be attached to the node.
     *           The limit for this value is dependent upon the maximum number of
     *           disks available on a machine per zone. See:
     *           https://cloud.google.com/compute/docs/disks/local-ssd
     *           for more information.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tags
     *           The list of instance tags applied to all nodes. Tags are used to identify
     *           valid sources or targets for network firewalls and are specified by
     *           the client during cluster or node pool creation. Each tag within the list
     *           must comply with RFC1035.
     *     @type bool $preemptible
     *           Whether the nodes are created as preemptible VM instances. See:
     *           https://cloud.google.com/compute/docs/instances/preemptible for more
     *           information about preemptible VM instances.
     *     @type array<\Google\Cloud\Container\V1\AcceleratorConfig>|\Google\Protobuf\Internal\RepeatedField $accelerators
     *           A list of hardware accelerators to be attached to each node.
     *           See https://cloud.google.com/compute/docs/gpus for more information about
     *           support for GPUs.
     *     @type string $disk_type
     *           Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     *           'pd-balanced')
     *           If unspecified, the default disk type is 'pd-standard'
     *     @type string $min_cpu_platform
     *           Minimum CPU platform to be used by this instance. The instance may be
     *           scheduled on the specified or newer CPU platform. Applicable values are the
     *           friendly names of CPU platforms, such as
     *           `minCpuPlatform: "Intel Haswell"` or
     *           `minCpuPlatform: "Intel Sandy Bridge"`. For more
     *           information, read [how to specify min CPU
     *           platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     *     @type \Google\Cloud\Container\V1\WorkloadMetadataConfig $workload_metadata_config
     *           The workload metadata configuration for this node.
     *     @type array<\Google\Cloud\Container\V1\NodeTaint>|\Google\Protobuf\Internal\RepeatedField $taints
     *           List of kubernetes taints to be applied to each node.
     *           For more information, including usage and the valid values, see:
     *           https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     *     @type \Google\Cloud\Container\V1\SandboxConfig $sandbox_config
     *           Sandbox configuration for this node.
     *     @type string $node_group
     *           Setting this field will assign instances of this
     *           pool to run on the specified node group. This is useful for running
     *           workloads on [sole tenant
     *           nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     *     @type \Google\Cloud\Container\V1\ReservationAffinity $reservation_affinity
     *           The optional reservation affinity. Setting this field will apply
     *           the specified [Zonal Compute
     *           Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     *           to this node pool.
     *     @type \Google\Cloud\Container\V1\ShieldedInstanceConfig $shielded_instance_config
     *           Shielded Instance options.
     *     @type \Google\Cloud\Container\V1\LinuxNodeConfig $linux_node_config
     *           Parameters that can be configured on Linux nodes.
     *     @type \Google\Cloud\Container\V1\NodeKubeletConfig $kubelet_config
     *           Node kubelet configs.
     *     @type string $boot_disk_kms_key
     *           The Customer Managed Encryption Key used to encrypt the boot disk attached
     *           to each node in the node pool. This should be of the form
     *           projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     *           For more information about protecting resources with Cloud KMS Keys please
     *           see:
     *           https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     *     @type \Google\Cloud\Container\V1\GcfsConfig $gcfs_config
     *           Google Container File System (image streaming) configs.
     *     @type \Google\Cloud\Container\V1\AdvancedMachineFeatures $advanced_machine_features
     *           Advanced features for the Compute Engine VM.
     *     @type \Google\Cloud\Container\V1\VirtualNIC $gvnic
     *           Enable or disable gvnic in the node pool.
     *     @type bool $spot
     *           Spot flag for enabling Spot VM, which is a rebrand of
     *           the existing preemptible flag.
     *     @type \Google\Cloud\Container\V1\ConfidentialNodes $confidential_nodes
     *           Confidential nodes config.
     *           All the nodes in the node pool will be Confidential VM once enabled.
     *     @type \Google\Cloud\Container\V1\FastSocket $fast_socket
     *           Enable or disable NCCL fast socket for the node pool.
     *     @type array|\Google\Protobuf\Internal\MapField $resource_labels
     *           The resource labels for the node pool to use to annotate any related
     *           Google Compute Engine resources.
     *     @type \Google\Cloud\Container\V1\NodePoolLoggingConfig $logging_config
     *           Logging configuration.
     *     @type \Google\Cloud\Container\V1\WindowsNodeConfig $windows_node_config
     *           Parameters that can be configured on Windows nodes.
     *     @type \Google\Cloud\Container\V1\LocalNvmeSsdBlockConfig $local_nvme_ssd_block_config
     *           Parameters for using raw-block Local NVMe SSDs.
     *     @type \Google\Cloud\Container\V1\EphemeralStorageLocalSsdConfig $ephemeral_storage_local_ssd_config
     *           Parameters for the node ephemeral storage using Local SSDs.
     *           If unspecified, ephemeral storage is backed by the boot disk.
     *     @type \Google\Cloud\Container\V1\SoleTenantConfig $sole_tenant_config
     *           Parameters for node pools to be backed by shared sole tenant node groups.
     *     @type \Google\Cloud\Container\V1\ResourceManagerTags $resource_manager_tags
     *           A map of resource manager tag keys and values to be attached to the nodes.
     *     @type bool $enable_confidential_storage
     *           Optional. Reserved for future use.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     * If unspecified, the default machine type is `e2-medium`.
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     * If unspecified, the default machine type is `e2-medium`.
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     * If unspecified, the default disk size is 100GB.
     *
     * Generated from protobuf field <code>int32 disk_size_gb = 2;</code>
     * @return int
     */
    public function getDiskSizeGb()
    {
        return $this->disk_size_gb;
    }

    /**
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     * If unspecified, the default disk size is 100GB.
     *
     * Generated from protobuf field <code>int32 disk_size_gb = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     * The following scopes are recommended, but not required, and by default are
     * not included:
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     *
     * Generated from protobuf field <code>repeated string oauth_scopes = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getOauthScopes()
    {
        return $this->oauth_scopes;
    }

    /**
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     * The following scopes are recommended, but not required, and by default are
     * not included:
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     *
     * Generated from protobuf field <code>repeated string oauth_scopes = 3;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setOauthScopes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->oauth_scopes = $arr;

        return $this;
    }

    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     *
     * Generated from protobuf field <code>string service_account = 9;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     *
     * Generated from protobuf field <code>string service_account = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     * The total size of all keys and values must be less than 512 KB.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     * The total size of all keys and values must be less than 512 KB.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     *
     * Generated from protobuf field <code>string image_type = 5;</code>
     * @return string
     */
    public function getImageType()
    {
        return $this->image_type;
    }

    /**
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     *
     * Generated from protobuf field <code>string image_type = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setImageType($var)
    {
        GPBUtil::checkString($var, True);
        $this->image_type = $var;

        return $this;
    }

    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * The number of local SSD disks to be attached to the node.
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     *
     * Generated from protobuf field <code>int32 local_ssd_count = 7;</code>
     * @return int
     */
    public function getLocalSsdCount()
    {
        return $this->local_ssd_count;
    }

    /**
     * The number of local SSD disks to be attached to the node.
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     *
     * Generated from protobuf field <code>int32 local_ssd_count = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setLocalSsdCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->local_ssd_count = $var;

        return $this;
    }

    /**
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     *
     * Generated from protobuf field <code>repeated string tags = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     *
     * Generated from protobuf field <code>repeated string tags = 8;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tags = $arr;

        return $this;
    }

    /**
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     *
     * Generated from protobuf field <code>bool preemptible = 10;</code>
     * @return bool
     */
    public function getPreemptible()
    {
        return $this->preemptible;
    }

    /**
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     *
     * Generated from protobuf field <code>bool preemptible = 10;</code>
     * @param bool $var
     * @return $this
     */
    public function setPreemptible($var)
    {
        GPBUtil::checkBool($var);
        $this->preemptible = $var;

        return $this;
    }

    /**
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAccelerators()
    {
        return $this->accelerators;
    }

    /**
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     * @param array<\Google\Cloud\Container\V1\AcceleratorConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAccelerators($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\AcceleratorConfig::class);
        $this->accelerators = $arr;

        return $this;
    }

    /**
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     * If unspecified, the default disk type is 'pd-standard'
     *
     * Generated from protobuf field <code>string disk_type = 12;</code>
     * @return string
     */
    public function getDiskType()
    {
        return $this->disk_type;
    }

    /**
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     * If unspecified, the default disk type is 'pd-standard'
     *
     * Generated from protobuf field <code>string disk_type = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setDiskType($var)
    {
        GPBUtil::checkString($var, True);
        $this->disk_type = $var;

        return $this;
    }

    /**
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     *
     * Generated from protobuf field <code>string min_cpu_platform = 13;</code>
     * @return string
     */
    public function getMinCpuPlatform()
    {
        return $this->min_cpu_platform;
    }

    /**
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     *
     * Generated from protobuf field <code>string min_cpu_platform = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setMinCpuPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->min_cpu_platform = $var;

        return $this;
    }

    /**
     * The workload metadata configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     * @return \Google\Cloud\Container\V1\WorkloadMetadataConfig|null
     */
    public function getWorkloadMetadataConfig()
    {
        return $this->workload_metadata_config;
    }

    public function hasWorkloadMetadataConfig()
    {
        return isset($this->workload_metadata_config);
    }

    public function clearWorkloadMetadataConfig()
    {
        unset($this->workload_metadata_config);
    }

    /**
     * The workload metadata configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     * @param \Google\Cloud\Container\V1\WorkloadMetadataConfig $var
     * @return $this
     */
    public function setWorkloadMetadataConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\WorkloadMetadataConfig::class);
        $this->workload_metadata_config = $var;

        return $this;
    }

    /**
     * List of kubernetes taints to be applied to each node.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTaints()
    {
        return $this->taints;
    }

    /**
     * List of kubernetes taints to be applied to each node.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     *
     * Generated from protobuf field <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     * @param array<\Google\Cloud\Container\V1\NodeTaint>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTaints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\NodeTaint::class);
        $this->taints = $arr;

        return $this;
    }

    /**
     * Sandbox configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     * @return \Google\Cloud\Container\V1\SandboxConfig|null
     */
    public function getSandboxConfig()
    {
        return $this->sandbox_config;
    }

    public function hasSandboxConfig()
    {
        return isset($this->sandbox_config);
    }

    public function clearSandboxConfig()
    {
        unset($this->sandbox_config);
    }

    /**
     * Sandbox configuration for this node.
     *
     * Generated from protobuf field <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     * @param \Google\Cloud\Container\V1\SandboxConfig $var
     * @return $this
     */
    public function setSandboxConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\SandboxConfig::class);
        $this->sandbox_config = $var;

        return $this;
    }

    /**
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     *
     * Generated from protobuf field <code>string node_group = 18;</code>
     * @return string
     */
    public function getNodeGroup()
    {
        return $this->node_group;
    }

    /**
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     *
     * Generated from protobuf field <code>string node_group = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setNodeGroup($var)
    {
        GPBUtil::checkString($var, True);
        $this->node_group = $var;

        return $this;
    }

    /**
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     * @return \Google\Cloud\Container\V1\ReservationAffinity|null
     */
    public function getReservationAffinity()
    {
        return $this->reservation_affinity;
    }

    public function hasReservationAffinity()
    {
        return isset($this->reservation_affinity);
    }

    public function clearReservationAffinity()
    {
        unset($this->reservation_affinity);
    }

    /**
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     * @param \Google\Cloud\Container\V1\ReservationAffinity $var
     * @return $this
     */
    public function setReservationAffinity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ReservationAffinity::class);
        $this->reservation_affinity = $var;

        return $this;
    }

    /**
     * Shielded Instance options.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     * @return \Google\Cloud\Container\V1\ShieldedInstanceConfig|null
     */
    public function getShieldedInstanceConfig()
    {
        return $this->shielded_instance_config;
    }

    public function hasShieldedInstanceConfig()
    {
        return isset($this->shielded_instance_config);
    }

    public function clearShieldedInstanceConfig()
    {
        unset($this->shielded_instance_config);
    }

    /**
     * Shielded Instance options.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     * @param \Google\Cloud\Container\V1\ShieldedInstanceConfig $var
     * @return $this
     */
    public function setShieldedInstanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ShieldedInstanceConfig::class);
        $this->shielded_instance_config = $var;

        return $this;
    }

    /**
     * Parameters that can be configured on Linux nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     * @return \Google\Cloud\Container\V1\LinuxNodeConfig|null
     */
    public function getLinuxNodeConfig()
    {
        return $this->linux_node_config;
    }

    public function hasLinuxNodeConfig()
    {
        return isset($this->linux_node_config);
    }

    public function clearLinuxNodeConfig()
    {
        unset($this->linux_node_config);
    }

    /**
     * Parameters that can be configured on Linux nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     * @param \Google\Cloud\Container\V1\LinuxNodeConfig $var
     * @return $this
     */
    public function setLinuxNodeConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\LinuxNodeConfig::class);
        $this->linux_node_config = $var;

        return $this;
    }

    /**
     * Node kubelet configs.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     * @return \Google\Cloud\Container\V1\NodeKubeletConfig|null
     */
    public function getKubeletConfig()
    {
        return $this->kubelet_config;
    }

    public function hasKubeletConfig()
    {
        return isset($this->kubelet_config);
    }

    public function clearKubeletConfig()
    {
        unset($this->kubelet_config);
    }

    /**
     * Node kubelet configs.
     *
     * Generated from protobuf field <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     * @param \Google\Cloud\Container\V1\NodeKubeletConfig $var
     * @return $this
     */
    public function setKubeletConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodeKubeletConfig::class);
        $this->kubelet_config = $var;

        return $this;
    }

    /**
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     *
     * Generated from protobuf field <code>string boot_disk_kms_key = 23;</code>
     * @return string
     */
    public function getBootDiskKmsKey()
    {
        return $this->boot_disk_kms_key;
    }

    /**
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     *
     * Generated from protobuf field <code>string boot_disk_kms_key = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setBootDiskKmsKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->boot_disk_kms_key = $var;

        return $this;
    }

    /**
     * Google Container File System (image streaming) configs.
     *
     * Generated from protobuf field <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     * @return \Google\Cloud\Container\V1\GcfsConfig|null
     */
    public function getGcfsConfig()
    {
        return $this->gcfs_config;
    }

    public function hasGcfsConfig()
    {
        return isset($this->gcfs_config);
    }

    public function clearGcfsConfig()
    {
        unset($this->gcfs_config);
    }

    /**
     * Google Container File System (image streaming) configs.
     *
     * Generated from protobuf field <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     * @param \Google\Cloud\Container\V1\GcfsConfig $var
     * @return $this
     */
    public function setGcfsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\GcfsConfig::class);
        $this->gcfs_config = $var;

        return $this;
    }

    /**
     * Advanced features for the Compute Engine VM.
     *
     * Generated from protobuf field <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     * @return \Google\Cloud\Container\V1\AdvancedMachineFeatures|null
     */
    public function getAdvancedMachineFeatures()
    {
        return $this->advanced_machine_features;
    }

    public function hasAdvancedMachineFeatures()
    {
        return isset($this->advanced_machine_features);
    }

    public function clearAdvancedMachineFeatures()
    {
        unset($this->advanced_machine_features);
    }

    /**
     * Advanced features for the Compute Engine VM.
     *
     * Generated from protobuf field <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     * @param \Google\Cloud\Container\V1\AdvancedMachineFeatures $var
     * @return $this
     */
    public function setAdvancedMachineFeatures($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AdvancedMachineFeatures::class);
        $this->advanced_machine_features = $var;

        return $this;
    }

    /**
     * Enable or disable gvnic in the node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     * @return \Google\Cloud\Container\V1\VirtualNIC|null
     */
    public function getGvnic()
    {
        return $this->gvnic;
    }

    public function hasGvnic()
    {
        return isset($this->gvnic);
    }

    public function clearGvnic()
    {
        unset($this->gvnic);
    }

    /**
     * Enable or disable gvnic in the node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     * @param \Google\Cloud\Container\V1\VirtualNIC $var
     * @return $this
     */
    public function setGvnic($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\VirtualNIC::class);
        $this->gvnic = $var;

        return $this;
    }

    /**
     * Spot flag for enabling Spot VM, which is a rebrand of
     * the existing preemptible flag.
     *
     * Generated from protobuf field <code>bool spot = 32;</code>
     * @return bool
     */
    public function getSpot()
    {
        return $this->spot;
    }

    /**
     * Spot flag for enabling Spot VM, which is a rebrand of
     * the existing preemptible flag.
     *
     * Generated from protobuf field <code>bool spot = 32;</code>
     * @param bool $var
     * @return $this
     */
    public function setSpot($var)
    {
        GPBUtil::checkBool($var);
        $this->spot = $var;

        return $this;
    }

    /**
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     *
     * Generated from protobuf field <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     * @return \Google\Cloud\Container\V1\ConfidentialNodes|null
     */
    public function getConfidentialNodes()
    {
        return $this->confidential_nodes;
    }

    public function hasConfidentialNodes()
    {
        return isset($this->confidential_nodes);
    }

    public function clearConfidentialNodes()
    {
        unset($this->confidential_nodes);
    }

    /**
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     *
     * Generated from protobuf field <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     * @param \Google\Cloud\Container\V1\ConfidentialNodes $var
     * @return $this
     */
    public function setConfidentialNodes($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ConfidentialNodes::class);
        $this->confidential_nodes = $var;

        return $this;
    }

    /**
     * Enable or disable NCCL fast socket for the node pool.
     *
     * Generated from protobuf field <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     * @return \Google\Cloud\Container\V1\FastSocket|null
     */
    public function getFastSocket()
    {
        return $this->fast_socket;
    }

    public function hasFastSocket()
    {
        return isset($this->fast_socket);
    }

    public function clearFastSocket()
    {
        unset($this->fast_socket);
    }

    /**
     * Enable or disable NCCL fast socket for the node pool.
     *
     * Generated from protobuf field <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     * @param \Google\Cloud\Container\V1\FastSocket $var
     * @return $this
     */
    public function setFastSocket($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\FastSocket::class);
        $this->fast_socket = $var;

        return $this;
    }

    /**
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     *
     * Generated from protobuf field <code>map<string, string> resource_labels = 37;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getResourceLabels()
    {
        return $this->resource_labels;
    }

    /**
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     *
     * Generated from protobuf field <code>map<string, string> resource_labels = 37;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setResourceLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_labels = $arr;

        return $this;
    }

    /**
     * Logging configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     * @return \Google\Cloud\Container\V1\NodePoolLoggingConfig|null
     */
    public function getLoggingConfig()
    {
        return $this->logging_config;
    }

    public function hasLoggingConfig()
    {
        return isset($this->logging_config);
    }

    public function clearLoggingConfig()
    {
        unset($this->logging_config);
    }

    /**
     * Logging configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     * @param \Google\Cloud\Container\V1\NodePoolLoggingConfig $var
     * @return $this
     */
    public function setLoggingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodePoolLoggingConfig::class);
        $this->logging_config = $var;

        return $this;
    }

    /**
     * Parameters that can be configured on Windows nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     * @return \Google\Cloud\Container\V1\WindowsNodeConfig|null
     */
    public function getWindowsNodeConfig()
    {
        return $this->windows_node_config;
    }

    public function hasWindowsNodeConfig()
    {
        return isset($this->windows_node_config);
    }

    public function clearWindowsNodeConfig()
    {
        unset($this->windows_node_config);
    }

    /**
     * Parameters that can be configured on Windows nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     * @param \Google\Cloud\Container\V1\WindowsNodeConfig $var
     * @return $this
     */
    public function setWindowsNodeConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\WindowsNodeConfig::class);
        $this->windows_node_config = $var;

        return $this;
    }

    /**
     * Parameters for using raw-block Local NVMe SSDs.
     *
     * Generated from protobuf field <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     * @return \Google\Cloud\Container\V1\LocalNvmeSsdBlockConfig|null
     */
    public function getLocalNvmeSsdBlockConfig()
    {
        return $this->local_nvme_ssd_block_config;
    }

    public function hasLocalNvmeSsdBlockConfig()
    {
        return isset($this->local_nvme_ssd_block_config);
    }

    public function clearLocalNvmeSsdBlockConfig()
    {
        unset($this->local_nvme_ssd_block_config);
    }

    /**
     * Parameters for using raw-block Local NVMe SSDs.
     *
     * Generated from protobuf field <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     * @param \Google\Cloud\Container\V1\LocalNvmeSsdBlockConfig $var
     * @return $this
     */
    public function setLocalNvmeSsdBlockConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\LocalNvmeSsdBlockConfig::class);
        $this->local_nvme_ssd_block_config = $var;

        return $this;
    }

    /**
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     *
     * Generated from protobuf field <code>.google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;</code>
     * @return \Google\Cloud\Container\V1\EphemeralStorageLocalSsdConfig|null
     */
    public function getEphemeralStorageLocalSsdConfig()
    {
        return $this->ephemeral_storage_local_ssd_config;
    }

    public function hasEphemeralStorageLocalSsdConfig()
    {
        return isset($this->ephemeral_storage_local_ssd_config);
    }

    public function clearEphemeralStorageLocalSsdConfig()
    {
        unset($this->ephemeral_storage_local_ssd_config);
    }

    /**
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     *
     * Generated from protobuf field <code>.google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;</code>
     * @param \Google\Cloud\Container\V1\EphemeralStorageLocalSsdConfig $var
     * @return $this
     */
    public function setEphemeralStorageLocalSsdConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\EphemeralStorageLocalSsdConfig::class);
        $this->ephemeral_storage_local_ssd_config = $var;

        return $this;
    }

    /**
     * Parameters for node pools to be backed by shared sole tenant node groups.
     *
     * Generated from protobuf field <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     * @return \Google\Cloud\Container\V1\SoleTenantConfig|null
     */
    public function getSoleTenantConfig()
    {
        return $this->sole_tenant_config;
    }

    public function hasSoleTenantConfig()
    {
        return isset($this->sole_tenant_config);
    }

    public function clearSoleTenantConfig()
    {
        unset($this->sole_tenant_config);
    }

    /**
     * Parameters for node pools to be backed by shared sole tenant node groups.
     *
     * Generated from protobuf field <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     * @param \Google\Cloud\Container\V1\SoleTenantConfig $var
     * @return $this
     */
    public function setSoleTenantConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\SoleTenantConfig::class);
        $this->sole_tenant_config = $var;

        return $this;
    }

    /**
     * A map of resource manager tag keys and values to be attached to the nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     * @return \Google\Cloud\Container\V1\ResourceManagerTags|null
     */
    public function getResourceManagerTags()
    {
        return $this->resource_manager_tags;
    }

    public function hasResourceManagerTags()
    {
        return isset($this->resource_manager_tags);
    }

    public function clearResourceManagerTags()
    {
        unset($this->resource_manager_tags);
    }

    /**
     * A map of resource manager tag keys and values to be attached to the nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     * @param \Google\Cloud\Container\V1\ResourceManagerTags $var
     * @return $this
     */
    public function setResourceManagerTags($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ResourceManagerTags::class);
        $this->resource_manager_tags = $var;

        return $this;
    }

    /**
     * Optional. Reserved for future use.
     *
     * Generated from protobuf field <code>bool enable_confidential_storage = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableConfidentialStorage()
    {
        return $this->enable_confidential_storage;
    }

    /**
     * Optional. Reserved for future use.
     *
     * Generated from protobuf field <code>bool enable_confidential_storage = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableConfidentialStorage($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_confidential_storage = $var;

        return $this;
    }

}

