<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v2/feature_flags.proto

namespace Google\Cloud\Bigtable\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Feature flags supported or enabled by a client.
 * This is intended to be sent as part of request metadata to assure the server
 * that certain behaviors are safe to enable. This proto is meant to be
 * serialized and websafe-base64 encoded under the `bigtable-features` metadata
 * key. The value will remain constant for the lifetime of a client and due to
 * HTTP2's HPACK compression, the request overhead will be tiny.
 * This is an internal implementation detail and should not be used by end users
 * directly.
 *
 * Generated from protobuf message <code>google.bigtable.v2.FeatureFlags</code>
 */
class FeatureFlags extends \Google\Protobuf\Internal\Message
{
    /**
     * Notify the server that the client supports reverse scans. The server will
     * reject ReadRowsRequests with the reverse bit set when this is absent.
     *
     * Generated from protobuf field <code>bool reverse_scans = 1;</code>
     */
    private $reverse_scans = false;
    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse. Due to technical reasons,
     * this disables partial retries.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit = 3;</code>
     */
    private $mutate_rows_rate_limit = false;
    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse. With partial retries
     * enabled.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit2 = 5;</code>
     */
    private $mutate_rows_rate_limit2 = false;
    /**
     * Notify the server that the client supports the last_scanned_row field
     * in ReadRowsResponse for long-running scans.
     *
     * Generated from protobuf field <code>bool last_scanned_row_responses = 4;</code>
     */
    private $last_scanned_row_responses = false;
    /**
     * Notify the server that the client supports using encoded routing cookie
     * strings to retry requests with.
     *
     * Generated from protobuf field <code>bool routing_cookie = 6;</code>
     */
    private $routing_cookie = false;
    /**
     * Notify the server that the client supports using retry info back off
     * durations to retry requests with.
     *
     * Generated from protobuf field <code>bool retry_info = 7;</code>
     */
    private $retry_info = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $reverse_scans
     *           Notify the server that the client supports reverse scans. The server will
     *           reject ReadRowsRequests with the reverse bit set when this is absent.
     *     @type bool $mutate_rows_rate_limit
     *           Notify the server that the client enables batch write flow control by
     *           requesting RateLimitInfo from MutateRowsResponse. Due to technical reasons,
     *           this disables partial retries.
     *     @type bool $mutate_rows_rate_limit2
     *           Notify the server that the client enables batch write flow control by
     *           requesting RateLimitInfo from MutateRowsResponse. With partial retries
     *           enabled.
     *     @type bool $last_scanned_row_responses
     *           Notify the server that the client supports the last_scanned_row field
     *           in ReadRowsResponse for long-running scans.
     *     @type bool $routing_cookie
     *           Notify the server that the client supports using encoded routing cookie
     *           strings to retry requests with.
     *     @type bool $retry_info
     *           Notify the server that the client supports using retry info back off
     *           durations to retry requests with.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\V2\FeatureFlags::initOnce();
        parent::__construct($data);
    }

    /**
     * Notify the server that the client supports reverse scans. The server will
     * reject ReadRowsRequests with the reverse bit set when this is absent.
     *
     * Generated from protobuf field <code>bool reverse_scans = 1;</code>
     * @return bool
     */
    public function getReverseScans()
    {
        return $this->reverse_scans;
    }

    /**
     * Notify the server that the client supports reverse scans. The server will
     * reject ReadRowsRequests with the reverse bit set when this is absent.
     *
     * Generated from protobuf field <code>bool reverse_scans = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setReverseScans($var)
    {
        GPBUtil::checkBool($var);
        $this->reverse_scans = $var;

        return $this;
    }

    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse. Due to technical reasons,
     * this disables partial retries.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit = 3;</code>
     * @return bool
     */
    public function getMutateRowsRateLimit()
    {
        return $this->mutate_rows_rate_limit;
    }

    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse. Due to technical reasons,
     * this disables partial retries.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setMutateRowsRateLimit($var)
    {
        GPBUtil::checkBool($var);
        $this->mutate_rows_rate_limit = $var;

        return $this;
    }

    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse. With partial retries
     * enabled.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit2 = 5;</code>
     * @return bool
     */
    public function getMutateRowsRateLimit2()
    {
        return $this->mutate_rows_rate_limit2;
    }

    /**
     * Notify the server that the client enables batch write flow control by
     * requesting RateLimitInfo from MutateRowsResponse. With partial retries
     * enabled.
     *
     * Generated from protobuf field <code>bool mutate_rows_rate_limit2 = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setMutateRowsRateLimit2($var)
    {
        GPBUtil::checkBool($var);
        $this->mutate_rows_rate_limit2 = $var;

        return $this;
    }

    /**
     * Notify the server that the client supports the last_scanned_row field
     * in ReadRowsResponse for long-running scans.
     *
     * Generated from protobuf field <code>bool last_scanned_row_responses = 4;</code>
     * @return bool
     */
    public function getLastScannedRowResponses()
    {
        return $this->last_scanned_row_responses;
    }

    /**
     * Notify the server that the client supports the last_scanned_row field
     * in ReadRowsResponse for long-running scans.
     *
     * Generated from protobuf field <code>bool last_scanned_row_responses = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setLastScannedRowResponses($var)
    {
        GPBUtil::checkBool($var);
        $this->last_scanned_row_responses = $var;

        return $this;
    }

    /**
     * Notify the server that the client supports using encoded routing cookie
     * strings to retry requests with.
     *
     * Generated from protobuf field <code>bool routing_cookie = 6;</code>
     * @return bool
     */
    public function getRoutingCookie()
    {
        return $this->routing_cookie;
    }

    /**
     * Notify the server that the client supports using encoded routing cookie
     * strings to retry requests with.
     *
     * Generated from protobuf field <code>bool routing_cookie = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setRoutingCookie($var)
    {
        GPBUtil::checkBool($var);
        $this->routing_cookie = $var;

        return $this;
    }

    /**
     * Notify the server that the client supports using retry info back off
     * durations to retry requests with.
     *
     * Generated from protobuf field <code>bool retry_info = 7;</code>
     * @return bool
     */
    public function getRetryInfo()
    {
        return $this->retry_info;
    }

    /**
     * Notify the server that the client supports using retry info back off
     * durations to retry requests with.
     *
     * Generated from protobuf field <code>bool retry_info = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setRetryInfo($var)
    {
        GPBUtil::checkBool($var);
        $this->retry_info = $var;

        return $this;
    }

}

