<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/advisorynotifications/v1/service.proto

namespace Google\Cloud\AdvisoryNotifications\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for fetching all notifications for a given parent.
 *
 * Generated from protobuf message <code>google.cloud.advisorynotifications.v1.ListNotificationsRequest</code>
 */
class ListNotificationsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent, which owns this collection of notifications.
     * Must be of the form "organizations/{organization}/locations/{location}"
     * or "projects/{project}/locations/{location}"
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * The maximum number of notifications to return. The service may return
     * fewer than this value. If unspecified or equal to 0, at most 50
     * notifications will be returned. The maximum value is 50; values above 50
     * will be coerced to 50.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     */
    protected $page_size = 0;
    /**
     * A page token returned from a previous request.
     * When paginating, all other parameters provided in the request
     * must match the call that returned the page token.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     */
    protected $page_token = '';
    /**
     * Specifies which parts of the notification resource should be returned
     * in the response.
     *
     * Generated from protobuf field <code>.google.cloud.advisorynotifications.v1.NotificationView view = 4;</code>
     */
    protected $view = 0;
    /**
     * ISO code for requested localization language.  If unset, will be
     * interpereted as "en". If the requested language is valid, but not supported
     * for this notification, English will be returned with an "Not applicable"
     * LocalizationState. If the ISO code is invalid (i.e. not a real language),
     * this RPC will throw an error.
     *
     * Generated from protobuf field <code>string language_code = 5;</code>
     */
    protected $language_code = '';

    /**
     * @param string $parent Required. The parent, which owns this collection of notifications.
     *                       Must be of the form "organizations/{organization}/locations/{location}"
     *                       or "projects/{project}/locations/{location}"
     *                       Please see {@see AdvisoryNotificationsServiceClient::locationName()} for help formatting this field.
     *
     * @return \Google\Cloud\AdvisoryNotifications\V1\ListNotificationsRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent, which owns this collection of notifications.
     *           Must be of the form "organizations/{organization}/locations/{location}"
     *           or "projects/{project}/locations/{location}"
     *     @type int $page_size
     *           The maximum number of notifications to return. The service may return
     *           fewer than this value. If unspecified or equal to 0, at most 50
     *           notifications will be returned. The maximum value is 50; values above 50
     *           will be coerced to 50.
     *     @type string $page_token
     *           A page token returned from a previous request.
     *           When paginating, all other parameters provided in the request
     *           must match the call that returned the page token.
     *     @type int $view
     *           Specifies which parts of the notification resource should be returned
     *           in the response.
     *     @type string $language_code
     *           ISO code for requested localization language.  If unset, will be
     *           interpereted as "en". If the requested language is valid, but not supported
     *           for this notification, English will be returned with an "Not applicable"
     *           LocalizationState. If the ISO code is invalid (i.e. not a real language),
     *           this RPC will throw an error.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Advisorynotifications\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent, which owns this collection of notifications.
     * Must be of the form "organizations/{organization}/locations/{location}"
     * or "projects/{project}/locations/{location}"
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent, which owns this collection of notifications.
     * Must be of the form "organizations/{organization}/locations/{location}"
     * or "projects/{project}/locations/{location}"
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The maximum number of notifications to return. The service may return
     * fewer than this value. If unspecified or equal to 0, at most 50
     * notifications will be returned. The maximum value is 50; values above 50
     * will be coerced to 50.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of notifications to return. The service may return
     * fewer than this value. If unspecified or equal to 0, at most 50
     * notifications will be returned. The maximum value is 50; values above 50
     * will be coerced to 50.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * A page token returned from a previous request.
     * When paginating, all other parameters provided in the request
     * must match the call that returned the page token.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A page token returned from a previous request.
     * When paginating, all other parameters provided in the request
     * must match the call that returned the page token.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Specifies which parts of the notification resource should be returned
     * in the response.
     *
     * Generated from protobuf field <code>.google.cloud.advisorynotifications.v1.NotificationView view = 4;</code>
     * @return int
     */
    public function getView()
    {
        return $this->view;
    }

    /**
     * Specifies which parts of the notification resource should be returned
     * in the response.
     *
     * Generated from protobuf field <code>.google.cloud.advisorynotifications.v1.NotificationView view = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setView($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AdvisoryNotifications\V1\NotificationView::class);
        $this->view = $var;

        return $this;
    }

    /**
     * ISO code for requested localization language.  If unset, will be
     * interpereted as "en". If the requested language is valid, but not supported
     * for this notification, English will be returned with an "Not applicable"
     * LocalizationState. If the ISO code is invalid (i.e. not a real language),
     * this RPC will throw an error.
     *
     * Generated from protobuf field <code>string language_code = 5;</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * ISO code for requested localization language.  If unset, will be
     * interpereted as "en". If the requested language is valid, but not supported
     * for this notification, English will be returned with an "Not applicable"
     * LocalizationState. If the ISO code is invalid (i.e. not a real language),
     * this RPC will throw an error.
     *
     * Generated from protobuf field <code>string language_code = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

}

