<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/eventarc/v1/eventarc.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Eventarc\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Eventarc\V1\Channel;
use Google\Cloud\Eventarc\V1\ChannelConnection;
use Google\Cloud\Eventarc\V1\CreateChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\CreateChannelRequest;
use Google\Cloud\Eventarc\V1\CreateTriggerRequest;
use Google\Cloud\Eventarc\V1\DeleteChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\DeleteChannelRequest;
use Google\Cloud\Eventarc\V1\DeleteTriggerRequest;
use Google\Cloud\Eventarc\V1\GetChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\GetChannelRequest;
use Google\Cloud\Eventarc\V1\GetGoogleChannelConfigRequest;
use Google\Cloud\Eventarc\V1\GetProviderRequest;
use Google\Cloud\Eventarc\V1\GetTriggerRequest;
use Google\Cloud\Eventarc\V1\GoogleChannelConfig;
use Google\Cloud\Eventarc\V1\ListChannelConnectionsRequest;
use Google\Cloud\Eventarc\V1\ListChannelsRequest;
use Google\Cloud\Eventarc\V1\ListProvidersRequest;
use Google\Cloud\Eventarc\V1\ListTriggersRequest;
use Google\Cloud\Eventarc\V1\Provider;
use Google\Cloud\Eventarc\V1\Trigger;
use Google\Cloud\Eventarc\V1\UpdateChannelRequest;
use Google\Cloud\Eventarc\V1\UpdateGoogleChannelConfigRequest;
use Google\Cloud\Eventarc\V1\UpdateTriggerRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Eventarc allows users to subscribe to various events that are provided by
 * Google Cloud services and forward them to supported destinations.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\Eventarc\V1\EventarcClient} for the stable implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createChannelAsync(CreateChannelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createChannelConnectionAsync(CreateChannelConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createTriggerAsync(CreateTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteChannelAsync(DeleteChannelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteChannelConnectionAsync(DeleteChannelConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteTriggerAsync(DeleteTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getChannelAsync(GetChannelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getChannelConnectionAsync(GetChannelConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGoogleChannelConfigAsync(GetGoogleChannelConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getProviderAsync(GetProviderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getTriggerAsync(GetTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listChannelConnectionsAsync(ListChannelConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listChannelsAsync(ListChannelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listProvidersAsync(ListProvidersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listTriggersAsync(ListTriggersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateChannelAsync(UpdateChannelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGoogleChannelConfigAsync(UpdateGoogleChannelConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateTriggerAsync(UpdateTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
abstract class EventarcBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.eventarc.v1.Eventarc';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'eventarc.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/eventarc_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/eventarc_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/eventarc_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/eventarc_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a channel
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channel
     *
     * @return string The formatted channel resource.
     */
    public static function channelName(string $project, string $location, string $channel): string
    {
        return self::getPathTemplate('channel')->render([
            'project' => $project,
            'location' => $location,
            'channel' => $channel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channelConnection
     *
     * @return string The formatted channel_connection resource.
     */
    public static function channelConnectionName(string $project, string $location, string $channelConnection): string
    {
        return self::getPathTemplate('channelConnection')->render([
            'project' => $project,
            'location' => $location,
            'channel_connection' => $channelConnection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * cloud_function resource.
     *
     * @param string $project
     * @param string $location
     * @param string $function
     *
     * @return string The formatted cloud_function resource.
     */
    public static function cloudFunctionName(string $project, string $location, string $function): string
    {
        return self::getPathTemplate('cloudFunction')->render([
            'project' => $project,
            'location' => $location,
            'function' => $function,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_channel_config resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted google_channel_config resource.
     */
    public static function googleChannelConfigName(string $project, string $location): string
    {
        return self::getPathTemplate('googleChannelConfig')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a provider
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $provider
     *
     * @return string The formatted provider resource.
     */
    public static function providerName(string $project, string $location, string $provider): string
    {
        return self::getPathTemplate('provider')->render([
            'project' => $project,
            'location' => $location,
            'provider' => $provider,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_account resource.
     *
     * @param string $project
     * @param string $serviceAccount
     *
     * @return string The formatted service_account resource.
     */
    public static function serviceAccountName(string $project, string $serviceAccount): string
    {
        return self::getPathTemplate('serviceAccount')->render([
            'project' => $project,
            'service_account' => $serviceAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a trigger
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trigger
     *
     * @return string The formatted trigger resource.
     */
    public static function triggerName(string $project, string $location, string $trigger): string
    {
        return self::getPathTemplate('trigger')->render([
            'project' => $project,
            'location' => $location,
            'trigger' => $trigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a workflow
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workflow
     *
     * @return string The formatted workflow resource.
     */
    public static function workflowName(string $project, string $location, string $workflow): string
    {
        return self::getPathTemplate('workflow')->render([
            'project' => $project,
            'location' => $location,
            'workflow' => $workflow,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - channel: projects/{project}/locations/{location}/channels/{channel}
     * - channelConnection: projects/{project}/locations/{location}/channelConnections/{channel_connection}
     * - cloudFunction: projects/{project}/locations/{location}/functions/{function}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - googleChannelConfig: projects/{project}/locations/{location}/googleChannelConfig
     * - location: projects/{project}/locations/{location}
     * - provider: projects/{project}/locations/{location}/providers/{provider}
     * - serviceAccount: projects/{project}/serviceAccounts/{service_account}
     * - trigger: projects/{project}/locations/{location}/triggers/{trigger}
     * - workflow: projects/{project}/locations/{location}/workflows/{workflow}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'eventarc.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create a new channel in a particular project and location.
     *
     * The async variant is {@see self::createChannelAsync()} .
     *
     * @param CreateChannelRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createChannel(CreateChannelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateChannel', $request, $callOptions)->wait();
    }

    /**
     * Create a new ChannelConnection in a particular project and location.
     *
     * The async variant is {@see self::createChannelConnectionAsync()} .
     *
     * @param CreateChannelConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createChannelConnection(CreateChannelConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateChannelConnection', $request, $callOptions)->wait();
    }

    /**
     * Create a new trigger in a particular project and location.
     *
     * The async variant is {@see self::createTriggerAsync()} .
     *
     * @param CreateTriggerRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTrigger(CreateTriggerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTrigger', $request, $callOptions)->wait();
    }

    /**
     * Delete a single channel.
     *
     * The async variant is {@see self::deleteChannelAsync()} .
     *
     * @param DeleteChannelRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteChannel(DeleteChannelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteChannel', $request, $callOptions)->wait();
    }

    /**
     * Delete a single ChannelConnection.
     *
     * The async variant is {@see self::deleteChannelConnectionAsync()} .
     *
     * @param DeleteChannelConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteChannelConnection(DeleteChannelConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteChannelConnection', $request, $callOptions)->wait();
    }

    /**
     * Delete a single trigger.
     *
     * The async variant is {@see self::deleteTriggerAsync()} .
     *
     * @param DeleteTriggerRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTrigger(DeleteTriggerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTrigger', $request, $callOptions)->wait();
    }

    /**
     * Get a single Channel.
     *
     * The async variant is {@see self::getChannelAsync()} .
     *
     * @param GetChannelRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Channel
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getChannel(GetChannelRequest $request, array $callOptions = []): Channel
    {
        return $this->startApiCall('GetChannel', $request, $callOptions)->wait();
    }

    /**
     * Get a single ChannelConnection.
     *
     * The async variant is {@see self::getChannelConnectionAsync()} .
     *
     * @param GetChannelConnectionRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelConnection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getChannelConnection(GetChannelConnectionRequest $request, array $callOptions = []): ChannelConnection
    {
        return $this->startApiCall('GetChannelConnection', $request, $callOptions)->wait();
    }

    /**
     * Get a GoogleChannelConfig
     *
     * The async variant is {@see self::getGoogleChannelConfigAsync()} .
     *
     * @param GetGoogleChannelConfigRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleChannelConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGoogleChannelConfig(GetGoogleChannelConfigRequest $request, array $callOptions = []): GoogleChannelConfig
    {
        return $this->startApiCall('GetGoogleChannelConfig', $request, $callOptions)->wait();
    }

    /**
     * Get a single Provider.
     *
     * The async variant is {@see self::getProviderAsync()} .
     *
     * @param GetProviderRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Provider
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProvider(GetProviderRequest $request, array $callOptions = []): Provider
    {
        return $this->startApiCall('GetProvider', $request, $callOptions)->wait();
    }

    /**
     * Get a single trigger.
     *
     * The async variant is {@see self::getTriggerAsync()} .
     *
     * @param GetTriggerRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Trigger
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTrigger(GetTriggerRequest $request, array $callOptions = []): Trigger
    {
        return $this->startApiCall('GetTrigger', $request, $callOptions)->wait();
    }

    /**
     * List channel connections.
     *
     * The async variant is {@see self::listChannelConnectionsAsync()} .
     *
     * @param ListChannelConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listChannelConnections(ListChannelConnectionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListChannelConnections', $request, $callOptions);
    }

    /**
     * List channels.
     *
     * The async variant is {@see self::listChannelsAsync()} .
     *
     * @param ListChannelsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listChannels(ListChannelsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListChannels', $request, $callOptions);
    }

    /**
     * List providers.
     *
     * The async variant is {@see self::listProvidersAsync()} .
     *
     * @param ListProvidersRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProviders(ListProvidersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProviders', $request, $callOptions);
    }

    /**
     * List triggers.
     *
     * The async variant is {@see self::listTriggersAsync()} .
     *
     * @param ListTriggersRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTriggers(ListTriggersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTriggers', $request, $callOptions);
    }

    /**
     * Update a single channel.
     *
     * The async variant is {@see self::updateChannelAsync()} .
     *
     * @param UpdateChannelRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateChannel(UpdateChannelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateChannel', $request, $callOptions)->wait();
    }

    /**
     * Update a single GoogleChannelConfig
     *
     * The async variant is {@see self::updateGoogleChannelConfigAsync()} .
     *
     * @param UpdateGoogleChannelConfigRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleChannelConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGoogleChannelConfig(UpdateGoogleChannelConfigRequest $request, array $callOptions = []): GoogleChannelConfig
    {
        return $this->startApiCall('UpdateGoogleChannelConfig', $request, $callOptions)->wait();
    }

    /**
     * Update a single trigger.
     *
     * The async variant is {@see self::updateTriggerAsync()} .
     *
     * @param UpdateTriggerRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTrigger(UpdateTriggerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTrigger', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see self::getLocationAsync()} .
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see self::listLocationsAsync()} .
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see self::getIamPolicyAsync()} .
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see self::setIamPolicyAsync()} .
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see self::testIamPermissionsAsync()} .
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
