<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v1/finding.proto

namespace Google\Cloud\SecurityCenter\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Security Command Center finding.
 * A finding is a record of assessment data like security, risk, health, or
 * privacy, that is ingested into Security Command Center for presentation,
 * notification, analysis, policy testing, and enforcement. For example, a
 * cross-site scripting (XSS) vulnerability in an App Engine application is a
 * finding.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v1.Finding</code>
 */
class Finding extends \Google\Protobuf\Internal\Message
{
    /**
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     */
    private $parent = '';
    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     */
    private $resource_name = '';
    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     */
    private $state = 0;
    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     */
    private $category = '';
    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     */
    private $external_uri = '';
    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     */
    private $source_properties;
    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $security_marks = null;
    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    private $event_time = null;
    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    private $create_time = null;
    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     */
    private $severity = 0;
    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     */
    private $canonical_name = '';
    /**
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     */
    private $mute = 0;
    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     */
    private $finding_class = 0;
    /**
     * Represents what's commonly known as an Indicator of compromise (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion.
     * Reference: https://en.wikipedia.org/wiki/Indicator_of_compromise
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     */
    private $indicator = null;
    /**
     * Represents vulnerability specific fields like cve, cvss scores etc.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     */
    private $vulnerability = null;
    /**
     * Output only. The most recent time this finding was muted or unmuted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $mute_update_time = null;
    /**
     * Output only. Third party SIEM/SOAR fields within SCC, contains external system
     * information and external system finding fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ExternalSystem> external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $external_systems;
    /**
     * MITRE ATT&CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     */
    private $mitre_attack = null;
    /**
     * Access details associated to the Finding, such as more information on the
     * caller, which method was accessed, from where, etc.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     */
    private $access = null;
    /**
     * Contains information about the IP connection associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     */
    private $connections;
    /**
     * First known as mute_annotation. Records additional information about the
     * mute operation e.g. mute config that muted the finding, user who muted the
     * finding, etc. Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>string mute_initiator = 28;</code>
     */
    private $mute_initiator = '';
    /**
     * Represents operating system processes associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     */
    private $processes;
    /**
     * Output only. Map containing the point of contacts for the given finding. The key
     * represents the type of contact, while the value contains a list of all the
     * contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ContactDetails> contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $contacts;
    /**
     * Contains compliance information for security standards associated to the
     * finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     */
    private $compliances;
    /**
     * Contains more detail about the finding.
     *
     * Generated from protobuf field <code>string description = 37;</code>
     */
    private $description = '';
    /**
     * Represents exfiltration associated with the Finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     */
    private $exfiltration = null;
    /**
     * Represents IAM bindings associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     */
    private $iam_bindings;
    /**
     * Next steps associate to the finding.
     *
     * Generated from protobuf field <code>string next_steps = 40;</code>
     */
    private $next_steps = '';
    /**
     * Containers associated with the finding. containers provides information
     * for both Kubernetes and non-Kubernetes containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     */
    private $containers;
    /**
     * Kubernetes resources associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     */
    private $kubernetes = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The relative resource name of this finding. See:
     *           https://cloud.google.com/apis/design/resource_names#relative_resource_name
     *           Example:
     *           "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     *     @type string $parent
     *           The relative resource name of the source the finding belongs to. See:
     *           https://cloud.google.com/apis/design/resource_names#relative_resource_name
     *           This field is immutable after creation time.
     *           For example:
     *           "organizations/{organization_id}/sources/{source_id}"
     *     @type string $resource_name
     *           For findings on Google Cloud resources, the full resource
     *           name of the Google Cloud resource this finding is for. See:
     *           https://cloud.google.com/apis/design/resource_names#full_resource_name
     *           When the finding is for a non-Google Cloud resource, the resourceName can
     *           be a customer or partner defined string. This field is immutable after
     *           creation time.
     *     @type int $state
     *           The state of the finding.
     *     @type string $category
     *           The additional taxonomy group within findings from a given source.
     *           This field is immutable after creation time.
     *           Example: "XSS_FLASH_INJECTION"
     *     @type string $external_uri
     *           The URI that, if available, points to a web page outside of Security
     *           Command Center where additional information about the finding can be found.
     *           This field is guaranteed to be either empty or a well formed URL.
     *     @type array|\Google\Protobuf\Internal\MapField $source_properties
     *           Source specific properties. These properties are managed by the source
     *           that writes the finding. The key names in the source_properties map must be
     *           between 1 and 255 characters, and must start with a letter and contain
     *           alphanumeric characters or underscores only.
     *     @type \Google\Cloud\SecurityCenter\V1\SecurityMarks $security_marks
     *           Output only. User specified security marks. These marks are entirely
     *           managed by the user and come from the SecurityMarks resource that belongs
     *           to the finding.
     *     @type \Google\Protobuf\Timestamp $event_time
     *           The time the finding was first detected. If an existing finding is updated,
     *           then this is the time the update occurred.
     *           For example, if the finding represents an open firewall, this property
     *           captures the time the detector believes the firewall became open. The
     *           accuracy is determined by the detector. If the finding is later resolved,
     *           then this time reflects when the finding was resolved. This must not
     *           be set to a value greater than the current timestamp.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           The time at which the finding was created in Security Command Center.
     *     @type int $severity
     *           The severity of the finding. This field is managed by the source that
     *           writes the finding.
     *     @type string $canonical_name
     *           The canonical name of the finding. It's either
     *           "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     *           "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     *           "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     *           depending on the closest CRM ancestor of the resource associated with the
     *           finding.
     *     @type int $mute
     *           Indicates the mute state of a finding (either muted, unmuted
     *           or undefined). Unlike other attributes of a finding, a finding provider
     *           shouldn't set the value of mute.
     *     @type int $finding_class
     *           The class of the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\Indicator $indicator
     *           Represents what's commonly known as an Indicator of compromise (IoC) in
     *           computer forensics. This is an artifact observed on a network or in an
     *           operating system that, with high confidence, indicates a computer
     *           intrusion.
     *           Reference: https://en.wikipedia.org/wiki/Indicator_of_compromise
     *     @type \Google\Cloud\SecurityCenter\V1\Vulnerability $vulnerability
     *           Represents vulnerability specific fields like cve, cvss scores etc.
     *           CVE stands for Common Vulnerabilities and Exposures
     *           (https://cve.mitre.org/about/)
     *     @type \Google\Protobuf\Timestamp $mute_update_time
     *           Output only. The most recent time this finding was muted or unmuted.
     *     @type array|\Google\Protobuf\Internal\MapField $external_systems
     *           Output only. Third party SIEM/SOAR fields within SCC, contains external system
     *           information and external system finding fields.
     *     @type \Google\Cloud\SecurityCenter\V1\MitreAttack $mitre_attack
     *           MITRE ATT&CK tactics and techniques related to this finding.
     *           See: https://attack.mitre.org
     *     @type \Google\Cloud\SecurityCenter\V1\Access $access
     *           Access details associated to the Finding, such as more information on the
     *           caller, which method was accessed, from where, etc.
     *     @type array<\Google\Cloud\SecurityCenter\V1\Connection>|\Google\Protobuf\Internal\RepeatedField $connections
     *           Contains information about the IP connection associated with the finding.
     *     @type string $mute_initiator
     *           First known as mute_annotation. Records additional information about the
     *           mute operation e.g. mute config that muted the finding, user who muted the
     *           finding, etc. Unlike other attributes of a finding, a finding provider
     *           shouldn't set the value of mute.
     *     @type array<\Google\Cloud\SecurityCenter\V1\Process>|\Google\Protobuf\Internal\RepeatedField $processes
     *           Represents operating system processes associated with the Finding.
     *     @type array|\Google\Protobuf\Internal\MapField $contacts
     *           Output only. Map containing the point of contacts for the given finding. The key
     *           represents the type of contact, while the value contains a list of all the
     *           contacts that pertain. Please refer to:
     *           https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *               {
     *                 "security": {
     *                   "contacts": [
     *                     {
     *                       "email": "person1&#64;company.com"
     *                     },
     *                     {
     *                       "email": "person2&#64;company.com"
     *                     }
     *                   ]
     *                 }
     *               }
     *     @type array<\Google\Cloud\SecurityCenter\V1\Compliance>|\Google\Protobuf\Internal\RepeatedField $compliances
     *           Contains compliance information for security standards associated to the
     *           finding.
     *     @type string $description
     *           Contains more detail about the finding.
     *     @type \Google\Cloud\SecurityCenter\V1\Exfiltration $exfiltration
     *           Represents exfiltration associated with the Finding.
     *     @type array<\Google\Cloud\SecurityCenter\V1\IamBinding>|\Google\Protobuf\Internal\RepeatedField $iam_bindings
     *           Represents IAM bindings associated with the Finding.
     *     @type string $next_steps
     *           Next steps associate to the finding.
     *     @type array<\Google\Cloud\SecurityCenter\V1\Container>|\Google\Protobuf\Internal\RepeatedField $containers
     *           Containers associated with the finding. containers provides information
     *           for both Kubernetes and non-Kubernetes containers.
     *     @type \Google\Cloud\SecurityCenter\V1\Kubernetes $kubernetes
     *           Kubernetes resources associated with the finding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V1\Finding::initOnce();
        parent::__construct($data);
    }

    /**
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     *
     * Generated from protobuf field <code>string parent = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     *
     * Generated from protobuf field <code>string resource_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The state of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     *
     * Generated from protobuf field <code>string category = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setCategory($var)
    {
        GPBUtil::checkString($var, True);
        $this->category = $var;

        return $this;
    }

    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     * @return string
     */
    public function getExternalUri()
    {
        return $this->external_uri;
    }

    /**
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     *
     * Generated from protobuf field <code>string external_uri = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setExternalUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_uri = $var;

        return $this;
    }

    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getSourceProperties()
    {
        return $this->source_properties;
    }

    /**
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> source_properties = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setSourceProperties($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Value::class);
        $this->source_properties = $arr;

        return $this;
    }

    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\SecurityCenter\V1\SecurityMarks|null
     */
    public function getSecurityMarks()
    {
        return $this->security_marks;
    }

    public function hasSecurityMarks()
    {
        return isset($this->security_marks);
    }

    public function clearSecurityMarks()
    {
        unset($this->security_marks);
    }

    /**
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\SecurityCenter\V1\SecurityMarks $var
     * @return $this
     */
    public function setSecurityMarks($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\SecurityMarks::class);
        $this->security_marks = $var;

        return $this;
    }

    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTime()
    {
        return $this->event_time;
    }

    public function hasEventTime()
    {
        return isset($this->event_time);
    }

    public function clearEventTime()
    {
        unset($this->event_time);
    }

    /**
     * The time the finding was first detected. If an existing finding is updated,
     * then this is the time the update occurred.
     * For example, if the finding represents an open firewall, this property
     * captures the time the detector believes the firewall became open. The
     * accuracy is determined by the detector. If the finding is later resolved,
     * then this time reflects when the finding was resolved. This must not
     * be set to a value greater than the current timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 9;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_time = $var;

        return $this;
    }

    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * The time at which the finding was created in Security Command Center.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     * @return int
     */
    public function getSeverity()
    {
        return $this->severity;
    }

    /**
     * The severity of the finding. This field is managed by the source that
     * writes the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Severity severity = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setSeverity($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\Severity::class);
        $this->severity = $var;

        return $this;
    }

    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     * @return string
     */
    public function getCanonicalName()
    {
        return $this->canonical_name;
    }

    /**
     * The canonical name of the finding. It's either
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}",
     * "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
     * "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
     * depending on the closest CRM ancestor of the resource associated with the
     * finding.
     *
     * Generated from protobuf field <code>string canonical_name = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setCanonicalName($var)
    {
        GPBUtil::checkString($var, True);
        $this->canonical_name = $var;

        return $this;
    }

    /**
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     * @return int
     */
    public function getMute()
    {
        return $this->mute;
    }

    /**
     * Indicates the mute state of a finding (either muted, unmuted
     * or undefined). Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.Mute mute = 15;</code>
     * @param int $var
     * @return $this
     */
    public function setMute($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\Mute::class);
        $this->mute = $var;

        return $this;
    }

    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     * @return int
     */
    public function getFindingClass()
    {
        return $this->finding_class;
    }

    /**
     * The class of the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Finding.FindingClass finding_class = 17;</code>
     * @param int $var
     * @return $this
     */
    public function setFindingClass($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\Finding\FindingClass::class);
        $this->finding_class = $var;

        return $this;
    }

    /**
     * Represents what's commonly known as an Indicator of compromise (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion.
     * Reference: https://en.wikipedia.org/wiki/Indicator_of_compromise
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Indicator|null
     */
    public function getIndicator()
    {
        return $this->indicator;
    }

    public function hasIndicator()
    {
        return isset($this->indicator);
    }

    public function clearIndicator()
    {
        unset($this->indicator);
    }

    /**
     * Represents what's commonly known as an Indicator of compromise (IoC) in
     * computer forensics. This is an artifact observed on a network or in an
     * operating system that, with high confidence, indicates a computer
     * intrusion.
     * Reference: https://en.wikipedia.org/wiki/Indicator_of_compromise
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Indicator indicator = 18;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Indicator $var
     * @return $this
     */
    public function setIndicator($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Indicator::class);
        $this->indicator = $var;

        return $this;
    }

    /**
     * Represents vulnerability specific fields like cve, cvss scores etc.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Vulnerability|null
     */
    public function getVulnerability()
    {
        return $this->vulnerability;
    }

    public function hasVulnerability()
    {
        return isset($this->vulnerability);
    }

    public function clearVulnerability()
    {
        unset($this->vulnerability);
    }

    /**
     * Represents vulnerability specific fields like cve, cvss scores etc.
     * CVE stands for Common Vulnerabilities and Exposures
     * (https://cve.mitre.org/about/)
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Vulnerability vulnerability = 20;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Vulnerability $var
     * @return $this
     */
    public function setVulnerability($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Vulnerability::class);
        $this->vulnerability = $var;

        return $this;
    }

    /**
     * Output only. The most recent time this finding was muted or unmuted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getMuteUpdateTime()
    {
        return $this->mute_update_time;
    }

    public function hasMuteUpdateTime()
    {
        return isset($this->mute_update_time);
    }

    public function clearMuteUpdateTime()
    {
        unset($this->mute_update_time);
    }

    /**
     * Output only. The most recent time this finding was muted or unmuted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp mute_update_time = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setMuteUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->mute_update_time = $var;

        return $this;
    }

    /**
     * Output only. Third party SIEM/SOAR fields within SCC, contains external system
     * information and external system finding fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ExternalSystem> external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getExternalSystems()
    {
        return $this->external_systems;
    }

    /**
     * Output only. Third party SIEM/SOAR fields within SCC, contains external system
     * information and external system finding fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ExternalSystem> external_systems = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setExternalSystems($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\ExternalSystem::class);
        $this->external_systems = $arr;

        return $this;
    }

    /**
     * MITRE ATT&CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     * @return \Google\Cloud\SecurityCenter\V1\MitreAttack|null
     */
    public function getMitreAttack()
    {
        return $this->mitre_attack;
    }

    public function hasMitreAttack()
    {
        return isset($this->mitre_attack);
    }

    public function clearMitreAttack()
    {
        unset($this->mitre_attack);
    }

    /**
     * MITRE ATT&CK tactics and techniques related to this finding.
     * See: https://attack.mitre.org
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.MitreAttack mitre_attack = 25;</code>
     * @param \Google\Cloud\SecurityCenter\V1\MitreAttack $var
     * @return $this
     */
    public function setMitreAttack($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\MitreAttack::class);
        $this->mitre_attack = $var;

        return $this;
    }

    /**
     * Access details associated to the Finding, such as more information on the
     * caller, which method was accessed, from where, etc.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Access|null
     */
    public function getAccess()
    {
        return $this->access;
    }

    public function hasAccess()
    {
        return isset($this->access);
    }

    public function clearAccess()
    {
        unset($this->access);
    }

    /**
     * Access details associated to the Finding, such as more information on the
     * caller, which method was accessed, from where, etc.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Access access = 26;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Access $var
     * @return $this
     */
    public function setAccess($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Access::class);
        $this->access = $var;

        return $this;
    }

    /**
     * Contains information about the IP connection associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConnections()
    {
        return $this->connections;
    }

    /**
     * Contains information about the IP connection associated with the finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Connection connections = 31;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\Connection>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConnections($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\Connection::class);
        $this->connections = $arr;

        return $this;
    }

    /**
     * First known as mute_annotation. Records additional information about the
     * mute operation e.g. mute config that muted the finding, user who muted the
     * finding, etc. Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>string mute_initiator = 28;</code>
     * @return string
     */
    public function getMuteInitiator()
    {
        return $this->mute_initiator;
    }

    /**
     * First known as mute_annotation. Records additional information about the
     * mute operation e.g. mute config that muted the finding, user who muted the
     * finding, etc. Unlike other attributes of a finding, a finding provider
     * shouldn't set the value of mute.
     *
     * Generated from protobuf field <code>string mute_initiator = 28;</code>
     * @param string $var
     * @return $this
     */
    public function setMuteInitiator($var)
    {
        GPBUtil::checkString($var, True);
        $this->mute_initiator = $var;

        return $this;
    }

    /**
     * Represents operating system processes associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProcesses()
    {
        return $this->processes;
    }

    /**
     * Represents operating system processes associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Process processes = 30;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\Process>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProcesses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\Process::class);
        $this->processes = $arr;

        return $this;
    }

    /**
     * Output only. Map containing the point of contacts for the given finding. The key
     * represents the type of contact, while the value contains a list of all the
     * contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ContactDetails> contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getContacts()
    {
        return $this->contacts;
    }

    /**
     * Output only. Map containing the point of contacts for the given finding. The key
     * represents the type of contact, while the value contains a list of all the
     * contacts that pertain. Please refer to:
     * https://cloud.google.com/resource-manager/docs/managing-notification-contacts#notification-categories
     *     {
     *       "security": {
     *         "contacts": [
     *           {
     *             "email": "person1&#64;company.com"
     *           },
     *           {
     *             "email": "person2&#64;company.com"
     *           }
     *         ]
     *       }
     *     }
     *
     * Generated from protobuf field <code>map<string, .google.cloud.securitycenter.v1.ContactDetails> contacts = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setContacts($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\ContactDetails::class);
        $this->contacts = $arr;

        return $this;
    }

    /**
     * Contains compliance information for security standards associated to the
     * finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCompliances()
    {
        return $this->compliances;
    }

    /**
     * Contains compliance information for security standards associated to the
     * finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Compliance compliances = 34;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\Compliance>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCompliances($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\Compliance::class);
        $this->compliances = $arr;

        return $this;
    }

    /**
     * Contains more detail about the finding.
     *
     * Generated from protobuf field <code>string description = 37;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Contains more detail about the finding.
     *
     * Generated from protobuf field <code>string description = 37;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Represents exfiltration associated with the Finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Exfiltration|null
     */
    public function getExfiltration()
    {
        return $this->exfiltration;
    }

    public function hasExfiltration()
    {
        return isset($this->exfiltration);
    }

    public function clearExfiltration()
    {
        unset($this->exfiltration);
    }

    /**
     * Represents exfiltration associated with the Finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Exfiltration exfiltration = 38;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Exfiltration $var
     * @return $this
     */
    public function setExfiltration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Exfiltration::class);
        $this->exfiltration = $var;

        return $this;
    }

    /**
     * Represents IAM bindings associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIamBindings()
    {
        return $this->iam_bindings;
    }

    /**
     * Represents IAM bindings associated with the Finding.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.IamBinding iam_bindings = 39;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\IamBinding>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIamBindings($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\IamBinding::class);
        $this->iam_bindings = $arr;

        return $this;
    }

    /**
     * Next steps associate to the finding.
     *
     * Generated from protobuf field <code>string next_steps = 40;</code>
     * @return string
     */
    public function getNextSteps()
    {
        return $this->next_steps;
    }

    /**
     * Next steps associate to the finding.
     *
     * Generated from protobuf field <code>string next_steps = 40;</code>
     * @param string $var
     * @return $this
     */
    public function setNextSteps($var)
    {
        GPBUtil::checkString($var, True);
        $this->next_steps = $var;

        return $this;
    }

    /**
     * Containers associated with the finding. containers provides information
     * for both Kubernetes and non-Kubernetes containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContainers()
    {
        return $this->containers;
    }

    /**
     * Containers associated with the finding. containers provides information
     * for both Kubernetes and non-Kubernetes containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v1.Container containers = 42;</code>
     * @param array<\Google\Cloud\SecurityCenter\V1\Container>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContainers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V1\Container::class);
        $this->containers = $arr;

        return $this;
    }

    /**
     * Kubernetes resources associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     * @return \Google\Cloud\SecurityCenter\V1\Kubernetes|null
     */
    public function getKubernetes()
    {
        return $this->kubernetes;
    }

    public function hasKubernetes()
    {
        return isset($this->kubernetes);
    }

    public function clearKubernetes()
    {
        unset($this->kubernetes);
    }

    /**
     * Kubernetes resources associated with the finding.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.Kubernetes kubernetes = 43;</code>
     * @param \Google\Cloud\SecurityCenter\V1\Kubernetes $var
     * @return $this
     */
    public function setKubernetes($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\Kubernetes::class);
        $this->kubernetes = $var;

        return $this;
    }

}

