<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/documentai/v1/document_processor_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\DocumentAI\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;

use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DocumentAI\V1\BatchDocumentsInputConfig;
use Google\Cloud\DocumentAI\V1\BatchProcessRequest;
use Google\Cloud\DocumentAI\V1\CreateProcessorRequest;
use Google\Cloud\DocumentAI\V1\DeleteProcessorRequest;
use Google\Cloud\DocumentAI\V1\DeleteProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\DeployProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\DisableProcessorRequest;
use Google\Cloud\DocumentAI\V1\Document;
use Google\Cloud\DocumentAI\V1\DocumentOutputConfig;
use Google\Cloud\DocumentAI\V1\DocumentSchema;
use Google\Cloud\DocumentAI\V1\EnableProcessorRequest;
use Google\Cloud\DocumentAI\V1\FetchProcessorTypesRequest;
use Google\Cloud\DocumentAI\V1\FetchProcessorTypesResponse;
use Google\Cloud\DocumentAI\V1\GetProcessorRequest;
use Google\Cloud\DocumentAI\V1\GetProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\ListProcessorsRequest;
use Google\Cloud\DocumentAI\V1\ListProcessorsResponse;
use Google\Cloud\DocumentAI\V1\ListProcessorTypesRequest;
use Google\Cloud\DocumentAI\V1\ListProcessorTypesResponse;
use Google\Cloud\DocumentAI\V1\ListProcessorVersionsRequest;
use Google\Cloud\DocumentAI\V1\ListProcessorVersionsResponse;
use Google\Cloud\DocumentAI\V1\Processor;
use Google\Cloud\DocumentAI\V1\ProcessorVersion;
use Google\Cloud\DocumentAI\V1\ProcessRequest;
use Google\Cloud\DocumentAI\V1\ProcessResponse;
use Google\Cloud\DocumentAI\V1\RawDocument;
use Google\Cloud\DocumentAI\V1\ReviewDocumentRequest;
use Google\Cloud\DocumentAI\V1\ReviewDocumentRequest\Priority;
use Google\Cloud\DocumentAI\V1\SetDefaultProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\UndeployProcessorVersionRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Service to call Cloud DocumentAI to process documents according to the
 * processor's definition. Processors are built using state-of-the-art Google
 * AI such as natural language, computer vision, and translation to extract
 * structured information from unstructured or semi-structured documents.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
 * try {
 *     $name = 'name';
 *     $operationResponse = $documentProcessorServiceClient->batchProcessDocuments($name);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $documentProcessorServiceClient->batchProcessDocuments($name);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'batchProcessDocuments');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $documentProcessorServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class DocumentProcessorServiceGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.documentai.v1.DocumentProcessorService';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'documentai.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $humanReviewConfigNameTemplate;

    private static $locationNameTemplate;

    private static $processorNameTemplate;

    private static $processorVersionNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/document_processor_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/document_processor_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/document_processor_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/document_processor_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getHumanReviewConfigNameTemplate()
    {
        if (self::$humanReviewConfigNameTemplate == null) {
            self::$humanReviewConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/processors/{processor}/humanReviewConfig'
            );
        }

        return self::$humanReviewConfigNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getProcessorNameTemplate()
    {
        if (self::$processorNameTemplate == null) {
            self::$processorNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/processors/{processor}'
            );
        }

        return self::$processorNameTemplate;
    }

    private static function getProcessorVersionNameTemplate()
    {
        if (self::$processorVersionNameTemplate == null) {
            self::$processorVersionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}'
            );
        }

        return self::$processorVersionNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'humanReviewConfig' => self::getHumanReviewConfigNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'processor' => self::getProcessorNameTemplate(),
                'processorVersion' => self::getProcessorVersionNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * human_review_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processor
     *
     * @return string The formatted human_review_config resource.
     */
    public static function humanReviewConfigName(
        $project,
        $location,
        $processor
    ) {
        return self::getHumanReviewConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'processor' => $processor,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a processor
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processor
     *
     * @return string The formatted processor resource.
     */
    public static function processorName($project, $location, $processor)
    {
        return self::getProcessorNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'processor' => $processor,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * processor_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processor
     * @param string $processorVersion
     *
     * @return string The formatted processor_version resource.
     */
    public static function processorVersionName(
        $project,
        $location,
        $processor,
        $processorVersion
    ) {
        return self::getProcessorVersionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'processor' => $processor,
            'processor_version' => $processorVersion,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - humanReviewConfig: projects/{project}/locations/{location}/processors/{processor}/humanReviewConfig
     * - location: projects/{project}/locations/{location}
     * - processor: projects/{project}/locations/{location}/processors/{processor}
     * - processorVersion: projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'documentai.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * LRO endpoint to batch process many documents. The output is written
     * to Cloud Storage as JSON in the [Document] format.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $documentProcessorServiceClient->batchProcessDocuments($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->batchProcessDocuments($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'batchProcessDocuments');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of [Processor][google.cloud.documentai.v1.Processor] or
     *                             [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
     *                             Format: `projects/{project}/locations/{location}/processors/{processor}`,
     *                             or
     *                             `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type BatchDocumentsInputConfig $inputDocuments
     *           The input documents for batch process.
     *     @type DocumentOutputConfig $documentOutputConfig
     *           The overall output config for batch process.
     *     @type bool $skipHumanReview
     *           Whether Human Review feature should be skipped for this request. Default to
     *           false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchProcessDocuments($name, array $optionalArgs = [])
    {
        $request = new BatchProcessRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['inputDocuments'])) {
            $request->setInputDocuments($optionalArgs['inputDocuments']);
        }

        if (isset($optionalArgs['documentOutputConfig'])) {
            $request->setDocumentOutputConfig(
                $optionalArgs['documentOutputConfig']
            );
        }

        if (isset($optionalArgs['skipHumanReview'])) {
            $request->setSkipHumanReview($optionalArgs['skipHumanReview']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'BatchProcessDocuments',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a processor from the type processor that the user chose.
     * The processor will be at "ENABLED" state by default after its creation.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedParent = $documentProcessorServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $processor = new Processor();
     *     $response = $documentProcessorServiceClient->createProcessor($formattedParent, $processor);
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. The parent (project and location) under which to create the processor.
     *                                Format: `projects/{project}/locations/{location}`
     * @param Processor $processor    Required. The processor to be created, requires [processor_type] and [display_name]
     *                                to be set. Also, the processor is under CMEK if CMEK fields are set.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DocumentAI\V1\Processor
     *
     * @throws ApiException if the remote call fails
     */
    public function createProcessor(
        $parent,
        $processor,
        array $optionalArgs = []
    ) {
        $request = new CreateProcessorRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setProcessor($processor);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateProcessor',
            Processor::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes the processor, unloads all deployed model artifacts if it was
     * enabled and then deletes all artifacts associated with this processor.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedName = $documentProcessorServiceClient->processorName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     $operationResponse = $documentProcessorServiceClient->deleteProcessor($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->deleteProcessor($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'deleteProcessor');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The processor resource name to be deleted.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteProcessor($name, array $optionalArgs = [])
    {
        $request = new DeleteProcessorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteProcessor',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes the processor version, all artifacts under the processor version
     * will be deleted.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedName = $documentProcessorServiceClient->processorVersionName('[PROJECT]', '[LOCATION]', '[PROCESSOR]', '[PROCESSOR_VERSION]');
     *     $operationResponse = $documentProcessorServiceClient->deleteProcessorVersion($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->deleteProcessorVersion($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'deleteProcessorVersion');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The processor version resource name to be deleted.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteProcessorVersion($name, array $optionalArgs = [])
    {
        $request = new DeleteProcessorVersionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteProcessorVersion',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deploys the processor version.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedName = $documentProcessorServiceClient->processorVersionName('[PROJECT]', '[LOCATION]', '[PROCESSOR]', '[PROCESSOR_VERSION]');
     *     $operationResponse = $documentProcessorServiceClient->deployProcessorVersion($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->deployProcessorVersion($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'deployProcessorVersion');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The processor version resource name to be deployed.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deployProcessorVersion($name, array $optionalArgs = [])
    {
        $request = new DeployProcessorVersionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeployProcessorVersion',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Disables a processor
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedName = $documentProcessorServiceClient->processorName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     $operationResponse = $documentProcessorServiceClient->disableProcessor($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->disableProcessor($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'disableProcessor');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The processor resource name to be disabled.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function disableProcessor($name, array $optionalArgs = [])
    {
        $request = new DisableProcessorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DisableProcessor',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Enables a processor
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedName = $documentProcessorServiceClient->processorName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     $operationResponse = $documentProcessorServiceClient->enableProcessor($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->enableProcessor($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'enableProcessor');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The processor resource name to be enabled.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function enableProcessor($name, array $optionalArgs = [])
    {
        $request = new EnableProcessorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'EnableProcessor',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Fetches processor types. Note that we do not use ListProcessorTypes here
     * because it is not paginated.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedParent = $documentProcessorServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $documentProcessorServiceClient->fetchProcessorTypes($formattedParent);
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project of processor type to list.
     *                             The available processor types may depend on the allow-listing on projects.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DocumentAI\V1\FetchProcessorTypesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function fetchProcessorTypes($parent, array $optionalArgs = [])
    {
        $request = new FetchProcessorTypesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FetchProcessorTypes',
            FetchProcessorTypesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a processor detail.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedName = $documentProcessorServiceClient->processorName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     $response = $documentProcessorServiceClient->getProcessor($formattedName);
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The processor resource name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DocumentAI\V1\Processor
     *
     * @throws ApiException if the remote call fails
     */
    public function getProcessor($name, array $optionalArgs = [])
    {
        $request = new GetProcessorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetProcessor',
            Processor::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a processor version detail.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedName = $documentProcessorServiceClient->processorVersionName('[PROJECT]', '[LOCATION]', '[PROCESSOR]', '[PROCESSOR_VERSION]');
     *     $response = $documentProcessorServiceClient->getProcessorVersion($formattedName);
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The processor resource name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DocumentAI\V1\ProcessorVersion
     *
     * @throws ApiException if the remote call fails
     */
    public function getProcessorVersion($name, array $optionalArgs = [])
    {
        $request = new GetProcessorVersionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetProcessorVersion',
            ProcessorVersion::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists the processor types that exist.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedParent = $documentProcessorServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $documentProcessorServiceClient->listProcessorTypes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $documentProcessorServiceClient->listProcessorTypes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The location of processor type to list.
     *                             The available processor types may depend on the allow-listing on projects.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProcessorTypes($parent, array $optionalArgs = [])
    {
        $request = new ListProcessorTypesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListProcessorTypes',
            $optionalArgs,
            ListProcessorTypesResponse::class,
            $request
        );
    }

    /**
     * Lists all versions of a processor.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedParent = $documentProcessorServiceClient->processorName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $documentProcessorServiceClient->listProcessorVersions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $documentProcessorServiceClient->listProcessorVersions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent (project, location and processor) to list all versions.
     *                             Format: `projects/{project}/locations/{location}/processors/{processor}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProcessorVersions($parent, array $optionalArgs = [])
    {
        $request = new ListProcessorVersionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListProcessorVersions',
            $optionalArgs,
            ListProcessorVersionsResponse::class,
            $request
        );
    }

    /**
     * Lists all processors which belong to this project.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedParent = $documentProcessorServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $documentProcessorServiceClient->listProcessors($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $documentProcessorServiceClient->listProcessors($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent (project and location) which owns this collection of Processors.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProcessors($parent, array $optionalArgs = [])
    {
        $request = new ListProcessorsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListProcessors',
            $optionalArgs,
            ListProcessorsResponse::class,
            $request
        );
    }

    /**
     * Processes a single document.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $name = 'name';
     *     $response = $documentProcessorServiceClient->processDocument($name);
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the [Processor][google.cloud.documentai.v1.Processor] or
     *                             [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion]
     *                             to use for processing. If a [Processor][google.cloud.documentai.v1.Processor] is specified, the server will use
     *                             its [default version][google.cloud.documentai.v1.Processor.default_processor_version]. Format:
     *                             `projects/{project}/locations/{location}/processors/{processor}`, or
     *                             `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type Document $inlineDocument
     *           An inline document proto.
     *     @type RawDocument $rawDocument
     *           A raw document content (bytes).
     *     @type bool $skipHumanReview
     *           Whether Human Review feature should be skipped for this request. Default to
     *           false.
     *     @type FieldMask $fieldMask
     *           Specifies which fields to include in ProcessResponse's document.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DocumentAI\V1\ProcessResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function processDocument($name, array $optionalArgs = [])
    {
        $request = new ProcessRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['inlineDocument'])) {
            $request->setInlineDocument($optionalArgs['inlineDocument']);
        }

        if (isset($optionalArgs['rawDocument'])) {
            $request->setRawDocument($optionalArgs['rawDocument']);
        }

        if (isset($optionalArgs['skipHumanReview'])) {
            $request->setSkipHumanReview($optionalArgs['skipHumanReview']);
        }

        if (isset($optionalArgs['fieldMask'])) {
            $request->setFieldMask($optionalArgs['fieldMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ProcessDocument',
            ProcessResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Send a document for Human Review. The input document should be processed by
     * the specified processor.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedHumanReviewConfig = $documentProcessorServiceClient->humanReviewConfigName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     $operationResponse = $documentProcessorServiceClient->reviewDocument($formattedHumanReviewConfig);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->reviewDocument($formattedHumanReviewConfig);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'reviewDocument');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $humanReviewConfig Required. The resource name of the HumanReviewConfig that the document will be
     *                                  reviewed with.
     * @param array  $optionalArgs      {
     *     Optional.
     *
     *     @type Document $inlineDocument
     *           An inline document proto.
     *     @type bool $enableSchemaValidation
     *           Whether the validation should be performed on the ad-hoc review request.
     *     @type int $priority
     *           The priority of the human review task.
     *           For allowed values, use constants defined on {@see \Google\Cloud\DocumentAI\V1\ReviewDocumentRequest\Priority}
     *     @type DocumentSchema $documentSchema
     *           The document schema of the human review task.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function reviewDocument($humanReviewConfig, array $optionalArgs = [])
    {
        $request = new ReviewDocumentRequest();
        $requestParamHeaders = [];
        $request->setHumanReviewConfig($humanReviewConfig);
        $requestParamHeaders['human_review_config'] = $humanReviewConfig;
        if (isset($optionalArgs['inlineDocument'])) {
            $request->setInlineDocument($optionalArgs['inlineDocument']);
        }

        if (isset($optionalArgs['enableSchemaValidation'])) {
            $request->setEnableSchemaValidation(
                $optionalArgs['enableSchemaValidation']
            );
        }

        if (isset($optionalArgs['priority'])) {
            $request->setPriority($optionalArgs['priority']);
        }

        if (isset($optionalArgs['documentSchema'])) {
            $request->setDocumentSchema($optionalArgs['documentSchema']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ReviewDocument',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Set the default (active) version of a [Processor][google.cloud.documentai.v1.Processor] that will be used in
     * [ProcessDocument][google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument] and
     * [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments].
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedProcessor = $documentProcessorServiceClient->processorName('[PROJECT]', '[LOCATION]', '[PROCESSOR]');
     *     $formattedDefaultProcessorVersion = $documentProcessorServiceClient->processorVersionName('[PROJECT]', '[LOCATION]', '[PROCESSOR]', '[PROCESSOR_VERSION]');
     *     $operationResponse = $documentProcessorServiceClient->setDefaultProcessorVersion($formattedProcessor, $formattedDefaultProcessorVersion);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->setDefaultProcessorVersion($formattedProcessor, $formattedDefaultProcessorVersion);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'setDefaultProcessorVersion');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $processor               Required. The resource name of the [Processor][google.cloud.documentai.v1.Processor] to change default version.
     * @param string $defaultProcessorVersion Required. The resource name of child [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion] to use as default.
     *                                        Format:
     *                                        `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{version}`
     * @param array  $optionalArgs            {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setDefaultProcessorVersion(
        $processor,
        $defaultProcessorVersion,
        array $optionalArgs = []
    ) {
        $request = new SetDefaultProcessorVersionRequest();
        $requestParamHeaders = [];
        $request->setProcessor($processor);
        $request->setDefaultProcessorVersion($defaultProcessorVersion);
        $requestParamHeaders['processor'] = $processor;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'SetDefaultProcessorVersion',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Undeploys the processor version.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $formattedName = $documentProcessorServiceClient->processorVersionName('[PROJECT]', '[LOCATION]', '[PROCESSOR]', '[PROCESSOR_VERSION]');
     *     $operationResponse = $documentProcessorServiceClient->undeployProcessorVersion($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $documentProcessorServiceClient->undeployProcessorVersion($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $documentProcessorServiceClient->resumeOperation($operationName, 'undeployProcessorVersion');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The processor version resource name to be undeployed.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function undeployProcessorVersion($name, array $optionalArgs = [])
    {
        $request = new UndeployProcessorVersionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UndeployProcessorVersion',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     $response = $documentProcessorServiceClient->getLocation();
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $documentProcessorServiceClient = new DocumentProcessorServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $documentProcessorServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $documentProcessorServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $documentProcessorServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
