<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/model.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specification of a container for serving predictions. Some fields in this
 * message correspond to fields in the [Kubernetes Container v1 core
 * specification](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.ModelContainerSpec</code>
 */
class ModelContainerSpec extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Immutable. URI of the Docker image to be used as the custom container for serving
     * predictions. This URI must identify an image in Artifact Registry or
     * Container Registry. Learn more about the [container publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel], stored
     * internally, and this original path is afterwards not used.
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     *
     * Generated from protobuf field <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $image_uri = '';
    /**
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * <code>$(<var>VARIABLE_NAME</var>)</code>
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * <code>$$(<var>VARIABLE_NAME</var>)</code>
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $command;
    /**
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * <code>$(<var>VARIABLE_NAME</var>)</code>
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * <code>$$(<var>VARIABLE_NAME</var>)</code>
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $args;
    /**
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $env;
    /**
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $ports;
    /**
     * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     * forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1.PredictionService.Predict] to this
     * path on the container's IP address and port. Vertex AI then returns the
     * container's response in the API response.
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
     * <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
     * The placeholders in this value are replaced as follows:
     * * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * <var>DEPLOYED_MODEL</var>: [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * Generated from protobuf field <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $predict_route = '';
    /**
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
     * <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
     * The placeholders in this value are replaced as follows:
     * * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * <var>DEPLOYED_MODEL</var>: [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * Generated from protobuf field <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $health_route = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $image_uri
     *           Required. Immutable. URI of the Docker image to be used as the custom container for serving
     *           predictions. This URI must identify an image in Artifact Registry or
     *           Container Registry. Learn more about the [container publishing
     *           requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     *           including permissions requirements for the Vertex AI Service Agent.
     *           The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel], stored
     *           internally, and this original path is afterwards not used.
     *           To learn about the requirements for the Docker image itself, see
     *           [Custom container
     *           requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     *           You can use the URI to one of Vertex AI's [pre-built container images for
     *           prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     *           in this field.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $command
     *           Immutable. Specifies the command that runs when the container starts. This overrides
     *           the container's
     *           [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     *           Specify this field as an array of executable and arguments, similar to a
     *           Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     *           If you do not specify this field, then the container's `ENTRYPOINT` runs,
     *           in conjunction with the [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] field or the
     *           container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     *           if either exists. If this field is not specified and the container does not
     *           have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     *           `CMD` and `ENTRYPOINT`
     *           interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *           If you specify this field, then you can also specify the `args` field to
     *           provide additional arguments for this command. However, if you specify this
     *           field, then the container's `CMD` is ignored. See the
     *           [Kubernetes documentation about how the
     *           `command` and `args` fields interact with a container's `ENTRYPOINT` and
     *           `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *           In this field, you can reference [environment variables set by Vertex
     *           AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     *           and environment variables set in the [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field.
     *           You cannot reference environment variables set in the Docker image. In
     *           order for environment variables to be expanded, reference them by using the
     *           following syntax:
     *           <code>$(<var>VARIABLE_NAME</var>)</code>
     *           Note that this differs from Bash variable expansion, which does not use
     *           parentheses. If a variable cannot be resolved, the reference in the input
     *           string is used unchanged. To avoid variable expansion, you can escape this
     *           syntax with `$$`; for example:
     *           <code>$$(<var>VARIABLE_NAME</var>)</code>
     *           This field corresponds to the `command` field of the Kubernetes Containers
     *           [v1 core
     *           API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $args
     *           Immutable. Specifies arguments for the command that runs when the container starts.
     *           This overrides the container's
     *           [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     *           this field as an array of executable and arguments, similar to a Docker
     *           `CMD`'s "default parameters" form.
     *           If you don't specify this field but do specify the
     *           [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] field, then the command from the
     *           `command` field runs without any additional arguments. See the
     *           [Kubernetes documentation about how the
     *           `command` and `args` fields interact with a container's `ENTRYPOINT` and
     *           `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     *           If you don't specify this field and don't specify the `command` field,
     *           then the container's
     *           [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     *           `CMD` determine what runs based on their default behavior. See the Docker
     *           documentation about [how `CMD` and `ENTRYPOINT`
     *           interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     *           In this field, you can reference [environment variables
     *           set by Vertex
     *           AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     *           and environment variables set in the [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field.
     *           You cannot reference environment variables set in the Docker image. In
     *           order for environment variables to be expanded, reference them by using the
     *           following syntax:
     *           <code>$(<var>VARIABLE_NAME</var>)</code>
     *           Note that this differs from Bash variable expansion, which does not use
     *           parentheses. If a variable cannot be resolved, the reference in the input
     *           string is used unchanged. To avoid variable expansion, you can escape this
     *           syntax with `$$`; for example:
     *           <code>$$(<var>VARIABLE_NAME</var>)</code>
     *           This field corresponds to the `args` field of the Kubernetes Containers
     *           [v1 core
     *           API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *     @type array<\Google\Cloud\AIPlatform\V1\EnvVar>|\Google\Protobuf\Internal\RepeatedField $env
     *           Immutable. List of environment variables to set in the container. After the container
     *           starts running, code running in the container can read these environment
     *           variables.
     *           Additionally, the [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
     *           [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can reference these variables. Later
     *           entries in this list can also reference earlier entries. For example, the
     *           following example sets the variable `VAR_2` to have the value `foo bar`:
     *           ```json
     *           [
     *             {
     *               "name": "VAR_1",
     *               "value": "foo"
     *             },
     *             {
     *               "name": "VAR_2",
     *               "value": "$(VAR_1) bar"
     *             }
     *           ]
     *           ```
     *           If you switch the order of the variables in the example, then the expansion
     *           does not occur.
     *           This field corresponds to the `env` field of the Kubernetes Containers
     *           [v1 core
     *           API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *     @type array<\Google\Cloud\AIPlatform\V1\Port>|\Google\Protobuf\Internal\RepeatedField $ports
     *           Immutable. List of ports to expose from the container. Vertex AI sends any
     *           prediction requests that it receives to the first port on this list. Vertex
     *           AI also sends
     *           [liveness and health
     *           checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     *           to this port.
     *           If you do not specify this field, it defaults to following value:
     *           ```json
     *           [
     *             {
     *               "containerPort": 8080
     *             }
     *           ]
     *           ```
     *           Vertex AI does not use ports other than the first one listed. This field
     *           corresponds to the `ports` field of the Kubernetes Containers
     *           [v1 core
     *           API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *     @type string $predict_route
     *           Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     *           forwards requests sent using
     *           [projects.locations.endpoints.predict][google.cloud.aiplatform.v1.PredictionService.Predict] to this
     *           path on the container's IP address and port. Vertex AI then returns the
     *           container's response in the API response.
     *           For example, if you set this field to `/foo`, then when Vertex AI
     *           receives a prediction request, it forwards the request body in a POST
     *           request to the `/foo` path on the port of your container specified by the
     *           first value of this `ModelContainerSpec`'s
     *           [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
     *           If you don't specify this field, it defaults to the following value when
     *           you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
     *           <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
     *           The placeholders in this value are replaced as follows:
     *           * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
     *             Endpoint.name][] field of the Endpoint where this Model has been
     *             deployed. (Vertex AI makes this value available to your container code
     *             as the [`AIP_ENDPOINT_ID` environment
     *            variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *           * <var>DEPLOYED_MODEL</var>: [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the `DeployedModel`.
     *             (Vertex AI makes this value available to your container code
     *             as the [`AIP_DEPLOYED_MODEL_ID` environment
     *             variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *     @type string $health_route
     *           Immutable. HTTP path on the container to send health checks to. Vertex AI
     *           intermittently sends GET requests to this path on the container's IP
     *           address and port to check that the container is healthy. Read more about
     *           [health
     *           checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     *           For example, if you set this field to `/bar`, then Vertex AI
     *           intermittently sends a GET request to the `/bar` path on the port of your
     *           container specified by the first value of this `ModelContainerSpec`'s
     *           [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
     *           If you don't specify this field, it defaults to the following value when
     *           you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
     *           <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
     *           The placeholders in this value are replaced as follows:
     *           * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
     *             Endpoint.name][] field of the Endpoint where this Model has been
     *             deployed. (Vertex AI makes this value available to your container code
     *             as the [`AIP_ENDPOINT_ID` environment
     *             variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *           * <var>DEPLOYED_MODEL</var>: [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the `DeployedModel`.
     *             (Vertex AI makes this value available to your container code as the
     *             [`AIP_DEPLOYED_MODEL_ID` environment
     *             variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\Model::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Immutable. URI of the Docker image to be used as the custom container for serving
     * predictions. This URI must identify an image in Artifact Registry or
     * Container Registry. Learn more about the [container publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel], stored
     * internally, and this original path is afterwards not used.
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     *
     * Generated from protobuf field <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getImageUri()
    {
        return $this->image_uri;
    }

    /**
     * Required. Immutable. URI of the Docker image to be used as the custom container for serving
     * predictions. This URI must identify an image in Artifact Registry or
     * Container Registry. Learn more about the [container publishing
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing),
     * including permissions requirements for the Vertex AI Service Agent.
     * The container image is ingested upon [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel], stored
     * internally, and this original path is afterwards not used.
     * To learn about the requirements for the Docker image itself, see
     * [Custom container
     * requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#).
     * You can use the URI to one of Vertex AI's [pre-built container images for
     * prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers)
     * in this field.
     *
     * Generated from protobuf field <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setImageUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->image_uri = $var;

        return $this;
    }

    /**
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * <code>$(<var>VARIABLE_NAME</var>)</code>
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * <code>$$(<var>VARIABLE_NAME</var>)</code>
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCommand()
    {
        return $this->command;
    }

    /**
     * Immutable. Specifies the command that runs when the container starts. This overrides
     * the container's
     * [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint).
     * Specify this field as an array of executable and arguments, similar to a
     * Docker `ENTRYPOINT`'s "exec" form, not its "shell" form.
     * If you do not specify this field, then the container's `ENTRYPOINT` runs,
     * in conjunction with the [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] field or the
     * container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd),
     * if either exists. If this field is not specified and the container does not
     * have an `ENTRYPOINT`, then refer to the Docker documentation about [how
     * `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * If you specify this field, then you can also specify the `args` field to
     * provide additional arguments for this command. However, if you specify this
     * field, then the container's `CMD` is ignored. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * In this field, you can reference [environment variables set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * <code>$(<var>VARIABLE_NAME</var>)</code>
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * <code>$$(<var>VARIABLE_NAME</var>)</code>
     * This field corresponds to the `command` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated string command = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCommand($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->command = $arr;

        return $this;
    }

    /**
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * <code>$(<var>VARIABLE_NAME</var>)</code>
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * <code>$$(<var>VARIABLE_NAME</var>)</code>
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getArgs()
    {
        return $this->args;
    }

    /**
     * Immutable. Specifies arguments for the command that runs when the container starts.
     * This overrides the container's
     * [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
     * this field as an array of executable and arguments, similar to a Docker
     * `CMD`'s "default parameters" form.
     * If you don't specify this field but do specify the
     * [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] field, then the command from the
     * `command` field runs without any additional arguments. See the
     * [Kubernetes documentation about how the
     * `command` and `args` fields interact with a container's `ENTRYPOINT` and
     * `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes).
     * If you don't specify this field and don't specify the `command` field,
     * then the container's
     * [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and
     * `CMD` determine what runs based on their default behavior. See the Docker
     * documentation about [how `CMD` and `ENTRYPOINT`
     * interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact).
     * In this field, you can reference [environment variables
     * set by Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables)
     * and environment variables set in the [env][google.cloud.aiplatform.v1.ModelContainerSpec.env] field.
     * You cannot reference environment variables set in the Docker image. In
     * order for environment variables to be expanded, reference them by using the
     * following syntax:
     * <code>$(<var>VARIABLE_NAME</var>)</code>
     * Note that this differs from Bash variable expansion, which does not use
     * parentheses. If a variable cannot be resolved, the reference in the input
     * string is used unchanged. To avoid variable expansion, you can escape this
     * syntax with `$$`; for example:
     * <code>$$(<var>VARIABLE_NAME</var>)</code>
     * This field corresponds to the `args` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated string args = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setArgs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->args = $arr;

        return $this;
    }

    /**
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEnv()
    {
        return $this->env;
    }

    /**
     * Immutable. List of environment variables to set in the container. After the container
     * starts running, code running in the container can read these environment
     * variables.
     * Additionally, the [command][google.cloud.aiplatform.v1.ModelContainerSpec.command] and
     * [args][google.cloud.aiplatform.v1.ModelContainerSpec.args] fields can reference these variables. Later
     * entries in this list can also reference earlier entries. For example, the
     * following example sets the variable `VAR_2` to have the value `foo bar`:
     * ```json
     * [
     *   {
     *     "name": "VAR_1",
     *     "value": "foo"
     *   },
     *   {
     *     "name": "VAR_2",
     *     "value": "$(VAR_1) bar"
     *   }
     * ]
     * ```
     * If you switch the order of the variables in the example, then the expansion
     * does not occur.
     * This field corresponds to the `env` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array<\Google\Cloud\AIPlatform\V1\EnvVar>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEnv($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AIPlatform\V1\EnvVar::class);
        $this->env = $arr;

        return $this;
    }

    /**
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPorts()
    {
        return $this->ports;
    }

    /**
     * Immutable. List of ports to expose from the container. Vertex AI sends any
     * prediction requests that it receives to the first port on this list. Vertex
     * AI also sends
     * [liveness and health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness)
     * to this port.
     * If you do not specify this field, it defaults to following value:
     * ```json
     * [
     *   {
     *     "containerPort": 8080
     *   }
     * ]
     * ```
     * Vertex AI does not use ports other than the first one listed. This field
     * corresponds to the `ports` field of the Kubernetes Containers
     * [v1 core
     * API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.Port ports = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param array<\Google\Cloud\AIPlatform\V1\Port>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPorts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AIPlatform\V1\Port::class);
        $this->ports = $arr;

        return $this;
    }

    /**
     * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     * forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1.PredictionService.Predict] to this
     * path on the container's IP address and port. Vertex AI then returns the
     * container's response in the API response.
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
     * <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
     * The placeholders in this value are replaced as follows:
     * * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * <var>DEPLOYED_MODEL</var>: [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * Generated from protobuf field <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getPredictRoute()
    {
        return $this->predict_route;
    }

    /**
     * Immutable. HTTP path on the container to send prediction requests to. Vertex AI
     * forwards requests sent using
     * [projects.locations.endpoints.predict][google.cloud.aiplatform.v1.PredictionService.Predict] to this
     * path on the container's IP address and port. Vertex AI then returns the
     * container's response in the API response.
     * For example, if you set this field to `/foo`, then when Vertex AI
     * receives a prediction request, it forwards the request body in a POST
     * request to the `/foo` path on the port of your container specified by the
     * first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
     * <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
     * The placeholders in this value are replaced as follows:
     * * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *  variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * <var>DEPLOYED_MODEL</var>: [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code
     *   as the [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * Generated from protobuf field <code>string predict_route = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setPredictRoute($var)
    {
        GPBUtil::checkString($var, True);
        $this->predict_route = $var;

        return $this;
    }

    /**
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
     * <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
     * The placeholders in this value are replaced as follows:
     * * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * <var>DEPLOYED_MODEL</var>: [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * Generated from protobuf field <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getHealthRoute()
    {
        return $this->health_route;
    }

    /**
     * Immutable. HTTP path on the container to send health checks to. Vertex AI
     * intermittently sends GET requests to this path on the container's IP
     * address and port to check that the container is healthy. Read more about
     * [health
     * checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health).
     * For example, if you set this field to `/bar`, then Vertex AI
     * intermittently sends a GET request to the `/bar` path on the port of your
     * container specified by the first value of this `ModelContainerSpec`'s
     * [ports][google.cloud.aiplatform.v1.ModelContainerSpec.ports] field.
     * If you don't specify this field, it defaults to the following value when
     * you [deploy this Model to an Endpoint][google.cloud.aiplatform.v1.EndpointService.DeployModel]:
     * <code>/v1/endpoints/<var>ENDPOINT</var>/deployedModels/<var>DEPLOYED_MODEL</var>:predict</code>
     * The placeholders in this value are replaced as follows:
     * * <var>ENDPOINT</var>: The last segment (following `endpoints/`)of the
     *   Endpoint.name][] field of the Endpoint where this Model has been
     *   deployed. (Vertex AI makes this value available to your container code
     *   as the [`AIP_ENDPOINT_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     * * <var>DEPLOYED_MODEL</var>: [DeployedModel.id][google.cloud.aiplatform.v1.DeployedModel.id] of the `DeployedModel`.
     *   (Vertex AI makes this value available to your container code as the
     *   [`AIP_DEPLOYED_MODEL_ID` environment
     *   variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
     *
     * Generated from protobuf field <code>string health_route = 7 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setHealthRoute($var)
    {
        GPBUtil::checkString($var, True);
        $this->health_route = $var;

        return $this;
    }

}

