<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/tasks/v2beta3/queue.proto

namespace Google\Cloud\Tasks\V2beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A queue is a container of related tasks. Queues are configured to manage
 * how those tasks are dispatched. Configurable properties include rate limits,
 * retry options, queue types, and others.
 *
 * Generated from protobuf message <code>google.cloud.tasks.v2beta3.Queue</code>
 */
class Queue extends \Google\Protobuf\Internal\Message
{
    /**
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     */
    private $rate_limits = null;
    /**
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     */
    private $retry_config = null;
    /**
     * Output only. The state of the queue.
     * `state` can only be changed by calling
     * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
     */
    private $state = 0;
    /**
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp purge_time = 7;</code>
     */
    private $purge_time = null;
    /**
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_ttl = 8;</code>
     */
    private $task_ttl = null;
    /**
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     */
    private $tombstone_ttl = null;
    /**
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;</code>
     */
    private $stackdriver_logging_config = null;
    /**
     * Immutable. The type of a queue (push or pull).
     * `Queue.type` is an immutable property of the queue that is set at the queue
     * creation time. When left unspecified, the default value of `PUSH` is
     * selected.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $type = 0;
    /**
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $stats = null;
    protected $queue_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     *           after which it becomes output only.
     *           The queue name.
     *           The queue name must have the following format:
     *           `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *           * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *              hyphens (-), colons (:), or periods (.).
     *              For more information, see
     *              [Identifying
     *              projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     *           * `LOCATION_ID` is the canonical ID for the queue's location.
     *              The list of available locations can be obtained by calling
     *              [ListLocations][google.cloud.location.Locations.ListLocations].
     *              For more information, see https://cloud.google.com/about/locations/.
     *           * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *             hyphens (-). The maximum length is 100 characters.
     *     @type \Google\Cloud\Tasks\V2beta3\AppEngineHttpQueue $app_engine_http_queue
     *           [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     *           [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     *           [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     *     @type \Google\Cloud\Tasks\V2beta3\RateLimits $rate_limits
     *           Rate limits for task dispatches.
     *           [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     *           related because they both control task attempts. However they control task
     *           attempts in different ways:
     *           * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *             dispatches from a queue (i.e. all traffic dispatched from the
     *             queue, regardless of whether the dispatch is from a first
     *             attempt or a retry).
     *           * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *             particular a task after its first attempt fails. That is,
     *             [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *             second attempt, third attempt, etc).
     *           The queue's actual dispatch rate is the result of:
     *           * Number of tasks in the queue
     *           * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *             [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *             [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     *           * System throttling due to `429` (Too Many Requests) or `503` (Service
     *             Unavailable) responses from the worker, high error rates, or to smooth
     *             sudden large traffic spikes.
     *     @type \Google\Cloud\Tasks\V2beta3\RetryConfig $retry_config
     *           Settings that determine the retry behavior.
     *           * For tasks created using Cloud Tasks: the queue-level retry settings
     *             apply to all tasks in the queue that were created using Cloud Tasks.
     *             Retry settings cannot be set on individual tasks.
     *           * For tasks created using the App Engine SDK: the queue-level retry
     *             settings apply to all tasks in the queue which do not have retry settings
     *             explicitly set on the task and were created by the App Engine SDK. See
     *             [App Engine
     *             documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     *     @type int $state
     *           Output only. The state of the queue.
     *           `state` can only be changed by calling
     *           [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     *           [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     *           [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     *           [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     *     @type \Google\Protobuf\Timestamp $purge_time
     *           Output only. The last time this queue was purged.
     *           All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     *           were purged.
     *           A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     *           [App Engine Task Queue SDK, or the Cloud
     *           Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *           Purge time will be truncated to the nearest microsecond. Purge
     *           time will be unset if the queue has never been purged.
     *     @type \Google\Protobuf\Duration $task_ttl
     *           The maximum amount of time that a task will be retained in
     *           this queue.
     *           Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     *           After a task has lived for `task_ttl`, the task will be deleted
     *           regardless of whether it was dispatched or not.
     *           The `task_ttl` for queues created via queue.yaml/xml is equal to the
     *           maximum duration because there is a
     *           [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     *           these queues. To view the maximum valid duration, see the documentation for
     *           [Duration][google.protobuf.Duration].
     *     @type \Google\Protobuf\Duration $tombstone_ttl
     *           The task tombstone time to live (TTL).
     *           After a task is deleted or executed, the task's tombstone is
     *           retained for the length of time specified by `tombstone_ttl`.
     *           The tombstone is used by task de-duplication; another task with the same
     *           name can't be created until the tombstone has expired. For more information
     *           about task de-duplication, see the documentation for
     *           [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     *           Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     *     @type \Google\Cloud\Tasks\V2beta3\StackdriverLoggingConfig $stackdriver_logging_config
     *           Configuration options for writing logs to
     *           [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     *           field is unset, then no logs are written.
     *     @type int $type
     *           Immutable. The type of a queue (push or pull).
     *           `Queue.type` is an immutable property of the queue that is set at the queue
     *           creation time. When left unspecified, the default value of `PUSH` is
     *           selected.
     *     @type \Google\Cloud\Tasks\V2beta3\QueueStats $stats
     *           Output only. The realtime, informational statistics for a queue. In order
     *           to receive the statistics the caller should include this field in the
     *           FieldMask.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Tasks\V2Beta3\Queue::initOnce();
        parent::__construct($data);
    }

    /**
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     * @return \Google\Cloud\Tasks\V2beta3\AppEngineHttpQueue|null
     */
    public function getAppEngineHttpQueue()
    {
        return $this->readOneof(3);
    }

    public function hasAppEngineHttpQueue()
    {
        return $this->hasOneof(3);
    }

    /**
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     * @param \Google\Cloud\Tasks\V2beta3\AppEngineHttpQueue $var
     * @return $this
     */
    public function setAppEngineHttpQueue($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta3\AppEngineHttpQueue::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     * @return \Google\Cloud\Tasks\V2beta3\RateLimits|null
     */
    public function getRateLimits()
    {
        return $this->rate_limits;
    }

    public function hasRateLimits()
    {
        return isset($this->rate_limits);
    }

    public function clearRateLimits()
    {
        unset($this->rate_limits);
    }

    /**
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     * @param \Google\Cloud\Tasks\V2beta3\RateLimits $var
     * @return $this
     */
    public function setRateLimits($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta3\RateLimits::class);
        $this->rate_limits = $var;

        return $this;
    }

    /**
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     * @return \Google\Cloud\Tasks\V2beta3\RetryConfig|null
     */
    public function getRetryConfig()
    {
        return $this->retry_config;
    }

    public function hasRetryConfig()
    {
        return isset($this->retry_config);
    }

    public function clearRetryConfig()
    {
        unset($this->retry_config);
    }

    /**
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     * @param \Google\Cloud\Tasks\V2beta3\RetryConfig $var
     * @return $this
     */
    public function setRetryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta3\RetryConfig::class);
        $this->retry_config = $var;

        return $this;
    }

    /**
     * Output only. The state of the queue.
     * `state` can only be changed by calling
     * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the queue.
     * `state` can only be changed by calling
     * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Tasks\V2beta3\Queue\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp purge_time = 7;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getPurgeTime()
    {
        return $this->purge_time;
    }

    public function hasPurgeTime()
    {
        return isset($this->purge_time);
    }

    public function clearPurgeTime()
    {
        unset($this->purge_time);
    }

    /**
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp purge_time = 7;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setPurgeTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->purge_time = $var;

        return $this;
    }

    /**
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_ttl = 8;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTaskTtl()
    {
        return $this->task_ttl;
    }

    public function hasTaskTtl()
    {
        return isset($this->task_ttl);
    }

    public function clearTaskTtl()
    {
        unset($this->task_ttl);
    }

    /**
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_ttl = 8;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTaskTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->task_ttl = $var;

        return $this;
    }

    /**
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTombstoneTtl()
    {
        return $this->tombstone_ttl;
    }

    public function hasTombstoneTtl()
    {
        return isset($this->tombstone_ttl);
    }

    public function clearTombstoneTtl()
    {
        unset($this->tombstone_ttl);
    }

    /**
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTombstoneTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->tombstone_ttl = $var;

        return $this;
    }

    /**
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;</code>
     * @return \Google\Cloud\Tasks\V2beta3\StackdriverLoggingConfig|null
     */
    public function getStackdriverLoggingConfig()
    {
        return $this->stackdriver_logging_config;
    }

    public function hasStackdriverLoggingConfig()
    {
        return isset($this->stackdriver_logging_config);
    }

    public function clearStackdriverLoggingConfig()
    {
        unset($this->stackdriver_logging_config);
    }

    /**
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;</code>
     * @param \Google\Cloud\Tasks\V2beta3\StackdriverLoggingConfig $var
     * @return $this
     */
    public function setStackdriverLoggingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta3\StackdriverLoggingConfig::class);
        $this->stackdriver_logging_config = $var;

        return $this;
    }

    /**
     * Immutable. The type of a queue (push or pull).
     * `Queue.type` is an immutable property of the queue that is set at the queue
     * creation time. When left unspecified, the default value of `PUSH` is
     * selected.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Immutable. The type of a queue (push or pull).
     * `Queue.type` is an immutable property of the queue that is set at the queue
     * creation time. When left unspecified, the default value of `PUSH` is
     * selected.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Tasks\V2beta3\Queue\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Tasks\V2beta3\QueueStats|null
     */
    public function getStats()
    {
        return $this->stats;
    }

    public function hasStats()
    {
        return isset($this->stats);
    }

    public function clearStats()
    {
        unset($this->stats);
    }

    /**
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Tasks\V2beta3\QueueStats $var
     * @return $this
     */
    public function setStats($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta3\QueueStats::class);
        $this->stats = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getQueueType()
    {
        return $this->whichOneof("queue_type");
    }

}

