<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1beta4/cloud_sql_resources.proto

namespace Google\Cloud\Sql\V1beta4;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Database instance export context.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1beta4.ExportContext</code>
 */
class ExportContext extends \Google\Protobuf\Internal\Message
{
    /**
     * The path to the file in Google Cloud Storage where the export will be
     * stored. The URI is in the form <b>gs://bucketName/fileName</b>. If the file
     * already exists, the request succeeds, but the operation fails.
     * <br>If <b>fileType</b> is <b>SQL</b> and the filename ends with .gz,
     * the contents are compressed.
     *
     * Generated from protobuf field <code>string uri = 1;</code>
     */
    private $uri = '';
    /**
     * Databases to be exported. <br /> <b>MySQL instances:</b> If
     * <b>fileType</b> is <b>SQL</b> and no database is specified, all
     * databases are exported, except for the <b>mysql</b> system database.
     * If <b>fileType</b> is <b>CSV</b>, you can specify one database,
     * either by using this property or by using the
     * <b>csvExportOptions.selectQuery</b> property, which takes precedence
     * over this property. <br /> <b>PostgreSQL instances:</b> You must specify
     * one database to be exported. If <b>fileType</b> is <b>CSV</b>,
     * this database must match the one specified in the
     * <b>csvExportOptions.selectQuery</b> property. <br /> <b>SQL Server
     * instances:</b> You must specify one database to be exported, and the
     * <b>fileType</b> must be <b>BAK</b>.
     *
     * Generated from protobuf field <code>repeated string databases = 2;</code>
     */
    private $databases;
    /**
     * This is always <b>sql#exportContext</b>.
     *
     * Generated from protobuf field <code>string kind = 3;</code>
     */
    private $kind = '';
    /**
     * Options for exporting data as SQL statements.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ExportContext.SqlExportOptions sql_export_options = 4;</code>
     */
    private $sql_export_options = null;
    /**
     * Options for exporting data as CSV. <b>MySQL</b> and <b>PostgreSQL</b>
     * instances only.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ExportContext.SqlCsvExportOptions csv_export_options = 5;</code>
     */
    private $csv_export_options = null;
    /**
     * The file type for the specified uri. <br><b>SQL</b>: The file
     * contains SQL statements. <br><b>CSV</b>: The file contains CSV data.
     * <br><b>BAK</b>: The file contains backup data for a SQL Server instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlFileType file_type = 6;</code>
     */
    private $file_type = 0;
    /**
     * Option for export offload.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue offload = 8;</code>
     */
    private $offload = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $uri
     *           The path to the file in Google Cloud Storage where the export will be
     *           stored. The URI is in the form <b>gs://bucketName/fileName</b>. If the file
     *           already exists, the request succeeds, but the operation fails.
     *           <br>If <b>fileType</b> is <b>SQL</b> and the filename ends with .gz,
     *           the contents are compressed.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $databases
     *           Databases to be exported. <br /> <b>MySQL instances:</b> If
     *           <b>fileType</b> is <b>SQL</b> and no database is specified, all
     *           databases are exported, except for the <b>mysql</b> system database.
     *           If <b>fileType</b> is <b>CSV</b>, you can specify one database,
     *           either by using this property or by using the
     *           <b>csvExportOptions.selectQuery</b> property, which takes precedence
     *           over this property. <br /> <b>PostgreSQL instances:</b> You must specify
     *           one database to be exported. If <b>fileType</b> is <b>CSV</b>,
     *           this database must match the one specified in the
     *           <b>csvExportOptions.selectQuery</b> property. <br /> <b>SQL Server
     *           instances:</b> You must specify one database to be exported, and the
     *           <b>fileType</b> must be <b>BAK</b>.
     *     @type string $kind
     *           This is always <b>sql#exportContext</b>.
     *     @type \Google\Cloud\Sql\V1beta4\ExportContext\SqlExportOptions $sql_export_options
     *           Options for exporting data as SQL statements.
     *     @type \Google\Cloud\Sql\V1beta4\ExportContext\SqlCsvExportOptions $csv_export_options
     *           Options for exporting data as CSV. <b>MySQL</b> and <b>PostgreSQL</b>
     *           instances only.
     *     @type int $file_type
     *           The file type for the specified uri. <br><b>SQL</b>: The file
     *           contains SQL statements. <br><b>CSV</b>: The file contains CSV data.
     *           <br><b>BAK</b>: The file contains backup data for a SQL Server instance.
     *     @type \Google\Protobuf\BoolValue $offload
     *           Option for export offload.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1Beta4\CloudSqlResources::initOnce();
        parent::__construct($data);
    }

    /**
     * The path to the file in Google Cloud Storage where the export will be
     * stored. The URI is in the form <b>gs://bucketName/fileName</b>. If the file
     * already exists, the request succeeds, but the operation fails.
     * <br>If <b>fileType</b> is <b>SQL</b> and the filename ends with .gz,
     * the contents are compressed.
     *
     * Generated from protobuf field <code>string uri = 1;</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * The path to the file in Google Cloud Storage where the export will be
     * stored. The URI is in the form <b>gs://bucketName/fileName</b>. If the file
     * already exists, the request succeeds, but the operation fails.
     * <br>If <b>fileType</b> is <b>SQL</b> and the filename ends with .gz,
     * the contents are compressed.
     *
     * Generated from protobuf field <code>string uri = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * Databases to be exported. <br /> <b>MySQL instances:</b> If
     * <b>fileType</b> is <b>SQL</b> and no database is specified, all
     * databases are exported, except for the <b>mysql</b> system database.
     * If <b>fileType</b> is <b>CSV</b>, you can specify one database,
     * either by using this property or by using the
     * <b>csvExportOptions.selectQuery</b> property, which takes precedence
     * over this property. <br /> <b>PostgreSQL instances:</b> You must specify
     * one database to be exported. If <b>fileType</b> is <b>CSV</b>,
     * this database must match the one specified in the
     * <b>csvExportOptions.selectQuery</b> property. <br /> <b>SQL Server
     * instances:</b> You must specify one database to be exported, and the
     * <b>fileType</b> must be <b>BAK</b>.
     *
     * Generated from protobuf field <code>repeated string databases = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDatabases()
    {
        return $this->databases;
    }

    /**
     * Databases to be exported. <br /> <b>MySQL instances:</b> If
     * <b>fileType</b> is <b>SQL</b> and no database is specified, all
     * databases are exported, except for the <b>mysql</b> system database.
     * If <b>fileType</b> is <b>CSV</b>, you can specify one database,
     * either by using this property or by using the
     * <b>csvExportOptions.selectQuery</b> property, which takes precedence
     * over this property. <br /> <b>PostgreSQL instances:</b> You must specify
     * one database to be exported. If <b>fileType</b> is <b>CSV</b>,
     * this database must match the one specified in the
     * <b>csvExportOptions.selectQuery</b> property. <br /> <b>SQL Server
     * instances:</b> You must specify one database to be exported, and the
     * <b>fileType</b> must be <b>BAK</b>.
     *
     * Generated from protobuf field <code>repeated string databases = 2;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDatabases($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->databases = $arr;

        return $this;
    }

    /**
     * This is always <b>sql#exportContext</b>.
     *
     * Generated from protobuf field <code>string kind = 3;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * This is always <b>sql#exportContext</b>.
     *
     * Generated from protobuf field <code>string kind = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Options for exporting data as SQL statements.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ExportContext.SqlExportOptions sql_export_options = 4;</code>
     * @return \Google\Cloud\Sql\V1beta4\ExportContext\SqlExportOptions|null
     */
    public function getSqlExportOptions()
    {
        return $this->sql_export_options;
    }

    public function hasSqlExportOptions()
    {
        return isset($this->sql_export_options);
    }

    public function clearSqlExportOptions()
    {
        unset($this->sql_export_options);
    }

    /**
     * Options for exporting data as SQL statements.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ExportContext.SqlExportOptions sql_export_options = 4;</code>
     * @param \Google\Cloud\Sql\V1beta4\ExportContext\SqlExportOptions $var
     * @return $this
     */
    public function setSqlExportOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\ExportContext\SqlExportOptions::class);
        $this->sql_export_options = $var;

        return $this;
    }

    /**
     * Options for exporting data as CSV. <b>MySQL</b> and <b>PostgreSQL</b>
     * instances only.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ExportContext.SqlCsvExportOptions csv_export_options = 5;</code>
     * @return \Google\Cloud\Sql\V1beta4\ExportContext\SqlCsvExportOptions|null
     */
    public function getCsvExportOptions()
    {
        return $this->csv_export_options;
    }

    public function hasCsvExportOptions()
    {
        return isset($this->csv_export_options);
    }

    public function clearCsvExportOptions()
    {
        unset($this->csv_export_options);
    }

    /**
     * Options for exporting data as CSV. <b>MySQL</b> and <b>PostgreSQL</b>
     * instances only.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ExportContext.SqlCsvExportOptions csv_export_options = 5;</code>
     * @param \Google\Cloud\Sql\V1beta4\ExportContext\SqlCsvExportOptions $var
     * @return $this
     */
    public function setCsvExportOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\ExportContext\SqlCsvExportOptions::class);
        $this->csv_export_options = $var;

        return $this;
    }

    /**
     * The file type for the specified uri. <br><b>SQL</b>: The file
     * contains SQL statements. <br><b>CSV</b>: The file contains CSV data.
     * <br><b>BAK</b>: The file contains backup data for a SQL Server instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlFileType file_type = 6;</code>
     * @return int
     */
    public function getFileType()
    {
        return $this->file_type;
    }

    /**
     * The file type for the specified uri. <br><b>SQL</b>: The file
     * contains SQL statements. <br><b>CSV</b>: The file contains CSV data.
     * <br><b>BAK</b>: The file contains backup data for a SQL Server instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlFileType file_type = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setFileType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1beta4\SqlFileType::class);
        $this->file_type = $var;

        return $this;
    }

    /**
     * Option for export offload.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue offload = 8;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getOffload()
    {
        return $this->offload;
    }

    public function hasOffload()
    {
        return isset($this->offload);
    }

    public function clearOffload()
    {
        unset($this->offload);
    }

    /**
     * Returns the unboxed value from <code>getOffload()</code>

     * Option for export offload.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue offload = 8;</code>
     * @return bool|null
     */
    public function getOffloadValue()
    {
        return $this->readWrapperValue("offload");
    }

    /**
     * Option for export offload.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue offload = 8;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setOffload($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->offload = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Option for export offload.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue offload = 8;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setOffloadValue($var)
    {
        $this->writeWrapperValue("offload", $var);
        return $this;}

}

