<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/redis/v1beta1/cloud_redis.proto

namespace Google\Cloud\Redis\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Google Cloud Redis instance.
 *
 * Generated from protobuf message <code>google.cloud.redis.v1beta1.Instance</code>
 */
class Instance extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to
     * [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id]
     * fields for more details.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $name = '';
    /**
     * An arbitrary and optional user-provided name for the instance.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    private $display_name = '';
    /**
     * Resource labels to represent user provided metadata
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     */
    private $labels;
    /**
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone from the specified region for the instance.
     * For standard tier, additional nodes will be added across multiple zones for
     * protection against zonal failures. If specified, at least one node will be
     * provisioned in this zone.
     *
     * Generated from protobuf field <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $location_id = '';
    /**
     * Optional. If specified, at least one node will be provisioned in this zone
     * in addition to the zone specified in location_id. Only applicable to
     * standard tier. If provided, it must be a different zone from the one
     * provided in [location_id]. Additional nodes beyond the first 2 will be
     * placed in zones selected by the service.
     *
     * Generated from protobuf field <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $alternative_location_id = '';
    /**
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_5_0` for Redis 5.0 compatibility
     *  *   `REDIS_6_X` for Redis 6.x compatibility
     *
     * Generated from protobuf field <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $redis_version = '';
    /**
     * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     * that are reserved for this instance. Range must
     * be unique and non-overlapping with existing subnets in an authorized
     * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     * address ranges associated with this private service access connection.
     * If not provided, the service will choose an unused /29 block, for
     * example, 10.0.0.0/29 or 192.168.0.0/29. For READ_REPLICAS_ENABLED
     * the default block size is /28.
     *
     * Generated from protobuf field <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $reserved_ip_range = '';
    /**
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     *  clients to connect to the service.
     *
     * Generated from protobuf field <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $host = '';
    /**
     * Output only. The port number of the exposed Redis endpoint.
     *
     * Generated from protobuf field <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $port = 0;
    /**
     * Output only. The current zone where the Redis primary node is located. In
     * basic tier, this will always be the same as [location_id]. In
     * standard tier, this can be the zone of any node in the instance.
     *
     * Generated from protobuf field <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $current_location_id = '';
    /**
     * Output only. The time the instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The current state of this instance.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Additional information about the current status of this
     * instance, if available.
     *
     * Generated from protobuf field <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $status_message = '';
    /**
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis version 3.2 and newer:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis version 4.0 and newer:
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *  Redis version 5.0 and newer:
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     *
     * Generated from protobuf field <code>map<string, string> redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $redis_configs;
    /**
     * Required. The service tier of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $tier = 0;
    /**
     * Required. Redis memory size in GiB.
     *
     * Generated from protobuf field <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $memory_size_gb = 0;
    /**
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     *
     * Generated from protobuf field <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $authorized_network = '';
    /**
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:<service_account_email>". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     *
     * Generated from protobuf field <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $persistence_iam_identity = '';
    /**
     * Optional. The network connect mode of the Redis instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $connect_mode = 0;
    /**
     * Optional. The number of replica nodes. Valid range for standard tier
     * is [1-5] and defaults to 1. Valid value for basic tier is 0 and defaults
     * to 0.
     *
     * Generated from protobuf field <code>int32 replica_count = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $replica_count = 0;
    /**
     * Output only. Info per node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.v1beta1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $nodes;
    /**
     * Output only. Hostname or IP address of the exposed readonly Redis
     * endpoint. Standard tier only. Targets all healthy replica nodes in
     * instance. Replication is asynchronous and replica nodes will exhibit some
     * lag behind the primary. Write requests must target 'host'.
     *
     * Generated from protobuf field <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $read_endpoint = '';
    /**
     * Output only. The port number of the exposed readonly redis
     * endpoint. Standard tier only. Write requests should target 'port'.
     *
     * Generated from protobuf field <code>int32 read_endpoint_port = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $read_endpoint_port = 0;
    /**
     * Optional. Read replica mode.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $read_replicas_mode = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Unique name of the resource in this scope including project and
     *           location using the form:
     *               `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *           Note: Redis instances are managed and addressed at regional level so
     *           location_id here refers to a GCP region; however, users may choose which
     *           specific zone (or collection of zones for cross-zone instances) an instance
     *           should be provisioned in. Refer to
     *           [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     *           [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id]
     *           fields for more details.
     *     @type string $display_name
     *           An arbitrary and optional user-provided name for the instance.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Resource labels to represent user provided metadata
     *     @type string $location_id
     *           Optional. The zone where the instance will be provisioned. If not provided,
     *           the service will choose a zone from the specified region for the instance.
     *           For standard tier, additional nodes will be added across multiple zones for
     *           protection against zonal failures. If specified, at least one node will be
     *           provisioned in this zone.
     *     @type string $alternative_location_id
     *           Optional. If specified, at least one node will be provisioned in this zone
     *           in addition to the zone specified in location_id. Only applicable to
     *           standard tier. If provided, it must be a different zone from the one
     *           provided in [location_id]. Additional nodes beyond the first 2 will be
     *           placed in zones selected by the service.
     *     @type string $redis_version
     *           Optional. The version of Redis software.
     *           If not provided, latest supported version will be used. Currently, the
     *           supported values are:
     *            *   `REDIS_3_2` for Redis 3.2 compatibility
     *            *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *            *   `REDIS_5_0` for Redis 5.0 compatibility
     *            *   `REDIS_6_X` for Redis 6.x compatibility
     *     @type string $reserved_ip_range
     *           Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     *           that are reserved for this instance. Range must
     *           be unique and non-overlapping with existing subnets in an authorized
     *           network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     *           address ranges associated with this private service access connection.
     *           If not provided, the service will choose an unused /29 block, for
     *           example, 10.0.0.0/29 or 192.168.0.0/29. For READ_REPLICAS_ENABLED
     *           the default block size is /28.
     *     @type string $host
     *           Output only. Hostname or IP address of the exposed Redis endpoint used by
     *            clients to connect to the service.
     *     @type int $port
     *           Output only. The port number of the exposed Redis endpoint.
     *     @type string $current_location_id
     *           Output only. The current zone where the Redis primary node is located. In
     *           basic tier, this will always be the same as [location_id]. In
     *           standard tier, this can be the zone of any node in the instance.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time the instance was created.
     *     @type int $state
     *           Output only. The current state of this instance.
     *     @type string $status_message
     *           Output only. Additional information about the current status of this
     *           instance, if available.
     *     @type array|\Google\Protobuf\Internal\MapField $redis_configs
     *           Optional. Redis configuration parameters, according to
     *           http://redis.io/topics/config. Currently, the only supported parameters
     *           are:
     *            Redis version 3.2 and newer:
     *            *   maxmemory-policy
     *            *   notify-keyspace-events
     *            Redis version 4.0 and newer:
     *            *   activedefrag
     *            *   lfu-decay-time
     *            *   lfu-log-factor
     *            *   maxmemory-gb
     *            Redis version 5.0 and newer:
     *            *   stream-node-max-bytes
     *            *   stream-node-max-entries
     *     @type int $tier
     *           Required. The service tier of the instance.
     *     @type int $memory_size_gb
     *           Required. Redis memory size in GiB.
     *     @type string $authorized_network
     *           Optional. The full name of the Google Compute Engine
     *           [network](https://cloud.google.com/vpc/docs/vpc) to which the
     *           instance is connected. If left unspecified, the `default` network
     *           will be used.
     *     @type string $persistence_iam_identity
     *           Output only. Cloud IAM identity used by import / export operations to
     *           transfer data to/from Cloud Storage. Format is
     *           "serviceAccount:<service_account_email>". The value may change over time
     *           for a given instance so should be checked before each import/export
     *           operation.
     *     @type int $connect_mode
     *           Optional. The network connect mode of the Redis instance.
     *           If not provided, the connect mode defaults to DIRECT_PEERING.
     *     @type int $replica_count
     *           Optional. The number of replica nodes. Valid range for standard tier
     *           is [1-5] and defaults to 1. Valid value for basic tier is 0 and defaults
     *           to 0.
     *     @type \Google\Cloud\Redis\V1beta1\NodeInfo[]|\Google\Protobuf\Internal\RepeatedField $nodes
     *           Output only. Info per node.
     *     @type string $read_endpoint
     *           Output only. Hostname or IP address of the exposed readonly Redis
     *           endpoint. Standard tier only. Targets all healthy replica nodes in
     *           instance. Replication is asynchronous and replica nodes will exhibit some
     *           lag behind the primary. Write requests must target 'host'.
     *     @type int $read_endpoint_port
     *           Output only. The port number of the exposed readonly redis
     *           endpoint. Standard tier only. Write requests should target 'port'.
     *     @type int $read_replicas_mode
     *           Optional. Read replica mode.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Redis\V1Beta1\CloudRedis::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to
     * [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id]
     * fields for more details.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * Note: Redis instances are managed and addressed at regional level so
     * location_id here refers to a GCP region; however, users may choose which
     * specific zone (or collection of zones for cross-zone instances) an instance
     * should be provisioned in. Refer to
     * [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
     * [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id]
     * fields for more details.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * An arbitrary and optional user-provided name for the instance.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * An arbitrary and optional user-provided name for the instance.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Resource labels to represent user provided metadata
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Resource labels to represent user provided metadata
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone from the specified region for the instance.
     * For standard tier, additional nodes will be added across multiple zones for
     * protection against zonal failures. If specified, at least one node will be
     * provisioned in this zone.
     *
     * Generated from protobuf field <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getLocationId()
    {
        return $this->location_id;
    }

    /**
     * Optional. The zone where the instance will be provisioned. If not provided,
     * the service will choose a zone from the specified region for the instance.
     * For standard tier, additional nodes will be added across multiple zones for
     * protection against zonal failures. If specified, at least one node will be
     * provisioned in this zone.
     *
     * Generated from protobuf field <code>string location_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setLocationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->location_id = $var;

        return $this;
    }

    /**
     * Optional. If specified, at least one node will be provisioned in this zone
     * in addition to the zone specified in location_id. Only applicable to
     * standard tier. If provided, it must be a different zone from the one
     * provided in [location_id]. Additional nodes beyond the first 2 will be
     * placed in zones selected by the service.
     *
     * Generated from protobuf field <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAlternativeLocationId()
    {
        return $this->alternative_location_id;
    }

    /**
     * Optional. If specified, at least one node will be provisioned in this zone
     * in addition to the zone specified in location_id. Only applicable to
     * standard tier. If provided, it must be a different zone from the one
     * provided in [location_id]. Additional nodes beyond the first 2 will be
     * placed in zones selected by the service.
     *
     * Generated from protobuf field <code>string alternative_location_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAlternativeLocationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->alternative_location_id = $var;

        return $this;
    }

    /**
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_5_0` for Redis 5.0 compatibility
     *  *   `REDIS_6_X` for Redis 6.x compatibility
     *
     * Generated from protobuf field <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRedisVersion()
    {
        return $this->redis_version;
    }

    /**
     * Optional. The version of Redis software.
     * If not provided, latest supported version will be used. Currently, the
     * supported values are:
     *  *   `REDIS_3_2` for Redis 3.2 compatibility
     *  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
     *  *   `REDIS_5_0` for Redis 5.0 compatibility
     *  *   `REDIS_6_X` for Redis 6.x compatibility
     *
     * Generated from protobuf field <code>string redis_version = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRedisVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->redis_version = $var;

        return $this;
    }

    /**
     * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     * that are reserved for this instance. Range must
     * be unique and non-overlapping with existing subnets in an authorized
     * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     * address ranges associated with this private service access connection.
     * If not provided, the service will choose an unused /29 block, for
     * example, 10.0.0.0/29 or 192.168.0.0/29. For READ_REPLICAS_ENABLED
     * the default block size is /28.
     *
     * Generated from protobuf field <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getReservedIpRange()
    {
        return $this->reserved_ip_range;
    }

    /**
     * Optional. For DIRECT_PEERING mode, the CIDR range of internal addresses
     * that are reserved for this instance. Range must
     * be unique and non-overlapping with existing subnets in an authorized
     * network. For PRIVATE_SERVICE_ACCESS mode, the name of one allocated IP
     * address ranges associated with this private service access connection.
     * If not provided, the service will choose an unused /29 block, for
     * example, 10.0.0.0/29 or 192.168.0.0/29. For READ_REPLICAS_ENABLED
     * the default block size is /28.
     *
     * Generated from protobuf field <code>string reserved_ip_range = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setReservedIpRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->reserved_ip_range = $var;

        return $this;
    }

    /**
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     *  clients to connect to the service.
     *
     * Generated from protobuf field <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * Output only. Hostname or IP address of the exposed Redis endpoint used by
     *  clients to connect to the service.
     *
     * Generated from protobuf field <code>string host = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setHost($var)
    {
        GPBUtil::checkString($var, True);
        $this->host = $var;

        return $this;
    }

    /**
     * Output only. The port number of the exposed Redis endpoint.
     *
     * Generated from protobuf field <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * Output only. The port number of the exposed Redis endpoint.
     *
     * Generated from protobuf field <code>int32 port = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->port = $var;

        return $this;
    }

    /**
     * Output only. The current zone where the Redis primary node is located. In
     * basic tier, this will always be the same as [location_id]. In
     * standard tier, this can be the zone of any node in the instance.
     *
     * Generated from protobuf field <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCurrentLocationId()
    {
        return $this->current_location_id;
    }

    /**
     * Output only. The current zone where the Redis primary node is located. In
     * basic tier, this will always be the same as [location_id]. In
     * standard tier, this can be the zone of any node in the instance.
     *
     * Generated from protobuf field <code>string current_location_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCurrentLocationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->current_location_id = $var;

        return $this;
    }

    /**
     * Output only. The time the instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time the instance was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The current state of this instance.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of this instance.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.State state = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Redis\V1beta1\Instance\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Additional information about the current status of this
     * instance, if available.
     *
     * Generated from protobuf field <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStatusMessage()
    {
        return $this->status_message;
    }

    /**
     * Output only. Additional information about the current status of this
     * instance, if available.
     *
     * Generated from protobuf field <code>string status_message = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStatusMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->status_message = $var;

        return $this;
    }

    /**
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis version 3.2 and newer:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis version 4.0 and newer:
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *  Redis version 5.0 and newer:
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     *
     * Generated from protobuf field <code>map<string, string> redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getRedisConfigs()
    {
        return $this->redis_configs;
    }

    /**
     * Optional. Redis configuration parameters, according to
     * http://redis.io/topics/config. Currently, the only supported parameters
     * are:
     *  Redis version 3.2 and newer:
     *  *   maxmemory-policy
     *  *   notify-keyspace-events
     *  Redis version 4.0 and newer:
     *  *   activedefrag
     *  *   lfu-decay-time
     *  *   lfu-log-factor
     *  *   maxmemory-gb
     *  Redis version 5.0 and newer:
     *  *   stream-node-max-bytes
     *  *   stream-node-max-entries
     *
     * Generated from protobuf field <code>map<string, string> redis_configs = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setRedisConfigs($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->redis_configs = $arr;

        return $this;
    }

    /**
     * Required. The service tier of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getTier()
    {
        return $this->tier;
    }

    /**
     * Required. The service tier of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.Tier tier = 17 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setTier($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Redis\V1beta1\Instance\Tier::class);
        $this->tier = $var;

        return $this;
    }

    /**
     * Required. Redis memory size in GiB.
     *
     * Generated from protobuf field <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getMemorySizeGb()
    {
        return $this->memory_size_gb;
    }

    /**
     * Required. Redis memory size in GiB.
     *
     * Generated from protobuf field <code>int32 memory_size_gb = 18 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setMemorySizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->memory_size_gb = $var;

        return $this;
    }

    /**
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     *
     * Generated from protobuf field <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAuthorizedNetwork()
    {
        return $this->authorized_network;
    }

    /**
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     *
     * Generated from protobuf field <code>string authorized_network = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAuthorizedNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->authorized_network = $var;

        return $this;
    }

    /**
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:<service_account_email>". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     *
     * Generated from protobuf field <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPersistenceIamIdentity()
    {
        return $this->persistence_iam_identity;
    }

    /**
     * Output only. Cloud IAM identity used by import / export operations to
     * transfer data to/from Cloud Storage. Format is
     * "serviceAccount:<service_account_email>". The value may change over time
     * for a given instance so should be checked before each import/export
     * operation.
     *
     * Generated from protobuf field <code>string persistence_iam_identity = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPersistenceIamIdentity($var)
    {
        GPBUtil::checkString($var, True);
        $this->persistence_iam_identity = $var;

        return $this;
    }

    /**
     * Optional. The network connect mode of the Redis instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getConnectMode()
    {
        return $this->connect_mode;
    }

    /**
     * Optional. The network connect mode of the Redis instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.ConnectMode connect_mode = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setConnectMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Redis\V1beta1\Instance\ConnectMode::class);
        $this->connect_mode = $var;

        return $this;
    }

    /**
     * Optional. The number of replica nodes. Valid range for standard tier
     * is [1-5] and defaults to 1. Valid value for basic tier is 0 and defaults
     * to 0.
     *
     * Generated from protobuf field <code>int32 replica_count = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getReplicaCount()
    {
        return $this->replica_count;
    }

    /**
     * Optional. The number of replica nodes. Valid range for standard tier
     * is [1-5] and defaults to 1. Valid value for basic tier is 0 and defaults
     * to 0.
     *
     * Generated from protobuf field <code>int32 replica_count = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setReplicaCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->replica_count = $var;

        return $this;
    }

    /**
     * Output only. Info per node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.v1beta1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNodes()
    {
        return $this->nodes;
    }

    /**
     * Output only. Info per node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.redis.v1beta1.NodeInfo nodes = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Redis\V1beta1\NodeInfo[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Redis\V1beta1\NodeInfo::class);
        $this->nodes = $arr;

        return $this;
    }

    /**
     * Output only. Hostname or IP address of the exposed readonly Redis
     * endpoint. Standard tier only. Targets all healthy replica nodes in
     * instance. Replication is asynchronous and replica nodes will exhibit some
     * lag behind the primary. Write requests must target 'host'.
     *
     * Generated from protobuf field <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getReadEndpoint()
    {
        return $this->read_endpoint;
    }

    /**
     * Output only. Hostname or IP address of the exposed readonly Redis
     * endpoint. Standard tier only. Targets all healthy replica nodes in
     * instance. Replication is asynchronous and replica nodes will exhibit some
     * lag behind the primary. Write requests must target 'host'.
     *
     * Generated from protobuf field <code>string read_endpoint = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setReadEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->read_endpoint = $var;

        return $this;
    }

    /**
     * Output only. The port number of the exposed readonly redis
     * endpoint. Standard tier only. Write requests should target 'port'.
     *
     * Generated from protobuf field <code>int32 read_endpoint_port = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getReadEndpointPort()
    {
        return $this->read_endpoint_port;
    }

    /**
     * Output only. The port number of the exposed readonly redis
     * endpoint. Standard tier only. Write requests should target 'port'.
     *
     * Generated from protobuf field <code>int32 read_endpoint_port = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setReadEndpointPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->read_endpoint_port = $var;

        return $this;
    }

    /**
     * Optional. Read replica mode.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getReadReplicasMode()
    {
        return $this->read_replicas_mode;
    }

    /**
     * Optional. Read replica mode.
     *
     * Generated from protobuf field <code>.google.cloud.redis.v1beta1.Instance.ReadReplicasMode read_replicas_mode = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setReadReplicasMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Redis\V1beta1\Instance\ReadReplicasMode::class);
        $this->read_replicas_mode = $var;

        return $this;
    }

}

