<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/vulnerability.proto

namespace Google\Cloud\OsConfig\V1\VulnerabilityReport\Vulnerability;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Contains metadata information for the vulnerability. This information is
 * collected from the upstream feed of the operating system.
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details</code>
 */
class Details extends \Google\Protobuf\Internal\Message
{
    /**
     * The CVE of the vulnerability. CVE cannot be
     * empty and the combination of <cve, classification> should be unique
     * across vulnerabilities for a VM.
     *
     * Generated from protobuf field <code>string cve = 1;</code>
     */
    private $cve = '';
    /**
     * The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
     * 0 - 10 where 0 indicates low severity and 10 indicates high severity.
     *
     * Generated from protobuf field <code>float cvss_v2_score = 2;</code>
     */
    private $cvss_v2_score = 0.0;
    /**
     * The full description of the CVSSv3 for this vulnerability from NVD.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.CVSSv3 cvss_v3 = 3;</code>
     */
    private $cvss_v3 = null;
    /**
     * Assigned severity/impact ranking from the distro.
     *
     * Generated from protobuf field <code>string severity = 4;</code>
     */
    private $severity = '';
    /**
     * The note or description describing the vulnerability from the distro.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     */
    private $description = '';
    /**
     * Corresponds to the references attached to the `VulnerabilityDetails`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details.Reference references = 6;</code>
     */
    private $references;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $cve
     *           The CVE of the vulnerability. CVE cannot be
     *           empty and the combination of <cve, classification> should be unique
     *           across vulnerabilities for a VM.
     *     @type float $cvss_v2_score
     *           The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
     *           0 - 10 where 0 indicates low severity and 10 indicates high severity.
     *     @type \Google\Cloud\OsConfig\V1\CVSSv3 $cvss_v3
     *           The full description of the CVSSv3 for this vulnerability from NVD.
     *     @type string $severity
     *           Assigned severity/impact ranking from the distro.
     *     @type string $description
     *           The note or description describing the vulnerability from the distro.
     *     @type \Google\Cloud\OsConfig\V1\VulnerabilityReport\Vulnerability\Details\Reference[]|\Google\Protobuf\Internal\RepeatedField $references
     *           Corresponds to the references attached to the `VulnerabilityDetails`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\Vulnerability::initOnce();
        parent::__construct($data);
    }

    /**
     * The CVE of the vulnerability. CVE cannot be
     * empty and the combination of <cve, classification> should be unique
     * across vulnerabilities for a VM.
     *
     * Generated from protobuf field <code>string cve = 1;</code>
     * @return string
     */
    public function getCve()
    {
        return $this->cve;
    }

    /**
     * The CVE of the vulnerability. CVE cannot be
     * empty and the combination of <cve, classification> should be unique
     * across vulnerabilities for a VM.
     *
     * Generated from protobuf field <code>string cve = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setCve($var)
    {
        GPBUtil::checkString($var, True);
        $this->cve = $var;

        return $this;
    }

    /**
     * The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
     * 0 - 10 where 0 indicates low severity and 10 indicates high severity.
     *
     * Generated from protobuf field <code>float cvss_v2_score = 2;</code>
     * @return float
     */
    public function getCvssV2Score()
    {
        return $this->cvss_v2_score;
    }

    /**
     * The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
     * 0 - 10 where 0 indicates low severity and 10 indicates high severity.
     *
     * Generated from protobuf field <code>float cvss_v2_score = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setCvssV2Score($var)
    {
        GPBUtil::checkFloat($var);
        $this->cvss_v2_score = $var;

        return $this;
    }

    /**
     * The full description of the CVSSv3 for this vulnerability from NVD.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.CVSSv3 cvss_v3 = 3;</code>
     * @return \Google\Cloud\OsConfig\V1\CVSSv3|null
     */
    public function getCvssV3()
    {
        return $this->cvss_v3;
    }

    public function hasCvssV3()
    {
        return isset($this->cvss_v3);
    }

    public function clearCvssV3()
    {
        unset($this->cvss_v3);
    }

    /**
     * The full description of the CVSSv3 for this vulnerability from NVD.
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.CVSSv3 cvss_v3 = 3;</code>
     * @param \Google\Cloud\OsConfig\V1\CVSSv3 $var
     * @return $this
     */
    public function setCvssV3($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OsConfig\V1\CVSSv3::class);
        $this->cvss_v3 = $var;

        return $this;
    }

    /**
     * Assigned severity/impact ranking from the distro.
     *
     * Generated from protobuf field <code>string severity = 4;</code>
     * @return string
     */
    public function getSeverity()
    {
        return $this->severity;
    }

    /**
     * Assigned severity/impact ranking from the distro.
     *
     * Generated from protobuf field <code>string severity = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setSeverity($var)
    {
        GPBUtil::checkString($var, True);
        $this->severity = $var;

        return $this;
    }

    /**
     * The note or description describing the vulnerability from the distro.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * The note or description describing the vulnerability from the distro.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Corresponds to the references attached to the `VulnerabilityDetails`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details.Reference references = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReferences()
    {
        return $this->references;
    }

    /**
     * Corresponds to the references attached to the `VulnerabilityDetails`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Details.Reference references = 6;</code>
     * @param \Google\Cloud\OsConfig\V1\VulnerabilityReport\Vulnerability\Details\Reference[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReferences($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OsConfig\V1\VulnerabilityReport\Vulnerability\Details\Reference::class);
        $this->references = $arr;

        return $this;
    }

}


