<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/os_policy.proto

namespace Google\Cloud\OsConfig\V1\OSPolicy;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Resource groups provide a mechanism to group OS policy resources.
 * Resource groups enable OS policy authors to create a single OS policy
 * to be applied to VMs running different operating Systems.
 * When the OS policy is applied to a target VM, the appropriate resource
 * group within the OS policy is selected based on the `OSFilter` specified
 * within the resource group.
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.OSPolicy.ResourceGroup</code>
 */
class ResourceGroup extends \Google\Protobuf\Internal\Message
{
    /**
     * List of inventory filters for the resource group.
     * The resources in this resource group are applied to the target VM if it
     * satisfies at least one of the following inventory filters.
     * For example, to apply this resource group to VMs running either `RHEL` or
     * `CentOS` operating systems, specify 2 items for the list with following
     * values:
     * inventory_filters[0].os_short_name='rhel' and
     * inventory_filters[1].os_short_name='centos'
     * If the list is empty, this resource group will be applied to the target
     * VM unconditionally.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.InventoryFilter inventory_filters = 1;</code>
     */
    private $inventory_filters;
    /**
     * Required. List of resources configured for this resource group.
     * The resources are executed in the exact order specified here.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.Resource resources = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $resources;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\OsConfig\V1\OSPolicy\InventoryFilter[]|\Google\Protobuf\Internal\RepeatedField $inventory_filters
     *           List of inventory filters for the resource group.
     *           The resources in this resource group are applied to the target VM if it
     *           satisfies at least one of the following inventory filters.
     *           For example, to apply this resource group to VMs running either `RHEL` or
     *           `CentOS` operating systems, specify 2 items for the list with following
     *           values:
     *           inventory_filters[0].os_short_name='rhel' and
     *           inventory_filters[1].os_short_name='centos'
     *           If the list is empty, this resource group will be applied to the target
     *           VM unconditionally.
     *     @type \Google\Cloud\OsConfig\V1\OSPolicy\Resource[]|\Google\Protobuf\Internal\RepeatedField $resources
     *           Required. List of resources configured for this resource group.
     *           The resources are executed in the exact order specified here.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\OsPolicy::initOnce();
        parent::__construct($data);
    }

    /**
     * List of inventory filters for the resource group.
     * The resources in this resource group are applied to the target VM if it
     * satisfies at least one of the following inventory filters.
     * For example, to apply this resource group to VMs running either `RHEL` or
     * `CentOS` operating systems, specify 2 items for the list with following
     * values:
     * inventory_filters[0].os_short_name='rhel' and
     * inventory_filters[1].os_short_name='centos'
     * If the list is empty, this resource group will be applied to the target
     * VM unconditionally.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.InventoryFilter inventory_filters = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInventoryFilters()
    {
        return $this->inventory_filters;
    }

    /**
     * List of inventory filters for the resource group.
     * The resources in this resource group are applied to the target VM if it
     * satisfies at least one of the following inventory filters.
     * For example, to apply this resource group to VMs running either `RHEL` or
     * `CentOS` operating systems, specify 2 items for the list with following
     * values:
     * inventory_filters[0].os_short_name='rhel' and
     * inventory_filters[1].os_short_name='centos'
     * If the list is empty, this resource group will be applied to the target
     * VM unconditionally.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.InventoryFilter inventory_filters = 1;</code>
     * @param \Google\Cloud\OsConfig\V1\OSPolicy\InventoryFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInventoryFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OsConfig\V1\OSPolicy\InventoryFilter::class);
        $this->inventory_filters = $arr;

        return $this;
    }

    /**
     * Required. List of resources configured for this resource group.
     * The resources are executed in the exact order specified here.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.Resource resources = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResources()
    {
        return $this->resources;
    }

    /**
     * Required. List of resources configured for this resource group.
     * The resources are executed in the exact order specified here.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.Resource resources = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\OsConfig\V1\OSPolicy\Resource[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResources($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OsConfig\V1\OSPolicy\Resource::class);
        $this->resources = $arr;

        return $this;
    }

}


