<?php

return [
    'interfaces' => [
        'google.cloud.networksecurity.v1beta1.NetworkSecurity' => [
            'CreateAuthorizationPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\AuthorizationPolicy',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'CreateClientTlsPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\ClientTlsPolicy',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'CreateServerTlsPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\ServerTlsPolicy',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'DeleteAuthorizationPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Protobuf\GPBEmpty',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'DeleteClientTlsPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Protobuf\GPBEmpty',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'DeleteServerTlsPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Protobuf\GPBEmpty',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'UpdateAuthorizationPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\AuthorizationPolicy',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'UpdateClientTlsPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\ClientTlsPolicy',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'UpdateServerTlsPolicy' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\ServerTlsPolicy',
                    'metadataReturnType' => '\Google\Cloud\NetworkSecurity\V1beta1\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'ListAuthorizationPolicies' => [
                'pageStreaming' => [
                    'requestPageTokenGetMethod' => 'getPageToken',
                    'requestPageTokenSetMethod' => 'setPageToken',
                    'requestPageSizeGetMethod' => 'getPageSize',
                    'requestPageSizeSetMethod' => 'setPageSize',
                    'responsePageTokenGetMethod' => 'getNextPageToken',
                    'resourcesGetMethod' => 'getAuthorizationPolicies',
                ],
            ],
            'ListClientTlsPolicies' => [
                'pageStreaming' => [
                    'requestPageTokenGetMethod' => 'getPageToken',
                    'requestPageTokenSetMethod' => 'setPageToken',
                    'requestPageSizeGetMethod' => 'getPageSize',
                    'requestPageSizeSetMethod' => 'setPageSize',
                    'responsePageTokenGetMethod' => 'getNextPageToken',
                    'resourcesGetMethod' => 'getClientTlsPolicies',
                ],
            ],
            'ListServerTlsPolicies' => [
                'pageStreaming' => [
                    'requestPageTokenGetMethod' => 'getPageToken',
                    'requestPageTokenSetMethod' => 'setPageToken',
                    'requestPageSizeGetMethod' => 'getPageSize',
                    'requestPageSizeSetMethod' => 'setPageSize',
                    'responsePageTokenGetMethod' => 'getNextPageToken',
                    'resourcesGetMethod' => 'getServerTlsPolicies',
                ],
            ],
        ],
    ],
];
