<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkmanagement/v1/connectivity_test.proto

namespace Google\Cloud\NetworkManagement\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Source or destination of the Connectivity Test.
 *
 * Generated from protobuf message <code>google.cloud.networkmanagement.v1.Endpoint</code>
 */
class Endpoint extends \Google\Protobuf\Internal\Message
{
    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     * An IPv6 address is only allowed when the test's destination is a
     * [global load balancer VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     *
     * Generated from protobuf field <code>string ip_address = 1;</code>
     */
    private $ip_address = '';
    /**
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     *
     * Generated from protobuf field <code>int32 port = 2;</code>
     */
    private $port = 0;
    /**
     * A Compute Engine instance URI.
     *
     * Generated from protobuf field <code>string instance = 3;</code>
     */
    private $instance = '';
    /**
     * A cluster URI for [Google Kubernetes Engine
     * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *
     * Generated from protobuf field <code>string gke_master_cluster = 7;</code>
     */
    private $gke_master_cluster = '';
    /**
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     *
     * Generated from protobuf field <code>string cloud_sql_instance = 8;</code>
     */
    private $cloud_sql_instance = '';
    /**
     * A Compute Engine network URI.
     *
     * Generated from protobuf field <code>string network = 4;</code>
     */
    private $network = '';
    /**
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.NetworkType network_type = 5;</code>
     */
    private $network_type = 0;
    /**
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a GCP
     * project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     *
     * Generated from protobuf field <code>string project_id = 6;</code>
     */
    private $project_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $ip_address
     *           The IP address of the endpoint, which can be an external or internal IP.
     *           An IPv6 address is only allowed when the test's destination is a
     *           [global load balancer VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     *     @type int $port
     *           The IP protocol port of the endpoint.
     *           Only applicable when protocol is TCP or UDP.
     *     @type string $instance
     *           A Compute Engine instance URI.
     *     @type string $gke_master_cluster
     *           A cluster URI for [Google Kubernetes Engine
     *           master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *     @type string $cloud_sql_instance
     *           A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     *     @type string $network
     *           A Compute Engine network URI.
     *     @type int $network_type
     *           Type of the network where the endpoint is located.
     *           Applicable only to source endpoint, as destination network type can be
     *           inferred from the source.
     *     @type string $project_id
     *           Project ID where the endpoint is located.
     *           The Project ID can be derived from the URI if you provide a VM instance or
     *           network URI.
     *           The following are two cases where you must provide the project ID:
     *           1. Only the IP address is specified, and the IP address is within a GCP
     *           project.
     *           2. When you are using Shared VPC and the IP address that you provide is
     *           from the service project. In this case, the network that the IP address
     *           resides in is defined in the host project.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkmanagement\V1\ConnectivityTest::initOnce();
        parent::__construct($data);
    }

    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     * An IPv6 address is only allowed when the test's destination is a
     * [global load balancer VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     *
     * Generated from protobuf field <code>string ip_address = 1;</code>
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ip_address;
    }

    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     * An IPv6 address is only allowed when the test's destination is a
     * [global load balancer VIP](https://cloud.google.com/load-balancing/docs/load-balancing-overview).
     *
     * Generated from protobuf field <code>string ip_address = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->ip_address = $var;

        return $this;
    }

    /**
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     *
     * Generated from protobuf field <code>int32 port = 2;</code>
     * @return int
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     *
     * Generated from protobuf field <code>int32 port = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->port = $var;

        return $this;
    }

    /**
     * A Compute Engine instance URI.
     *
     * Generated from protobuf field <code>string instance = 3;</code>
     * @return string
     */
    public function getInstance()
    {
        return $this->instance;
    }

    /**
     * A Compute Engine instance URI.
     *
     * Generated from protobuf field <code>string instance = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance = $var;

        return $this;
    }

    /**
     * A cluster URI for [Google Kubernetes Engine
     * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *
     * Generated from protobuf field <code>string gke_master_cluster = 7;</code>
     * @return string
     */
    public function getGkeMasterCluster()
    {
        return $this->gke_master_cluster;
    }

    /**
     * A cluster URI for [Google Kubernetes Engine
     * master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *
     * Generated from protobuf field <code>string gke_master_cluster = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setGkeMasterCluster($var)
    {
        GPBUtil::checkString($var, True);
        $this->gke_master_cluster = $var;

        return $this;
    }

    /**
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     *
     * Generated from protobuf field <code>string cloud_sql_instance = 8;</code>
     * @return string
     */
    public function getCloudSqlInstance()
    {
        return $this->cloud_sql_instance;
    }

    /**
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     *
     * Generated from protobuf field <code>string cloud_sql_instance = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCloudSqlInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_sql_instance = $var;

        return $this;
    }

    /**
     * A Compute Engine network URI.
     *
     * Generated from protobuf field <code>string network = 4;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * A Compute Engine network URI.
     *
     * Generated from protobuf field <code>string network = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.NetworkType network_type = 5;</code>
     * @return int
     */
    public function getNetworkType()
    {
        return $this->network_type;
    }

    /**
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.NetworkType network_type = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setNetworkType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\Endpoint\NetworkType::class);
        $this->network_type = $var;

        return $this;
    }

    /**
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a GCP
     * project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     *
     * Generated from protobuf field <code>string project_id = 6;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a GCP
     * project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     *
     * Generated from protobuf field <code>string project_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

}

