<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/deploy/v1/cloud_deploy.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Deploy\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;

use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;

use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Deploy\V1\ApproveRolloutRequest;
use Google\Cloud\Deploy\V1\ApproveRolloutResponse;
use Google\Cloud\Deploy\V1\Config;
use Google\Cloud\Deploy\V1\CreateDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\CreateReleaseRequest;
use Google\Cloud\Deploy\V1\CreateRolloutRequest;
use Google\Cloud\Deploy\V1\CreateTargetRequest;
use Google\Cloud\Deploy\V1\DeleteDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\DeleteTargetRequest;
use Google\Cloud\Deploy\V1\DeliveryPipeline;
use Google\Cloud\Deploy\V1\GetConfigRequest;
use Google\Cloud\Deploy\V1\GetDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\GetReleaseRequest;
use Google\Cloud\Deploy\V1\GetRolloutRequest;
use Google\Cloud\Deploy\V1\GetTargetRequest;
use Google\Cloud\Deploy\V1\ListDeliveryPipelinesRequest;
use Google\Cloud\Deploy\V1\ListDeliveryPipelinesResponse;
use Google\Cloud\Deploy\V1\ListReleasesRequest;
use Google\Cloud\Deploy\V1\ListReleasesResponse;
use Google\Cloud\Deploy\V1\ListRolloutsRequest;
use Google\Cloud\Deploy\V1\ListRolloutsResponse;
use Google\Cloud\Deploy\V1\ListTargetsRequest;
use Google\Cloud\Deploy\V1\ListTargetsResponse;
use Google\Cloud\Deploy\V1\Release;
use Google\Cloud\Deploy\V1\Rollout;
use Google\Cloud\Deploy\V1\Target;
use Google\Cloud\Deploy\V1\UpdateDeliveryPipelineRequest;
use Google\Cloud\Deploy\V1\UpdateTargetRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: CloudDeploy service creates and manages Continuous Delivery operations
 * on Google Cloud Platform via Skaffold (https://skaffold.dev).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $cloudDeployClient = new CloudDeployClient();
 * try {
 *     $formattedName = $cloudDeployClient->rolloutName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]', '[RELEASE]', '[ROLLOUT]');
 *     $approved = false;
 *     $response = $cloudDeployClient->approveRollout($formattedName, $approved);
 * } finally {
 *     $cloudDeployClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class CloudDeployGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.deploy.v1.CloudDeploy';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'clouddeploy.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $buildNameTemplate;

    private static $configNameTemplate;

    private static $deliveryPipelineNameTemplate;

    private static $locationNameTemplate;

    private static $releaseNameTemplate;

    private static $rolloutNameTemplate;

    private static $targetNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/cloud_deploy_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/cloud_deploy_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/cloud_deploy_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/cloud_deploy_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getBuildNameTemplate()
    {
        if (self::$buildNameTemplate == null) {
            self::$buildNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/builds/{build}'
            );
        }

        return self::$buildNameTemplate;
    }

    private static function getConfigNameTemplate()
    {
        if (self::$configNameTemplate == null) {
            self::$configNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/config'
            );
        }

        return self::$configNameTemplate;
    }

    private static function getDeliveryPipelineNameTemplate()
    {
        if (self::$deliveryPipelineNameTemplate == null) {
            self::$deliveryPipelineNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}'
            );
        }

        return self::$deliveryPipelineNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getReleaseNameTemplate()
    {
        if (self::$releaseNameTemplate == null) {
            self::$releaseNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}'
            );
        }

        return self::$releaseNameTemplate;
    }

    private static function getRolloutNameTemplate()
    {
        if (self::$rolloutNameTemplate == null) {
            self::$rolloutNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}'
            );
        }

        return self::$rolloutNameTemplate;
    }

    private static function getTargetNameTemplate()
    {
        if (self::$targetNameTemplate == null) {
            self::$targetNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/targets/{target}'
            );
        }

        return self::$targetNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'build' => self::getBuildNameTemplate(),
                'config' => self::getConfigNameTemplate(),
                'deliveryPipeline' => self::getDeliveryPipelineNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'release' => self::getReleaseNameTemplate(),
                'rollout' => self::getRolloutNameTemplate(),
                'target' => self::getTargetNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a build
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $build
     *
     * @return string The formatted build resource.
     */
    public static function buildName($project, $location, $build)
    {
        return self::getBuildNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'build' => $build,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a config
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted config resource.
     */
    public static function configName($project, $location)
    {
        return self::getConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * delivery_pipeline resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     *
     * @return string The formatted delivery_pipeline resource.
     */
    public static function deliveryPipelineName(
        $project,
        $location,
        $deliveryPipeline
    ) {
        return self::getDeliveryPipelineNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a release
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $release
     *
     * @return string The formatted release resource.
     */
    public static function releaseName(
        $project,
        $location,
        $deliveryPipeline,
        $release
    ) {
        return self::getReleaseNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'release' => $release,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a rollout
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deliveryPipeline
     * @param string $release
     * @param string $rollout
     *
     * @return string The formatted rollout resource.
     */
    public static function rolloutName(
        $project,
        $location,
        $deliveryPipeline,
        $release,
        $rollout
    ) {
        return self::getRolloutNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'delivery_pipeline' => $deliveryPipeline,
            'release' => $release,
            'rollout' => $rollout,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a target
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $target
     *
     * @return string The formatted target resource.
     */
    public static function targetName($project, $location, $target)
    {
        return self::getTargetNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'target' => $target,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - build: projects/{project}/locations/{location}/builds/{build}
     * - config: projects/{project}/locations/{location}/config
     * - deliveryPipeline: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}
     * - location: projects/{project}/locations/{location}
     * - release: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}
     * - rollout: projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}
     * - target: projects/{project}/locations/{location}/targets/{target}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'clouddeploy.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Approves a Rollout.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedName = $cloudDeployClient->rolloutName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]', '[RELEASE]', '[ROLLOUT]');
     *     $approved = false;
     *     $response = $cloudDeployClient->approveRollout($formattedName, $approved);
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the Rollout. Format is
     *                             projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/
     *                             releases/{release}/rollouts/{rollout}.
     * @param bool   $approved     Required. True = approve; false = reject
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Deploy\V1\ApproveRolloutResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function approveRollout($name, $approved, array $optionalArgs = [])
    {
        $request = new ApproveRolloutRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setApproved($approved);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ApproveRollout',
            ApproveRolloutResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a new DeliveryPipeline in a given project and location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedParent = $cloudDeployClient->locationName('[PROJECT]', '[LOCATION]');
     *     $deliveryPipelineId = 'delivery_pipeline_id';
     *     $deliveryPipeline = new DeliveryPipeline();
     *     $operationResponse = $cloudDeployClient->createDeliveryPipeline($formattedParent, $deliveryPipelineId, $deliveryPipeline);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudDeployClient->createDeliveryPipeline($formattedParent, $deliveryPipelineId, $deliveryPipeline);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudDeployClient->resumeOperation($operationName, 'createDeliveryPipeline');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string           $parent             Required. The parent collection in which the `DeliveryPipeline` should be created.
     *                                             Format should be projects/{project_id}/locations/{location_name}.
     * @param string           $deliveryPipelineId Required. ID of the `DeliveryPipeline`.
     * @param DeliveryPipeline $deliveryPipeline   Required. The `DeliveryPipeline` to create.
     * @param array            $optionalArgs       {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. If set to true, the request is validated and the user is provided with
     *           an expected result, but no actual change is made.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createDeliveryPipeline(
        $parent,
        $deliveryPipelineId,
        $deliveryPipeline,
        array $optionalArgs = []
    ) {
        $request = new CreateDeliveryPipelineRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDeliveryPipelineId($deliveryPipelineId);
        $request->setDeliveryPipeline($deliveryPipeline);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateDeliveryPipeline',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Release in a given project and location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedParent = $cloudDeployClient->deliveryPipelineName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]');
     *     $releaseId = 'release_id';
     *     $release = new Release();
     *     $operationResponse = $cloudDeployClient->createRelease($formattedParent, $releaseId, $release);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudDeployClient->createRelease($formattedParent, $releaseId, $release);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudDeployClient->resumeOperation($operationName, 'createRelease');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent collection in which the `Release` should be created.
     *                              Format should be
     *                              projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}.
     * @param string  $releaseId    Required. ID of the `Release`.
     * @param Release $release      Required. The `Release` to create.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. If set to true, the request is validated and the user is provided with
     *           an expected result, but no actual change is made.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createRelease(
        $parent,
        $releaseId,
        $release,
        array $optionalArgs = []
    ) {
        $request = new CreateReleaseRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setReleaseId($releaseId);
        $request->setRelease($release);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateRelease',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Rollout in a given project and location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedParent = $cloudDeployClient->releaseName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]', '[RELEASE]');
     *     $rolloutId = 'rollout_id';
     *     $rollout = new Rollout();
     *     $operationResponse = $cloudDeployClient->createRollout($formattedParent, $rolloutId, $rollout);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudDeployClient->createRollout($formattedParent, $rolloutId, $rollout);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudDeployClient->resumeOperation($operationName, 'createRollout');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent collection in which the `Rollout` should be created.
     *                              Format should be
     *                              projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}.
     * @param string  $rolloutId    Required. ID of the `Rollout`.
     * @param Rollout $rollout      Required. The `Rollout` to create.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. If set to true, the request is validated and the user is provided with
     *           an expected result, but no actual change is made.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createRollout(
        $parent,
        $rolloutId,
        $rollout,
        array $optionalArgs = []
    ) {
        $request = new CreateRolloutRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRolloutId($rolloutId);
        $request->setRollout($rollout);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateRollout',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Target in a given project and location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedParent = $cloudDeployClient->locationName('[PROJECT]', '[LOCATION]');
     *     $targetId = 'target_id';
     *     $target = new Target();
     *     $operationResponse = $cloudDeployClient->createTarget($formattedParent, $targetId, $target);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudDeployClient->createTarget($formattedParent, $targetId, $target);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudDeployClient->resumeOperation($operationName, 'createTarget');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent collection in which the `Target` should be created.
     *                             Format should be
     *                             projects/{project_id}/locations/{location_name}.
     * @param string $targetId     Required. ID of the `Target`.
     * @param Target $target       Required. The `Target` to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. If set to true, the request is validated and the user is provided with
     *           an expected result, but no actual change is made.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createTarget(
        $parent,
        $targetId,
        $target,
        array $optionalArgs = []
    ) {
        $request = new CreateTargetRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTargetId($targetId);
        $request->setTarget($target);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateTarget',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single DeliveryPipeline.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedName = $cloudDeployClient->deliveryPipelineName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]');
     *     $operationResponse = $cloudDeployClient->deleteDeliveryPipeline($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudDeployClient->deleteDeliveryPipeline($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudDeployClient->resumeOperation($operationName, 'deleteDeliveryPipeline');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the `DeliveryPipeline` to delete. Format should be
     *                             projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $allowMissing
     *           Optional. If set to true, then deleting an already deleted or non-existing
     *           `DeliveryPipeline` will succeed.
     *     @type bool $validateOnly
     *           Optional. If set, validate the request and preview the review, but do not actually
     *           post it.
     *     @type bool $force
     *           Optional. If set to true, all child resources under this pipeline will also be
     *           deleted. Otherwise, the request will only work if the pipeline has
     *           no child resources.
     *     @type string $etag
     *           Optional. This checksum is computed by the server based on the value of other
     *           fields, and may be sent on update and delete requests to ensure the
     *           client has an up-to-date value before proceeding.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDeliveryPipeline($name, array $optionalArgs = [])
    {
        $request = new DeleteDeliveryPipelineRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteDeliveryPipeline',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single Target.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedName = $cloudDeployClient->targetName('[PROJECT]', '[LOCATION]', '[TARGET]');
     *     $operationResponse = $cloudDeployClient->deleteTarget($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudDeployClient->deleteTarget($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudDeployClient->resumeOperation($operationName, 'deleteTarget');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the `Target` to delete. Format should be
     *                             projects/{project_id}/locations/{location_name}/targets/{target_name}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $allowMissing
     *           Optional. If set to true, then deleting an already deleted or non-existing
     *           DeliveryPipeline will succeed.
     *     @type bool $validateOnly
     *           Optional. If set, validate the request and preview the review, but do not actually
     *           post it.
     *     @type string $etag
     *           Optional. This checksum is computed by the server based on the value of other
     *           fields, and may be sent on update and delete requests to ensure the
     *           client has an up-to-date value before proceeding.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTarget($name, array $optionalArgs = [])
    {
        $request = new DeleteTargetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTarget',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets the configuration for a location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedName = $cloudDeployClient->configName('[PROJECT]', '[LOCATION]');
     *     $response = $cloudDeployClient->getConfig($formattedName);
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of requested configuration.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Deploy\V1\Config
     *
     * @throws ApiException if the remote call fails
     */
    public function getConfig($name, array $optionalArgs = [])
    {
        $request = new GetConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetConfig',
            Config::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single DeliveryPipeline.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedName = $cloudDeployClient->deliveryPipelineName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]');
     *     $response = $cloudDeployClient->getDeliveryPipeline($formattedName);
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the `DeliveryPipeline`. Format must be
     *                             projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Deploy\V1\DeliveryPipeline
     *
     * @throws ApiException if the remote call fails
     */
    public function getDeliveryPipeline($name, array $optionalArgs = [])
    {
        $request = new GetDeliveryPipelineRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDeliveryPipeline',
            DeliveryPipeline::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single Release.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedName = $cloudDeployClient->releaseName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]', '[RELEASE]');
     *     $response = $cloudDeployClient->getRelease($formattedName);
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the `Release`. Format must be
     *                             projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Deploy\V1\Release
     *
     * @throws ApiException if the remote call fails
     */
    public function getRelease($name, array $optionalArgs = [])
    {
        $request = new GetReleaseRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRelease',
            Release::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single Rollout.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedName = $cloudDeployClient->rolloutName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]', '[RELEASE]', '[ROLLOUT]');
     *     $response = $cloudDeployClient->getRollout($formattedName);
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the `Rollout`. Format must be
     *                             projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Deploy\V1\Rollout
     *
     * @throws ApiException if the remote call fails
     */
    public function getRollout($name, array $optionalArgs = [])
    {
        $request = new GetRolloutRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRollout',
            Rollout::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single Target.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedName = $cloudDeployClient->targetName('[PROJECT]', '[LOCATION]', '[TARGET]');
     *     $response = $cloudDeployClient->getTarget($formattedName);
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the `Target`. Format must be
     *                             projects/{project_id}/locations/{location_name}/targets/{target_name}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Deploy\V1\Target
     *
     * @throws ApiException if the remote call fails
     */
    public function getTarget($name, array $optionalArgs = [])
    {
        $request = new GetTargetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTarget',
            Target::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists DeliveryPipelines in a given project and location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedParent = $cloudDeployClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudDeployClient->listDeliveryPipelines($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudDeployClient->listDeliveryPipelines($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of pipelines. Format must be
     *                             projects/{project_id}/locations/{location_name}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter builds to be returned. See https://google.aip.dev/160 for more
     *           details.
     *     @type string $orderBy
     *           Field to sort by. See https://google.aip.dev/132#ordering for more details.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDeliveryPipelines($parent, array $optionalArgs = [])
    {
        $request = new ListDeliveryPipelinesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDeliveryPipelines',
            $optionalArgs,
            ListDeliveryPipelinesResponse::class,
            $request
        );
    }

    /**
     * Lists Releases in a given project and location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedParent = $cloudDeployClient->deliveryPipelineName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudDeployClient->listReleases($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudDeployClient->listReleases($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The `DeliveryPipeline` which owns this collection of `Release` objects.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter builds to be returned. See https://google.aip.dev/160 for more
     *           details.
     *     @type string $orderBy
     *           Optional. Field to sort by. See https://google.aip.dev/132#ordering for more details.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listReleases($parent, array $optionalArgs = [])
    {
        $request = new ListReleasesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListReleases',
            $optionalArgs,
            ListReleasesResponse::class,
            $request
        );
    }

    /**
     * Lists Rollouts in a given project and location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedParent = $cloudDeployClient->releaseName('[PROJECT]', '[LOCATION]', '[DELIVERY_PIPELINE]', '[RELEASE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudDeployClient->listRollouts($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudDeployClient->listRollouts($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The `Release` which owns this collection of `Rollout` objects.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter builds to be returned. See https://google.aip.dev/160 for more
     *           details.
     *     @type string $orderBy
     *           Optional. Field to sort by. See https://google.aip.dev/132#ordering for more details.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listRollouts($parent, array $optionalArgs = [])
    {
        $request = new ListRolloutsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListRollouts',
            $optionalArgs,
            ListRolloutsResponse::class,
            $request
        );
    }

    /**
     * Lists Targets in a given project and location.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $formattedParent = $cloudDeployClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudDeployClient->listTargets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudDeployClient->listTargets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of targets. Format must be
     *                             projects/{project_id}/locations/{location_name}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter builds to be returned. See https://google.aip.dev/160 for more
     *           details.
     *     @type string $orderBy
     *           Optional. Field to sort by. See https://google.aip.dev/132#ordering for more details.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTargets($parent, array $optionalArgs = [])
    {
        $request = new ListTargetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTargets',
            $optionalArgs,
            ListTargetsResponse::class,
            $request
        );
    }

    /**
     * Updates the parameters of a single DeliveryPipeline.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $deliveryPipeline = new DeliveryPipeline();
     *     $operationResponse = $cloudDeployClient->updateDeliveryPipeline($updateMask, $deliveryPipeline);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudDeployClient->updateDeliveryPipeline($updateMask, $deliveryPipeline);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudDeployClient->resumeOperation($operationName, 'updateDeliveryPipeline');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param FieldMask        $updateMask       Required. Field mask is used to specify the fields to be overwritten in the
     *                                           `DeliveryPipeline` resource by the update.
     *                                           The fields specified in the update_mask are relative to the resource, not
     *                                           the full request. A field will be overwritten if it is in the mask. If the
     *                                           user does not provide a mask then all fields will be overwritten.
     * @param DeliveryPipeline $deliveryPipeline Required. The `DeliveryPipeline` to update.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $allowMissing
     *           Optional. If set to true, updating a `DeliveryPipeline` that does not exist will
     *           result in the creation of a new `DeliveryPipeline`.
     *     @type bool $validateOnly
     *           Optional. If set to true, the request is validated and the user is provided with
     *           an expected result, but no actual change is made.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDeliveryPipeline(
        $updateMask,
        $deliveryPipeline,
        array $optionalArgs = []
    ) {
        $request = new UpdateDeliveryPipelineRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setDeliveryPipeline($deliveryPipeline);
        $requestParamHeaders[
            'delivery_pipeline.name'
        ] = $deliveryPipeline->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateDeliveryPipeline',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single Target.
     *
     * Sample code:
     * ```
     * $cloudDeployClient = new CloudDeployClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $target = new Target();
     *     $operationResponse = $cloudDeployClient->updateTarget($updateMask, $target);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudDeployClient->updateTarget($updateMask, $target);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudDeployClient->resumeOperation($operationName, 'updateTarget');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudDeployClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                Target resource by the update.
     *                                The fields specified in the update_mask are relative to the resource, not
     *                                the full request. A field will be overwritten if it is in the mask. If the
     *                                user does not provide a mask then all fields will be overwritten.
     * @param Target    $target       Required. The `Target` to update.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $allowMissing
     *           Optional. If set to true, updating a `Target` that does not exist will
     *           result in the creation of a new `Target`.
     *     @type bool $validateOnly
     *           Optional. If set to true, the request is validated and the user is provided with
     *           an expected result, but no actual change is made.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTarget($updateMask, $target, array $optionalArgs = [])
    {
        $request = new UpdateTargetRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setTarget($target);
        $requestParamHeaders['target.name'] = $target->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateTarget',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
