<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/channel/v1/offers.proto

namespace Google\Cloud\Channel\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Parameter's definition. Specifies what parameter is required to use the
 * current Offer to purchase.
 *
 * Generated from protobuf message <code>google.cloud.channel.v1.ParameterDefinition</code>
 */
class ParameterDefinition extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the parameter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Data type of the parameter. Minimal value, Maximum value and allowed values
     * will use specified data type here.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
     */
    private $parameter_type = 0;
    /**
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     */
    private $min_value = null;
    /**
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     */
    private $max_value = null;
    /**
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     */
    private $allowed_values;
    /**
     * If set to true, parameter is optional to purchase this Offer.
     *
     * Generated from protobuf field <code>bool optional = 6;</code>
     */
    private $optional = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Name of the parameter.
     *     @type int $parameter_type
     *           Data type of the parameter. Minimal value, Maximum value and allowed values
     *           will use specified data type here.
     *     @type \Google\Cloud\Channel\V1\Value $min_value
     *           Minimal value of the parameter, if applicable. Inclusive. For example,
     *           minimal commitment when purchasing Anthos is 0.01.
     *           Applicable to INT64 and DOUBLE parameter types.
     *     @type \Google\Cloud\Channel\V1\Value $max_value
     *           Maximum value of the parameter, if applicable. Inclusive. For example,
     *           maximum seats when purchasing Google Workspace Business Standard.
     *           Applicable to INT64 and DOUBLE parameter types.
     *     @type \Google\Cloud\Channel\V1\Value[]|\Google\Protobuf\Internal\RepeatedField $allowed_values
     *           If not empty, parameter values must be drawn from this list.
     *           For example, [us-west1, us-west2, ...]
     *           Applicable to STRING parameter type.
     *     @type bool $optional
     *           If set to true, parameter is optional to purchase this Offer.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Channel\V1\Offers::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of the parameter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the parameter.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Data type of the parameter. Minimal value, Maximum value and allowed values
     * will use specified data type here.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
     * @return int
     */
    public function getParameterType()
    {
        return $this->parameter_type;
    }

    /**
     * Data type of the parameter. Minimal value, Maximum value and allowed values
     * will use specified data type here.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.ParameterDefinition.ParameterType parameter_type = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setParameterType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Channel\V1\ParameterDefinition\ParameterType::class);
        $this->parameter_type = $var;

        return $this;
    }

    /**
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     * @return \Google\Cloud\Channel\V1\Value|null
     */
    public function getMinValue()
    {
        return $this->min_value;
    }

    public function hasMinValue()
    {
        return isset($this->min_value);
    }

    public function clearMinValue()
    {
        unset($this->min_value);
    }

    /**
     * Minimal value of the parameter, if applicable. Inclusive. For example,
     * minimal commitment when purchasing Anthos is 0.01.
     * Applicable to INT64 and DOUBLE parameter types.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Value min_value = 3;</code>
     * @param \Google\Cloud\Channel\V1\Value $var
     * @return $this
     */
    public function setMinValue($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Channel\V1\Value::class);
        $this->min_value = $var;

        return $this;
    }

    /**
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     * @return \Google\Cloud\Channel\V1\Value|null
     */
    public function getMaxValue()
    {
        return $this->max_value;
    }

    public function hasMaxValue()
    {
        return isset($this->max_value);
    }

    public function clearMaxValue()
    {
        unset($this->max_value);
    }

    /**
     * Maximum value of the parameter, if applicable. Inclusive. For example,
     * maximum seats when purchasing Google Workspace Business Standard.
     * Applicable to INT64 and DOUBLE parameter types.
     *
     * Generated from protobuf field <code>.google.cloud.channel.v1.Value max_value = 4;</code>
     * @param \Google\Cloud\Channel\V1\Value $var
     * @return $this
     */
    public function setMaxValue($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Channel\V1\Value::class);
        $this->max_value = $var;

        return $this;
    }

    /**
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedValues()
    {
        return $this->allowed_values;
    }

    /**
     * If not empty, parameter values must be drawn from this list.
     * For example, [us-west1, us-west2, ...]
     * Applicable to STRING parameter type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.channel.v1.Value allowed_values = 5;</code>
     * @param \Google\Cloud\Channel\V1\Value[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedValues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Channel\V1\Value::class);
        $this->allowed_values = $arr;

        return $this;
    }

    /**
     * If set to true, parameter is optional to purchase this Offer.
     *
     * Generated from protobuf field <code>bool optional = 6;</code>
     * @return bool
     */
    public function getOptional()
    {
        return $this->optional;
    }

    /**
     * If set to true, parameter is optional to purchase this Offer.
     *
     * Generated from protobuf field <code>bool optional = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setOptional($var)
    {
        GPBUtil::checkBool($var);
        $this->optional = $var;

        return $this;
    }

}

