<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v1/cloudbuild.proto

namespace Google\Cloud\Build\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for a WorkerPool to run the builds.
 * Workers are machines that Cloud Build uses to run your builds. By default,
 * all workers run in a project owned by Cloud Build. To have full control over
 * the workers that execute your builds -- such as enabling them to access
 * private resources on your private network -- you can request Cloud Build to
 * run the workers in your own project by creating a custom workers pool.
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v1.WorkerPool</code>
 */
class WorkerPool extends \Google\Protobuf\Internal\Message
{
    /**
     * User-defined name of the `WorkerPool`.
     *
     * Generated from protobuf field <code>string name = 14;</code>
     */
    private $name = '';
    /**
     * The project ID of the GCP project for which the `WorkerPool` is created.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     */
    private $project_id = '';
    /**
     * Output only. The service account used to manage the `WorkerPool`. The
     * service account must have the Compute Instance Admin (Beta) permission at
     * the project level.
     *
     * Generated from protobuf field <code>string service_account_email = 3;</code>
     */
    private $service_account_email = '';
    /**
     * Total number of workers to be created across all requested regions.
     *
     * Generated from protobuf field <code>int64 worker_count = 4;</code>
     */
    private $worker_count = 0;
    /**
     * Configuration to be used for a creating workers in the `WorkerPool`.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     */
    private $worker_config = null;
    /**
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     */
    private $regions;
    /**
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    private $create_time = null;
    /**
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 17;</code>
     */
    private $update_time = null;
    /**
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 12;</code>
     */
    private $delete_time = null;
    /**
     * Output only. WorkerPool Status.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
     */
    private $status = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           User-defined name of the `WorkerPool`.
     *     @type string $project_id
     *           The project ID of the GCP project for which the `WorkerPool` is created.
     *     @type string $service_account_email
     *           Output only. The service account used to manage the `WorkerPool`. The
     *           service account must have the Compute Instance Admin (Beta) permission at
     *           the project level.
     *     @type int|string $worker_count
     *           Total number of workers to be created across all requested regions.
     *     @type \Google\Cloud\Build\V1\WorkerConfig $worker_config
     *           Configuration to be used for a creating workers in the `WorkerPool`.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $regions
     *           List of regions to create the `WorkerPool`. Regions can't be empty.
     *           If Cloud Build adds a new GCP region in the future, the existing
     *           `WorkerPool` will not be enabled in the new region automatically;
     *           you must add the new region to the `regions` field to enable the
     *           `WorkerPool` in that region.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Time at which the request to create the `WorkerPool` was
     *           received.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Time at which the request to update the `WorkerPool` was
     *           received.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. Time at which the request to delete the `WorkerPool` was
     *           received.
     *     @type int $status
     *           Output only. WorkerPool Status.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudbuild\V1\Cloudbuild::initOnce();
        parent::__construct($data);
    }

    /**
     * User-defined name of the `WorkerPool`.
     *
     * Generated from protobuf field <code>string name = 14;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * User-defined name of the `WorkerPool`.
     *
     * Generated from protobuf field <code>string name = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The project ID of the GCP project for which the `WorkerPool` is created.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * The project ID of the GCP project for which the `WorkerPool` is created.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Output only. The service account used to manage the `WorkerPool`. The
     * service account must have the Compute Instance Admin (Beta) permission at
     * the project level.
     *
     * Generated from protobuf field <code>string service_account_email = 3;</code>
     * @return string
     */
    public function getServiceAccountEmail()
    {
        return $this->service_account_email;
    }

    /**
     * Output only. The service account used to manage the `WorkerPool`. The
     * service account must have the Compute Instance Admin (Beta) permission at
     * the project level.
     *
     * Generated from protobuf field <code>string service_account_email = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_email = $var;

        return $this;
    }

    /**
     * Total number of workers to be created across all requested regions.
     *
     * Generated from protobuf field <code>int64 worker_count = 4;</code>
     * @return int|string
     */
    public function getWorkerCount()
    {
        return $this->worker_count;
    }

    /**
     * Total number of workers to be created across all requested regions.
     *
     * Generated from protobuf field <code>int64 worker_count = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setWorkerCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->worker_count = $var;

        return $this;
    }

    /**
     * Configuration to be used for a creating workers in the `WorkerPool`.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     * @return \Google\Cloud\Build\V1\WorkerConfig|null
     */
    public function getWorkerConfig()
    {
        return isset($this->worker_config) ? $this->worker_config : null;
    }

    public function hasWorkerConfig()
    {
        return isset($this->worker_config);
    }

    public function clearWorkerConfig()
    {
        unset($this->worker_config);
    }

    /**
     * Configuration to be used for a creating workers in the `WorkerPool`.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     * @param \Google\Cloud\Build\V1\WorkerConfig $var
     * @return $this
     */
    public function setWorkerConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V1\WorkerConfig::class);
        $this->worker_config = $var;

        return $this;
    }

    /**
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRegions()
    {
        return $this->regions;
    }

    /**
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRegions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Build\V1\WorkerPool\Region::class);
        $this->regions = $arr;

        return $this;
    }

    /**
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return isset($this->create_time) ? $this->create_time : null;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 17;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return isset($this->update_time) ? $this->update_time : null;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 17;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 12;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return isset($this->delete_time) ? $this->delete_time : null;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 12;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Output only. WorkerPool Status.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Output only. WorkerPool Status.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Build\V1\WorkerPool\Status::class);
        $this->status = $var;

        return $this;
    }

}

