<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/identity/accesscontextmanager/v1/access_context_manager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Identity\AccessContextManager\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;

use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;

use Google\ApiCore\Transport\TransportInterface;

use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Identity\AccessContextManager\V1\AccessLevel;
use Google\Identity\AccessContextManager\V1\AccessPolicy;
use Google\Identity\AccessContextManager\V1\CommitServicePerimetersRequest;
use Google\Identity\AccessContextManager\V1\CommitServicePerimetersResponse;
use Google\Identity\AccessContextManager\V1\CreateAccessLevelRequest;
use Google\Identity\AccessContextManager\V1\CreateGcpUserAccessBindingRequest;
use Google\Identity\AccessContextManager\V1\CreateServicePerimeterRequest;
use Google\Identity\AccessContextManager\V1\DeleteAccessLevelRequest;
use Google\Identity\AccessContextManager\V1\DeleteAccessPolicyRequest;
use Google\Identity\AccessContextManager\V1\DeleteGcpUserAccessBindingRequest;
use Google\Identity\AccessContextManager\V1\DeleteServicePerimeterRequest;
use Google\Identity\AccessContextManager\V1\GcpUserAccessBinding;
use Google\Identity\AccessContextManager\V1\GetAccessLevelRequest;
use Google\Identity\AccessContextManager\V1\GetAccessPolicyRequest;
use Google\Identity\AccessContextManager\V1\GetGcpUserAccessBindingRequest;
use Google\Identity\AccessContextManager\V1\GetServicePerimeterRequest;
use Google\Identity\AccessContextManager\V1\ListAccessLevelsRequest;
use Google\Identity\AccessContextManager\V1\ListAccessLevelsResponse;
use Google\Identity\AccessContextManager\V1\ListAccessPoliciesRequest;
use Google\Identity\AccessContextManager\V1\ListAccessPoliciesResponse;
use Google\Identity\AccessContextManager\V1\ListGcpUserAccessBindingsRequest;
use Google\Identity\AccessContextManager\V1\ListGcpUserAccessBindingsResponse;
use Google\Identity\AccessContextManager\V1\ListServicePerimetersRequest;
use Google\Identity\AccessContextManager\V1\ListServicePerimetersResponse;
use Google\Identity\AccessContextManager\V1\ReplaceAccessLevelsRequest;
use Google\Identity\AccessContextManager\V1\ReplaceAccessLevelsResponse;
use Google\Identity\AccessContextManager\V1\ReplaceServicePerimetersRequest;
use Google\Identity\AccessContextManager\V1\ReplaceServicePerimetersResponse;
use Google\Identity\AccessContextManager\V1\ServicePerimeter;
use Google\Identity\AccessContextManager\V1\UpdateAccessLevelRequest;
use Google\Identity\AccessContextManager\V1\UpdateAccessPolicyRequest;

use Google\Identity\AccessContextManager\V1\UpdateGcpUserAccessBindingRequest;
use Google\Identity\AccessContextManager\V1\UpdateServicePerimeterRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\Timestamp;

/**
 * Service Description: API for setting [Access Levels]
 * [google.identity.accesscontextmanager.v1.AccessLevel] and [Service
 * Perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
 * for Google Cloud Projects. Each organization has one [AccessPolicy]
 * [google.identity.accesscontextmanager.v1.AccessPolicy] containing the
 * [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
 * and [Service Perimeters]
 * [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
 * [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
 * applicable to all resources in the organization.
 * AccessPolicies
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $accessContextManagerClient = new AccessContextManagerClient();
 * try {
 *     $formattedParent = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
 *     $operationResponse = $accessContextManagerClient->commitServicePerimeters($formattedParent);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $accessContextManagerClient->commitServicePerimeters($formattedParent);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'commitServicePerimeters');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $accessContextManagerClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class AccessContextManagerGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.identity.accesscontextmanager.v1.AccessContextManager';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'accesscontextmanager.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $accessLevelNameTemplate;

    private static $accessPolicyNameTemplate;

    private static $gcpUserAccessBindingNameTemplate;

    private static $organizationNameTemplate;

    private static $servicePerimeterNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/access_context_manager_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/access_context_manager_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/access_context_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/access_context_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAccessLevelNameTemplate()
    {
        if (self::$accessLevelNameTemplate == null) {
            self::$accessLevelNameTemplate = new PathTemplate(
                'accessPolicies/{access_policy}/accessLevels/{access_level}'
            );
        }

        return self::$accessLevelNameTemplate;
    }

    private static function getAccessPolicyNameTemplate()
    {
        if (self::$accessPolicyNameTemplate == null) {
            self::$accessPolicyNameTemplate = new PathTemplate(
                'accessPolicies/{access_policy}'
            );
        }

        return self::$accessPolicyNameTemplate;
    }

    private static function getGcpUserAccessBindingNameTemplate()
    {
        if (self::$gcpUserAccessBindingNameTemplate == null) {
            self::$gcpUserAccessBindingNameTemplate = new PathTemplate(
                'organizations/{organization}/gcpUserAccessBindings/{gcp_user_access_binding}'
            );
        }

        return self::$gcpUserAccessBindingNameTemplate;
    }

    private static function getOrganizationNameTemplate()
    {
        if (self::$organizationNameTemplate == null) {
            self::$organizationNameTemplate = new PathTemplate(
                'organizations/{organization}'
            );
        }

        return self::$organizationNameTemplate;
    }

    private static function getServicePerimeterNameTemplate()
    {
        if (self::$servicePerimeterNameTemplate == null) {
            self::$servicePerimeterNameTemplate = new PathTemplate(
                'accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}'
            );
        }

        return self::$servicePerimeterNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'accessLevel' => self::getAccessLevelNameTemplate(),
                'accessPolicy' => self::getAccessPolicyNameTemplate(),
                'gcpUserAccessBinding' => self::getGcpUserAccessBindingNameTemplate(),
                'organization' => self::getOrganizationNameTemplate(),
                'servicePerimeter' => self::getServicePerimeterNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a access_level
     * resource.
     *
     * @param string $accessPolicy
     * @param string $accessLevel
     *
     * @return string The formatted access_level resource.
     */
    public static function accessLevelName($accessPolicy, $accessLevel)
    {
        return self::getAccessLevelNameTemplate()->render([
            'access_policy' => $accessPolicy,
            'access_level' => $accessLevel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * access_policy resource.
     *
     * @param string $accessPolicy
     *
     * @return string The formatted access_policy resource.
     */
    public static function accessPolicyName($accessPolicy)
    {
        return self::getAccessPolicyNameTemplate()->render([
            'access_policy' => $accessPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * gcp_user_access_binding resource.
     *
     * @param string $organization
     * @param string $gcpUserAccessBinding
     *
     * @return string The formatted gcp_user_access_binding resource.
     */
    public static function gcpUserAccessBindingName(
        $organization,
        $gcpUserAccessBinding
    ) {
        return self::getGcpUserAccessBindingNameTemplate()->render([
            'organization' => $organization,
            'gcp_user_access_binding' => $gcpUserAccessBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName($organization)
    {
        return self::getOrganizationNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_perimeter resource.
     *
     * @param string $accessPolicy
     * @param string $servicePerimeter
     *
     * @return string The formatted service_perimeter resource.
     */
    public static function servicePerimeterName(
        $accessPolicy,
        $servicePerimeter
    ) {
        return self::getServicePerimeterNameTemplate()->render([
            'access_policy' => $accessPolicy,
            'service_perimeter' => $servicePerimeter,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - accessLevel: accessPolicies/{access_policy}/accessLevels/{access_level}
     * - accessPolicy: accessPolicies/{access_policy}
     * - gcpUserAccessBinding: organizations/{organization}/gcpUserAccessBindings/{gcp_user_access_binding}
     * - organization: organizations/{organization}
     * - servicePerimeter: accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'accesscontextmanager.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Commit the dry-run spec for all the [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
     * [Access Policy][google.identity.accesscontextmanager.v1.AccessPolicy].
     * A commit operation on a Service Perimeter involves copying its `spec` field
     * to that Service Perimeter's `status` field. Only [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] with
     * `use_explicit_dry_run_spec` field set to true are affected by a commit
     * operation. The longrunning operation from this RPC will have a successful
     * status once the dry-run specs for all the [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
     * committed. If a commit fails, it will cause the longrunning operation to
     * return an error response and the entire commit operation will be cancelled.
     * When successful, Operation.response field will contain
     * CommitServicePerimetersResponse. The `dry_run` and the `spec` fields will
     * be cleared after a successful commit operation.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     $operationResponse = $accessContextManagerClient->commitServicePerimeters($formattedParent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->commitServicePerimeters($formattedParent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'commitServicePerimeters');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name for the parent [Access Policy]
     *                             [google.identity.accesscontextmanager.v1.AccessPolicy] which owns all
     *                             [Service Perimeters]
     *                             [google.identity.accesscontextmanager.v1.ServicePerimeter] in scope for
     *                             the commit operation.
     *
     *                             Format: `accessPolicies/{policy_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. The etag for the version of the [Access Policy]
     *           [google.identity.accesscontextmanager.v1alpha.AccessPolicy] that this
     *           commit operation is to be performed on. If, at the time of commit, the
     *           etag for the Access Policy stored in Access Context Manager is different
     *           from the specified etag, then the commit operation will not be performed
     *           and the call will fail. This field is not required. If etag is not
     *           provided, the operation will be performed as if a valid etag is provided.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function commitServicePerimeters($parent, array $optionalArgs = [])
    {
        $request = new CommitServicePerimetersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CommitServicePerimeters',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create an [Access Level]
     * [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
     * operation from this RPC will have a successful status once the [Access
     * Level] [google.identity.accesscontextmanager.v1.AccessLevel] has
     * propagated to long-lasting storage. [Access Levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] containing
     * errors will result in an error response for the first error encountered.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     $accessLevel = new AccessLevel();
     *     $operationResponse = $accessContextManagerClient->createAccessLevel($formattedParent, $accessLevel);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->createAccessLevel($formattedParent, $accessLevel);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'createAccessLevel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string      $parent       Required. Resource name for the access policy which owns this [Access
     *                                  Level] [google.identity.accesscontextmanager.v1.AccessLevel].
     *
     *                                  Format: `accessPolicies/{policy_id}`
     * @param AccessLevel $accessLevel  Required. The [Access Level]
     *                                  [google.identity.accesscontextmanager.v1.AccessLevel] to create.
     *                                  Syntactic correctness of the [Access Level]
     *                                  [google.identity.accesscontextmanager.v1.AccessLevel] is a
     *                                  precondition for creation.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAccessLevel(
        $parent,
        $accessLevel,
        array $optionalArgs = []
    ) {
        $request = new CreateAccessLevelRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAccessLevel($accessLevel);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAccessLevel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create an `AccessPolicy`. Fails if this organization already has a
     * `AccessPolicy`. The longrunning Operation will have a successful status
     * once the `AccessPolicy` has propagated to long-lasting storage.
     * Syntactic and basic semantic errors will be returned in `metadata` as a
     * BadRequest proto.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $operationResponse = $accessContextManagerClient->createAccessPolicy();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->createAccessPolicy();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'createAccessPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Output only. Resource name of the `AccessPolicy`. Format:
     *           `accessPolicies/{access_policy}`
     *     @type string $parent
     *           Required. The parent of this `AccessPolicy` in the Cloud Resource
     *           Hierarchy. Currently immutable once created. Format:
     *           `organizations/{organization_id}`
     *     @type string $title
     *           Required. Human readable title. Does not affect behavior.
     *     @type Timestamp $createTime
     *           Output only. Time the `AccessPolicy` was created in UTC.
     *     @type Timestamp $updateTime
     *           Output only. Time the `AccessPolicy` was updated in UTC.
     *     @type string $etag
     *           Output only. An opaque identifier for the current version of the
     *           `AccessPolicy`. This will always be a strongly validated etag, meaning that
     *           two Access Polices will be identical if and only if their etags are
     *           identical. Clients should not expect this to be in any specific format.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAccessPolicy(array $optionalArgs = [])
    {
        $request = new AccessPolicy();
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
        }

        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
        }

        if (isset($optionalArgs['title'])) {
            $request->setTitle($optionalArgs['title']);
        }

        if (isset($optionalArgs['createTime'])) {
            $request->setCreateTime($optionalArgs['createTime']);
        }

        if (isset($optionalArgs['updateTime'])) {
            $request->setUpdateTime($optionalArgs['updateTime']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        return $this->startOperationsCall(
            'CreateAccessPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a [GcpUserAccessBinding]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
     * client specifies a [name]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
     * the server will ignore it. Fails if a resource already exists with the same
     * [group_key]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
     * Completion of this long-running operation does not necessarily signify that
     * the new binding is deployed onto all affected users, which may take more
     * time.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->organizationName('[ORGANIZATION]');
     *     $gcpUserAccessBinding = new GcpUserAccessBinding();
     *     $operationResponse = $accessContextManagerClient->createGcpUserAccessBinding($formattedParent, $gcpUserAccessBinding);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->createGcpUserAccessBinding($formattedParent, $gcpUserAccessBinding);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'createGcpUserAccessBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string               $parent               Required. Example: "organizations/256"
     * @param GcpUserAccessBinding $gcpUserAccessBinding Required. [GcpUserAccessBinding]
     *                                                   [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
     * @param array                $optionalArgs         {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createGcpUserAccessBinding(
        $parent,
        $gcpUserAccessBinding,
        array $optionalArgs = []
    ) {
        $request = new CreateGcpUserAccessBindingRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setGcpUserAccessBinding($gcpUserAccessBinding);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateGcpUserAccessBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create a [Service Perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
     * longrunning operation from this RPC will have a successful status once the
     * [Service Perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] has
     * propagated to long-lasting storage. [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
     * errors will result in an error response for the first error encountered.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     $servicePerimeter = new ServicePerimeter();
     *     $operationResponse = $accessContextManagerClient->createServicePerimeter($formattedParent, $servicePerimeter);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->createServicePerimeter($formattedParent, $servicePerimeter);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'createServicePerimeter');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string           $parent           Required. Resource name for the access policy which owns this [Service
     *                                           Perimeter] [google.identity.accesscontextmanager.v1.ServicePerimeter].
     *
     *                                           Format: `accessPolicies/{policy_id}`
     * @param ServicePerimeter $servicePerimeter Required. The [Service Perimeter]
     *                                           [google.identity.accesscontextmanager.v1.ServicePerimeter] to create.
     *                                           Syntactic correctness of the [Service Perimeter]
     *                                           [google.identity.accesscontextmanager.v1.ServicePerimeter] is a
     *                                           precondition for creation.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createServicePerimeter(
        $parent,
        $servicePerimeter,
        array $optionalArgs = []
    ) {
        $request = new CreateServicePerimeterRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setServicePerimeter($servicePerimeter);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateServicePerimeter',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete an [Access Level]
     * [google.identity.accesscontextmanager.v1.AccessLevel] by resource
     * name. The longrunning operation from this RPC will have a successful status
     * once the [Access Level]
     * [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
     * from long-lasting storage.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedName = $accessContextManagerClient->accessLevelName('[ACCESS_POLICY]', '[ACCESS_LEVEL]');
     *     $operationResponse = $accessContextManagerClient->deleteAccessLevel($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->deleteAccessLevel($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'deleteAccessLevel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name for the [Access Level]
     *                             [google.identity.accesscontextmanager.v1.AccessLevel].
     *
     *                             Format:
     *                             `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAccessLevel($name, array $optionalArgs = [])
    {
        $request = new DeleteAccessLevelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAccessLevel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete an [AccessPolicy]
     * [google.identity.accesscontextmanager.v1.AccessPolicy] by resource
     * name. The longrunning Operation will have a successful status once the
     * [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy]
     * has been removed from long-lasting storage.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedName = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     $operationResponse = $accessContextManagerClient->deleteAccessPolicy($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->deleteAccessPolicy($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'deleteAccessPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name for the access policy to delete.
     *
     *                             Format `accessPolicies/{policy_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAccessPolicy($name, array $optionalArgs = [])
    {
        $request = new DeleteAccessPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAccessPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a [GcpUserAccessBinding]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
     * Completion of this long-running operation does not necessarily signify that
     * the binding deletion is deployed onto all affected users, which may take
     * more time.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedName = $accessContextManagerClient->gcpUserAccessBindingName('[ORGANIZATION]', '[GCP_USER_ACCESS_BINDING]');
     *     $operationResponse = $accessContextManagerClient->deleteGcpUserAccessBinding($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->deleteGcpUserAccessBinding($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'deleteGcpUserAccessBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteGcpUserAccessBinding($name, array $optionalArgs = [])
    {
        $request = new DeleteGcpUserAccessBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteGcpUserAccessBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete a [Service Perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
     * name. The longrunning operation from this RPC will have a successful status
     * once the [Service Perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] has been
     * removed from long-lasting storage.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedName = $accessContextManagerClient->servicePerimeterName('[ACCESS_POLICY]', '[SERVICE_PERIMETER]');
     *     $operationResponse = $accessContextManagerClient->deleteServicePerimeter($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->deleteServicePerimeter($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'deleteServicePerimeter');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name for the [Service Perimeter]
     *                             [google.identity.accesscontextmanager.v1.ServicePerimeter].
     *
     *                             Format:
     *                             `accessPolicies/{policy_id}/servicePerimeters/{service_perimeter_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteServicePerimeter($name, array $optionalArgs = [])
    {
        $request = new DeleteServicePerimeterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteServicePerimeter',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Get an [Access Level]
     * [google.identity.accesscontextmanager.v1.AccessLevel] by resource
     * name.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedName = $accessContextManagerClient->accessLevelName('[ACCESS_POLICY]', '[ACCESS_LEVEL]');
     *     $response = $accessContextManagerClient->getAccessLevel($formattedName);
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name for the [Access Level]
     *                             [google.identity.accesscontextmanager.v1.AccessLevel].
     *
     *                             Format:
     *                             `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $accessLevelFormat
     *           Whether to return `BasicLevels` in the Cloud Common Expression
     *           Language rather than as `BasicLevels`. Defaults to AS_DEFINED, where
     *           [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
     *           are returned as `BasicLevels` or `CustomLevels` based on how they were
     *           created. If set to CEL, all [Access Levels]
     *           [google.identity.accesscontextmanager.v1.AccessLevel] are returned as
     *           `CustomLevels`. In the CEL case, `BasicLevels` are translated to equivalent
     *           `CustomLevels`.
     *           For allowed values, use constants defined on {@see \Google\Identity\AccessContextManager\V1\LevelFormat}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Identity\AccessContextManager\V1\AccessLevel
     *
     * @throws ApiException if the remote call fails
     */
    public function getAccessLevel($name, array $optionalArgs = [])
    {
        $request = new GetAccessLevelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['accessLevelFormat'])) {
            $request->setAccessLevelFormat($optionalArgs['accessLevelFormat']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAccessLevel',
            AccessLevel::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get an [AccessPolicy]
     * [google.identity.accesscontextmanager.v1.AccessPolicy] by name.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedName = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     $response = $accessContextManagerClient->getAccessPolicy($formattedName);
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name for the access policy to get.
     *
     *                             Format `accessPolicies/{policy_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Identity\AccessContextManager\V1\AccessPolicy
     *
     * @throws ApiException if the remote call fails
     */
    public function getAccessPolicy($name, array $optionalArgs = [])
    {
        $request = new GetAccessPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAccessPolicy',
            AccessPolicy::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets the [GcpUserAccessBinding]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
     * the given name.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedName = $accessContextManagerClient->gcpUserAccessBindingName('[ORGANIZATION]', '[GCP_USER_ACCESS_BINDING]');
     *     $response = $accessContextManagerClient->getGcpUserAccessBinding($formattedName);
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Identity\AccessContextManager\V1\GcpUserAccessBinding
     *
     * @throws ApiException if the remote call fails
     */
    public function getGcpUserAccessBinding($name, array $optionalArgs = [])
    {
        $request = new GetGcpUserAccessBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetGcpUserAccessBinding',
            GcpUserAccessBinding::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get a [Service Perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
     * name.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedName = $accessContextManagerClient->servicePerimeterName('[ACCESS_POLICY]', '[SERVICE_PERIMETER]');
     *     $response = $accessContextManagerClient->getServicePerimeter($formattedName);
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name for the [Service Perimeter]
     *                             [google.identity.accesscontextmanager.v1.ServicePerimeter].
     *
     *                             Format:
     *                             `accessPolicies/{policy_id}/servicePerimeters/{service_perimeters_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Identity\AccessContextManager\V1\ServicePerimeter
     *
     * @throws ApiException if the remote call fails
     */
    public function getServicePerimeter($name, array $optionalArgs = [])
    {
        $request = new GetServicePerimeterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetServicePerimeter',
            ServicePerimeter::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * List all [Access Levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] for an access
     * policy.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $accessContextManagerClient->listAccessLevels($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $accessContextManagerClient->listAccessLevels($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name for the access policy to list [Access Levels]
     *                             [google.identity.accesscontextmanager.v1.AccessLevel] from.
     *
     *                             Format:
     *                             `accessPolicies/{policy_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $accessLevelFormat
     *           Whether to return `BasicLevels` in the Cloud Common Expression language, as
     *           `CustomLevels`, rather than as `BasicLevels`. Defaults to returning
     *           `AccessLevels` in the format they were defined.
     *           For allowed values, use constants defined on {@see \Google\Identity\AccessContextManager\V1\LevelFormat}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAccessLevels($parent, array $optionalArgs = [])
    {
        $request = new ListAccessLevelsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['accessLevelFormat'])) {
            $request->setAccessLevelFormat($optionalArgs['accessLevelFormat']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAccessLevels',
            $optionalArgs,
            ListAccessLevelsResponse::class,
            $request
        );
    }

    /**
     * List all [AccessPolicies]
     * [google.identity.accesscontextmanager.v1.AccessPolicy] under a
     * container.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->organizationName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $accessContextManagerClient->listAccessPolicies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $accessContextManagerClient->listAccessPolicies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name for the container to list AccessPolicy instances
     *                             from.
     *
     *                             Format:
     *                             `organizations/{org_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAccessPolicies($parent, array $optionalArgs = [])
    {
        $request = new ListAccessPoliciesRequest();
        $request->setParent($parent);
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        return $this->getPagedListResponse(
            'ListAccessPolicies',
            $optionalArgs,
            ListAccessPoliciesResponse::class,
            $request
        );
    }

    /**
     * Lists all [GcpUserAccessBindings]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
     * Google Cloud organization.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->organizationName('[ORGANIZATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $accessContextManagerClient->listGcpUserAccessBindings($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $accessContextManagerClient->listGcpUserAccessBindings($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Example: "organizations/256"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listGcpUserAccessBindings($parent, array $optionalArgs = [])
    {
        $request = new ListGcpUserAccessBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListGcpUserAccessBindings',
            $optionalArgs,
            ListGcpUserAccessBindingsResponse::class,
            $request
        );
    }

    /**
     * List all [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
     * access policy.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $accessContextManagerClient->listServicePerimeters($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $accessContextManagerClient->listServicePerimeters($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name for the access policy to list [Service Perimeters]
     *                             [google.identity.accesscontextmanager.v1.ServicePerimeter] from.
     *
     *                             Format:
     *                             `accessPolicies/{policy_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listServicePerimeters($parent, array $optionalArgs = [])
    {
        $request = new ListServicePerimetersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListServicePerimeters',
            $optionalArgs,
            ListServicePerimetersResponse::class,
            $request
        );
    }

    /**
     * Replace all existing [Access Levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] in an [Access
     * Policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
     * the [Access Levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
     * is done atomically. The longrunning operation from this RPC will have a
     * successful status once all replacements have propagated to long-lasting
     * storage. Replacements containing errors will result in an error response
     * for the first error encountered.  Replacement will be cancelled on error,
     * existing [Access Levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] will not be
     * affected. Operation.response field will contain
     * ReplaceAccessLevelsResponse. Removing [Access Levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
     * [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] will result in
     * error.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     $accessLevels = [];
     *     $operationResponse = $accessContextManagerClient->replaceAccessLevels($formattedParent, $accessLevels);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->replaceAccessLevels($formattedParent, $accessLevels);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'replaceAccessLevels');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string        $parent       Required. Resource name for the access policy which owns these
     *                                    [Access Levels]
     *                                    [google.identity.accesscontextmanager.v1.AccessLevel].
     *
     *                                    Format: `accessPolicies/{policy_id}`
     * @param AccessLevel[] $accessLevels Required. The desired [Access Levels]
     *                                    [google.identity.accesscontextmanager.v1.AccessLevel] that should
     *                                    replace all existing [Access Levels]
     *                                    [google.identity.accesscontextmanager.v1.AccessLevel] in the
     *                                    [Access Policy]
     *                                    [google.identity.accesscontextmanager.v1.AccessPolicy].
     * @param array         $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. The etag for the version of the [Access Policy]
     *           [google.identity.accesscontextmanager.v1.AccessPolicy] that this
     *           replace operation is to be performed on. If, at the time of replace, the
     *           etag for the Access Policy stored in Access Context Manager is different
     *           from the specified etag, then the replace operation will not be performed
     *           and the call will fail. This field is not required. If etag is not
     *           provided, the operation will be performed as if a valid etag is provided.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function replaceAccessLevels(
        $parent,
        $accessLevels,
        array $optionalArgs = []
    ) {
        $request = new ReplaceAccessLevelsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAccessLevels($accessLevels);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ReplaceAccessLevels',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Replace all existing [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
     * [Access Policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
     * with the [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] provided.
     * This is done atomically. The longrunning operation from this
     * RPC will have a successful status once all replacements have propagated to
     * long-lasting storage. Replacements containing errors will result in an
     * error response for the first error encountered. Replacement will be
     * cancelled on error, existing [Service Perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] will not be
     * affected. Operation.response field will contain
     * ReplaceServicePerimetersResponse.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $formattedParent = $accessContextManagerClient->accessPolicyName('[ACCESS_POLICY]');
     *     $servicePerimeters = [];
     *     $operationResponse = $accessContextManagerClient->replaceServicePerimeters($formattedParent, $servicePerimeters);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->replaceServicePerimeters($formattedParent, $servicePerimeters);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'replaceServicePerimeters');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param string             $parent            Required. Resource name for the access policy which owns these
     *                                              [Service Perimeters]
     *                                              [google.identity.accesscontextmanager.v1.ServicePerimeter].
     *
     *                                              Format: `accessPolicies/{policy_id}`
     * @param ServicePerimeter[] $servicePerimeters Required. The desired [Service Perimeters]
     *                                              [google.identity.accesscontextmanager.v1.ServicePerimeter] that should
     *                                              replace all existing [Service Perimeters]
     *                                              [google.identity.accesscontextmanager.v1.ServicePerimeter] in the
     *                                              [Access Policy]
     *                                              [google.identity.accesscontextmanager.v1.AccessPolicy].
     * @param array              $optionalArgs      {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. The etag for the version of the [Access Policy]
     *           [google.identity.accesscontextmanager.v1.AccessPolicy] that this
     *           replace operation is to be performed on. If, at the time of replace, the
     *           etag for the Access Policy stored in Access Context Manager is different
     *           from the specified etag, then the replace operation will not be performed
     *           and the call will fail. This field is not required. If etag is not
     *           provided, the operation will be performed as if a valid etag is provided.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function replaceServicePerimeters(
        $parent,
        $servicePerimeters,
        array $optionalArgs = []
    ) {
        $request = new ReplaceServicePerimetersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setServicePerimeters($servicePerimeters);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ReplaceServicePerimeters',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update an [Access Level]
     * [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
     * operation from this RPC will have a successful status once the changes to
     * the [Access Level]
     * [google.identity.accesscontextmanager.v1.AccessLevel] have propagated
     * to long-lasting storage. [Access Levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] containing
     * errors will result in an error response for the first error encountered.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $accessLevel = new AccessLevel();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $accessContextManagerClient->updateAccessLevel($accessLevel, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->updateAccessLevel($accessLevel, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'updateAccessLevel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param AccessLevel $accessLevel  Required. The updated [Access Level]
     *                                  [google.identity.accesscontextmanager.v1.AccessLevel]. Syntactic
     *                                  correctness of the [Access Level]
     *                                  [google.identity.accesscontextmanager.v1.AccessLevel] is a
     *                                  precondition for creation.
     * @param FieldMask   $updateMask   Required. Mask to control which fields get updated. Must be non-empty.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAccessLevel(
        $accessLevel,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateAccessLevelRequest();
        $requestParamHeaders = [];
        $request->setAccessLevel($accessLevel);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['access_level.name'] = $accessLevel->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateAccessLevel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update an [AccessPolicy]
     * [google.identity.accesscontextmanager.v1.AccessPolicy]. The
     * longrunning Operation from this RPC will have a successful status once the
     * changes to the [AccessPolicy]
     * [google.identity.accesscontextmanager.v1.AccessPolicy] have propagated
     * to long-lasting storage. Syntactic and basic semantic errors will be
     * returned in `metadata` as a BadRequest proto.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $policy = new AccessPolicy();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $accessContextManagerClient->updateAccessPolicy($policy, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->updateAccessPolicy($policy, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'updateAccessPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param AccessPolicy $policy       Required. The updated AccessPolicy.
     * @param FieldMask    $updateMask   Required. Mask to control which fields get updated. Must be non-empty.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAccessPolicy(
        $policy,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateAccessPolicyRequest();
        $requestParamHeaders = [];
        $request->setPolicy($policy);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['policy.name'] = $policy->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateAccessPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a [GcpUserAccessBinding]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
     * Completion of this long-running operation does not necessarily signify that
     * the changed binding is deployed onto all affected users, which may take
     * more time.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $gcpUserAccessBinding = new GcpUserAccessBinding();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $accessContextManagerClient->updateGcpUserAccessBinding($gcpUserAccessBinding, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->updateGcpUserAccessBinding($gcpUserAccessBinding, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'updateGcpUserAccessBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param GcpUserAccessBinding $gcpUserAccessBinding Required. [GcpUserAccessBinding]
     *                                                   [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
     * @param FieldMask            $updateMask           Required. Only the fields specified in this mask are updated. Because name and
     *                                                   group_key cannot be changed, update_mask is required and must always be:
     *
     *                                                   update_mask {
     *                                                   paths: "access_levels"
     *                                                   }
     * @param array                $optionalArgs         {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateGcpUserAccessBinding(
        $gcpUserAccessBinding,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateGcpUserAccessBindingRequest();
        $requestParamHeaders = [];
        $request->setGcpUserAccessBinding($gcpUserAccessBinding);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'gcp_user_access_binding.name'
        ] = $gcpUserAccessBinding->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateGcpUserAccessBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update a [Service Perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
     * longrunning operation from this RPC will have a successful status once the
     * changes to the [Service Perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] have
     * propagated to long-lasting storage. [Service Perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
     * errors will result in an error response for the first error encountered.
     *
     * Sample code:
     * ```
     * $accessContextManagerClient = new AccessContextManagerClient();
     * try {
     *     $servicePerimeter = new ServicePerimeter();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $accessContextManagerClient->updateServicePerimeter($servicePerimeter, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $accessContextManagerClient->updateServicePerimeter($servicePerimeter, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $accessContextManagerClient->resumeOperation($operationName, 'updateServicePerimeter');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $accessContextManagerClient->close();
     * }
     * ```
     *
     * @param ServicePerimeter $servicePerimeter Required. The updated `ServicePerimeter`. Syntactic correctness of the
     *                                           `ServicePerimeter` is a precondition for creation.
     * @param FieldMask        $updateMask       Required. Mask to control which fields get updated. Must be non-empty.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateServicePerimeter(
        $servicePerimeter,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateServicePerimeterRequest();
        $requestParamHeaders = [];
        $request->setServicePerimeter($servicePerimeter);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'service_perimeter.name'
        ] = $servicePerimeter->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateServicePerimeter',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
