<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gkebackup/v1/gkebackup.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\GkeBackup\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\GkeBackup\V1\Backup;
use Google\Cloud\GkeBackup\V1\BackupPlan;
use Google\Cloud\GkeBackup\V1\CreateBackupPlanRequest;
use Google\Cloud\GkeBackup\V1\CreateBackupRequest;
use Google\Cloud\GkeBackup\V1\CreateRestorePlanRequest;
use Google\Cloud\GkeBackup\V1\CreateRestoreRequest;
use Google\Cloud\GkeBackup\V1\DeleteBackupPlanRequest;
use Google\Cloud\GkeBackup\V1\DeleteBackupRequest;
use Google\Cloud\GkeBackup\V1\DeleteRestorePlanRequest;
use Google\Cloud\GkeBackup\V1\DeleteRestoreRequest;
use Google\Cloud\GkeBackup\V1\GetBackupPlanRequest;
use Google\Cloud\GkeBackup\V1\GetBackupRequest;
use Google\Cloud\GkeBackup\V1\GetRestorePlanRequest;
use Google\Cloud\GkeBackup\V1\GetRestoreRequest;
use Google\Cloud\GkeBackup\V1\GetVolumeBackupRequest;
use Google\Cloud\GkeBackup\V1\GetVolumeRestoreRequest;
use Google\Cloud\GkeBackup\V1\ListBackupPlansRequest;
use Google\Cloud\GkeBackup\V1\ListBackupsRequest;
use Google\Cloud\GkeBackup\V1\ListRestorePlansRequest;
use Google\Cloud\GkeBackup\V1\ListRestoresRequest;
use Google\Cloud\GkeBackup\V1\ListVolumeBackupsRequest;
use Google\Cloud\GkeBackup\V1\ListVolumeRestoresRequest;
use Google\Cloud\GkeBackup\V1\Restore;
use Google\Cloud\GkeBackup\V1\RestorePlan;
use Google\Cloud\GkeBackup\V1\UpdateBackupPlanRequest;
use Google\Cloud\GkeBackup\V1\UpdateBackupRequest;
use Google\Cloud\GkeBackup\V1\UpdateRestorePlanRequest;
use Google\Cloud\GkeBackup\V1\UpdateRestoreRequest;
use Google\Cloud\GkeBackup\V1\VolumeBackup;
use Google\Cloud\GkeBackup\V1\VolumeRestore;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: BackupForGKE allows Kubernetes administrators to configure, execute, and
 * manage backup and restore operations for their GKE clusters.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\GkeBackup\V1\BackupForGKEClient} for the stable implementation
 *
 * @experimental
 *
 * @method PromiseInterface createBackupAsync(CreateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBackupPlanAsync(CreateBackupPlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRestoreAsync(CreateRestoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRestorePlanAsync(CreateRestorePlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBackupAsync(DeleteBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBackupPlanAsync(DeleteBackupPlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteRestoreAsync(DeleteRestoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteRestorePlanAsync(DeleteRestorePlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBackupAsync(GetBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBackupPlanAsync(GetBackupPlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRestoreAsync(GetRestoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRestorePlanAsync(GetRestorePlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getVolumeBackupAsync(GetVolumeBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getVolumeRestoreAsync(GetVolumeRestoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBackupPlansAsync(ListBackupPlansRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBackupsAsync(ListBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRestorePlansAsync(ListRestorePlansRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRestoresAsync(ListRestoresRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listVolumeBackupsAsync(ListVolumeBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listVolumeRestoresAsync(ListVolumeRestoresRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBackupAsync(UpdateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBackupPlanAsync(UpdateBackupPlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateRestoreAsync(UpdateRestoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateRestorePlanAsync(UpdateRestorePlanRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class BackupForGKEClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.gkebackup.v1.BackupForGKE';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'gkebackup.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/backup_for_gke_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/backup_for_gke_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/backup_for_gke_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/backup_for_gke_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlan
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName(string $project, string $location, string $backupPlan, string $backup): string
    {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'location' => $location,
            'backup_plan' => $backupPlan,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup_plan
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlan
     *
     * @return string The formatted backup_plan resource.
     */
    public static function backupPlanName(string $project, string $location, string $backupPlan): string
    {
        return self::getPathTemplate('backupPlan')->render([
            'project' => $project,
            'location' => $location,
            'backup_plan' => $backupPlan,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(string $project, string $location, string $cluster): string
    {
        return self::getPathTemplate('cluster')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a restore
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $restorePlan
     * @param string $restore
     *
     * @return string The formatted restore resource.
     */
    public static function restoreName(string $project, string $location, string $restorePlan, string $restore): string
    {
        return self::getPathTemplate('restore')->render([
            'project' => $project,
            'location' => $location,
            'restore_plan' => $restorePlan,
            'restore' => $restore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a restore_plan
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $restorePlan
     *
     * @return string The formatted restore_plan resource.
     */
    public static function restorePlanName(string $project, string $location, string $restorePlan): string
    {
        return self::getPathTemplate('restorePlan')->render([
            'project' => $project,
            'location' => $location,
            'restore_plan' => $restorePlan,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_backup resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPlan
     * @param string $backup
     * @param string $volumeBackup
     *
     * @return string The formatted volume_backup resource.
     */
    public static function volumeBackupName(string $project, string $location, string $backupPlan, string $backup, string $volumeBackup): string
    {
        return self::getPathTemplate('volumeBackup')->render([
            'project' => $project,
            'location' => $location,
            'backup_plan' => $backupPlan,
            'backup' => $backup,
            'volume_backup' => $volumeBackup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_restore resource.
     *
     * @param string $project
     * @param string $location
     * @param string $restorePlan
     * @param string $restore
     * @param string $volumeRestore
     *
     * @return string The formatted volume_restore resource.
     */
    public static function volumeRestoreName(string $project, string $location, string $restorePlan, string $restore, string $volumeRestore): string
    {
        return self::getPathTemplate('volumeRestore')->render([
            'project' => $project,
            'location' => $location,
            'restore_plan' => $restorePlan,
            'restore' => $restore,
            'volume_restore' => $volumeRestore,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}
     * - backupPlan: projects/{project}/locations/{location}/backupPlans/{backup_plan}
     * - cluster: projects/{project}/locations/{location}/clusters/{cluster}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - location: projects/{project}/locations/{location}
     * - restore: projects/{project}/locations/{location}/restorePlans/{restore_plan}/restores/{restore}
     * - restorePlan: projects/{project}/locations/{location}/restorePlans/{restore_plan}
     * - volumeBackup: projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}/volumeBackups/{volume_backup}
     * - volumeRestore: projects/{project}/locations/{location}/restorePlans/{restore_plan}/restores/{restore}/volumeRestores/{volume_restore}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'gkebackup.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a Backup for the given BackupPlan.
     *
     * The async variant is {@see BackupForGKEClient::createBackupAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/create_backup.php
     *
     * @param CreateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackup(CreateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackup', $request, $callOptions)->wait();
    }

    /**
     * Creates a new BackupPlan in a given location.
     *
     * The async variant is {@see BackupForGKEClient::createBackupPlanAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/create_backup_plan.php
     *
     * @param CreateBackupPlanRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackupPlan(CreateBackupPlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackupPlan', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Restore for the given RestorePlan.
     *
     * The async variant is {@see BackupForGKEClient::createRestoreAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/create_restore.php
     *
     * @param CreateRestoreRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRestore(CreateRestoreRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRestore', $request, $callOptions)->wait();
    }

    /**
     * Creates a new RestorePlan in a given location.
     *
     * The async variant is {@see BackupForGKEClient::createRestorePlanAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/create_restore_plan.php
     *
     * @param CreateRestorePlanRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRestorePlan(CreateRestorePlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRestorePlan', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing Backup.
     *
     * The async variant is {@see BackupForGKEClient::deleteBackupAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/delete_backup.php
     *
     * @param DeleteBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackup(DeleteBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackup', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing BackupPlan.
     *
     * The async variant is {@see BackupForGKEClient::deleteBackupPlanAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/delete_backup_plan.php
     *
     * @param DeleteBackupPlanRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackupPlan(DeleteBackupPlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackupPlan', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing Restore.
     *
     * The async variant is {@see BackupForGKEClient::deleteRestoreAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/delete_restore.php
     *
     * @param DeleteRestoreRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRestore(DeleteRestoreRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRestore', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing RestorePlan.
     *
     * The async variant is {@see BackupForGKEClient::deleteRestorePlanAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/delete_restore_plan.php
     *
     * @param DeleteRestorePlanRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRestorePlan(DeleteRestorePlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRestorePlan', $request, $callOptions)->wait();
    }

    /**
     * Retrieve the details of a single Backup.
     *
     * The async variant is {@see BackupForGKEClient::getBackupAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/get_backup.php
     *
     * @param GetBackupRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackup(GetBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('GetBackup', $request, $callOptions)->wait();
    }

    /**
     * Retrieve the details of a single BackupPlan.
     *
     * The async variant is {@see BackupForGKEClient::getBackupPlanAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/get_backup_plan.php
     *
     * @param GetBackupPlanRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupPlan
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackupPlan(GetBackupPlanRequest $request, array $callOptions = []): BackupPlan
    {
        return $this->startApiCall('GetBackupPlan', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the details of a single Restore.
     *
     * The async variant is {@see BackupForGKEClient::getRestoreAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/get_restore.php
     *
     * @param GetRestoreRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Restore
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRestore(GetRestoreRequest $request, array $callOptions = []): Restore
    {
        return $this->startApiCall('GetRestore', $request, $callOptions)->wait();
    }

    /**
     * Retrieve the details of a single RestorePlan.
     *
     * The async variant is {@see BackupForGKEClient::getRestorePlanAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/get_restore_plan.php
     *
     * @param GetRestorePlanRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RestorePlan
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRestorePlan(GetRestorePlanRequest $request, array $callOptions = []): RestorePlan
    {
        return $this->startApiCall('GetRestorePlan', $request, $callOptions)->wait();
    }

    /**
     * Retrieve the details of a single VolumeBackup.
     *
     * The async variant is {@see BackupForGKEClient::getVolumeBackupAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/get_volume_backup.php
     *
     * @param GetVolumeBackupRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VolumeBackup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVolumeBackup(GetVolumeBackupRequest $request, array $callOptions = []): VolumeBackup
    {
        return $this->startApiCall('GetVolumeBackup', $request, $callOptions)->wait();
    }

    /**
     * Retrieve the details of a single VolumeRestore.
     *
     * The async variant is {@see BackupForGKEClient::getVolumeRestoreAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/get_volume_restore.php
     *
     * @param GetVolumeRestoreRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VolumeRestore
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVolumeRestore(GetVolumeRestoreRequest $request, array $callOptions = []): VolumeRestore
    {
        return $this->startApiCall('GetVolumeRestore', $request, $callOptions)->wait();
    }

    /**
     * Lists BackupPlans in a given location.
     *
     * The async variant is {@see BackupForGKEClient::listBackupPlansAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/list_backup_plans.php
     *
     * @param ListBackupPlansRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupPlans(ListBackupPlansRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackupPlans', $request, $callOptions);
    }

    /**
     * Lists the Backups for a given BackupPlan.
     *
     * The async variant is {@see BackupForGKEClient::listBackupsAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/list_backups.php
     *
     * @param ListBackupsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackups(ListBackupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackups', $request, $callOptions);
    }

    /**
     * Lists RestorePlans in a given location.
     *
     * The async variant is {@see BackupForGKEClient::listRestorePlansAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/list_restore_plans.php
     *
     * @param ListRestorePlansRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRestorePlans(ListRestorePlansRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRestorePlans', $request, $callOptions);
    }

    /**
     * Lists the Restores for a given RestorePlan.
     *
     * The async variant is {@see BackupForGKEClient::listRestoresAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/list_restores.php
     *
     * @param ListRestoresRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRestores(ListRestoresRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRestores', $request, $callOptions);
    }

    /**
     * Lists the VolumeBackups for a given Backup.
     *
     * The async variant is {@see BackupForGKEClient::listVolumeBackupsAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/list_volume_backups.php
     *
     * @param ListVolumeBackupsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVolumeBackups(ListVolumeBackupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVolumeBackups', $request, $callOptions);
    }

    /**
     * Lists the VolumeRestores for a given Restore.
     *
     * The async variant is {@see BackupForGKEClient::listVolumeRestoresAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/list_volume_restores.php
     *
     * @param ListVolumeRestoresRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVolumeRestores(ListVolumeRestoresRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVolumeRestores', $request, $callOptions);
    }

    /**
     * Update a Backup.
     *
     * The async variant is {@see BackupForGKEClient::updateBackupAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/update_backup.php
     *
     * @param UpdateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackup(UpdateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackup', $request, $callOptions)->wait();
    }

    /**
     * Update a BackupPlan.
     *
     * The async variant is {@see BackupForGKEClient::updateBackupPlanAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/update_backup_plan.php
     *
     * @param UpdateBackupPlanRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackupPlan(UpdateBackupPlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackupPlan', $request, $callOptions)->wait();
    }

    /**
     * Update a Restore.
     *
     * The async variant is {@see BackupForGKEClient::updateRestoreAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/update_restore.php
     *
     * @param UpdateRestoreRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRestore(UpdateRestoreRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateRestore', $request, $callOptions)->wait();
    }

    /**
     * Update a RestorePlan.
     *
     * The async variant is {@see BackupForGKEClient::updateRestorePlanAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/update_restore_plan.php
     *
     * @param UpdateRestorePlanRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRestorePlan(UpdateRestorePlanRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateRestorePlan', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see BackupForGKEClient::getLocationAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see BackupForGKEClient::listLocationsAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see BackupForGKEClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see BackupForGKEClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see BackupForGKEClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/BackupForGKEClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
