<?php
/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/asset/v1/asset_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Asset\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Asset\V1\AnalyzeIamPolicyLongrunningRequest;
use Google\Cloud\Asset\V1\AnalyzeIamPolicyRequest;
use Google\Cloud\Asset\V1\AnalyzeIamPolicyResponse;
use Google\Cloud\Asset\V1\AnalyzeMoveRequest;
use Google\Cloud\Asset\V1\AnalyzeMoveResponse;
use Google\Cloud\Asset\V1\AnalyzeOrgPoliciesRequest;
use Google\Cloud\Asset\V1\AnalyzeOrgPoliciesResponse;
use Google\Cloud\Asset\V1\AnalyzeOrgPolicyGovernedAssetsRequest;
use Google\Cloud\Asset\V1\AnalyzeOrgPolicyGovernedAssetsResponse;
use Google\Cloud\Asset\V1\AnalyzeOrgPolicyGovernedContainersRequest;
use Google\Cloud\Asset\V1\AnalyzeOrgPolicyGovernedContainersResponse;
use Google\Cloud\Asset\V1\BatchGetAssetsHistoryRequest;
use Google\Cloud\Asset\V1\BatchGetAssetsHistoryResponse;
use Google\Cloud\Asset\V1\BatchGetEffectiveIamPoliciesRequest;
use Google\Cloud\Asset\V1\BatchGetEffectiveIamPoliciesResponse;
use Google\Cloud\Asset\V1\ContentType;
use Google\Cloud\Asset\V1\CreateFeedRequest;
use Google\Cloud\Asset\V1\CreateSavedQueryRequest;
use Google\Cloud\Asset\V1\DeleteFeedRequest;
use Google\Cloud\Asset\V1\DeleteSavedQueryRequest;
use Google\Cloud\Asset\V1\ExportAssetsRequest;
use Google\Cloud\Asset\V1\Feed;
use Google\Cloud\Asset\V1\GetFeedRequest;
use Google\Cloud\Asset\V1\GetSavedQueryRequest;
use Google\Cloud\Asset\V1\IamPolicyAnalysisOutputConfig;
use Google\Cloud\Asset\V1\IamPolicyAnalysisQuery;
use Google\Cloud\Asset\V1\ListAssetsRequest;
use Google\Cloud\Asset\V1\ListAssetsResponse;
use Google\Cloud\Asset\V1\ListFeedsRequest;
use Google\Cloud\Asset\V1\ListFeedsResponse;
use Google\Cloud\Asset\V1\ListSavedQueriesRequest;
use Google\Cloud\Asset\V1\ListSavedQueriesResponse;
use Google\Cloud\Asset\V1\OutputConfig;
use Google\Cloud\Asset\V1\QueryAssetsOutputConfig;
use Google\Cloud\Asset\V1\QueryAssetsRequest;
use Google\Cloud\Asset\V1\QueryAssetsResponse;
use Google\Cloud\Asset\V1\SavedQuery;
use Google\Cloud\Asset\V1\SearchAllIamPoliciesRequest;
use Google\Cloud\Asset\V1\SearchAllIamPoliciesResponse;
use Google\Cloud\Asset\V1\SearchAllResourcesRequest;
use Google\Cloud\Asset\V1\SearchAllResourcesResponse;
use Google\Cloud\Asset\V1\TimeWindow;
use Google\Cloud\Asset\V1\UpdateFeedRequest;
use Google\Cloud\Asset\V1\UpdateSavedQueryRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\Duration;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Timestamp;

/**
 * Service Description: Asset service definition.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $assetServiceClient = new AssetServiceClient();
 * try {
 *     $analysisQuery = new IamPolicyAnalysisQuery();
 *     $response = $assetServiceClient->analyzeIamPolicy($analysisQuery);
 * } finally {
 *     $assetServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Asset\V1\Client\AssetServiceClient} to use the new surface.
 */
class AssetServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.asset.v1.AssetService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'cloudasset.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $feedNameTemplate;

    private static $folderNameTemplate;

    private static $folderFeedNameTemplate;

    private static $folderSavedQueryNameTemplate;

    private static $organizationNameTemplate;

    private static $organizationFeedNameTemplate;

    private static $organizationSavedQueryNameTemplate;

    private static $projectNameTemplate;

    private static $projectFeedNameTemplate;

    private static $projectSavedQueryNameTemplate;

    private static $savedQueryNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/asset_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/asset_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/asset_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/asset_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getFeedNameTemplate()
    {
        if (self::$feedNameTemplate == null) {
            self::$feedNameTemplate = new PathTemplate(
                'projects/{project}/feeds/{feed}'
            );
        }

        return self::$feedNameTemplate;
    }

    private static function getFolderNameTemplate()
    {
        if (self::$folderNameTemplate == null) {
            self::$folderNameTemplate = new PathTemplate('folders/{folder}');
        }

        return self::$folderNameTemplate;
    }

    private static function getFolderFeedNameTemplate()
    {
        if (self::$folderFeedNameTemplate == null) {
            self::$folderFeedNameTemplate = new PathTemplate(
                'folders/{folder}/feeds/{feed}'
            );
        }

        return self::$folderFeedNameTemplate;
    }

    private static function getFolderSavedQueryNameTemplate()
    {
        if (self::$folderSavedQueryNameTemplate == null) {
            self::$folderSavedQueryNameTemplate = new PathTemplate(
                'folders/{folder}/savedQueries/{saved_query}'
            );
        }

        return self::$folderSavedQueryNameTemplate;
    }

    private static function getOrganizationNameTemplate()
    {
        if (self::$organizationNameTemplate == null) {
            self::$organizationNameTemplate = new PathTemplate(
                'organizations/{organization}'
            );
        }

        return self::$organizationNameTemplate;
    }

    private static function getOrganizationFeedNameTemplate()
    {
        if (self::$organizationFeedNameTemplate == null) {
            self::$organizationFeedNameTemplate = new PathTemplate(
                'organizations/{organization}/feeds/{feed}'
            );
        }

        return self::$organizationFeedNameTemplate;
    }

    private static function getOrganizationSavedQueryNameTemplate()
    {
        if (self::$organizationSavedQueryNameTemplate == null) {
            self::$organizationSavedQueryNameTemplate = new PathTemplate(
                'organizations/{organization}/savedQueries/{saved_query}'
            );
        }

        return self::$organizationSavedQueryNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getProjectFeedNameTemplate()
    {
        if (self::$projectFeedNameTemplate == null) {
            self::$projectFeedNameTemplate = new PathTemplate(
                'projects/{project}/feeds/{feed}'
            );
        }

        return self::$projectFeedNameTemplate;
    }

    private static function getProjectSavedQueryNameTemplate()
    {
        if (self::$projectSavedQueryNameTemplate == null) {
            self::$projectSavedQueryNameTemplate = new PathTemplate(
                'projects/{project}/savedQueries/{saved_query}'
            );
        }

        return self::$projectSavedQueryNameTemplate;
    }

    private static function getSavedQueryNameTemplate()
    {
        if (self::$savedQueryNameTemplate == null) {
            self::$savedQueryNameTemplate = new PathTemplate(
                'projects/{project}/savedQueries/{saved_query}'
            );
        }

        return self::$savedQueryNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'feed' => self::getFeedNameTemplate(),
                'folder' => self::getFolderNameTemplate(),
                'folderFeed' => self::getFolderFeedNameTemplate(),
                'folderSavedQuery' => self::getFolderSavedQueryNameTemplate(),
                'organization' => self::getOrganizationNameTemplate(),
                'organizationFeed' => self::getOrganizationFeedNameTemplate(),
                'organizationSavedQuery' => self::getOrganizationSavedQueryNameTemplate(),
                'project' => self::getProjectNameTemplate(),
                'projectFeed' => self::getProjectFeedNameTemplate(),
                'projectSavedQuery' => self::getProjectSavedQueryNameTemplate(),
                'savedQuery' => self::getSavedQueryNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a feed
     * resource.
     *
     * @param string $project
     * @param string $feed
     *
     * @return string The formatted feed resource.
     */
    public static function feedName($project, $feed)
    {
        return self::getFeedNameTemplate()->render([
            'project' => $project,
            'feed' => $feed,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName($folder)
    {
        return self::getFolderNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder_feed
     * resource.
     *
     * @param string $folder
     * @param string $feed
     *
     * @return string The formatted folder_feed resource.
     */
    public static function folderFeedName($folder, $feed)
    {
        return self::getFolderFeedNameTemplate()->render([
            'folder' => $folder,
            'feed' => $feed,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_saved_query resource.
     *
     * @param string $folder
     * @param string $savedQuery
     *
     * @return string The formatted folder_saved_query resource.
     */
    public static function folderSavedQueryName($folder, $savedQuery)
    {
        return self::getFolderSavedQueryNameTemplate()->render([
            'folder' => $folder,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName($organization)
    {
        return self::getOrganizationNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_feed resource.
     *
     * @param string $organization
     * @param string $feed
     *
     * @return string The formatted organization_feed resource.
     */
    public static function organizationFeedName($organization, $feed)
    {
        return self::getOrganizationFeedNameTemplate()->render([
            'organization' => $organization,
            'feed' => $feed,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_saved_query resource.
     *
     * @param string $organization
     * @param string $savedQuery
     *
     * @return string The formatted organization_saved_query resource.
     */
    public static function organizationSavedQueryName(
        $organization,
        $savedQuery
    ) {
        return self::getOrganizationSavedQueryNameTemplate()->render([
            'organization' => $organization,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project_feed
     * resource.
     *
     * @param string $project
     * @param string $feed
     *
     * @return string The formatted project_feed resource.
     */
    public static function projectFeedName($project, $feed)
    {
        return self::getProjectFeedNameTemplate()->render([
            'project' => $project,
            'feed' => $feed,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_saved_query resource.
     *
     * @param string $project
     * @param string $savedQuery
     *
     * @return string The formatted project_saved_query resource.
     */
    public static function projectSavedQueryName($project, $savedQuery)
    {
        return self::getProjectSavedQueryNameTemplate()->render([
            'project' => $project,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a saved_query
     * resource.
     *
     * @param string $project
     * @param string $savedQuery
     *
     * @return string The formatted saved_query resource.
     */
    public static function savedQueryName($project, $savedQuery)
    {
        return self::getSavedQueryNameTemplate()->render([
            'project' => $project,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - feed: projects/{project}/feeds/{feed}
     * - folder: folders/{folder}
     * - folderFeed: folders/{folder}/feeds/{feed}
     * - folderSavedQuery: folders/{folder}/savedQueries/{saved_query}
     * - organization: organizations/{organization}
     * - organizationFeed: organizations/{organization}/feeds/{feed}
     * - organizationSavedQuery: organizations/{organization}/savedQueries/{saved_query}
     * - project: projects/{project}
     * - projectFeed: projects/{project}/feeds/{feed}
     * - projectSavedQuery: projects/{project}/savedQueries/{saved_query}
     * - savedQuery: projects/{project}/savedQueries/{saved_query}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudasset.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Analyzes IAM policies to answer which identities have what accesses on
     * which resources.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $analysisQuery = new IamPolicyAnalysisQuery();
     *     $response = $assetServiceClient->analyzeIamPolicy($analysisQuery);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param IamPolicyAnalysisQuery $analysisQuery Required. The request query.
     * @param array                  $optionalArgs  {
     *     Optional.
     *
     *     @type string $savedAnalysisQuery
     *           Optional. The name of a saved query, which must be in the format of:
     *
     *           * projects/project_number/savedQueries/saved_query_id
     *           * folders/folder_number/savedQueries/saved_query_id
     *           * organizations/organization_number/savedQueries/saved_query_id
     *
     *           If both `analysis_query` and `saved_analysis_query` are provided, they
     *           will be merged together with the `saved_analysis_query` as base and
     *           the `analysis_query` as overrides. For more details of the merge behavior,
     *           please refer to the
     *           [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
     *           page.
     *
     *           Note that you cannot override primitive fields with default value, such as
     *           0 or empty string, etc., because we use proto3, which doesn't support field
     *           presence yet.
     *     @type Duration $executionTimeout
     *           Optional. Amount of time executable has to complete.  See JSON
     *           representation of
     *           [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json).
     *
     *           If this field is set with a value less than the RPC deadline, and the
     *           execution of your query hasn't finished in the specified
     *           execution timeout,  you will get a response with partial result.
     *           Otherwise, your query's execution will continue until the RPC deadline.
     *           If it's not finished until then, you will get a  DEADLINE_EXCEEDED error.
     *
     *           Default is empty.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\AnalyzeIamPolicyResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function analyzeIamPolicy($analysisQuery, array $optionalArgs = [])
    {
        $request = new AnalyzeIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setAnalysisQuery($analysisQuery);
        $requestParamHeaders[
            'analysis_query.scope'
        ] = $analysisQuery->getScope();
        if (isset($optionalArgs['savedAnalysisQuery'])) {
            $request->setSavedAnalysisQuery(
                $optionalArgs['savedAnalysisQuery']
            );
        }

        if (isset($optionalArgs['executionTimeout'])) {
            $request->setExecutionTimeout($optionalArgs['executionTimeout']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'AnalyzeIamPolicy',
            AnalyzeIamPolicyResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Analyzes IAM policies asynchronously to answer which identities have what
     * accesses on which resources, and writes the analysis results to a Google
     * Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
     * output format is the JSON format that represents a
     * [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
     * This method implements the
     * [google.longrunning.Operation][google.longrunning.Operation], which allows
     * you to track the operation status. We recommend intervals of at least 2
     * seconds with exponential backoff retry to poll the operation result. The
     * metadata contains the metadata for the long-running operation.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $analysisQuery = new IamPolicyAnalysisQuery();
     *     $outputConfig = new IamPolicyAnalysisOutputConfig();
     *     $operationResponse = $assetServiceClient->analyzeIamPolicyLongrunning($analysisQuery, $outputConfig);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $assetServiceClient->analyzeIamPolicyLongrunning($analysisQuery, $outputConfig);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $assetServiceClient->resumeOperation($operationName, 'analyzeIamPolicyLongrunning');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param IamPolicyAnalysisQuery        $analysisQuery Required. The request query.
     * @param IamPolicyAnalysisOutputConfig $outputConfig  Required. Output configuration indicating where the results will be output
     *                                                     to.
     * @param array                         $optionalArgs  {
     *     Optional.
     *
     *     @type string $savedAnalysisQuery
     *           Optional. The name of a saved query, which must be in the format of:
     *
     *           * projects/project_number/savedQueries/saved_query_id
     *           * folders/folder_number/savedQueries/saved_query_id
     *           * organizations/organization_number/savedQueries/saved_query_id
     *
     *           If both `analysis_query` and `saved_analysis_query` are provided, they
     *           will be merged together with the `saved_analysis_query` as base and
     *           the `analysis_query` as overrides. For more details of the merge behavior,
     *           please refer to the
     *           [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
     *           doc.
     *
     *           Note that you cannot override primitive fields with default value, such as
     *           0 or empty string, etc., because we use proto3, which doesn't support field
     *           presence yet.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function analyzeIamPolicyLongrunning(
        $analysisQuery,
        $outputConfig,
        array $optionalArgs = []
    ) {
        $request = new AnalyzeIamPolicyLongrunningRequest();
        $requestParamHeaders = [];
        $request->setAnalysisQuery($analysisQuery);
        $request->setOutputConfig($outputConfig);
        $requestParamHeaders[
            'analysis_query.scope'
        ] = $analysisQuery->getScope();
        if (isset($optionalArgs['savedAnalysisQuery'])) {
            $request->setSavedAnalysisQuery(
                $optionalArgs['savedAnalysisQuery']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'AnalyzeIamPolicyLongrunning',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Analyze moving a resource to a specified destination without kicking off
     * the actual move. The analysis is best effort depending on the user's
     * permissions of viewing different hierarchical policies and configurations.
     * The policies and configuration are subject to change before the actual
     * resource migration takes place.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $resource = 'resource';
     *     $destinationParent = 'destination_parent';
     *     $response = $assetServiceClient->analyzeMove($resource, $destinationParent);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $resource          Required. Name of the resource to perform the analysis against.
     *                                  Only Google Cloud projects are supported as of today. Hence, this can only
     *                                  be a project ID (such as "projects/my-project-id") or a project number
     *                                  (such as "projects/12345").
     * @param string $destinationParent Required. Name of the Google Cloud folder or organization to reparent the
     *                                  target resource. The analysis will be performed against hypothetically
     *                                  moving the resource to this specified desitination parent. This can only be
     *                                  a folder number (such as "folders/123") or an organization number (such as
     *                                  "organizations/123").
     * @param array  $optionalArgs      {
     *     Optional.
     *
     *     @type int $view
     *           Analysis view indicating what information should be included in the
     *           analysis response. If unspecified, the default view is FULL.
     *           For allowed values, use constants defined on {@see \Google\Cloud\Asset\V1\AnalyzeMoveRequest\AnalysisView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\AnalyzeMoveResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function analyzeMove(
        $resource,
        $destinationParent,
        array $optionalArgs = []
    ) {
        $request = new AnalyzeMoveRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setDestinationParent($destinationParent);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'AnalyzeMove',
            AnalyzeMoveResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Analyzes organization policies under a scope.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $scope = 'scope';
     *     $constraint = 'constraint';
     *     // Iterate over pages of elements
     *     $pagedResponse = $assetServiceClient->analyzeOrgPolicies($scope, $constraint);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $assetServiceClient->analyzeOrgPolicies($scope, $constraint);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $scope        Required. The organization to scope the request. Only organization
     *                             policies within the scope will be analyzed.
     *
     *                             * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     * @param string $constraint   Required. The name of the constraint to analyze organization policies for.
     *                             The response only contains analyzed organization policies for the provided
     *                             constraint.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The expression to filter
     *           [AnalyzeOrgPoliciesResponse.org_policy_results][google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.org_policy_results].
     *           The only supported field is `consolidated_policy.attached_resource`, and
     *           the only supported operator is `=`.
     *
     *           Example:
     *           consolidated_policy.attached_resource="//cloudresourcemanager.googleapis.com/folders/001"
     *           will return the org policy results of"folders/001".
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function analyzeOrgPolicies(
        $scope,
        $constraint,
        array $optionalArgs = []
    ) {
        $request = new AnalyzeOrgPoliciesRequest();
        $requestParamHeaders = [];
        $request->setScope($scope);
        $request->setConstraint($constraint);
        $requestParamHeaders['scope'] = $scope;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'AnalyzeOrgPolicies',
            $optionalArgs,
            AnalyzeOrgPoliciesResponse::class,
            $request
        );
    }

    /**
     * Analyzes organization policies governed assets (Google Cloud resources or
     * policies) under a scope. This RPC supports custom constraints and the
     * following 10 canned constraints:
     *
     * * storage.uniformBucketLevelAccess
     * * iam.disableServiceAccountKeyCreation
     * * iam.allowedPolicyMemberDomains
     * * compute.vmExternalIpAccess
     * * appengine.enforceServiceAccountActAsCheck
     * * gcp.resourceLocations
     * * compute.trustedImageProjects
     * * compute.skipDefaultNetworkCreation
     * * compute.requireOsLogin
     * * compute.disableNestedVirtualization
     *
     * This RPC only returns either resources of types supported by [searchable
     * asset
     * types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types),
     * or IAM policies.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $scope = 'scope';
     *     $constraint = 'constraint';
     *     // Iterate over pages of elements
     *     $pagedResponse = $assetServiceClient->analyzeOrgPolicyGovernedAssets($scope, $constraint);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $assetServiceClient->analyzeOrgPolicyGovernedAssets($scope, $constraint);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $scope        Required. The organization to scope the request. Only organization
     *                             policies within the scope will be analyzed. The output assets will
     *                             also be limited to the ones governed by those in-scope organization
     *                             policies.
     *
     *                             * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     * @param string $constraint   Required. The name of the constraint to analyze governed assets for. The
     *                             analysis only contains analyzed organization policies for the provided
     *                             constraint.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The expression to filter the governed assets in result. The only supported
     *           fields for governed resources are `governed_resource.project` and
     *           `governed_resource.folders`. The only supported fields for governed iam
     *           policies are `governed_iam_policy.project` and
     *           `governed_iam_policy.folders`. The only supported operator is `=`.
     *
     *           Example 1: governed_resource.project="projects/12345678" filter will return
     *           all governed resources under projects/12345678 including the project
     *           ifself, if applicable.
     *
     *           Example 2: governed_iam_policy.folders="folders/12345678" filter will
     *           return all governed iam policies under folders/12345678, if applicable.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function analyzeOrgPolicyGovernedAssets(
        $scope,
        $constraint,
        array $optionalArgs = []
    ) {
        $request = new AnalyzeOrgPolicyGovernedAssetsRequest();
        $requestParamHeaders = [];
        $request->setScope($scope);
        $request->setConstraint($constraint);
        $requestParamHeaders['scope'] = $scope;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'AnalyzeOrgPolicyGovernedAssets',
            $optionalArgs,
            AnalyzeOrgPolicyGovernedAssetsResponse::class,
            $request
        );
    }

    /**
     * Analyzes organization policies governed containers (projects, folders or
     * organization) under a scope.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $scope = 'scope';
     *     $constraint = 'constraint';
     *     // Iterate over pages of elements
     *     $pagedResponse = $assetServiceClient->analyzeOrgPolicyGovernedContainers($scope, $constraint);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $assetServiceClient->analyzeOrgPolicyGovernedContainers($scope, $constraint);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $scope        Required. The organization to scope the request. Only organization
     *                             policies within the scope will be analyzed. The output containers will
     *                             also be limited to the ones governed by those in-scope organization
     *                             policies.
     *
     *                             * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     * @param string $constraint   Required. The name of the constraint to analyze governed containers for.
     *                             The analysis only contains organization policies for the provided
     *                             constraint.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The expression to filter the governed containers in result.
     *           The only supported field is `parent`, and the only supported operator is
     *           `=`.
     *
     *           Example:
     *           parent="//cloudresourcemanager.googleapis.com/folders/001" will return all
     *           containers under "folders/001".
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function analyzeOrgPolicyGovernedContainers(
        $scope,
        $constraint,
        array $optionalArgs = []
    ) {
        $request = new AnalyzeOrgPolicyGovernedContainersRequest();
        $requestParamHeaders = [];
        $request->setScope($scope);
        $request->setConstraint($constraint);
        $requestParamHeaders['scope'] = $scope;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'AnalyzeOrgPolicyGovernedContainers',
            $optionalArgs,
            AnalyzeOrgPolicyGovernedContainersResponse::class,
            $request
        );
    }

    /**
     * Batch gets the update history of assets that overlap a time window.
     * For IAM_POLICY content, this API outputs history when the asset and its
     * attached IAM POLICY both exist. This can create gaps in the output history.
     * Otherwise, this API outputs history with asset in both non-delete or
     * deleted status.
     * If a specified asset does not exist, this API returns an INVALID_ARGUMENT
     * error.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $parent = 'parent';
     *     $contentType = ContentType::CONTENT_TYPE_UNSPECIFIED;
     *     $readTimeWindow = new TimeWindow();
     *     $response = $assetServiceClient->batchGetAssetsHistory($parent, $contentType, $readTimeWindow);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent         Required. The relative name of the root asset. It can only be an
     *                                   organization number (such as "organizations/123"), a project ID (such as
     *                                   "projects/my-project-id")", or a project number (such as "projects/12345").
     * @param int        $contentType    Optional. The content type.
     *                                   For allowed values, use constants defined on {@see \Google\Cloud\Asset\V1\ContentType}
     * @param TimeWindow $readTimeWindow Optional. The time window for the asset history. Both start_time and
     *                                   end_time are optional and if set, it must be after the current time minus
     *                                   35 days. If end_time is not set, it is default to current timestamp.
     *                                   If start_time is not set, the snapshot of the assets at end_time will be
     *                                   returned. The returned results contain all temporal assets whose time
     *                                   window overlap with read_time_window.
     * @param array      $optionalArgs   {
     *     Optional.
     *
     *     @type string[] $assetNames
     *           A list of the full names of the assets.
     *           See: https://cloud.google.com/asset-inventory/docs/resource-name-format
     *           Example:
     *
     *           `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     *
     *           The request becomes a no-op if the asset name list is empty, and the max
     *           size of the asset name list is 100 in one request.
     *     @type string[] $relationshipTypes
     *           Optional. A list of relationship types to output, for example:
     *           `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
     *           content_type=RELATIONSHIP.
     *           * If specified:
     *           it outputs specified relationships' history on the [asset_names]. It
     *           returns an error if any of the [relationship_types] doesn't belong to the
     *           supported relationship types of the [asset_names] or if any of the
     *           [asset_names]'s types doesn't belong to the source types of the
     *           [relationship_types].
     *           * Otherwise:
     *           it outputs the supported relationships' history on the [asset_names] or
     *           returns an error if any of the [asset_names]'s types has no relationship
     *           support.
     *           See [Introduction to Cloud Asset
     *           Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
     *           supported asset types and relationship types.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\BatchGetAssetsHistoryResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchGetAssetsHistory(
        $parent,
        $contentType,
        $readTimeWindow,
        array $optionalArgs = []
    ) {
        $request = new BatchGetAssetsHistoryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setContentType($contentType);
        $request->setReadTimeWindow($readTimeWindow);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['assetNames'])) {
            $request->setAssetNames($optionalArgs['assetNames']);
        }

        if (isset($optionalArgs['relationshipTypes'])) {
            $request->setRelationshipTypes($optionalArgs['relationshipTypes']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'BatchGetAssetsHistory',
            BatchGetAssetsHistoryResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets effective IAM policies for a batch of resources.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $scope = 'scope';
     *     $names = [];
     *     $response = $assetServiceClient->batchGetEffectiveIamPolicies($scope, $names);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string   $scope        Required. Only IAM policies on or below the scope will be returned.
     *
     *                               This can only be an organization number (such as "organizations/123"), a
     *                               folder number (such as "folders/123"), a project ID (such as
     *                               "projects/my-project-id"), or a project number (such as "projects/12345").
     *
     *                               To know how to get organization id, visit [here
     *                               ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
     *
     *                               To know how to get folder or project id, visit [here
     *                               ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
     * @param string[] $names        Required. The names refer to the [full_resource_names]
     *                               (https://cloud.google.com/asset-inventory/docs/resource-name-format)
     *                               of [searchable asset
     *                               types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
     *                               A maximum of 20 resources' effective policies can be retrieved in a batch.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\BatchGetEffectiveIamPoliciesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchGetEffectiveIamPolicies(
        $scope,
        $names,
        array $optionalArgs = []
    ) {
        $request = new BatchGetEffectiveIamPoliciesRequest();
        $requestParamHeaders = [];
        $request->setScope($scope);
        $request->setNames($names);
        $requestParamHeaders['scope'] = $scope;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'BatchGetEffectiveIamPolicies',
            BatchGetEffectiveIamPoliciesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a feed in a parent project/folder/organization to listen to its
     * asset updates.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $parent = 'parent';
     *     $feedId = 'feed_id';
     *     $feed = new Feed();
     *     $response = $assetServiceClient->createFeed($parent, $feedId, $feed);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the project/folder/organization where this feed
     *                             should be created in. It can only be an organization number (such as
     *                             "organizations/123"), a folder number (such as "folders/123"), a project ID
     *                             (such as "projects/my-project-id"), or a project number (such as
     *                             "projects/12345").
     * @param string $feedId       Required. This is the client-assigned asset feed identifier and it needs to
     *                             be unique under a specific parent project/folder/organization.
     * @param Feed   $feed         Required. The feed details. The field `name` must be empty and it will be
     *                             generated in the format of: projects/project_number/feeds/feed_id
     *                             folders/folder_number/feeds/feed_id
     *                             organizations/organization_number/feeds/feed_id
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\Feed
     *
     * @throws ApiException if the remote call fails
     */
    public function createFeed(
        $parent,
        $feedId,
        $feed,
        array $optionalArgs = []
    ) {
        $request = new CreateFeedRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFeedId($feedId);
        $request->setFeed($feed);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateFeed',
            Feed::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a saved query in a parent project/folder/organization.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $formattedParent = $assetServiceClient->projectName('[PROJECT]');
     *     $savedQuery = new SavedQuery();
     *     $savedQueryId = 'saved_query_id';
     *     $response = $assetServiceClient->createSavedQuery($formattedParent, $savedQuery, $savedQueryId);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The name of the project/folder/organization where this
     *                                 saved_query should be created in. It can only be an organization number
     *                                 (such as "organizations/123"), a folder number (such as "folders/123"), a
     *                                 project ID (such as "projects/my-project-id"), or a project number (such as
     *                                 "projects/12345").
     * @param SavedQuery $savedQuery   Required. The saved_query details. The `name` field must be empty as it
     *                                 will be generated based on the parent and saved_query_id.
     * @param string     $savedQueryId Required. The ID to use for the saved query, which must be unique in the
     *                                 specified parent. It will become the final component of the saved query's
     *                                 resource name.
     *
     *                                 This value should be 4-63 characters, and valid characters
     *                                 are `[a-z][0-9]-`.
     *
     *                                 Notice that this field is required in the saved query creation, and the
     *                                 `name` field of the `saved_query` will be ignored.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\SavedQuery
     *
     * @throws ApiException if the remote call fails
     */
    public function createSavedQuery(
        $parent,
        $savedQuery,
        $savedQueryId,
        array $optionalArgs = []
    ) {
        $request = new CreateSavedQueryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSavedQuery($savedQuery);
        $request->setSavedQueryId($savedQueryId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateSavedQuery',
            SavedQuery::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes an asset feed.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $formattedName = $assetServiceClient->feedName('[PROJECT]', '[FEED]');
     *     $assetServiceClient->deleteFeed($formattedName);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the feed and it must be in the format of:
     *                             projects/project_number/feeds/feed_id
     *                             folders/folder_number/feeds/feed_id
     *                             organizations/organization_number/feeds/feed_id
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFeed($name, array $optionalArgs = [])
    {
        $request = new DeleteFeedRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteFeed',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a saved query.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $formattedName = $assetServiceClient->savedQueryName('[PROJECT]', '[SAVED_QUERY]');
     *     $assetServiceClient->deleteSavedQuery($formattedName);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the saved query to delete. It must be in the format
     *                             of:
     *
     *                             * projects/project_number/savedQueries/saved_query_id
     *                             * folders/folder_number/savedQueries/saved_query_id
     *                             * organizations/organization_number/savedQueries/saved_query_id
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSavedQuery($name, array $optionalArgs = [])
    {
        $request = new DeleteSavedQueryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteSavedQuery',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Exports assets with time and resource types to a given Cloud Storage
     * location/BigQuery table. For Cloud Storage location destinations, the
     * output format is newline-delimited JSON. Each line represents a
     * [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
     * format; for BigQuery table destinations, the output table stores the fields
     * in asset Protobuf as columns. This API implements the
     * [google.longrunning.Operation][google.longrunning.Operation] API, which
     * allows you to keep track of the export. We recommend intervals of at least
     * 2 seconds with exponential retry to poll the export operation result. For
     * regular-size resource parent, the export operation usually finishes within
     * 5 minutes.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $parent = 'parent';
     *     $outputConfig = new OutputConfig();
     *     $operationResponse = $assetServiceClient->exportAssets($parent, $outputConfig);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $assetServiceClient->exportAssets($parent, $outputConfig);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $assetServiceClient->resumeOperation($operationName, 'exportAssets');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent       Required. The relative name of the root asset. This can only be an
     *                                   organization number (such as "organizations/123"), a project ID (such as
     *                                   "projects/my-project-id"), or a project number (such as "projects/12345"),
     *                                   or a folder number (such as "folders/123").
     * @param OutputConfig $outputConfig Required. Output configuration indicating where the results will be output
     *                                   to.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type Timestamp $readTime
     *           Timestamp to take an asset snapshot. This can only be set to a timestamp
     *           between the current time and the current time minus 35 days (inclusive).
     *           If not specified, the current time will be used. Due to delays in resource
     *           data collection and indexing, there is a volatile window during which
     *           running the same query may get different results.
     *     @type string[] $assetTypes
     *           A list of asset types to take a snapshot for. For example:
     *           "compute.googleapis.com/Disk".
     *
     *           Regular expressions are also supported. For example:
     *
     *           * "compute.googleapis.com.*" snapshots resources whose asset type starts
     *           with "compute.googleapis.com".
     *           * ".*Instance" snapshots resources whose asset type ends with "Instance".
     *           * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     *           See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     *           regular expression syntax. If the regular expression does not match any
     *           supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     *           If specified, only matching assets will be returned, otherwise, it will
     *           snapshot all asset types. See [Introduction to Cloud Asset
     *           Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     *           for all supported asset types.
     *     @type int $contentType
     *           Asset content type. If not specified, no content but the asset name will be
     *           returned.
     *           For allowed values, use constants defined on {@see \Google\Cloud\Asset\V1\ContentType}
     *     @type string[] $relationshipTypes
     *           A list of relationship types to export, for example:
     *           `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
     *           content_type=RELATIONSHIP.
     *           * If specified:
     *           it snapshots specified relationships. It returns an error if
     *           any of the [relationship_types] doesn't belong to the supported
     *           relationship types of the [asset_types] or if any of the [asset_types]
     *           doesn't belong to the source types of the [relationship_types].
     *           * Otherwise:
     *           it snapshots the supported relationships for all [asset_types] or returns
     *           an error if any of the [asset_types] has no relationship support.
     *           An unspecified asset types field means all supported asset_types.
     *           See [Introduction to Cloud Asset
     *           Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
     *           supported asset types and relationship types.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function exportAssets(
        $parent,
        $outputConfig,
        array $optionalArgs = []
    ) {
        $request = new ExportAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setOutputConfig($outputConfig);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['readTime'])) {
            $request->setReadTime($optionalArgs['readTime']);
        }

        if (isset($optionalArgs['assetTypes'])) {
            $request->setAssetTypes($optionalArgs['assetTypes']);
        }

        if (isset($optionalArgs['contentType'])) {
            $request->setContentType($optionalArgs['contentType']);
        }

        if (isset($optionalArgs['relationshipTypes'])) {
            $request->setRelationshipTypes($optionalArgs['relationshipTypes']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ExportAssets',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details about an asset feed.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $formattedName = $assetServiceClient->feedName('[PROJECT]', '[FEED]');
     *     $response = $assetServiceClient->getFeed($formattedName);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Feed and it must be in the format of:
     *                             projects/project_number/feeds/feed_id
     *                             folders/folder_number/feeds/feed_id
     *                             organizations/organization_number/feeds/feed_id
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\Feed
     *
     * @throws ApiException if the remote call fails
     */
    public function getFeed($name, array $optionalArgs = [])
    {
        $request = new GetFeedRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFeed',
            Feed::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details about a saved query.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $formattedName = $assetServiceClient->savedQueryName('[PROJECT]', '[SAVED_QUERY]');
     *     $response = $assetServiceClient->getSavedQuery($formattedName);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the saved query and it must be in the format of:
     *
     *                             * projects/project_number/savedQueries/saved_query_id
     *                             * folders/folder_number/savedQueries/saved_query_id
     *                             * organizations/organization_number/savedQueries/saved_query_id
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\SavedQuery
     *
     * @throws ApiException if the remote call fails
     */
    public function getSavedQuery($name, array $optionalArgs = [])
    {
        $request = new GetSavedQueryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSavedQuery',
            SavedQuery::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists assets with time and resource types and returns paged results in
     * response.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $assetServiceClient->listAssets($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $assetServiceClient->listAssets($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the organization, folder, or project the assets belong
     *                             to. Format: "organizations/[organization-number]" (such as
     *                             "organizations/123"), "projects/[project-id]" (such as
     *                             "projects/my-project-id"), "projects/[project-number]" (such as
     *                             "projects/12345"), or "folders/[folder-number]" (such as "folders/12345").
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type Timestamp $readTime
     *           Timestamp to take an asset snapshot. This can only be set to a timestamp
     *           between the current time and the current time minus 35 days (inclusive).
     *           If not specified, the current time will be used. Due to delays in resource
     *           data collection and indexing, there is a volatile window during which
     *           running the same query may get different results.
     *     @type string[] $assetTypes
     *           A list of asset types to take a snapshot for. For example:
     *           "compute.googleapis.com/Disk".
     *
     *           Regular expression is also supported. For example:
     *
     *           * "compute.googleapis.com.*" snapshots resources whose asset type starts
     *           with "compute.googleapis.com".
     *           * ".*Instance" snapshots resources whose asset type ends with "Instance".
     *           * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     *           See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     *           regular expression syntax. If the regular expression does not match any
     *           supported asset type, an INVALID_ARGUMENT error will be returned.
     *
     *           If specified, only matching assets will be returned, otherwise, it will
     *           snapshot all asset types. See [Introduction to Cloud Asset
     *           Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     *           for all supported asset types.
     *     @type int $contentType
     *           Asset content type. If not specified, no content but the asset name will
     *           be returned.
     *           For allowed values, use constants defined on {@see \Google\Cloud\Asset\V1\ContentType}
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string[] $relationshipTypes
     *           A list of relationship types to output, for example:
     *           `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
     *           content_type=RELATIONSHIP.
     *           * If specified:
     *           it snapshots specified relationships. It returns an error if
     *           any of the [relationship_types] doesn't belong to the supported
     *           relationship types of the [asset_types] or if any of the [asset_types]
     *           doesn't belong to the source types of the [relationship_types].
     *           * Otherwise:
     *           it snapshots the supported relationships for all [asset_types] or returns
     *           an error if any of the [asset_types] has no relationship support.
     *           An unspecified asset types field means all supported asset_types.
     *           See [Introduction to Cloud Asset
     *           Inventory](https://cloud.google.com/asset-inventory/docs/overview)
     *           for all supported asset types and relationship types.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAssets($parent, array $optionalArgs = [])
    {
        $request = new ListAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['readTime'])) {
            $request->setReadTime($optionalArgs['readTime']);
        }

        if (isset($optionalArgs['assetTypes'])) {
            $request->setAssetTypes($optionalArgs['assetTypes']);
        }

        if (isset($optionalArgs['contentType'])) {
            $request->setContentType($optionalArgs['contentType']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['relationshipTypes'])) {
            $request->setRelationshipTypes($optionalArgs['relationshipTypes']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAssets',
            $optionalArgs,
            ListAssetsResponse::class,
            $request
        );
    }

    /**
     * Lists all asset feeds in a parent project/folder/organization.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $parent = 'parent';
     *     $response = $assetServiceClient->listFeeds($parent);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent project/folder/organization whose feeds are to be
     *                             listed. It can only be using project/folder/organization number (such as
     *                             "folders/12345")", or a project ID (such as "projects/my-project-id").
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\ListFeedsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFeeds($parent, array $optionalArgs = [])
    {
        $request = new ListFeedsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ListFeeds',
            ListFeedsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all saved queries in a parent project/folder/organization.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $formattedParent = $assetServiceClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $assetServiceClient->listSavedQueries($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $assetServiceClient->listSavedQueries($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent project/folder/organization whose savedQueries are to
     *                             be listed. It can only be using project/folder/organization number (such as
     *                             "folders/12345")", or a project ID (such as "projects/my-project-id").
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Optional. The expression to filter resources.
     *           The expression is a list of zero or more restrictions combined via logical
     *           operators `AND` and `OR`. When `AND` and `OR` are both used in the
     *           expression, parentheses must be appropriately used to group the
     *           combinations. The expression may also contain regular expressions.
     *
     *           See https://google.aip.dev/160 for more information on the grammar.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSavedQueries($parent, array $optionalArgs = [])
    {
        $request = new ListSavedQueriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSavedQueries',
            $optionalArgs,
            ListSavedQueriesResponse::class,
            $request
        );
    }

    /**
     * Issue a job that queries assets using a SQL statement compatible with
     * [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
     *
     * If the query execution finishes within timeout and there's no pagination,
     * the full query results will be returned in the `QueryAssetsResponse`.
     *
     * Otherwise, full query results can be obtained by issuing extra requests
     * with the `job_reference` from the a previous `QueryAssets` call.
     *
     * Note, the query result has approximately 10 GB limitation enforced by
     * [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
     * Queries return larger results will result in errors.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $parent = 'parent';
     *     $response = $assetServiceClient->queryAssets($parent);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The relative name of the root asset. This can only be an
     *                             organization number (such as "organizations/123"), a project ID (such as
     *                             "projects/my-project-id"), or a project number (such as "projects/12345"),
     *                             or a folder number (such as "folders/123").
     *
     *                             Only assets belonging to the `parent` will be returned.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $statement
     *           Optional. A SQL statement that's compatible with [BigQuery
     *           SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
     *     @type string $jobReference
     *           Optional. Reference to the query job, which is from the
     *           `QueryAssetsResponse` of previous `QueryAssets` call.
     *     @type int $pageSize
     *           Optional. The maximum number of rows to return in the results. Responses
     *           are limited to 10 MB and 1000 rows.
     *
     *           By default, the maximum row count is 1000. When the byte or row count limit
     *           is reached, the rest of the query results will be paginated.
     *
     *           The field will be ignored when [output_config] is specified.
     *     @type string $pageToken
     *           Optional. A page token received from previous `QueryAssets`.
     *
     *           The field will be ignored when [output_config] is specified.
     *     @type Duration $timeout
     *           Optional. Specifies the maximum amount of time that the client is willing
     *           to wait for the query to complete. By default, this limit is 5 min for the
     *           first query, and 1 minute for the following queries. If the query is
     *           complete, the `done` field in the `QueryAssetsResponse` is true, otherwise
     *           false.
     *
     *           Like BigQuery [jobs.query
     *           API](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest)
     *           The call is not guaranteed to wait for the specified timeout; it typically
     *           returns after around 200 seconds (200,000 milliseconds), even if the query
     *           is not complete.
     *
     *           The field will be ignored when [output_config] is specified.
     *     @type TimeWindow $readTimeWindow
     *           Optional. [start_time] is required. [start_time] must be less than
     *           [end_time] Defaults [end_time] to now if [start_time] is set and
     *           [end_time] isn't. Maximum permitted time range is 7 days.
     *     @type Timestamp $readTime
     *           Optional. Queries cloud assets as they appeared at the specified point in
     *           time.
     *     @type QueryAssetsOutputConfig $outputConfig
     *           Optional. Destination where the query results will be saved.
     *
     *           When this field is specified, the query results won't be saved in the
     *           [QueryAssetsResponse.query_result]. Instead
     *           [QueryAssetsResponse.output_config] will be set.
     *
     *           Meanwhile, [QueryAssetsResponse.job_reference] will be set and can be used
     *           to check the status of the query job when passed to a following
     *           [QueryAssets] API call.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\QueryAssetsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function queryAssets($parent, array $optionalArgs = [])
    {
        $request = new QueryAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['statement'])) {
            $request->setStatement($optionalArgs['statement']);
        }

        if (isset($optionalArgs['jobReference'])) {
            $request->setJobReference($optionalArgs['jobReference']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['timeout'])) {
            $request->setTimeout($optionalArgs['timeout']);
        }

        if (isset($optionalArgs['readTimeWindow'])) {
            $request->setReadTimeWindow($optionalArgs['readTimeWindow']);
        }

        if (isset($optionalArgs['readTime'])) {
            $request->setReadTime($optionalArgs['readTime']);
        }

        if (isset($optionalArgs['outputConfig'])) {
            $request->setOutputConfig($optionalArgs['outputConfig']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'QueryAssets',
            QueryAssetsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Searches all IAM policies within the specified scope, such as a project,
     * folder, or organization. The caller must be granted the
     * `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
     * otherwise the request will be rejected.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $scope = 'scope';
     *     // Iterate over pages of elements
     *     $pagedResponse = $assetServiceClient->searchAllIamPolicies($scope);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $assetServiceClient->searchAllIamPolicies($scope);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $scope        Required. A scope can be a project, a folder, or an organization. The
     *                             search is limited to the IAM policies within the `scope`. The caller must
     *                             be granted the
     *                             [`cloudasset.assets.searchAllIamPolicies`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
     *                             permission on the desired scope.
     *
     *                             The allowed values are:
     *
     *                             * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
     *                             * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
     *                             * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
     *                             * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $query
     *           Optional. The query statement. See [how to construct a
     *           query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
     *           for more information. If not specified or empty, it will search all the
     *           IAM policies within the specified `scope`. Note that the query string is
     *           compared against each IAM policy binding, including its principals,
     *           roles, and IAM conditions. The returned IAM policies will only
     *           contain the bindings that match your query. To learn more about the IAM
     *           policy structure, see the [IAM policy
     *           documentation](https://cloud.google.com/iam/help/allow-policies/structure).
     *
     *           Examples:
     *
     *           * `policy:amy&#64;gmail.com` to find IAM policy bindings that specify user
     *           "amy&#64;gmail.com".
     *           * `policy:roles/compute.admin` to find IAM policy bindings that specify
     *           the Compute Admin role.
     *           * `policy:comp*` to find IAM policy bindings that contain "comp" as a
     *           prefix of any word in the binding.
     *           * `policy.role.permissions:storage.buckets.update` to find IAM policy
     *           bindings that specify a role containing "storage.buckets.update"
     *           permission. Note that if callers don't have `iam.roles.get` access to a
     *           role's included permissions, policy bindings that specify this role will
     *           be dropped from the search results.
     *           * `policy.role.permissions:upd*` to find IAM policy bindings that specify a
     *           role containing "upd" as a prefix of any word in the role permission.
     *           Note that if callers don't have `iam.roles.get` access to a role's
     *           included permissions, policy bindings that specify this role will be
     *           dropped from the search results.
     *           * `resource:organizations/123456` to find IAM policy bindings
     *           that are set on "organizations/123456".
     *           * `resource=//cloudresourcemanager.googleapis.com/projects/myproject` to
     *           find IAM policy bindings that are set on the project named "myproject".
     *           * `Important` to find IAM policy bindings that contain "Important" as a
     *           word in any of the searchable fields (except for the included
     *           permissions).
     *           * `resource:(instance1 OR instance2) policy:amy` to find
     *           IAM policy bindings that are set on resources "instance1" or
     *           "instance2" and also specify user "amy".
     *           * `roles:roles/compute.admin` to find IAM policy bindings that specify the
     *           Compute Admin role.
     *           * `memberTypes:user` to find IAM policy bindings that contain the
     *           principal type "user".
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string[] $assetTypes
     *           Optional. A list of asset types that the IAM policies are attached to. If
     *           empty, it will search the IAM policies that are attached to all the
     *           [searchable asset
     *           types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
     *
     *           Regular expressions are also supported. For example:
     *
     *           * "compute.googleapis.com.*" snapshots IAM policies attached to asset type
     *           starts with "compute.googleapis.com".
     *           * ".*Instance" snapshots IAM policies attached to asset type ends with
     *           "Instance".
     *           * ".*Instance.*" snapshots IAM policies attached to asset type contains
     *           "Instance".
     *
     *           See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     *           regular expression syntax. If the regular expression does not match any
     *           supported asset type, an INVALID_ARGUMENT error will be returned.
     *     @type string $orderBy
     *           Optional. A comma-separated list of fields specifying the sorting order of
     *           the results. The default order is ascending. Add " DESC" after the field
     *           name to indicate descending order. Redundant space characters are ignored.
     *           Example: "assetType DESC, resource".
     *           Only singular primitive fields in the response are sortable:
     *           * resource
     *           * assetType
     *           * project
     *           All the other fields such as repeated fields (e.g., `folders`) and
     *           non-primitive fields (e.g., `policy`) are not supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchAllIamPolicies($scope, array $optionalArgs = [])
    {
        $request = new SearchAllIamPoliciesRequest();
        $requestParamHeaders = [];
        $request->setScope($scope);
        $requestParamHeaders['scope'] = $scope;
        if (isset($optionalArgs['query'])) {
            $request->setQuery($optionalArgs['query']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['assetTypes'])) {
            $request->setAssetTypes($optionalArgs['assetTypes']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'SearchAllIamPolicies',
            $optionalArgs,
            SearchAllIamPoliciesResponse::class,
            $request
        );
    }

    /**
     * Searches all Google Cloud resources within the specified scope, such as a
     * project, folder, or organization. The caller must be granted the
     * `cloudasset.assets.searchAllResources` permission on the desired scope,
     * otherwise the request will be rejected.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $scope = 'scope';
     *     // Iterate over pages of elements
     *     $pagedResponse = $assetServiceClient->searchAllResources($scope);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $assetServiceClient->searchAllResources($scope);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param string $scope        Required. A scope can be a project, a folder, or an organization. The
     *                             search is limited to the resources within the `scope`. The caller must be
     *                             granted the
     *                             [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
     *                             permission on the desired scope.
     *
     *                             The allowed values are:
     *
     *                             * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
     *                             * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
     *                             * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
     *                             * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $query
     *           Optional. The query statement. See [how to construct a
     *           query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
     *           for more information. If not specified or empty, it will search all the
     *           resources within the specified `scope`.
     *
     *           Examples:
     *
     *           * `name:Important` to find Google Cloud resources whose name contains
     *           `Important` as a word.
     *           * `name=Important` to find the Google Cloud resource whose name is exactly
     *           `Important`.
     *           * `displayName:Impor*` to find Google Cloud resources whose display name
     *           contains `Impor` as a prefix of any word in the field.
     *           * `location:us-west*` to find Google Cloud resources whose location
     *           contains both `us` and `west` as prefixes.
     *           * `labels:prod` to find Google Cloud resources whose labels contain `prod`
     *           as a key or value.
     *           * `labels.env:prod` to find Google Cloud resources that have a label `env`
     *           and its value is `prod`.
     *           * `labels.env:*` to find Google Cloud resources that have a label `env`.
     *           * `tagKeys:env` to find Google Cloud resources that have directly
     *           attached tags where the
     *           [`TagKey`](https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys#resource:-tagkey)
     *           .`namespacedName` contains `env`.
     *           * `tagValues:prod*` to find Google Cloud resources that have directly
     *           attached tags where the
     *           [`TagValue`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
     *           .`namespacedName` contains a word prefixed by `prod`.
     *           * `tagValueIds=tagValues/123` to find Google Cloud resources that have
     *           directly attached tags where the
     *           [`TagValue`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
     *           .`name` is exactly `tagValues/123`.
     *           * `effectiveTagKeys:env` to find Google Cloud resources that have
     *           directly attached or inherited tags where the
     *           [`TagKey`](https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys#resource:-tagkey)
     *           .`namespacedName` contains `env`.
     *           * `effectiveTagValues:prod*` to find Google Cloud resources that have
     *           directly attached or inherited tags where the
     *           [`TagValue`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
     *           .`namespacedName` contains a word prefixed by `prod`.
     *           * `effectiveTagValueIds=tagValues/123` to find Google Cloud resources that
     *           have directly attached or inherited tags where the
     *           [`TagValue`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
     *           .`name` is exactly `tagValues/123`.
     *           * `kmsKey:key` to find Google Cloud resources encrypted with a
     *           customer-managed encryption key whose name contains `key` as a word. This
     *           field is deprecated. Please use the `kmsKeys` field to retrieve Cloud KMS
     *           key information.
     *           * `kmsKeys:key` to find Google Cloud resources encrypted with
     *           customer-managed encryption keys whose name contains the word `key`.
     *           * `relationships:instance-group-1` to find Google Cloud resources that have
     *           relationships with `instance-group-1` in the related resource name.
     *           * `relationships:INSTANCE_TO_INSTANCEGROUP` to find Compute Engine
     *           instances that have relationships of type `INSTANCE_TO_INSTANCEGROUP`.
     *           * `relationships.INSTANCE_TO_INSTANCEGROUP:instance-group-1` to find
     *           Compute Engine instances that have relationships with `instance-group-1`
     *           in the Compute Engine instance group resource name, for relationship type
     *           `INSTANCE_TO_INSTANCEGROUP`.
     *           * `state:ACTIVE` to find Google Cloud resources whose state contains
     *           `ACTIVE` as a word.
     *           * `NOT state:ACTIVE` to find Google Cloud resources whose state doesn't
     *           contain `ACTIVE` as a word.
     *           * `createTime<1609459200` to find Google Cloud resources that were created
     *           before `2021-01-01 00:00:00 UTC`. `1609459200` is the epoch timestamp of
     *           `2021-01-01 00:00:00 UTC` in seconds.
     *           * `updateTime>1609459200` to find Google Cloud resources that were updated
     *           after `2021-01-01 00:00:00 UTC`. `1609459200` is the epoch timestamp of
     *           `2021-01-01 00:00:00 UTC` in seconds.
     *           * `Important` to find Google Cloud resources that contain `Important` as a
     *           word in any of the searchable fields.
     *           * `Impor*` to find Google Cloud resources that contain `Impor` as a prefix
     *           of any word in any of the searchable fields.
     *           * `Important location:(us-west1 OR global)` to find Google Cloud
     *           resources that contain `Important` as a word in any of the searchable
     *           fields and are also located in the `us-west1` region or the `global`
     *           location.
     *     @type string[] $assetTypes
     *           Optional. A list of asset types that this request searches for. If empty,
     *           it will search all the [searchable asset
     *           types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
     *
     *           Regular expressions are also supported. For example:
     *
     *           * "compute.googleapis.com.*" snapshots resources whose asset type starts
     *           with "compute.googleapis.com".
     *           * ".*Instance" snapshots resources whose asset type ends with "Instance".
     *           * ".*Instance.*" snapshots resources whose asset type contains "Instance".
     *
     *           See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
     *           regular expression syntax. If the regular expression does not match any
     *           supported asset type, an INVALID_ARGUMENT error will be returned.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Optional. A comma-separated list of fields specifying the sorting order of
     *           the results. The default order is ascending. Add " DESC" after the field
     *           name to indicate descending order. Redundant space characters are ignored.
     *           Example: "location DESC, name".
     *           Only the following fields in the response are sortable:
     *
     *           * name
     *           * assetType
     *           * project
     *           * displayName
     *           * description
     *           * location
     *           * createTime
     *           * updateTime
     *           * state
     *           * parentFullResourceName
     *           * parentAssetType
     *     @type FieldMask $readMask
     *           Optional. A comma-separated list of fields that you want returned in the
     *           results. The following fields are returned by default if not specified:
     *
     *           * `name`
     *           * `assetType`
     *           * `project`
     *           * `folders`
     *           * `organization`
     *           * `displayName`
     *           * `description`
     *           * `location`
     *           * `labels`
     *           * `tags`
     *           * `effectiveTags`
     *           * `networkTags`
     *           * `kmsKeys`
     *           * `createTime`
     *           * `updateTime`
     *           * `state`
     *           * `additionalAttributes`
     *           * `parentFullResourceName`
     *           * `parentAssetType`
     *
     *           Some fields of large size, such as `versionedResources`,
     *           `attachedResources`, `effectiveTags` etc., are not returned by default, but
     *           you can specify them in the `read_mask` parameter if you want to include
     *           them. If `"*"` is specified, all [available
     *           fields](https://cloud.google.com/asset-inventory/docs/reference/rest/v1/TopLevel/searchAllResources#resourcesearchresult)
     *           are returned.
     *           Examples: `"name,location"`, `"name,versionedResources"`, `"*"`.
     *           Any invalid field path will trigger INVALID_ARGUMENT error.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchAllResources($scope, array $optionalArgs = [])
    {
        $request = new SearchAllResourcesRequest();
        $requestParamHeaders = [];
        $request->setScope($scope);
        $requestParamHeaders['scope'] = $scope;
        if (isset($optionalArgs['query'])) {
            $request->setQuery($optionalArgs['query']);
        }

        if (isset($optionalArgs['assetTypes'])) {
            $request->setAssetTypes($optionalArgs['assetTypes']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'SearchAllResources',
            $optionalArgs,
            SearchAllResourcesResponse::class,
            $request
        );
    }

    /**
     * Updates an asset feed configuration.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $feed = new Feed();
     *     $updateMask = new FieldMask();
     *     $response = $assetServiceClient->updateFeed($feed, $updateMask);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param Feed      $feed         Required. The new values of feed details. It must match an existing feed
     *                                and the field `name` must be in the format of:
     *                                projects/project_number/feeds/feed_id or
     *                                folders/folder_number/feeds/feed_id or
     *                                organizations/organization_number/feeds/feed_id.
     * @param FieldMask $updateMask   Required. Only updates the `feed` fields indicated by this mask.
     *                                The field mask must not be empty, and it must not contain fields that
     *                                are immutable or only set by the server.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\Feed
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFeed($feed, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateFeedRequest();
        $requestParamHeaders = [];
        $request->setFeed($feed);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['feed.name'] = $feed->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateFeed',
            Feed::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a saved query.
     *
     * Sample code:
     * ```
     * $assetServiceClient = new AssetServiceClient();
     * try {
     *     $savedQuery = new SavedQuery();
     *     $updateMask = new FieldMask();
     *     $response = $assetServiceClient->updateSavedQuery($savedQuery, $updateMask);
     * } finally {
     *     $assetServiceClient->close();
     * }
     * ```
     *
     * @param SavedQuery $savedQuery   Required. The saved query to update.
     *
     *                                 The saved query's `name` field is used to identify the one to update,
     *                                 which has format as below:
     *
     *                                 * projects/project_number/savedQueries/saved_query_id
     *                                 * folders/folder_number/savedQueries/saved_query_id
     *                                 * organizations/organization_number/savedQueries/saved_query_id
     * @param FieldMask  $updateMask   Required. The list of fields to update.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Asset\V1\SavedQuery
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSavedQuery(
        $savedQuery,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateSavedQueryRequest();
        $requestParamHeaders = [];
        $request->setSavedQuery($savedQuery);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['saved_query.name'] = $savedQuery->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateSavedQuery',
            SavedQuery::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
