<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/vizier_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\AddTrialMeasurementRequest;
use Google\Cloud\AIPlatform\V1\CheckTrialEarlyStoppingStateRequest;
use Google\Cloud\AIPlatform\V1\CheckTrialEarlyStoppingStateResponse;
use Google\Cloud\AIPlatform\V1\CompleteTrialRequest;
use Google\Cloud\AIPlatform\V1\CreateStudyRequest;
use Google\Cloud\AIPlatform\V1\CreateTrialRequest;
use Google\Cloud\AIPlatform\V1\DeleteStudyRequest;
use Google\Cloud\AIPlatform\V1\DeleteTrialRequest;
use Google\Cloud\AIPlatform\V1\GetStudyRequest;
use Google\Cloud\AIPlatform\V1\GetTrialRequest;
use Google\Cloud\AIPlatform\V1\ListOptimalTrialsRequest;
use Google\Cloud\AIPlatform\V1\ListOptimalTrialsResponse;
use Google\Cloud\AIPlatform\V1\ListStudiesRequest;
use Google\Cloud\AIPlatform\V1\ListStudiesResponse;
use Google\Cloud\AIPlatform\V1\ListTrialsRequest;
use Google\Cloud\AIPlatform\V1\ListTrialsResponse;
use Google\Cloud\AIPlatform\V1\LookupStudyRequest;
use Google\Cloud\AIPlatform\V1\Measurement;
use Google\Cloud\AIPlatform\V1\StopTrialRequest;
use Google\Cloud\AIPlatform\V1\Study;
use Google\Cloud\AIPlatform\V1\SuggestTrialsRequest;
use Google\Cloud\AIPlatform\V1\SuggestTrialsResponse;
use Google\Cloud\AIPlatform\V1\Trial;
use Google\Cloud\AIPlatform\V1\TrialContext;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Vertex AI Vizier API.
 *
 * Vertex AI Vizier is a service to solve blackbox optimization problems,
 * such as tuning machine learning hyperparameters and searching over deep
 * learning architectures.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $vizierServiceClient = new VizierServiceClient();
 * try {
 *     $formattedTrialName = $vizierServiceClient->trialName('[PROJECT]', '[LOCATION]', '[STUDY]', '[TRIAL]');
 *     $measurement = new Measurement();
 *     $response = $vizierServiceClient->addTrialMeasurement($formattedTrialName, $measurement);
 * } finally {
 *     $vizierServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\AIPlatform\V1\Client\VizierServiceClient} to use the new surface.
 */
class VizierServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.VizierService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $customJobNameTemplate;

    private static $locationNameTemplate;

    private static $studyNameTemplate;

    private static $trialNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/vizier_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/vizier_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/vizier_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/vizier_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getCustomJobNameTemplate()
    {
        if (self::$customJobNameTemplate == null) {
            self::$customJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/customJobs/{custom_job}'
            );
        }

        return self::$customJobNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getStudyNameTemplate()
    {
        if (self::$studyNameTemplate == null) {
            self::$studyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/studies/{study}'
            );
        }

        return self::$studyNameTemplate;
    }

    private static function getTrialNameTemplate()
    {
        if (self::$trialNameTemplate == null) {
            self::$trialNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/studies/{study}/trials/{trial}'
            );
        }

        return self::$trialNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'customJob' => self::getCustomJobNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'study' => self::getStudyNameTemplate(),
                'trial' => self::getTrialNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a custom_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $customJob
     *
     * @return string The formatted custom_job resource.
     */
    public static function customJobName($project, $location, $customJob)
    {
        return self::getCustomJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'custom_job' => $customJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a study
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $study
     *
     * @return string The formatted study resource.
     */
    public static function studyName($project, $location, $study)
    {
        return self::getStudyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'study' => $study,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a trial
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $study
     * @param string $trial
     *
     * @return string The formatted trial resource.
     */
    public static function trialName($project, $location, $study, $trial)
    {
        return self::getTrialNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'study' => $study,
            'trial' => $trial,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - customJob: projects/{project}/locations/{location}/customJobs/{custom_job}
     * - location: projects/{project}/locations/{location}
     * - study: projects/{project}/locations/{location}/studies/{study}
     * - trial: projects/{project}/locations/{location}/studies/{study}/trials/{trial}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Adds a measurement of the objective metrics to a Trial. This measurement
     * is assumed to have been taken before the Trial is complete.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedTrialName = $vizierServiceClient->trialName('[PROJECT]', '[LOCATION]', '[STUDY]', '[TRIAL]');
     *     $measurement = new Measurement();
     *     $response = $vizierServiceClient->addTrialMeasurement($formattedTrialName, $measurement);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string      $trialName    Required. The name of the trial to add measurement.
     *                                  Format:
     *                                  `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
     * @param Measurement $measurement  Required. The measurement to be added to a Trial.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Trial
     *
     * @throws ApiException if the remote call fails
     */
    public function addTrialMeasurement(
        $trialName,
        $measurement,
        array $optionalArgs = []
    ) {
        $request = new AddTrialMeasurementRequest();
        $requestParamHeaders = [];
        $request->setTrialName($trialName);
        $request->setMeasurement($measurement);
        $requestParamHeaders['trial_name'] = $trialName;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'AddTrialMeasurement',
            Trial::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Checks  whether a Trial should stop or not. Returns a
     * long-running operation. When the operation is successful,
     * it will contain a
     * [CheckTrialEarlyStoppingStateResponse][google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateResponse].
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedTrialName = $vizierServiceClient->trialName('[PROJECT]', '[LOCATION]', '[STUDY]', '[TRIAL]');
     *     $operationResponse = $vizierServiceClient->checkTrialEarlyStoppingState($formattedTrialName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vizierServiceClient->checkTrialEarlyStoppingState($formattedTrialName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vizierServiceClient->resumeOperation($operationName, 'checkTrialEarlyStoppingState');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $trialName    Required. The Trial's name.
     *                             Format:
     *                             `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function checkTrialEarlyStoppingState(
        $trialName,
        array $optionalArgs = []
    ) {
        $request = new CheckTrialEarlyStoppingStateRequest();
        $requestParamHeaders = [];
        $request->setTrialName($trialName);
        $requestParamHeaders['trial_name'] = $trialName;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CheckTrialEarlyStoppingState',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Marks a Trial as complete.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedName = $vizierServiceClient->trialName('[PROJECT]', '[LOCATION]', '[STUDY]', '[TRIAL]');
     *     $response = $vizierServiceClient->completeTrial($formattedName);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The Trial's name.
     *                             Format:
     *                             `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type Measurement $finalMeasurement
     *           Optional. If provided, it will be used as the completed Trial's
     *           final_measurement; Otherwise, the service will auto-select a
     *           previously reported measurement as the final-measurement
     *     @type bool $trialInfeasible
     *           Optional. True if the Trial cannot be run with the given Parameter, and
     *           final_measurement will be ignored.
     *     @type string $infeasibleReason
     *           Optional. A human readable reason why the trial was infeasible. This should
     *           only be provided if `trial_infeasible` is true.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Trial
     *
     * @throws ApiException if the remote call fails
     */
    public function completeTrial($name, array $optionalArgs = [])
    {
        $request = new CompleteTrialRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['finalMeasurement'])) {
            $request->setFinalMeasurement($optionalArgs['finalMeasurement']);
        }

        if (isset($optionalArgs['trialInfeasible'])) {
            $request->setTrialInfeasible($optionalArgs['trialInfeasible']);
        }

        if (isset($optionalArgs['infeasibleReason'])) {
            $request->setInfeasibleReason($optionalArgs['infeasibleReason']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CompleteTrial',
            Trial::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a Study. A resource name will be generated after creation of the
     * Study.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedParent = $vizierServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $study = new Study();
     *     $response = $vizierServiceClient->createStudy($formattedParent, $study);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to create the CustomJob in.
     *                             Format: `projects/{project}/locations/{location}`
     * @param Study  $study        Required. The Study configuration used to create the Study.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Study
     *
     * @throws ApiException if the remote call fails
     */
    public function createStudy($parent, $study, array $optionalArgs = [])
    {
        $request = new CreateStudyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setStudy($study);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateStudy',
            Study::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Adds a user provided Trial to a Study.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedParent = $vizierServiceClient->studyName('[PROJECT]', '[LOCATION]', '[STUDY]');
     *     $trial = new Trial();
     *     $response = $vizierServiceClient->createTrial($formattedParent, $trial);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Study to create the Trial in.
     *                             Format: `projects/{project}/locations/{location}/studies/{study}`
     * @param Trial  $trial        Required. The Trial to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Trial
     *
     * @throws ApiException if the remote call fails
     */
    public function createTrial($parent, $trial, array $optionalArgs = [])
    {
        $request = new CreateTrialRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTrial($trial);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateTrial',
            Trial::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a Study.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedName = $vizierServiceClient->studyName('[PROJECT]', '[LOCATION]', '[STUDY]');
     *     $vizierServiceClient->deleteStudy($formattedName);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Study resource to be deleted.
     *                             Format: `projects/{project}/locations/{location}/studies/{study}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteStudy($name, array $optionalArgs = [])
    {
        $request = new DeleteStudyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteStudy',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a Trial.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedName = $vizierServiceClient->trialName('[PROJECT]', '[LOCATION]', '[STUDY]', '[TRIAL]');
     *     $vizierServiceClient->deleteTrial($formattedName);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The Trial's name.
     *                             Format:
     *                             `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTrial($name, array $optionalArgs = [])
    {
        $request = new DeleteTrialRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteTrial',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a Study by name.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedName = $vizierServiceClient->studyName('[PROJECT]', '[LOCATION]', '[STUDY]');
     *     $response = $vizierServiceClient->getStudy($formattedName);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Study resource.
     *                             Format: `projects/{project}/locations/{location}/studies/{study}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Study
     *
     * @throws ApiException if the remote call fails
     */
    public function getStudy($name, array $optionalArgs = [])
    {
        $request = new GetStudyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetStudy',
            Study::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a Trial.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedName = $vizierServiceClient->trialName('[PROJECT]', '[LOCATION]', '[STUDY]', '[TRIAL]');
     *     $response = $vizierServiceClient->getTrial($formattedName);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Trial resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Trial
     *
     * @throws ApiException if the remote call fails
     */
    public function getTrial($name, array $optionalArgs = [])
    {
        $request = new GetTrialRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTrial',
            Trial::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists the pareto-optimal Trials for multi-objective Study or the
     * optimal Trials for single-objective Study. The definition of
     * pareto-optimal can be checked in wiki page.
     * https://en.wikipedia.org/wiki/Pareto_efficiency
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedParent = $vizierServiceClient->studyName('[PROJECT]', '[LOCATION]', '[STUDY]');
     *     $response = $vizierServiceClient->listOptimalTrials($formattedParent);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the Study that the optimal Trial belongs to.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\ListOptimalTrialsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listOptimalTrials($parent, array $optionalArgs = [])
    {
        $request = new ListOptimalTrialsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ListOptimalTrials',
            ListOptimalTrialsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all the studies in a region for an associated project.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedParent = $vizierServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vizierServiceClient->listStudies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vizierServiceClient->listStudies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list the Study from.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listStudies($parent, array $optionalArgs = [])
    {
        $request = new ListStudiesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListStudies',
            $optionalArgs,
            ListStudiesResponse::class,
            $request
        );
    }

    /**
     * Lists the Trials associated with a Study.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedParent = $vizierServiceClient->studyName('[PROJECT]', '[LOCATION]', '[STUDY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vizierServiceClient->listTrials($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vizierServiceClient->listTrials($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Study to list the Trial from.
     *                             Format: `projects/{project}/locations/{location}/studies/{study}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTrials($parent, array $optionalArgs = [])
    {
        $request = new ListTrialsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTrials',
            $optionalArgs,
            ListTrialsResponse::class,
            $request
        );
    }

    /**
     * Looks a study up using the user-defined display_name field instead of the
     * fully qualified resource name.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedParent = $vizierServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $displayName = 'display_name';
     *     $response = $vizierServiceClient->lookupStudy($formattedParent, $displayName);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to get the Study from.
     *                             Format: `projects/{project}/locations/{location}`
     * @param string $displayName  Required. The user-defined display name of the Study
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Study
     *
     * @throws ApiException if the remote call fails
     */
    public function lookupStudy($parent, $displayName, array $optionalArgs = [])
    {
        $request = new LookupStudyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDisplayName($displayName);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'LookupStudy',
            Study::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Stops a Trial.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedName = $vizierServiceClient->trialName('[PROJECT]', '[LOCATION]', '[STUDY]', '[TRIAL]');
     *     $response = $vizierServiceClient->stopTrial($formattedName);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The Trial's name.
     *                             Format:
     *                             `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Trial
     *
     * @throws ApiException if the remote call fails
     */
    public function stopTrial($name, array $optionalArgs = [])
    {
        $request = new StopTrialRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'StopTrial',
            Trial::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Adds one or more Trials to a Study, with parameter values
     * suggested by Vertex AI Vizier. Returns a long-running
     * operation associated with the generation of Trial suggestions.
     * When this long-running operation succeeds, it will contain
     * a
     * [SuggestTrialsResponse][google.cloud.aiplatform.v1.SuggestTrialsResponse].
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $formattedParent = $vizierServiceClient->studyName('[PROJECT]', '[LOCATION]', '[STUDY]');
     *     $suggestionCount = 0;
     *     $clientId = 'client_id';
     *     $operationResponse = $vizierServiceClient->suggestTrials($formattedParent, $suggestionCount, $clientId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vizierServiceClient->suggestTrials($formattedParent, $suggestionCount, $clientId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vizierServiceClient->resumeOperation($operationName, 'suggestTrials');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $parent          Required. The project and location that the Study belongs to.
     *                                Format: `projects/{project}/locations/{location}/studies/{study}`
     * @param int    $suggestionCount Required. The number of suggestions requested. It must be positive.
     * @param string $clientId        Required. The identifier of the client that is requesting the suggestion.
     *
     *                                If multiple SuggestTrialsRequests have the same `client_id`,
     *                                the service will return the identical suggested Trial if the Trial is
     *                                pending, and provide a new Trial if the last suggested Trial was completed.
     * @param array  $optionalArgs    {
     *     Optional.
     *
     *     @type TrialContext[] $contexts
     *           Optional. This allows you to specify the "context" for a Trial; a context
     *           is a slice (a subspace) of the search space.
     *
     *           Typical uses for contexts:
     *           1) You are using Vizier to tune a server for best performance, but there's
     *           a strong weekly cycle.  The context specifies the day-of-week.
     *           This allows Tuesday to generalize from Wednesday without assuming that
     *           everything is identical.
     *           2) Imagine you're optimizing some medical treatment for people.
     *           As they walk in the door, you know certain facts about them
     *           (e.g. sex, weight, height, blood-pressure).  Put that information in the
     *           context, and Vizier will adapt its suggestions to the patient.
     *           3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
     *           conditions as contexts, and Vizier will generalize between "A" and "B"
     *           conditions.  If they are similar, this will allow Vizier to converge
     *           to the optimum faster than if "A" and "B" were separate Studies.
     *           NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
     *           CreateTrial() RPC; that's the asynchronous option where you don't need a
     *           close association between contexts and suggestions.
     *
     *           NOTE: All the Parameters you set in a context MUST be defined in the
     *           Study.
     *           NOTE: You must supply 0 or $suggestion_count contexts.
     *           If you don't supply any contexts, Vizier will make suggestions
     *           from the full search space specified in the StudySpec; if you supply
     *           a full set of context, each suggestion will match the corresponding
     *           context.
     *           NOTE: A Context with no features set matches anything, and allows
     *           suggestions from the full search space.
     *           NOTE: Contexts MUST lie within the search space specified in the
     *           StudySpec.  It's an error if they don't.
     *           NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
     *           new suggestions are generated.
     *           NOTE: Generation of suggestions involves a match between a Context and
     *           (optionally) a REQUESTED trial; if that match is not fully specified, a
     *           suggestion will be geneated in the merged subspace.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function suggestTrials(
        $parent,
        $suggestionCount,
        $clientId,
        array $optionalArgs = []
    ) {
        $request = new SuggestTrialsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSuggestionCount($suggestionCount);
        $request->setClientId($clientId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['contexts'])) {
            $request->setContexts($optionalArgs['contexts']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'SuggestTrials',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $response = $vizierServiceClient->getLocation();
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $vizierServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vizierServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $vizierServiceClient->getIamPolicy($resource);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $vizierServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $vizierServiceClient = new VizierServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $vizierServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $vizierServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
