<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v2/resource.proto

namespace Google\Cloud\SecurityCenter\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * GCP metadata associated with the resource, only applicable if the finding's
 * cloud provider is Google Cloud Platform.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v2.GcpMetadata</code>
 */
class GcpMetadata extends \Google\Protobuf\Internal\Message
{
    /**
     * The full resource name of project that the resource belongs to.
     *
     * Generated from protobuf field <code>string project = 1;</code>
     */
    private $project = '';
    /**
     * The project ID that the resource belongs to.
     *
     * Generated from protobuf field <code>string project_display_name = 2;</code>
     */
    private $project_display_name = '';
    /**
     * The full resource name of resource's parent.
     *
     * Generated from protobuf field <code>string parent = 3;</code>
     */
    private $parent = '';
    /**
     * The human readable name of resource's parent.
     *
     * Generated from protobuf field <code>string parent_display_name = 4;</code>
     */
    private $parent_display_name = '';
    /**
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v2.Folder folders = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $folders;
    /**
     * The name of the organization that the resource belongs to.
     *
     * Generated from protobuf field <code>string organization = 6;</code>
     */
    private $organization = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $project
     *           The full resource name of project that the resource belongs to.
     *     @type string $project_display_name
     *           The project ID that the resource belongs to.
     *     @type string $parent
     *           The full resource name of resource's parent.
     *     @type string $parent_display_name
     *           The human readable name of resource's parent.
     *     @type array<\Google\Cloud\SecurityCenter\V2\Folder>|\Google\Protobuf\Internal\RepeatedField $folders
     *           Output only. Contains a Folder message for each folder in the assets
     *           ancestry. The first folder is the deepest nested folder, and the last
     *           folder is the folder directly under the Organization.
     *     @type string $organization
     *           The name of the organization that the resource belongs to.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V2\Resource::initOnce();
        parent::__construct($data);
    }

    /**
     * The full resource name of project that the resource belongs to.
     *
     * Generated from protobuf field <code>string project = 1;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * The full resource name of project that the resource belongs to.
     *
     * Generated from protobuf field <code>string project = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * The project ID that the resource belongs to.
     *
     * Generated from protobuf field <code>string project_display_name = 2;</code>
     * @return string
     */
    public function getProjectDisplayName()
    {
        return $this->project_display_name;
    }

    /**
     * The project ID that the resource belongs to.
     *
     * Generated from protobuf field <code>string project_display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_display_name = $var;

        return $this;
    }

    /**
     * The full resource name of resource's parent.
     *
     * Generated from protobuf field <code>string parent = 3;</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * The full resource name of resource's parent.
     *
     * Generated from protobuf field <code>string parent = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The human readable name of resource's parent.
     *
     * Generated from protobuf field <code>string parent_display_name = 4;</code>
     * @return string
     */
    public function getParentDisplayName()
    {
        return $this->parent_display_name;
    }

    /**
     * The human readable name of resource's parent.
     *
     * Generated from protobuf field <code>string parent_display_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setParentDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent_display_name = $var;

        return $this;
    }

    /**
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v2.Folder folders = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFolders()
    {
        return $this->folders;
    }

    /**
     * Output only. Contains a Folder message for each folder in the assets
     * ancestry. The first folder is the deepest nested folder, and the last
     * folder is the folder directly under the Organization.
     *
     * Generated from protobuf field <code>repeated .google.cloud.securitycenter.v2.Folder folders = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\SecurityCenter\V2\Folder>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFolders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\SecurityCenter\V2\Folder::class);
        $this->folders = $arr;

        return $this;
    }

    /**
     * The name of the organization that the resource belongs to.
     *
     * Generated from protobuf field <code>string organization = 6;</code>
     * @return string
     */
    public function getOrganization()
    {
        return $this->organization;
    }

    /**
     * The name of the organization that the resource belongs to.
     *
     * Generated from protobuf field <code>string organization = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setOrganization($var)
    {
        GPBUtil::checkString($var, True);
        $this->organization = $var;

        return $this;
    }

}

