<?php
/*
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/privacy/dlp/v2/dlp.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dlp\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dlp\V2\ActivateJobTriggerRequest;
use Google\Cloud\Dlp\V2\ByteContentItem;
use Google\Cloud\Dlp\V2\CancelDlpJobRequest;
use Google\Cloud\Dlp\V2\ColumnDataProfile;
use Google\Cloud\Dlp\V2\Connection;
use Google\Cloud\Dlp\V2\ContentItem;
use Google\Cloud\Dlp\V2\CreateConnectionRequest;
use Google\Cloud\Dlp\V2\CreateDeidentifyTemplateRequest;
use Google\Cloud\Dlp\V2\CreateDiscoveryConfigRequest;
use Google\Cloud\Dlp\V2\CreateDlpJobRequest;
use Google\Cloud\Dlp\V2\CreateInspectTemplateRequest;
use Google\Cloud\Dlp\V2\CreateJobTriggerRequest;
use Google\Cloud\Dlp\V2\CreateStoredInfoTypeRequest;
use Google\Cloud\Dlp\V2\DeidentifyConfig;
use Google\Cloud\Dlp\V2\DeidentifyContentRequest;
use Google\Cloud\Dlp\V2\DeidentifyContentResponse;
use Google\Cloud\Dlp\V2\DeidentifyTemplate;
use Google\Cloud\Dlp\V2\DeleteConnectionRequest;
use Google\Cloud\Dlp\V2\DeleteDeidentifyTemplateRequest;
use Google\Cloud\Dlp\V2\DeleteDiscoveryConfigRequest;
use Google\Cloud\Dlp\V2\DeleteDlpJobRequest;
use Google\Cloud\Dlp\V2\DeleteFileStoreDataProfileRequest;
use Google\Cloud\Dlp\V2\DeleteInspectTemplateRequest;
use Google\Cloud\Dlp\V2\DeleteJobTriggerRequest;
use Google\Cloud\Dlp\V2\DeleteStoredInfoTypeRequest;
use Google\Cloud\Dlp\V2\DeleteTableDataProfileRequest;
use Google\Cloud\Dlp\V2\DiscoveryConfig;
use Google\Cloud\Dlp\V2\DlpJob;
use Google\Cloud\Dlp\V2\DlpJobType;
use Google\Cloud\Dlp\V2\FileStoreDataProfile;
use Google\Cloud\Dlp\V2\FinishDlpJobRequest;
use Google\Cloud\Dlp\V2\GetColumnDataProfileRequest;
use Google\Cloud\Dlp\V2\GetConnectionRequest;
use Google\Cloud\Dlp\V2\GetDeidentifyTemplateRequest;
use Google\Cloud\Dlp\V2\GetDiscoveryConfigRequest;
use Google\Cloud\Dlp\V2\GetDlpJobRequest;
use Google\Cloud\Dlp\V2\GetFileStoreDataProfileRequest;
use Google\Cloud\Dlp\V2\GetInspectTemplateRequest;
use Google\Cloud\Dlp\V2\GetJobTriggerRequest;
use Google\Cloud\Dlp\V2\GetProjectDataProfileRequest;
use Google\Cloud\Dlp\V2\GetStoredInfoTypeRequest;
use Google\Cloud\Dlp\V2\GetTableDataProfileRequest;
use Google\Cloud\Dlp\V2\HybridContentItem;
use Google\Cloud\Dlp\V2\HybridInspectDlpJobRequest;
use Google\Cloud\Dlp\V2\HybridInspectJobTriggerRequest;
use Google\Cloud\Dlp\V2\HybridInspectResponse;
use Google\Cloud\Dlp\V2\InspectConfig;
use Google\Cloud\Dlp\V2\InspectContentRequest;
use Google\Cloud\Dlp\V2\InspectContentResponse;
use Google\Cloud\Dlp\V2\InspectJobConfig;
use Google\Cloud\Dlp\V2\InspectTemplate;
use Google\Cloud\Dlp\V2\JobTrigger;
use Google\Cloud\Dlp\V2\ListColumnDataProfilesRequest;
use Google\Cloud\Dlp\V2\ListColumnDataProfilesResponse;
use Google\Cloud\Dlp\V2\ListConnectionsRequest;
use Google\Cloud\Dlp\V2\ListConnectionsResponse;
use Google\Cloud\Dlp\V2\ListDeidentifyTemplatesRequest;
use Google\Cloud\Dlp\V2\ListDeidentifyTemplatesResponse;
use Google\Cloud\Dlp\V2\ListDiscoveryConfigsRequest;
use Google\Cloud\Dlp\V2\ListDiscoveryConfigsResponse;
use Google\Cloud\Dlp\V2\ListDlpJobsRequest;
use Google\Cloud\Dlp\V2\ListDlpJobsResponse;
use Google\Cloud\Dlp\V2\ListFileStoreDataProfilesRequest;
use Google\Cloud\Dlp\V2\ListFileStoreDataProfilesResponse;
use Google\Cloud\Dlp\V2\ListInfoTypesRequest;
use Google\Cloud\Dlp\V2\ListInfoTypesResponse;
use Google\Cloud\Dlp\V2\ListInspectTemplatesRequest;
use Google\Cloud\Dlp\V2\ListInspectTemplatesResponse;
use Google\Cloud\Dlp\V2\ListJobTriggersRequest;
use Google\Cloud\Dlp\V2\ListJobTriggersResponse;
use Google\Cloud\Dlp\V2\ListProjectDataProfilesRequest;
use Google\Cloud\Dlp\V2\ListProjectDataProfilesResponse;
use Google\Cloud\Dlp\V2\ListStoredInfoTypesRequest;
use Google\Cloud\Dlp\V2\ListStoredInfoTypesResponse;
use Google\Cloud\Dlp\V2\ListTableDataProfilesRequest;
use Google\Cloud\Dlp\V2\ListTableDataProfilesResponse;
use Google\Cloud\Dlp\V2\ProjectDataProfile;
use Google\Cloud\Dlp\V2\RedactImageRequest;
use Google\Cloud\Dlp\V2\RedactImageRequest\ImageRedactionConfig;
use Google\Cloud\Dlp\V2\RedactImageResponse;
use Google\Cloud\Dlp\V2\ReidentifyContentRequest;
use Google\Cloud\Dlp\V2\ReidentifyContentResponse;
use Google\Cloud\Dlp\V2\RiskAnalysisJobConfig;
use Google\Cloud\Dlp\V2\SearchConnectionsRequest;
use Google\Cloud\Dlp\V2\SearchConnectionsResponse;
use Google\Cloud\Dlp\V2\StoredInfoType;
use Google\Cloud\Dlp\V2\StoredInfoTypeConfig;
use Google\Cloud\Dlp\V2\TableDataProfile;
use Google\Cloud\Dlp\V2\UpdateConnectionRequest;
use Google\Cloud\Dlp\V2\UpdateDeidentifyTemplateRequest;
use Google\Cloud\Dlp\V2\UpdateDiscoveryConfigRequest;
use Google\Cloud\Dlp\V2\UpdateInspectTemplateRequest;
use Google\Cloud\Dlp\V2\UpdateJobTriggerRequest;
use Google\Cloud\Dlp\V2\UpdateStoredInfoTypeRequest;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: The Cloud Data Loss Prevention (DLP) API is a service that allows clients
 * to detect the presence of Personally Identifiable Information (PII) and other
 * privacy-sensitive data in user-supplied, unstructured data streams, like text
 * blocks or images.
 * The service also includes methods for sensitive data redaction and
 * scheduling of data scans on Google Cloud Platform based data sets.
 *
 * To learn more about concepts and find how-to guides see
 * https://cloud.google.com/sensitive-data-protection/docs/.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $dlpServiceClient = new DlpServiceClient();
 * try {
 *     $formattedName = $dlpServiceClient->jobTriggerName('[PROJECT]', '[JOB_TRIGGER]');
 *     $response = $dlpServiceClient->activateJobTrigger($formattedName);
 * } finally {
 *     $dlpServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\Dlp\V2\Client\DlpServiceClient}.
 */
class DlpServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.privacy.dlp.v2.DlpService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'dlp.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dlp.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $columnDataProfileNameTemplate;

    private static $connectionNameTemplate;

    private static $deidentifyTemplateNameTemplate;

    private static $discoveryConfigNameTemplate;

    private static $dlpJobNameTemplate;

    private static $fileStoreDataProfileNameTemplate;

    private static $inspectTemplateNameTemplate;

    private static $jobTriggerNameTemplate;

    private static $locationNameTemplate;

    private static $organizationNameTemplate;

    private static $organizationDeidentifyTemplateNameTemplate;

    private static $organizationInspectTemplateNameTemplate;

    private static $organizationLocationNameTemplate;

    private static $organizationLocationColumnDataProfileNameTemplate;

    private static $organizationLocationConnectionNameTemplate;

    private static $organizationLocationDeidentifyTemplateNameTemplate;

    private static $organizationLocationFileStoreDataProfileNameTemplate;

    private static $organizationLocationInspectTemplateNameTemplate;

    private static $organizationLocationProjectDataProfileNameTemplate;

    private static $organizationLocationStoredInfoTypeNameTemplate;

    private static $organizationLocationTableDataProfileNameTemplate;

    private static $organizationStoredInfoTypeNameTemplate;

    private static $projectNameTemplate;

    private static $projectDataProfileNameTemplate;

    private static $projectDeidentifyTemplateNameTemplate;

    private static $projectDlpJobNameTemplate;

    private static $projectInspectTemplateNameTemplate;

    private static $projectJobTriggerNameTemplate;

    private static $projectLocationColumnDataProfileNameTemplate;

    private static $projectLocationConnectionNameTemplate;

    private static $projectLocationDeidentifyTemplateNameTemplate;

    private static $projectLocationDlpJobNameTemplate;

    private static $projectLocationFileStoreDataProfileNameTemplate;

    private static $projectLocationInspectTemplateNameTemplate;

    private static $projectLocationJobTriggerNameTemplate;

    private static $projectLocationProjectDataProfileNameTemplate;

    private static $projectLocationStoredInfoTypeNameTemplate;

    private static $projectLocationTableDataProfileNameTemplate;

    private static $projectStoredInfoTypeNameTemplate;

    private static $storedInfoTypeNameTemplate;

    private static $tableDataProfileNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/dlp_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/dlp_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/dlp_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/dlp_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getColumnDataProfileNameTemplate()
    {
        if (self::$columnDataProfileNameTemplate == null) {
            self::$columnDataProfileNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/columnDataProfiles/{column_data_profile}'
            );
        }

        return self::$columnDataProfileNameTemplate;
    }

    private static function getConnectionNameTemplate()
    {
        if (self::$connectionNameTemplate == null) {
            self::$connectionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/connections/{connection}'
            );
        }

        return self::$connectionNameTemplate;
    }

    private static function getDeidentifyTemplateNameTemplate()
    {
        if (self::$deidentifyTemplateNameTemplate == null) {
            self::$deidentifyTemplateNameTemplate = new PathTemplate(
                'organizations/{organization}/deidentifyTemplates/{deidentify_template}'
            );
        }

        return self::$deidentifyTemplateNameTemplate;
    }

    private static function getDiscoveryConfigNameTemplate()
    {
        if (self::$discoveryConfigNameTemplate == null) {
            self::$discoveryConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/discoveryConfigs/{discovery_config}'
            );
        }

        return self::$discoveryConfigNameTemplate;
    }

    private static function getDlpJobNameTemplate()
    {
        if (self::$dlpJobNameTemplate == null) {
            self::$dlpJobNameTemplate = new PathTemplate(
                'projects/{project}/dlpJobs/{dlp_job}'
            );
        }

        return self::$dlpJobNameTemplate;
    }

    private static function getFileStoreDataProfileNameTemplate()
    {
        if (self::$fileStoreDataProfileNameTemplate == null) {
            self::$fileStoreDataProfileNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}'
            );
        }

        return self::$fileStoreDataProfileNameTemplate;
    }

    private static function getInspectTemplateNameTemplate()
    {
        if (self::$inspectTemplateNameTemplate == null) {
            self::$inspectTemplateNameTemplate = new PathTemplate(
                'organizations/{organization}/inspectTemplates/{inspect_template}'
            );
        }

        return self::$inspectTemplateNameTemplate;
    }

    private static function getJobTriggerNameTemplate()
    {
        if (self::$jobTriggerNameTemplate == null) {
            self::$jobTriggerNameTemplate = new PathTemplate(
                'projects/{project}/jobTriggers/{job_trigger}'
            );
        }

        return self::$jobTriggerNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getOrganizationNameTemplate()
    {
        if (self::$organizationNameTemplate == null) {
            self::$organizationNameTemplate = new PathTemplate(
                'organizations/{organization}'
            );
        }

        return self::$organizationNameTemplate;
    }

    private static function getOrganizationDeidentifyTemplateNameTemplate()
    {
        if (self::$organizationDeidentifyTemplateNameTemplate == null) {
            self::$organizationDeidentifyTemplateNameTemplate = new PathTemplate(
                'organizations/{organization}/deidentifyTemplates/{deidentify_template}'
            );
        }

        return self::$organizationDeidentifyTemplateNameTemplate;
    }

    private static function getOrganizationInspectTemplateNameTemplate()
    {
        if (self::$organizationInspectTemplateNameTemplate == null) {
            self::$organizationInspectTemplateNameTemplate = new PathTemplate(
                'organizations/{organization}/inspectTemplates/{inspect_template}'
            );
        }

        return self::$organizationInspectTemplateNameTemplate;
    }

    private static function getOrganizationLocationNameTemplate()
    {
        if (self::$organizationLocationNameTemplate == null) {
            self::$organizationLocationNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}'
            );
        }

        return self::$organizationLocationNameTemplate;
    }

    private static function getOrganizationLocationColumnDataProfileNameTemplate()
    {
        if (self::$organizationLocationColumnDataProfileNameTemplate == null) {
            self::$organizationLocationColumnDataProfileNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/columnDataProfiles/{column_data_profile}'
            );
        }

        return self::$organizationLocationColumnDataProfileNameTemplate;
    }

    private static function getOrganizationLocationConnectionNameTemplate()
    {
        if (self::$organizationLocationConnectionNameTemplate == null) {
            self::$organizationLocationConnectionNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/connections/{connection}'
            );
        }

        return self::$organizationLocationConnectionNameTemplate;
    }

    private static function getOrganizationLocationDeidentifyTemplateNameTemplate()
    {
        if (self::$organizationLocationDeidentifyTemplateNameTemplate == null) {
            self::$organizationLocationDeidentifyTemplateNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/deidentifyTemplates/{deidentify_template}'
            );
        }

        return self::$organizationLocationDeidentifyTemplateNameTemplate;
    }

    private static function getOrganizationLocationFileStoreDataProfileNameTemplate()
    {
        if (
            self::$organizationLocationFileStoreDataProfileNameTemplate == null
        ) {
            self::$organizationLocationFileStoreDataProfileNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}'
            );
        }

        return self::$organizationLocationFileStoreDataProfileNameTemplate;
    }

    private static function getOrganizationLocationInspectTemplateNameTemplate()
    {
        if (self::$organizationLocationInspectTemplateNameTemplate == null) {
            self::$organizationLocationInspectTemplateNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/inspectTemplates/{inspect_template}'
            );
        }

        return self::$organizationLocationInspectTemplateNameTemplate;
    }

    private static function getOrganizationLocationProjectDataProfileNameTemplate()
    {
        if (self::$organizationLocationProjectDataProfileNameTemplate == null) {
            self::$organizationLocationProjectDataProfileNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/projectDataProfiles/{project_data_profile}'
            );
        }

        return self::$organizationLocationProjectDataProfileNameTemplate;
    }

    private static function getOrganizationLocationStoredInfoTypeNameTemplate()
    {
        if (self::$organizationLocationStoredInfoTypeNameTemplate == null) {
            self::$organizationLocationStoredInfoTypeNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/storedInfoTypes/{stored_info_type}'
            );
        }

        return self::$organizationLocationStoredInfoTypeNameTemplate;
    }

    private static function getOrganizationLocationTableDataProfileNameTemplate()
    {
        if (self::$organizationLocationTableDataProfileNameTemplate == null) {
            self::$organizationLocationTableDataProfileNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/tableDataProfiles/{table_data_profile}'
            );
        }

        return self::$organizationLocationTableDataProfileNameTemplate;
    }

    private static function getOrganizationStoredInfoTypeNameTemplate()
    {
        if (self::$organizationStoredInfoTypeNameTemplate == null) {
            self::$organizationStoredInfoTypeNameTemplate = new PathTemplate(
                'organizations/{organization}/storedInfoTypes/{stored_info_type}'
            );
        }

        return self::$organizationStoredInfoTypeNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getProjectDataProfileNameTemplate()
    {
        if (self::$projectDataProfileNameTemplate == null) {
            self::$projectDataProfileNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/projectDataProfiles/{project_data_profile}'
            );
        }

        return self::$projectDataProfileNameTemplate;
    }

    private static function getProjectDeidentifyTemplateNameTemplate()
    {
        if (self::$projectDeidentifyTemplateNameTemplate == null) {
            self::$projectDeidentifyTemplateNameTemplate = new PathTemplate(
                'projects/{project}/deidentifyTemplates/{deidentify_template}'
            );
        }

        return self::$projectDeidentifyTemplateNameTemplate;
    }

    private static function getProjectDlpJobNameTemplate()
    {
        if (self::$projectDlpJobNameTemplate == null) {
            self::$projectDlpJobNameTemplate = new PathTemplate(
                'projects/{project}/dlpJobs/{dlp_job}'
            );
        }

        return self::$projectDlpJobNameTemplate;
    }

    private static function getProjectInspectTemplateNameTemplate()
    {
        if (self::$projectInspectTemplateNameTemplate == null) {
            self::$projectInspectTemplateNameTemplate = new PathTemplate(
                'projects/{project}/inspectTemplates/{inspect_template}'
            );
        }

        return self::$projectInspectTemplateNameTemplate;
    }

    private static function getProjectJobTriggerNameTemplate()
    {
        if (self::$projectJobTriggerNameTemplate == null) {
            self::$projectJobTriggerNameTemplate = new PathTemplate(
                'projects/{project}/jobTriggers/{job_trigger}'
            );
        }

        return self::$projectJobTriggerNameTemplate;
    }

    private static function getProjectLocationColumnDataProfileNameTemplate()
    {
        if (self::$projectLocationColumnDataProfileNameTemplate == null) {
            self::$projectLocationColumnDataProfileNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/columnDataProfiles/{column_data_profile}'
            );
        }

        return self::$projectLocationColumnDataProfileNameTemplate;
    }

    private static function getProjectLocationConnectionNameTemplate()
    {
        if (self::$projectLocationConnectionNameTemplate == null) {
            self::$projectLocationConnectionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/connections/{connection}'
            );
        }

        return self::$projectLocationConnectionNameTemplate;
    }

    private static function getProjectLocationDeidentifyTemplateNameTemplate()
    {
        if (self::$projectLocationDeidentifyTemplateNameTemplate == null) {
            self::$projectLocationDeidentifyTemplateNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}'
            );
        }

        return self::$projectLocationDeidentifyTemplateNameTemplate;
    }

    private static function getProjectLocationDlpJobNameTemplate()
    {
        if (self::$projectLocationDlpJobNameTemplate == null) {
            self::$projectLocationDlpJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/dlpJobs/{dlp_job}'
            );
        }

        return self::$projectLocationDlpJobNameTemplate;
    }

    private static function getProjectLocationFileStoreDataProfileNameTemplate()
    {
        if (self::$projectLocationFileStoreDataProfileNameTemplate == null) {
            self::$projectLocationFileStoreDataProfileNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}'
            );
        }

        return self::$projectLocationFileStoreDataProfileNameTemplate;
    }

    private static function getProjectLocationInspectTemplateNameTemplate()
    {
        if (self::$projectLocationInspectTemplateNameTemplate == null) {
            self::$projectLocationInspectTemplateNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/inspectTemplates/{inspect_template}'
            );
        }

        return self::$projectLocationInspectTemplateNameTemplate;
    }

    private static function getProjectLocationJobTriggerNameTemplate()
    {
        if (self::$projectLocationJobTriggerNameTemplate == null) {
            self::$projectLocationJobTriggerNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/jobTriggers/{job_trigger}'
            );
        }

        return self::$projectLocationJobTriggerNameTemplate;
    }

    private static function getProjectLocationProjectDataProfileNameTemplate()
    {
        if (self::$projectLocationProjectDataProfileNameTemplate == null) {
            self::$projectLocationProjectDataProfileNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/projectDataProfiles/{project_data_profile}'
            );
        }

        return self::$projectLocationProjectDataProfileNameTemplate;
    }

    private static function getProjectLocationStoredInfoTypeNameTemplate()
    {
        if (self::$projectLocationStoredInfoTypeNameTemplate == null) {
            self::$projectLocationStoredInfoTypeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/storedInfoTypes/{stored_info_type}'
            );
        }

        return self::$projectLocationStoredInfoTypeNameTemplate;
    }

    private static function getProjectLocationTableDataProfileNameTemplate()
    {
        if (self::$projectLocationTableDataProfileNameTemplate == null) {
            self::$projectLocationTableDataProfileNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/tableDataProfiles/{table_data_profile}'
            );
        }

        return self::$projectLocationTableDataProfileNameTemplate;
    }

    private static function getProjectStoredInfoTypeNameTemplate()
    {
        if (self::$projectStoredInfoTypeNameTemplate == null) {
            self::$projectStoredInfoTypeNameTemplate = new PathTemplate(
                'projects/{project}/storedInfoTypes/{stored_info_type}'
            );
        }

        return self::$projectStoredInfoTypeNameTemplate;
    }

    private static function getStoredInfoTypeNameTemplate()
    {
        if (self::$storedInfoTypeNameTemplate == null) {
            self::$storedInfoTypeNameTemplate = new PathTemplate(
                'organizations/{organization}/storedInfoTypes/{stored_info_type}'
            );
        }

        return self::$storedInfoTypeNameTemplate;
    }

    private static function getTableDataProfileNameTemplate()
    {
        if (self::$tableDataProfileNameTemplate == null) {
            self::$tableDataProfileNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/tableDataProfiles/{table_data_profile}'
            );
        }

        return self::$tableDataProfileNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'columnDataProfile' => self::getColumnDataProfileNameTemplate(),
                'connection' => self::getConnectionNameTemplate(),
                'deidentifyTemplate' => self::getDeidentifyTemplateNameTemplate(),
                'discoveryConfig' => self::getDiscoveryConfigNameTemplate(),
                'dlpJob' => self::getDlpJobNameTemplate(),
                'fileStoreDataProfile' => self::getFileStoreDataProfileNameTemplate(),
                'inspectTemplate' => self::getInspectTemplateNameTemplate(),
                'jobTrigger' => self::getJobTriggerNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'organization' => self::getOrganizationNameTemplate(),
                'organizationDeidentifyTemplate' => self::getOrganizationDeidentifyTemplateNameTemplate(),
                'organizationInspectTemplate' => self::getOrganizationInspectTemplateNameTemplate(),
                'organizationLocation' => self::getOrganizationLocationNameTemplate(),
                'organizationLocationColumnDataProfile' => self::getOrganizationLocationColumnDataProfileNameTemplate(),
                'organizationLocationConnection' => self::getOrganizationLocationConnectionNameTemplate(),
                'organizationLocationDeidentifyTemplate' => self::getOrganizationLocationDeidentifyTemplateNameTemplate(),
                'organizationLocationFileStoreDataProfile' => self::getOrganizationLocationFileStoreDataProfileNameTemplate(),
                'organizationLocationInspectTemplate' => self::getOrganizationLocationInspectTemplateNameTemplate(),
                'organizationLocationProjectDataProfile' => self::getOrganizationLocationProjectDataProfileNameTemplate(),
                'organizationLocationStoredInfoType' => self::getOrganizationLocationStoredInfoTypeNameTemplate(),
                'organizationLocationTableDataProfile' => self::getOrganizationLocationTableDataProfileNameTemplate(),
                'organizationStoredInfoType' => self::getOrganizationStoredInfoTypeNameTemplate(),
                'project' => self::getProjectNameTemplate(),
                'projectDataProfile' => self::getProjectDataProfileNameTemplate(),
                'projectDeidentifyTemplate' => self::getProjectDeidentifyTemplateNameTemplate(),
                'projectDlpJob' => self::getProjectDlpJobNameTemplate(),
                'projectInspectTemplate' => self::getProjectInspectTemplateNameTemplate(),
                'projectJobTrigger' => self::getProjectJobTriggerNameTemplate(),
                'projectLocationColumnDataProfile' => self::getProjectLocationColumnDataProfileNameTemplate(),
                'projectLocationConnection' => self::getProjectLocationConnectionNameTemplate(),
                'projectLocationDeidentifyTemplate' => self::getProjectLocationDeidentifyTemplateNameTemplate(),
                'projectLocationDlpJob' => self::getProjectLocationDlpJobNameTemplate(),
                'projectLocationFileStoreDataProfile' => self::getProjectLocationFileStoreDataProfileNameTemplate(),
                'projectLocationInspectTemplate' => self::getProjectLocationInspectTemplateNameTemplate(),
                'projectLocationJobTrigger' => self::getProjectLocationJobTriggerNameTemplate(),
                'projectLocationProjectDataProfile' => self::getProjectLocationProjectDataProfileNameTemplate(),
                'projectLocationStoredInfoType' => self::getProjectLocationStoredInfoTypeNameTemplate(),
                'projectLocationTableDataProfile' => self::getProjectLocationTableDataProfileNameTemplate(),
                'projectStoredInfoType' => self::getProjectStoredInfoTypeNameTemplate(),
                'storedInfoType' => self::getStoredInfoTypeNameTemplate(),
                'tableDataProfile' => self::getTableDataProfileNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * column_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $columnDataProfile
     *
     * @return string The formatted column_data_profile resource.
     */
    public static function columnDataProfileName(
        $organization,
        $location,
        $columnDataProfile
    ) {
        return self::getColumnDataProfileNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'column_data_profile' => $columnDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a connection
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connection
     *
     * @return string The formatted connection resource.
     */
    public static function connectionName($project, $location, $connection)
    {
        return self::getConnectionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'connection' => $connection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * deidentify_template resource.
     *
     * @param string $organization
     * @param string $deidentifyTemplate
     *
     * @return string The formatted deidentify_template resource.
     */
    public static function deidentifyTemplateName(
        $organization,
        $deidentifyTemplate
    ) {
        return self::getDeidentifyTemplateNameTemplate()->render([
            'organization' => $organization,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * discovery_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $discoveryConfig
     *
     * @return string The formatted discovery_config resource.
     */
    public static function discoveryConfigName(
        $project,
        $location,
        $discoveryConfig
    ) {
        return self::getDiscoveryConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'discovery_config' => $discoveryConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dlp_job
     * resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted dlp_job resource.
     */
    public static function dlpJobName($project, $dlpJob)
    {
        return self::getDlpJobNameTemplate()->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * file_store_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $fileStoreDataProfile
     *
     * @return string The formatted file_store_data_profile resource.
     */
    public static function fileStoreDataProfileName(
        $organization,
        $location,
        $fileStoreDataProfile
    ) {
        return self::getFileStoreDataProfileNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'file_store_data_profile' => $fileStoreDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * inspect_template resource.
     *
     * @param string $organization
     * @param string $inspectTemplate
     *
     * @return string The formatted inspect_template resource.
     */
    public static function inspectTemplateName($organization, $inspectTemplate)
    {
        return self::getInspectTemplateNameTemplate()->render([
            'organization' => $organization,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job_trigger
     * resource.
     *
     * @param string $project
     * @param string $jobTrigger
     *
     * @return string The formatted job_trigger resource.
     */
    public static function jobTriggerName($project, $jobTrigger)
    {
        return self::getJobTriggerNameTemplate()->render([
            'project' => $project,
            'job_trigger' => $jobTrigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName($organization)
    {
        return self::getOrganizationNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_deidentify_template resource.
     *
     * @param string $organization
     * @param string $deidentifyTemplate
     *
     * @return string The formatted organization_deidentify_template resource.
     */
    public static function organizationDeidentifyTemplateName(
        $organization,
        $deidentifyTemplate
    ) {
        return self::getOrganizationDeidentifyTemplateNameTemplate()->render([
            'organization' => $organization,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_inspect_template resource.
     *
     * @param string $organization
     * @param string $inspectTemplate
     *
     * @return string The formatted organization_inspect_template resource.
     */
    public static function organizationInspectTemplateName(
        $organization,
        $inspectTemplate
    ) {
        return self::getOrganizationInspectTemplateNameTemplate()->render([
            'organization' => $organization,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName($organization, $location)
    {
        return self::getOrganizationLocationNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_column_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $columnDataProfile
     *
     * @return string The formatted organization_location_column_data_profile resource.
     */
    public static function organizationLocationColumnDataProfileName(
        $organization,
        $location,
        $columnDataProfile
    ) {
        return self::getOrganizationLocationColumnDataProfileNameTemplate()->render(
            [
                'organization' => $organization,
                'location' => $location,
                'column_data_profile' => $columnDataProfile,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_connection resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $connection
     *
     * @return string The formatted organization_location_connection resource.
     */
    public static function organizationLocationConnectionName(
        $organization,
        $location,
        $connection
    ) {
        return self::getOrganizationLocationConnectionNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'connection' => $connection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_deidentify_template resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $deidentifyTemplate
     *
     * @return string The formatted organization_location_deidentify_template resource.
     */
    public static function organizationLocationDeidentifyTemplateName(
        $organization,
        $location,
        $deidentifyTemplate
    ) {
        return self::getOrganizationLocationDeidentifyTemplateNameTemplate()->render(
            [
                'organization' => $organization,
                'location' => $location,
                'deidentify_template' => $deidentifyTemplate,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_file_store_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $fileStoreDataProfile
     *
     * @return string The formatted organization_location_file_store_data_profile resource.
     */
    public static function organizationLocationFileStoreDataProfileName(
        $organization,
        $location,
        $fileStoreDataProfile
    ) {
        return self::getOrganizationLocationFileStoreDataProfileNameTemplate()->render(
            [
                'organization' => $organization,
                'location' => $location,
                'file_store_data_profile' => $fileStoreDataProfile,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_inspect_template resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $inspectTemplate
     *
     * @return string The formatted organization_location_inspect_template resource.
     */
    public static function organizationLocationInspectTemplateName(
        $organization,
        $location,
        $inspectTemplate
    ) {
        return self::getOrganizationLocationInspectTemplateNameTemplate()->render(
            [
                'organization' => $organization,
                'location' => $location,
                'inspect_template' => $inspectTemplate,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_project_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $projectDataProfile
     *
     * @return string The formatted organization_location_project_data_profile resource.
     */
    public static function organizationLocationProjectDataProfileName(
        $organization,
        $location,
        $projectDataProfile
    ) {
        return self::getOrganizationLocationProjectDataProfileNameTemplate()->render(
            [
                'organization' => $organization,
                'location' => $location,
                'project_data_profile' => $projectDataProfile,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_stored_info_type resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $storedInfoType
     *
     * @return string The formatted organization_location_stored_info_type resource.
     */
    public static function organizationLocationStoredInfoTypeName(
        $organization,
        $location,
        $storedInfoType
    ) {
        return self::getOrganizationLocationStoredInfoTypeNameTemplate()->render(
            [
                'organization' => $organization,
                'location' => $location,
                'stored_info_type' => $storedInfoType,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_table_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $tableDataProfile
     *
     * @return string The formatted organization_location_table_data_profile resource.
     */
    public static function organizationLocationTableDataProfileName(
        $organization,
        $location,
        $tableDataProfile
    ) {
        return self::getOrganizationLocationTableDataProfileNameTemplate()->render(
            [
                'organization' => $organization,
                'location' => $location,
                'table_data_profile' => $tableDataProfile,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_stored_info_type resource.
     *
     * @param string $organization
     * @param string $storedInfoType
     *
     * @return string The formatted organization_stored_info_type resource.
     */
    public static function organizationStoredInfoTypeName(
        $organization,
        $storedInfoType
    ) {
        return self::getOrganizationStoredInfoTypeNameTemplate()->render([
            'organization' => $organization,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $projectDataProfile
     *
     * @return string The formatted project_data_profile resource.
     */
    public static function projectDataProfileName(
        $organization,
        $location,
        $projectDataProfile
    ) {
        return self::getProjectDataProfileNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'project_data_profile' => $projectDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_deidentify_template resource.
     *
     * @param string $project
     * @param string $deidentifyTemplate
     *
     * @return string The formatted project_deidentify_template resource.
     */
    public static function projectDeidentifyTemplateName(
        $project,
        $deidentifyTemplate
    ) {
        return self::getProjectDeidentifyTemplateNameTemplate()->render([
            'project' => $project,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_dlp_job resource.
     *
     * @param string $project
     * @param string $dlpJob
     *
     * @return string The formatted project_dlp_job resource.
     */
    public static function projectDlpJobName($project, $dlpJob)
    {
        return self::getProjectDlpJobNameTemplate()->render([
            'project' => $project,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_inspect_template resource.
     *
     * @param string $project
     * @param string $inspectTemplate
     *
     * @return string The formatted project_inspect_template resource.
     */
    public static function projectInspectTemplateName(
        $project,
        $inspectTemplate
    ) {
        return self::getProjectInspectTemplateNameTemplate()->render([
            'project' => $project,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_job_trigger resource.
     *
     * @param string $project
     * @param string $jobTrigger
     *
     * @return string The formatted project_job_trigger resource.
     */
    public static function projectJobTriggerName($project, $jobTrigger)
    {
        return self::getProjectJobTriggerNameTemplate()->render([
            'project' => $project,
            'job_trigger' => $jobTrigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_column_data_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $columnDataProfile
     *
     * @return string The formatted project_location_column_data_profile resource.
     */
    public static function projectLocationColumnDataProfileName(
        $project,
        $location,
        $columnDataProfile
    ) {
        return self::getProjectLocationColumnDataProfileNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'column_data_profile' => $columnDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connection
     *
     * @return string The formatted project_location_connection resource.
     */
    public static function projectLocationConnectionName(
        $project,
        $location,
        $connection
    ) {
        return self::getProjectLocationConnectionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'connection' => $connection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_deidentify_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deidentifyTemplate
     *
     * @return string The formatted project_location_deidentify_template resource.
     */
    public static function projectLocationDeidentifyTemplateName(
        $project,
        $location,
        $deidentifyTemplate
    ) {
        return self::getProjectLocationDeidentifyTemplateNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'deidentify_template' => $deidentifyTemplate,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_dlp_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dlpJob
     *
     * @return string The formatted project_location_dlp_job resource.
     */
    public static function projectLocationDlpJobName(
        $project,
        $location,
        $dlpJob
    ) {
        return self::getProjectLocationDlpJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'dlp_job' => $dlpJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_file_store_data_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $fileStoreDataProfile
     *
     * @return string The formatted project_location_file_store_data_profile resource.
     */
    public static function projectLocationFileStoreDataProfileName(
        $project,
        $location,
        $fileStoreDataProfile
    ) {
        return self::getProjectLocationFileStoreDataProfileNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'file_store_data_profile' => $fileStoreDataProfile,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_inspect_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $inspectTemplate
     *
     * @return string The formatted project_location_inspect_template resource.
     */
    public static function projectLocationInspectTemplateName(
        $project,
        $location,
        $inspectTemplate
    ) {
        return self::getProjectLocationInspectTemplateNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_job_trigger resource.
     *
     * @param string $project
     * @param string $location
     * @param string $jobTrigger
     *
     * @return string The formatted project_location_job_trigger resource.
     */
    public static function projectLocationJobTriggerName(
        $project,
        $location,
        $jobTrigger
    ) {
        return self::getProjectLocationJobTriggerNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'job_trigger' => $jobTrigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_project_data_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $projectDataProfile
     *
     * @return string The formatted project_location_project_data_profile resource.
     */
    public static function projectLocationProjectDataProfileName(
        $project,
        $location,
        $projectDataProfile
    ) {
        return self::getProjectLocationProjectDataProfileNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'project_data_profile' => $projectDataProfile,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_stored_info_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $storedInfoType
     *
     * @return string The formatted project_location_stored_info_type resource.
     */
    public static function projectLocationStoredInfoTypeName(
        $project,
        $location,
        $storedInfoType
    ) {
        return self::getProjectLocationStoredInfoTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_table_data_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tableDataProfile
     *
     * @return string The formatted project_location_table_data_profile resource.
     */
    public static function projectLocationTableDataProfileName(
        $project,
        $location,
        $tableDataProfile
    ) {
        return self::getProjectLocationTableDataProfileNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'table_data_profile' => $tableDataProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_stored_info_type resource.
     *
     * @param string $project
     * @param string $storedInfoType
     *
     * @return string The formatted project_stored_info_type resource.
     */
    public static function projectStoredInfoTypeName($project, $storedInfoType)
    {
        return self::getProjectStoredInfoTypeNameTemplate()->render([
            'project' => $project,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * stored_info_type resource.
     *
     * @param string $organization
     * @param string $storedInfoType
     *
     * @return string The formatted stored_info_type resource.
     */
    public static function storedInfoTypeName($organization, $storedInfoType)
    {
        return self::getStoredInfoTypeNameTemplate()->render([
            'organization' => $organization,
            'stored_info_type' => $storedInfoType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * table_data_profile resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $tableDataProfile
     *
     * @return string The formatted table_data_profile resource.
     */
    public static function tableDataProfileName(
        $organization,
        $location,
        $tableDataProfile
    ) {
        return self::getTableDataProfileNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'table_data_profile' => $tableDataProfile,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - columnDataProfile: organizations/{organization}/locations/{location}/columnDataProfiles/{column_data_profile}
     * - connection: projects/{project}/locations/{location}/connections/{connection}
     * - deidentifyTemplate: organizations/{organization}/deidentifyTemplates/{deidentify_template}
     * - discoveryConfig: projects/{project}/locations/{location}/discoveryConfigs/{discovery_config}
     * - dlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - fileStoreDataProfile: organizations/{organization}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}
     * - inspectTemplate: organizations/{organization}/inspectTemplates/{inspect_template}
     * - jobTrigger: projects/{project}/jobTriggers/{job_trigger}
     * - location: projects/{project}/locations/{location}
     * - organization: organizations/{organization}
     * - organizationDeidentifyTemplate: organizations/{organization}/deidentifyTemplates/{deidentify_template}
     * - organizationInspectTemplate: organizations/{organization}/inspectTemplates/{inspect_template}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationColumnDataProfile: organizations/{organization}/locations/{location}/columnDataProfiles/{column_data_profile}
     * - organizationLocationConnection: organizations/{organization}/locations/{location}/connections/{connection}
     * - organizationLocationDeidentifyTemplate: organizations/{organization}/locations/{location}/deidentifyTemplates/{deidentify_template}
     * - organizationLocationFileStoreDataProfile: organizations/{organization}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}
     * - organizationLocationInspectTemplate: organizations/{organization}/locations/{location}/inspectTemplates/{inspect_template}
     * - organizationLocationProjectDataProfile: organizations/{organization}/locations/{location}/projectDataProfiles/{project_data_profile}
     * - organizationLocationStoredInfoType: organizations/{organization}/locations/{location}/storedInfoTypes/{stored_info_type}
     * - organizationLocationTableDataProfile: organizations/{organization}/locations/{location}/tableDataProfiles/{table_data_profile}
     * - organizationStoredInfoType: organizations/{organization}/storedInfoTypes/{stored_info_type}
     * - project: projects/{project}
     * - projectDataProfile: organizations/{organization}/locations/{location}/projectDataProfiles/{project_data_profile}
     * - projectDeidentifyTemplate: projects/{project}/deidentifyTemplates/{deidentify_template}
     * - projectDlpJob: projects/{project}/dlpJobs/{dlp_job}
     * - projectInspectTemplate: projects/{project}/inspectTemplates/{inspect_template}
     * - projectJobTrigger: projects/{project}/jobTriggers/{job_trigger}
     * - projectLocationColumnDataProfile: projects/{project}/locations/{location}/columnDataProfiles/{column_data_profile}
     * - projectLocationConnection: projects/{project}/locations/{location}/connections/{connection}
     * - projectLocationDeidentifyTemplate: projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}
     * - projectLocationDlpJob: projects/{project}/locations/{location}/dlpJobs/{dlp_job}
     * - projectLocationFileStoreDataProfile: projects/{project}/locations/{location}/fileStoreDataProfiles/{file_store_data_profile}
     * - projectLocationInspectTemplate: projects/{project}/locations/{location}/inspectTemplates/{inspect_template}
     * - projectLocationJobTrigger: projects/{project}/locations/{location}/jobTriggers/{job_trigger}
     * - projectLocationProjectDataProfile: projects/{project}/locations/{location}/projectDataProfiles/{project_data_profile}
     * - projectLocationStoredInfoType: projects/{project}/locations/{location}/storedInfoTypes/{stored_info_type}
     * - projectLocationTableDataProfile: projects/{project}/locations/{location}/tableDataProfiles/{table_data_profile}
     * - projectStoredInfoType: projects/{project}/storedInfoTypes/{stored_info_type}
     * - storedInfoType: organizations/{organization}/storedInfoTypes/{stored_info_type}
     * - tableDataProfile: organizations/{organization}/locations/{location}/tableDataProfiles/{table_data_profile}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dlp.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Activate a job trigger. Causes the immediate execute of a trigger
     * instead of waiting on the trigger event to occur.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->jobTriggerName('[PROJECT]', '[JOB_TRIGGER]');
     *     $response = $dlpServiceClient->activateJobTrigger($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the trigger to activate, for example
     *                             `projects/dlp-test-project/jobTriggers/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DlpJob
     *
     * @throws ApiException if the remote call fails
     */
    public function activateJobTrigger($name, array $optionalArgs = [])
    {
        $request = new ActivateJobTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ActivateJobTrigger',
            DlpJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Starts asynchronous cancellation on a long-running DlpJob. The server
     * makes a best effort to cancel the DlpJob, but success is not
     * guaranteed.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->dlpJobName('[PROJECT]', '[DLP_JOB]');
     *     $dlpServiceClient->cancelDlpJob($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DlpJob resource to be cancelled.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function cancelDlpJob($name, array $optionalArgs = [])
    {
        $request = new CancelDlpJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CancelDlpJob',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Create a Connection to an external data source.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     $connection = new Connection();
     *     $response = $dlpServiceClient->createConnection($formattedParent, $connection);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. Parent resource name.
     *
     *                                 The format of this value varies depending on the scope of the request
     *                                 (project or organization):
     *
     *                                 + Projects scope:
     *                                 `projects/{project_id}/locations/{location_id}`
     *                                 + Organizations scope:
     *                                 `organizations/{org_id}/locations/{location_id}`
     * @param Connection $connection   Required. The connection resource.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\Connection
     *
     * @throws ApiException if the remote call fails
     */
    public function createConnection(
        $parent,
        $connection,
        array $optionalArgs = []
    ) {
        $request = new CreateConnectionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConnection($connection);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateConnection',
            Connection::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a DeidentifyTemplate for reusing frequently used configuration
     * for de-identifying content, images, and storage.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     $deidentifyTemplate = new DeidentifyTemplate();
     *     $response = $dlpServiceClient->createDeidentifyTemplate($formattedParent, $deidentifyTemplate);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string             $parent             Required. Parent resource name.
     *
     *                                               The format of this value varies depending on the scope of the request
     *                                               (project or organization) and whether you have [specified a processing
     *                                               location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                                               + Projects scope, location specified:
     *                                               `projects/{project_id}/locations/{location_id}`
     *                                               + Projects scope, no location specified (defaults to global):
     *                                               `projects/{project_id}`
     *                                               + Organizations scope, location specified:
     *                                               `organizations/{org_id}/locations/{location_id}`
     *                                               + Organizations scope, no location specified (defaults to global):
     *                                               `organizations/{org_id}`
     *
     *                                               The following example `parent` string specifies a parent project with the
     *                                               identifier `example-project`, and specifies the `europe-west3` location
     *                                               for processing data:
     *
     *                                               parent=projects/example-project/locations/europe-west3
     * @param DeidentifyTemplate $deidentifyTemplate Required. The DeidentifyTemplate to create.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type string $templateId
     *           The template id can contain uppercase and lowercase letters,
     *           numbers, and hyphens; that is, it must match the regular
     *           expression: `[a-zA-Z\d-_]+`. The maximum length is 100
     *           characters. Can be empty to allow the system to generate one.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DeidentifyTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function createDeidentifyTemplate(
        $parent,
        $deidentifyTemplate,
        array $optionalArgs = []
    ) {
        $request = new CreateDeidentifyTemplateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDeidentifyTemplate($deidentifyTemplate);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['templateId'])) {
            $request->setTemplateId($optionalArgs['templateId']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateDeidentifyTemplate',
            DeidentifyTemplate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a config for discovery to scan and profile storage.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $discoveryConfig = new DiscoveryConfig();
     *     $response = $dlpServiceClient->createDiscoveryConfig($formattedParent, $discoveryConfig);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string          $parent          Required. Parent resource name.
     *
     *                                         The format of this value varies depending on the scope of the request
     *                                         (project or organization):
     *
     *                                         + Projects scope:
     *                                         `projects/{project_id}/locations/{location_id}`
     *                                         + Organizations scope:
     *                                         `organizations/{org_id}/locations/{location_id}`
     *
     *                                         The following example `parent` string specifies a parent project with the
     *                                         identifier `example-project`, and specifies the `europe-west3` location
     *                                         for processing data:
     *
     *                                         parent=projects/example-project/locations/europe-west3
     * @param DiscoveryConfig $discoveryConfig Required. The DiscoveryConfig to create.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type string $configId
     *           The config ID can contain uppercase and lowercase letters,
     *           numbers, and hyphens; that is, it must match the regular
     *           expression: `[a-zA-Z\d-_]+`. The maximum length is 100
     *           characters. Can be empty to allow the system to generate one.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DiscoveryConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function createDiscoveryConfig(
        $parent,
        $discoveryConfig,
        array $optionalArgs = []
    ) {
        $request = new CreateDiscoveryConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDiscoveryConfig($discoveryConfig);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['configId'])) {
            $request->setConfigId($optionalArgs['configId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateDiscoveryConfig',
            DiscoveryConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a new job to inspect storage or calculate risk metrics.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
     * system will automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->projectName('[PROJECT]');
     *     $response = $dlpServiceClient->createDlpJob($formattedParent);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent resource name.
     *
     *                             The format of this value varies depending on whether you have [specified a
     *                             processing
     *                             location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                             + Projects scope, location specified:
     *                             `projects/{project_id}/locations/{location_id}`
     *                             + Projects scope, no location specified (defaults to global):
     *                             `projects/{project_id}`
     *
     *                             The following example `parent` string specifies a parent project with the
     *                             identifier `example-project`, and specifies the `europe-west3` location
     *                             for processing data:
     *
     *                             parent=projects/example-project/locations/europe-west3
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type InspectJobConfig $inspectJob The configuration details for an inspect
     *          job. Only one of $inspectJob and $riskJob may be provided.
     *           An inspection job scans a storage repository for InfoTypes.
     *     @type RiskAnalysisJobConfig $riskJob The configuration details for a risk
     *          analysis job. Only one of $inspectJob and $riskJob may be provided.
     *           A risk analysis job calculates re-identification risk metrics for a
     *           BigQuery table.
     *     @type string $jobId
     *           The job id can contain uppercase and lowercase letters,
     *           numbers, and hyphens; that is, it must match the regular
     *           expression: `[a-zA-Z\d-_]+`. The maximum length is 100
     *           characters. Can be empty to allow the system to generate one.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DlpJob
     *
     * @throws ApiException if the remote call fails
     */
    public function createDlpJob($parent, array $optionalArgs = [])
    {
        $request = new CreateDlpJobRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['inspectJob'])) {
            $request->setInspectJob($optionalArgs['inspectJob']);
        }

        if (isset($optionalArgs['riskJob'])) {
            $request->setRiskJob($optionalArgs['riskJob']);
        }

        if (isset($optionalArgs['jobId'])) {
            $request->setJobId($optionalArgs['jobId']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateDlpJob',
            DlpJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates an InspectTemplate for reusing frequently used configuration
     * for inspecting content, images, and storage.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     $inspectTemplate = new InspectTemplate();
     *     $response = $dlpServiceClient->createInspectTemplate($formattedParent, $inspectTemplate);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string          $parent          Required. Parent resource name.
     *
     *                                         The format of this value varies depending on the scope of the request
     *                                         (project or organization) and whether you have [specified a processing
     *                                         location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                                         + Projects scope, location specified:
     *                                         `projects/{project_id}/locations/{location_id}`
     *                                         + Projects scope, no location specified (defaults to global):
     *                                         `projects/{project_id}`
     *                                         + Organizations scope, location specified:
     *                                         `organizations/{org_id}/locations/{location_id}`
     *                                         + Organizations scope, no location specified (defaults to global):
     *                                         `organizations/{org_id}`
     *
     *                                         The following example `parent` string specifies a parent project with the
     *                                         identifier `example-project`, and specifies the `europe-west3` location
     *                                         for processing data:
     *
     *                                         parent=projects/example-project/locations/europe-west3
     * @param InspectTemplate $inspectTemplate Required. The InspectTemplate to create.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type string $templateId
     *           The template id can contain uppercase and lowercase letters,
     *           numbers, and hyphens; that is, it must match the regular
     *           expression: `[a-zA-Z\d-_]+`. The maximum length is 100
     *           characters. Can be empty to allow the system to generate one.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\InspectTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function createInspectTemplate(
        $parent,
        $inspectTemplate,
        array $optionalArgs = []
    ) {
        $request = new CreateInspectTemplateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setInspectTemplate($inspectTemplate);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['templateId'])) {
            $request->setTemplateId($optionalArgs['templateId']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateInspectTemplate',
            InspectTemplate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a job trigger to run DLP actions such as scanning storage for
     * sensitive information on a set schedule.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->projectName('[PROJECT]');
     *     $jobTrigger = new JobTrigger();
     *     $response = $dlpServiceClient->createJobTrigger($formattedParent, $jobTrigger);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. Parent resource name.
     *
     *                                 The format of this value varies depending on whether you have [specified a
     *                                 processing
     *                                 location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                                 + Projects scope, location specified:
     *                                 `projects/{project_id}/locations/{location_id}`
     *                                 + Projects scope, no location specified (defaults to global):
     *                                 `projects/{project_id}`
     *
     *                                 The following example `parent` string specifies a parent project with the
     *                                 identifier `example-project`, and specifies the `europe-west3` location
     *                                 for processing data:
     *
     *                                 parent=projects/example-project/locations/europe-west3
     * @param JobTrigger $jobTrigger   Required. The JobTrigger to create.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type string $triggerId
     *           The trigger id can contain uppercase and lowercase letters,
     *           numbers, and hyphens; that is, it must match the regular
     *           expression: `[a-zA-Z\d-_]+`. The maximum length is 100
     *           characters. Can be empty to allow the system to generate one.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\JobTrigger
     *
     * @throws ApiException if the remote call fails
     */
    public function createJobTrigger(
        $parent,
        $jobTrigger,
        array $optionalArgs = []
    ) {
        $request = new CreateJobTriggerRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setJobTrigger($jobTrigger);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['triggerId'])) {
            $request->setTriggerId($optionalArgs['triggerId']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateJobTrigger',
            JobTrigger::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a pre-built stored infoType to be used for inspection.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     $config = new StoredInfoTypeConfig();
     *     $response = $dlpServiceClient->createStoredInfoType($formattedParent, $config);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string               $parent       Required. Parent resource name.
     *
     *                                           The format of this value varies depending on the scope of the request
     *                                           (project or organization) and whether you have [specified a processing
     *                                           location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                                           + Projects scope, location specified:
     *                                           `projects/{project_id}/locations/{location_id}`
     *                                           + Projects scope, no location specified (defaults to global):
     *                                           `projects/{project_id}`
     *                                           + Organizations scope, location specified:
     *                                           `organizations/{org_id}/locations/{location_id}`
     *                                           + Organizations scope, no location specified (defaults to global):
     *                                           `organizations/{org_id}`
     *
     *                                           The following example `parent` string specifies a parent project with the
     *                                           identifier `example-project`, and specifies the `europe-west3` location
     *                                           for processing data:
     *
     *                                           parent=projects/example-project/locations/europe-west3
     * @param StoredInfoTypeConfig $config       Required. Configuration of the storedInfoType to create.
     * @param array                $optionalArgs {
     *     Optional.
     *
     *     @type string $storedInfoTypeId
     *           The storedInfoType ID can contain uppercase and lowercase letters,
     *           numbers, and hyphens; that is, it must match the regular
     *           expression: `[a-zA-Z\d-_]+`. The maximum length is 100
     *           characters. Can be empty to allow the system to generate one.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\StoredInfoType
     *
     * @throws ApiException if the remote call fails
     */
    public function createStoredInfoType(
        $parent,
        $config,
        array $optionalArgs = []
    ) {
        $request = new CreateStoredInfoTypeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConfig($config);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['storedInfoTypeId'])) {
            $request->setStoredInfoTypeId($optionalArgs['storedInfoTypeId']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateStoredInfoType',
            StoredInfoType::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * De-identifies potentially sensitive info from a ContentItem.
     * This method has limits on input size and output size.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/deidentify-sensitive-data
     * to learn more.
     *
     * When no InfoTypes or CustomInfoTypes are specified in this request, the
     * system will automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $response = $dlpServiceClient->deidentifyContent();
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $parent The parent resource name. Please note, unless you have
     *           authenticated using an API key this option will be required.
     *
     *           The format of this value varies depending on whether you have [specified a
     *           processing
     *           location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *           + Projects scope, location specified:
     *           `projects/{project_id}/locations/{location_id}`
     *           + Projects scope, no location specified (defaults to global):
     *           `projects/{project_id}`
     *
     *           The following example `parent` string specifies a parent project with the
     *           identifier `example-project`, and specifies the `europe-west3` location
     *           for processing data:
     *
     *           parent=projects/example-project/locations/europe-west3
     *     @type DeidentifyConfig $deidentifyConfig
     *           Configuration for the de-identification of the content item.
     *           Items specified here will override the template referenced by the
     *           deidentify_template_name argument.
     *     @type InspectConfig $inspectConfig
     *           Configuration for the inspector.
     *           Items specified here will override the template referenced by the
     *           inspect_template_name argument.
     *     @type ContentItem $item
     *           The item to de-identify. Will be treated as text.
     *
     *           This value must be of type
     *           [Table][google.privacy.dlp.v2.Table] if your
     *           [deidentify_config][google.privacy.dlp.v2.DeidentifyContentRequest.deidentify_config]
     *           is a
     *           [RecordTransformations][google.privacy.dlp.v2.RecordTransformations]
     *           object.
     *     @type string $inspectTemplateName
     *           Template to use. Any configuration directly specified in
     *           inspect_config will override those set in the template. Singular fields
     *           that are set in this request will replace their corresponding fields in the
     *           template. Repeated fields are appended. Singular sub-messages and groups
     *           are recursively merged.
     *     @type string $deidentifyTemplateName
     *           Template to use. Any configuration directly specified in
     *           deidentify_config will override those set in the template. Singular fields
     *           that are set in this request will replace their corresponding fields in the
     *           template. Repeated fields are appended. Singular sub-messages and groups
     *           are recursively merged.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DeidentifyContentResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deidentifyContent(array $optionalArgs = [])
    {
        $request = new DeidentifyContentRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['deidentifyConfig'])) {
            $request->setDeidentifyConfig($optionalArgs['deidentifyConfig']);
        }

        if (isset($optionalArgs['inspectConfig'])) {
            $request->setInspectConfig($optionalArgs['inspectConfig']);
        }

        if (isset($optionalArgs['item'])) {
            $request->setItem($optionalArgs['item']);
        }

        if (isset($optionalArgs['inspectTemplateName'])) {
            $request->setInspectTemplateName(
                $optionalArgs['inspectTemplateName']
            );
        }

        if (isset($optionalArgs['deidentifyTemplateName'])) {
            $request->setDeidentifyTemplateName(
                $optionalArgs['deidentifyTemplateName']
            );
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeidentifyContent',
            DeidentifyContentResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Delete a Connection.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->connectionName('[PROJECT]', '[LOCATION]', '[CONNECTION]');
     *     $dlpServiceClient->deleteConnection($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the Connection to be deleted, in the format:
     *                             `projects/{project}/locations/{location}/connections/{connection}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteConnection($name, array $optionalArgs = [])
    {
        $request = new DeleteConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteConnection',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a DeidentifyTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->deidentifyTemplateName('[ORGANIZATION]', '[DEIDENTIFY_TEMPLATE]');
     *     $dlpServiceClient->deleteDeidentifyTemplate($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the organization and deidentify template to be
     *                             deleted, for example
     *                             `organizations/433245324/deidentifyTemplates/432452342` or
     *                             projects/project-id/deidentifyTemplates/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDeidentifyTemplate($name, array $optionalArgs = [])
    {
        $request = new DeleteDeidentifyTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteDeidentifyTemplate',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a discovery configuration.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->discoveryConfigName('[PROJECT]', '[LOCATION]', '[DISCOVERY_CONFIG]');
     *     $dlpServiceClient->deleteDiscoveryConfig($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the project and the config, for example
     *                             `projects/dlp-test-project/discoveryConfigs/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDiscoveryConfig($name, array $optionalArgs = [])
    {
        $request = new DeleteDiscoveryConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteDiscoveryConfig',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a long-running DlpJob. This method indicates that the client is
     * no longer interested in the DlpJob result. The job will be canceled if
     * possible.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->dlpJobName('[PROJECT]', '[DLP_JOB]');
     *     $dlpServiceClient->deleteDlpJob($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DlpJob resource to be deleted.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDlpJob($name, array $optionalArgs = [])
    {
        $request = new DeleteDlpJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteDlpJob',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Delete a FileStoreDataProfile. Will not prevent the profile from being
     * regenerated if the resource is still included in a discovery configuration.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->fileStoreDataProfileName('[ORGANIZATION]', '[LOCATION]', '[FILE_STORE_DATA_PROFILE]');
     *     $dlpServiceClient->deleteFileStoreDataProfile($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the file store data profile.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFileStoreDataProfile($name, array $optionalArgs = [])
    {
        $request = new DeleteFileStoreDataProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteFileStoreDataProfile',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes an InspectTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->inspectTemplateName('[ORGANIZATION]', '[INSPECT_TEMPLATE]');
     *     $dlpServiceClient->deleteInspectTemplate($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the organization and inspectTemplate to be
     *                             deleted, for example `organizations/433245324/inspectTemplates/432452342`
     *                             or projects/project-id/inspectTemplates/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteInspectTemplate($name, array $optionalArgs = [])
    {
        $request = new DeleteInspectTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteInspectTemplate',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a job trigger.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->jobTriggerName('[PROJECT]', '[JOB_TRIGGER]');
     *     $dlpServiceClient->deleteJobTrigger($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the project and the triggeredJob, for example
     *                             `projects/dlp-test-project/jobTriggers/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteJobTrigger($name, array $optionalArgs = [])
    {
        $request = new DeleteJobTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteJobTrigger',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a stored infoType.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->storedInfoTypeName('[ORGANIZATION]', '[STORED_INFO_TYPE]');
     *     $dlpServiceClient->deleteStoredInfoType($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the organization and storedInfoType to be
     *                             deleted, for example `organizations/433245324/storedInfoTypes/432452342` or
     *                             projects/project-id/storedInfoTypes/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteStoredInfoType($name, array $optionalArgs = [])
    {
        $request = new DeleteStoredInfoTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteStoredInfoType',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Delete a TableDataProfile. Will not prevent the profile from being
     * regenerated if the table is still included in a discovery configuration.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->tableDataProfileName('[ORGANIZATION]', '[LOCATION]', '[TABLE_DATA_PROFILE]');
     *     $dlpServiceClient->deleteTableDataProfile($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the table data profile.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTableDataProfile($name, array $optionalArgs = [])
    {
        $request = new DeleteTableDataProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteTableDataProfile',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Finish a running hybrid DlpJob. Triggers the finalization steps and running
     * of any enabled actions that have not yet run.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->dlpJobName('[PROJECT]', '[DLP_JOB]');
     *     $dlpServiceClient->finishDlpJob($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DlpJob resource to be finished.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function finishDlpJob($name, array $optionalArgs = [])
    {
        $request = new FinishDlpJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FinishDlpJob',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a column data profile.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->columnDataProfileName('[ORGANIZATION]', '[LOCATION]', '[COLUMN_DATA_PROFILE]');
     *     $response = $dlpServiceClient->getColumnDataProfile($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name, for example
     *                             `organizations/12345/locations/us/columnDataProfiles/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\ColumnDataProfile
     *
     * @throws ApiException if the remote call fails
     */
    public function getColumnDataProfile($name, array $optionalArgs = [])
    {
        $request = new GetColumnDataProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetColumnDataProfile',
            ColumnDataProfile::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get a Connection by name.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->connectionName('[PROJECT]', '[LOCATION]', '[CONNECTION]');
     *     $response = $dlpServiceClient->getConnection($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name in the format:
     *                             `projects/{project}/locations/{location}/connections/{connection}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\Connection
     *
     * @throws ApiException if the remote call fails
     */
    public function getConnection($name, array $optionalArgs = [])
    {
        $request = new GetConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetConnection',
            Connection::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a DeidentifyTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->deidentifyTemplateName('[ORGANIZATION]', '[DEIDENTIFY_TEMPLATE]');
     *     $response = $dlpServiceClient->getDeidentifyTemplate($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the organization and deidentify template to be
     *                             read, for example `organizations/433245324/deidentifyTemplates/432452342`
     *                             or projects/project-id/deidentifyTemplates/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DeidentifyTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function getDeidentifyTemplate($name, array $optionalArgs = [])
    {
        $request = new GetDeidentifyTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDeidentifyTemplate',
            DeidentifyTemplate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a discovery configuration.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->discoveryConfigName('[PROJECT]', '[LOCATION]', '[DISCOVERY_CONFIG]');
     *     $response = $dlpServiceClient->getDiscoveryConfig($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the project and the configuration, for example
     *                             `projects/dlp-test-project/discoveryConfigs/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DiscoveryConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getDiscoveryConfig($name, array $optionalArgs = [])
    {
        $request = new GetDiscoveryConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDiscoveryConfig',
            DiscoveryConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets the latest state of a long-running DlpJob.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->dlpJobName('[PROJECT]', '[DLP_JOB]');
     *     $response = $dlpServiceClient->getDlpJob($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DlpJob resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DlpJob
     *
     * @throws ApiException if the remote call fails
     */
    public function getDlpJob($name, array $optionalArgs = [])
    {
        $request = new GetDlpJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDlpJob',
            DlpJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a file store data profile.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->projectDataProfileName('[ORGANIZATION]', '[LOCATION]', '[PROJECT_DATA_PROFILE]');
     *     $response = $dlpServiceClient->getFileStoreDataProfile($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name, for example
     *                             `organizations/12345/locations/us/fileStoreDataProfiles/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\FileStoreDataProfile
     *
     * @throws ApiException if the remote call fails
     */
    public function getFileStoreDataProfile($name, array $optionalArgs = [])
    {
        $request = new GetFileStoreDataProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFileStoreDataProfile',
            FileStoreDataProfile::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets an InspectTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->inspectTemplateName('[ORGANIZATION]', '[INSPECT_TEMPLATE]');
     *     $response = $dlpServiceClient->getInspectTemplate($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the organization and inspectTemplate to be read,
     *                             for example `organizations/433245324/inspectTemplates/432452342` or
     *                             projects/project-id/inspectTemplates/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\InspectTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function getInspectTemplate($name, array $optionalArgs = [])
    {
        $request = new GetInspectTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetInspectTemplate',
            InspectTemplate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a job trigger.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->jobTriggerName('[PROJECT]', '[JOB_TRIGGER]');
     *     $response = $dlpServiceClient->getJobTrigger($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the project and the triggeredJob, for example
     *                             `projects/dlp-test-project/jobTriggers/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\JobTrigger
     *
     * @throws ApiException if the remote call fails
     */
    public function getJobTrigger($name, array $optionalArgs = [])
    {
        $request = new GetJobTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetJobTrigger',
            JobTrigger::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a project data profile.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->projectDataProfileName('[ORGANIZATION]', '[LOCATION]', '[PROJECT_DATA_PROFILE]');
     *     $response = $dlpServiceClient->getProjectDataProfile($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name, for example
     *                             `organizations/12345/locations/us/projectDataProfiles/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\ProjectDataProfile
     *
     * @throws ApiException if the remote call fails
     */
    public function getProjectDataProfile($name, array $optionalArgs = [])
    {
        $request = new GetProjectDataProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetProjectDataProfile',
            ProjectDataProfile::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a stored infoType.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->storedInfoTypeName('[ORGANIZATION]', '[STORED_INFO_TYPE]');
     *     $response = $dlpServiceClient->getStoredInfoType($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the organization and storedInfoType to be read,
     *                             for example `organizations/433245324/storedInfoTypes/432452342` or
     *                             projects/project-id/storedInfoTypes/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\StoredInfoType
     *
     * @throws ApiException if the remote call fails
     */
    public function getStoredInfoType($name, array $optionalArgs = [])
    {
        $request = new GetStoredInfoTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetStoredInfoType',
            StoredInfoType::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a table data profile.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->tableDataProfileName('[ORGANIZATION]', '[LOCATION]', '[TABLE_DATA_PROFILE]');
     *     $response = $dlpServiceClient->getTableDataProfile($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name, for example
     *                             `organizations/12345/locations/us/tableDataProfiles/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\TableDataProfile
     *
     * @throws ApiException if the remote call fails
     */
    public function getTableDataProfile($name, array $optionalArgs = [])
    {
        $request = new GetTableDataProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTableDataProfile',
            TableDataProfile::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Inspect hybrid content and store findings to a job.
     * To review the findings, inspect the job. Inspection will occur
     * asynchronously.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->dlpJobName('[PROJECT]', '[DLP_JOB]');
     *     $response = $dlpServiceClient->hybridInspectDlpJob($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the job to execute a hybrid inspect on, for
     *                             example `projects/dlp-test-project/dlpJob/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type HybridContentItem $hybridItem
     *           The item to inspect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\HybridInspectResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function hybridInspectDlpJob($name, array $optionalArgs = [])
    {
        $request = new HybridInspectDlpJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['hybridItem'])) {
            $request->setHybridItem($optionalArgs['hybridItem']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'HybridInspectDlpJob',
            HybridInspectResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Inspect hybrid content and store findings to a trigger. The inspection
     * will be processed asynchronously. To review the findings monitor the
     * jobs within the trigger.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->jobTriggerName('[PROJECT]', '[JOB_TRIGGER]');
     *     $response = $dlpServiceClient->hybridInspectJobTrigger($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the trigger to execute a hybrid inspect on, for
     *                             example `projects/dlp-test-project/jobTriggers/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type HybridContentItem $hybridItem
     *           The item to inspect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\HybridInspectResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function hybridInspectJobTrigger($name, array $optionalArgs = [])
    {
        $request = new HybridInspectJobTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['hybridItem'])) {
            $request->setHybridItem($optionalArgs['hybridItem']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'HybridInspectJobTrigger',
            HybridInspectResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Finds potentially sensitive info in content.
     * This method has limits on input size, processing time, and output size.
     *
     * When no InfoTypes or CustomInfoTypes are specified in this request, the
     * system will automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     *
     * For how to guides, see
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-images
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-text,
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $response = $dlpServiceClient->inspectContent();
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $parent The parent resource name. Please note, unless you have
     *           authenticated using an API key this option will be required.
     *
     *           The format of this value varies depending on whether you have [specified a
     *           processing
     *           location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *           + Projects scope, location specified:
     *           `projects/{project_id}/locations/{location_id}`
     *           + Projects scope, no location specified (defaults to global):
     *           `projects/{project_id}`
     *
     *           The following example `parent` string specifies a parent project with the
     *           identifier `example-project`, and specifies the `europe-west3` location
     *           for processing data:
     *
     *           parent=projects/example-project/locations/europe-west3
     *     @type InspectConfig $inspectConfig
     *           Configuration for the inspector. What specified here will override
     *           the template referenced by the inspect_template_name argument.
     *     @type ContentItem $item
     *           The item to inspect.
     *     @type string $inspectTemplateName
     *           Template to use. Any configuration directly specified in
     *           inspect_config will override those set in the template. Singular fields
     *           that are set in this request will replace their corresponding fields in the
     *           template. Repeated fields are appended. Singular sub-messages and groups
     *           are recursively merged.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\InspectContentResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function inspectContent(array $optionalArgs = [])
    {
        $request = new InspectContentRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['inspectConfig'])) {
            $request->setInspectConfig($optionalArgs['inspectConfig']);
        }

        if (isset($optionalArgs['item'])) {
            $request->setItem($optionalArgs['item']);
        }

        if (isset($optionalArgs['inspectTemplateName'])) {
            $request->setInspectTemplateName(
                $optionalArgs['inspectTemplateName']
            );
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'InspectContent',
            InspectContentResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists column data profiles for an organization.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listColumnDataProfiles($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listColumnDataProfiles($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the organization or project, for
     *                             example `organizations/433245324/locations/europe` or
     *                             `projects/project-id/locations/asia`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Comma-separated list of fields to order by, followed by `asc` or `desc`
     *           postfix. This list is case insensitive. The default sorting order is
     *           ascending. Redundant space characters are insignificant. Only one order
     *           field at a time is allowed.
     *
     *           Examples:
     *
     *           * `project_id asc`
     *           * `table_id`
     *           * `sensitivity_level desc`
     *
     *           Supported fields are:
     *
     *           - `project_id`: The Google Cloud project ID.
     *           - `dataset_id`: The ID of a BigQuery dataset.
     *           - `table_id`: The ID of a BigQuery table.
     *           - `sensitivity_level`: How sensitive the data in a column is, at most.
     *           - `data_risk_level`: How much risk is associated with this data.
     *           - `profile_last_generated`: When the profile was last updated in epoch
     *           seconds.
     *     @type string $filter
     *           Allows filtering.
     *
     *           Supported syntax:
     *
     *           * Filter expressions are made up of one or more restrictions.
     *           * Restrictions can be combined by `AND` or `OR` logical operators. A
     *           sequence of restrictions implicitly uses `AND`.
     *           * A restriction has the form of `{field} {operator} {value}`.
     *           * Supported fields/values:
     *           - `table_data_profile_name` - The name of the related table data
     *           profile.
     *           - `project_id` - The Google Cloud project ID. (REQUIRED)
     *           - `dataset_id` - The BigQuery dataset ID. (REQUIRED)
     *           - `table_id` - The BigQuery table ID. (REQUIRED)
     *           - `field_id` - The ID of the BigQuery field.
     *           - `info_type` - The infotype detected in the resource.
     *           - `sensitivity_level` - HIGH|MEDIUM|LOW
     *           - `data_risk_level`: How much risk is associated with this data.
     *           - `status_code` - an RPC status code as defined in
     *           https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
     *           * The operator must be `=` for project_id, dataset_id, and table_id. Other
     *           filters also support `!=`.
     *
     *           Examples:
     *
     *           * project_id = 12345 AND status_code = 1
     *           * project_id = 12345 AND sensitivity_level = HIGH
     *           * project_id = 12345 AND info_type = STREET_ADDRESS
     *
     *           The length of this field should be no more than 500 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listColumnDataProfiles($parent, array $optionalArgs = [])
    {
        $request = new ListColumnDataProfilesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListColumnDataProfiles',
            $optionalArgs,
            ListColumnDataProfilesResponse::class,
            $request
        );
    }

    /**
     * Lists Connections in a parent. Use SearchConnections to see all connections
     * within an organization.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listConnections($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listConnections($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the organization or project, for
     *                             example, `organizations/433245324/locations/europe` or
     *                             `projects/project-id/locations/asia`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Supported field/value: `state` - MISSING|AVAILABLE|ERROR
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listConnections($parent, array $optionalArgs = [])
    {
        $request = new ListConnectionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListConnections',
            $optionalArgs,
            ListConnectionsResponse::class,
            $request
        );
    }

    /**
     * Lists DeidentifyTemplates.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listDeidentifyTemplates($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listDeidentifyTemplates($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent resource name.
     *
     *                             The format of this value varies depending on the scope of the request
     *                             (project or organization) and whether you have [specified a processing
     *                             location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                             + Projects scope, location specified:
     *                             `projects/{project_id}/locations/{location_id}`
     *                             + Projects scope, no location specified (defaults to global):
     *                             `projects/{project_id}`
     *                             + Organizations scope, location specified:
     *                             `organizations/{org_id}/locations/{location_id}`
     *                             + Organizations scope, no location specified (defaults to global):
     *                             `organizations/{org_id}`
     *
     *                             The following example `parent` string specifies a parent project with the
     *                             identifier `example-project`, and specifies the `europe-west3` location
     *                             for processing data:
     *
     *                             parent=projects/example-project/locations/europe-west3
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Comma-separated list of fields to order by,
     *           followed by `asc` or `desc` postfix. This list is case insensitive. The
     *           default sorting order is ascending. Redundant space characters are
     *           insignificant.
     *
     *           Example: `name asc,update_time, create_time desc`
     *
     *           Supported fields are:
     *
     *           - `create_time`: corresponds to the time the template was created.
     *           - `update_time`: corresponds to the time the template was last updated.
     *           - `name`: corresponds to the template's name.
     *           - `display_name`: corresponds to the template's display name.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDeidentifyTemplates($parent, array $optionalArgs = [])
    {
        $request = new ListDeidentifyTemplatesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDeidentifyTemplates',
            $optionalArgs,
            ListDeidentifyTemplatesResponse::class,
            $request
        );
    }

    /**
     * Lists discovery configurations.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listDiscoveryConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listDiscoveryConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent resource name.
     *
     *                             The format of this value is as follows:
     *                             `projects/{project_id}/locations/{location_id}`
     *
     *                             The following example `parent` string specifies a parent project with the
     *                             identifier `example-project`, and specifies the `europe-west3` location
     *                             for processing data:
     *
     *                             parent=projects/example-project/locations/europe-west3
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Comma-separated list of config fields to order by,
     *           followed by `asc` or `desc` postfix. This list is case insensitive. The
     *           default sorting order is ascending. Redundant space characters are
     *           insignificant.
     *
     *           Example: `name asc,update_time, create_time desc`
     *
     *           Supported fields are:
     *
     *           - `last_run_time`: corresponds to the last time the DiscoveryConfig ran.
     *           - `name`: corresponds to the DiscoveryConfig's name.
     *           - `status`: corresponds to DiscoveryConfig's status.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDiscoveryConfigs($parent, array $optionalArgs = [])
    {
        $request = new ListDiscoveryConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDiscoveryConfigs',
            $optionalArgs,
            ListDiscoveryConfigsResponse::class,
            $request
        );
    }

    /**
     * Lists DlpJobs that match the specified filter in the request.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
     * and
     * https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listDlpJobs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listDlpJobs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent resource name.
     *
     *                             The format of this value varies depending on whether you have [specified a
     *                             processing
     *                             location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                             + Projects scope, location specified:
     *                             `projects/{project_id}/locations/{location_id}`
     *                             + Projects scope, no location specified (defaults to global):
     *                             `projects/{project_id}`
     *
     *                             The following example `parent` string specifies a parent project with the
     *                             identifier `example-project`, and specifies the `europe-west3` location
     *                             for processing data:
     *
     *                             parent=projects/example-project/locations/europe-west3
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Allows filtering.
     *
     *           Supported syntax:
     *
     *           * Filter expressions are made up of one or more restrictions.
     *           * Restrictions can be combined by `AND` or `OR` logical operators. A
     *           sequence of restrictions implicitly uses `AND`.
     *           * A restriction has the form of `{field} {operator} {value}`.
     *           * Supported fields/values for inspect jobs:
     *           - `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED
     *           - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
     *           - `trigger_name` - The name of the trigger that created the job.
     *           - 'end_time` - Corresponds to the time the job finished.
     *           - 'start_time` - Corresponds to the time the job finished.
     *           * Supported fields for risk analysis jobs:
     *           - `state` - RUNNING|CANCELED|FINISHED|FAILED
     *           - 'end_time` - Corresponds to the time the job finished.
     *           - 'start_time` - Corresponds to the time the job finished.
     *           * The operator must be `=` or `!=`.
     *
     *           Examples:
     *
     *           * inspected_storage = cloud_storage AND state = done
     *           * inspected_storage = cloud_storage OR inspected_storage = bigquery
     *           * inspected_storage = cloud_storage AND (state = done OR state = canceled)
     *           * end_time > \"2017-12-12T00:00:00+00:00\"
     *
     *           The length of this field should be no more than 500 characters.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $type
     *           The type of job. Defaults to `DlpJobType.INSPECT`
     *           For allowed values, use constants defined on {@see \Google\Cloud\Dlp\V2\DlpJobType}
     *     @type string $orderBy
     *           Comma-separated list of fields to order by,
     *           followed by `asc` or `desc` postfix. This list is case insensitive. The
     *           default sorting order is ascending. Redundant space characters are
     *           insignificant.
     *
     *           Example: `name asc, end_time asc, create_time desc`
     *
     *           Supported fields are:
     *
     *           - `create_time`: corresponds to the time the job was created.
     *           - `end_time`: corresponds to the time the job ended.
     *           - `name`: corresponds to the job's name.
     *           - `state`: corresponds to `state`
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDlpJobs($parent, array $optionalArgs = [])
    {
        $request = new ListDlpJobsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['type'])) {
            $request->setType($optionalArgs['type']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDlpJobs',
            $optionalArgs,
            ListDlpJobsResponse::class,
            $request
        );
    }

    /**
     * Lists file store data profiles for an organization.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listFileStoreDataProfiles($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listFileStoreDataProfiles($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the organization or project, for
     *                             example `organizations/433245324/locations/europe` or
     *                             `projects/project-id/locations/asia`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Optional. Comma-separated list of fields to order by, followed by `asc` or
     *           `desc` postfix. This list is case insensitive. The default sorting order is
     *           ascending. Redundant space characters are insignificant. Only one order
     *           field at a time is allowed.
     *
     *           Examples:
     *
     *           * `project_id asc`
     *           * `name`
     *           * `sensitivity_level desc`
     *
     *           Supported fields are:
     *
     *           - `project_id`: The Google Cloud project ID.
     *           - `sensitivity_level`: How sensitive the data in a table is, at most.
     *           - `data_risk_level`: How much risk is associated with this data.
     *           - `profile_last_generated`: When the profile was last updated in epoch
     *           seconds.
     *           - `last_modified`: The last time the resource was modified.
     *           - `resource_visibility`: Visibility restriction for this resource.
     *           - `name`: The name of the profile.
     *           - `create_time`: The time the file store was first created.
     *     @type string $filter
     *           Optional. Allows filtering.
     *
     *           Supported syntax:
     *
     *           * Filter expressions are made up of one or more restrictions.
     *           * Restrictions can be combined by `AND` or `OR` logical operators. A
     *           sequence of restrictions implicitly uses `AND`.
     *           * A restriction has the form of `{field} {operator} {value}`.
     *           * Supported fields/values:
     *           - `project_id` - The Google Cloud project ID.
     *           - `file_store_path` - The path like "gs://bucket".
     *           - `sensitivity_level` - HIGH|MODERATE|LOW
     *           - `data_risk_level` - HIGH|MODERATE|LOW
     *           - `resource_visibility`: PUBLIC|RESTRICTED
     *           - `status_code` - an RPC status code as defined in
     *           https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
     *           * The operator must be `=` or `!=`.
     *
     *           Examples:
     *
     *           * `project_id = 12345 AND status_code = 1`
     *           * `project_id = 12345 AND sensitivity_level = HIGH`
     *           * `project_id = 12345 AND resource_visibility = PUBLIC`
     *           * `file_store_path = "gs://mybucket"`
     *
     *           The length of this field should be no more than 500 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFileStoreDataProfiles($parent, array $optionalArgs = [])
    {
        $request = new ListFileStoreDataProfilesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFileStoreDataProfiles',
            $optionalArgs,
            ListFileStoreDataProfilesResponse::class,
            $request
        );
    }

    /**
     * Returns a list of the sensitive information types that DLP API
     * supports. See
     * https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $response = $dlpServiceClient->listInfoTypes();
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $parent The parent resource name. Please note, unless you have
     *           authenticated using an API key this option will be required.
     *
     *           The format of this value is as follows:
     *
     *           `locations/{location_id}`
     *     @type string $languageCode
     *           BCP-47 language code for localized infoType friendly
     *           names. If omitted, or if localized strings are not available,
     *           en-US strings will be returned.
     *     @type string $filter
     *           filter to only return infoTypes supported by certain parts of the
     *           API. Defaults to supported_by=INSPECT.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\ListInfoTypesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInfoTypes(array $optionalArgs = [])
    {
        $request = new ListInfoTypesRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ListInfoTypes',
            ListInfoTypesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists InspectTemplates.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listInspectTemplates($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listInspectTemplates($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent resource name.
     *
     *                             The format of this value varies depending on the scope of the request
     *                             (project or organization) and whether you have [specified a processing
     *                             location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                             + Projects scope, location specified:
     *                             `projects/{project_id}/locations/{location_id}`
     *                             + Projects scope, no location specified (defaults to global):
     *                             `projects/{project_id}`
     *                             + Organizations scope, location specified:
     *                             `organizations/{org_id}/locations/{location_id}`
     *                             + Organizations scope, no location specified (defaults to global):
     *                             `organizations/{org_id}`
     *
     *                             The following example `parent` string specifies a parent project with the
     *                             identifier `example-project`, and specifies the `europe-west3` location
     *                             for processing data:
     *
     *                             parent=projects/example-project/locations/europe-west3
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Comma-separated list of fields to order by,
     *           followed by `asc` or `desc` postfix. This list is case insensitive. The
     *           default sorting order is ascending. Redundant space characters are
     *           insignificant.
     *
     *           Example: `name asc,update_time, create_time desc`
     *
     *           Supported fields are:
     *
     *           - `create_time`: corresponds to the time the template was created.
     *           - `update_time`: corresponds to the time the template was last updated.
     *           - `name`: corresponds to the template's name.
     *           - `display_name`: corresponds to the template's display name.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInspectTemplates($parent, array $optionalArgs = [])
    {
        $request = new ListInspectTemplatesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListInspectTemplates',
            $optionalArgs,
            ListInspectTemplatesResponse::class,
            $request
        );
    }

    /**
     * Lists job triggers.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listJobTriggers($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listJobTriggers($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent resource name.
     *
     *                             The format of this value varies depending on whether you have [specified a
     *                             processing
     *                             location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                             + Projects scope, location specified:
     *                             `projects/{project_id}/locations/{location_id}`
     *                             + Projects scope, no location specified (defaults to global):
     *                             `projects/{project_id}`
     *
     *                             The following example `parent` string specifies a parent project with the
     *                             identifier `example-project`, and specifies the `europe-west3` location
     *                             for processing data:
     *
     *                             parent=projects/example-project/locations/europe-west3
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Comma-separated list of triggeredJob fields to order by,
     *           followed by `asc` or `desc` postfix. This list is case insensitive. The
     *           default sorting order is ascending. Redundant space characters are
     *           insignificant.
     *
     *           Example: `name asc,update_time, create_time desc`
     *
     *           Supported fields are:
     *
     *           - `create_time`: corresponds to the time the JobTrigger was created.
     *           - `update_time`: corresponds to the time the JobTrigger was last updated.
     *           - `last_run_time`: corresponds to the last time the JobTrigger ran.
     *           - `name`: corresponds to the JobTrigger's name.
     *           - `display_name`: corresponds to the JobTrigger's display name.
     *           - `status`: corresponds to JobTrigger's status.
     *     @type string $filter
     *           Allows filtering.
     *
     *           Supported syntax:
     *
     *           * Filter expressions are made up of one or more restrictions.
     *           * Restrictions can be combined by `AND` or `OR` logical operators. A
     *           sequence of restrictions implicitly uses `AND`.
     *           * A restriction has the form of `{field} {operator} {value}`.
     *           * Supported fields/values for inspect triggers:
     *           - `status` - HEALTHY|PAUSED|CANCELLED
     *           - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
     *           - 'last_run_time` - RFC 3339 formatted timestamp, surrounded by
     *           quotation marks. Nanoseconds are ignored.
     *           - 'error_count' - Number of errors that have occurred while running.
     *           * The operator must be `=` or `!=` for status and inspected_storage.
     *
     *           Examples:
     *
     *           * inspected_storage = cloud_storage AND status = HEALTHY
     *           * inspected_storage = cloud_storage OR inspected_storage = bigquery
     *           * inspected_storage = cloud_storage AND (state = PAUSED OR state = HEALTHY)
     *           * last_run_time > \"2017-12-12T00:00:00+00:00\"
     *
     *           The length of this field should be no more than 500 characters.
     *     @type int $type
     *           The type of jobs. Will use `DlpJobType.INSPECT` if not set.
     *           For allowed values, use constants defined on {@see \Google\Cloud\Dlp\V2\DlpJobType}
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listJobTriggers($parent, array $optionalArgs = [])
    {
        $request = new ListJobTriggersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['type'])) {
            $request->setType($optionalArgs['type']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListJobTriggers',
            $optionalArgs,
            ListJobTriggersResponse::class,
            $request
        );
    }

    /**
     * Lists project data profiles for an organization.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listProjectDataProfiles($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listProjectDataProfiles($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. organizations/{org_id}/locations/{loc_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Comma-separated list of fields to order by, followed by `asc` or `desc`
     *           postfix. This list is case insensitive. The default sorting order is
     *           ascending. Redundant space characters are insignificant. Only one order
     *           field at a time is allowed.
     *
     *           Examples:
     *           * `project_id`
     *           * `sensitivity_level desc`
     *
     *           Supported fields are:
     *
     *           - `project_id`: Google Cloud project ID
     *           - `sensitivity_level`: How sensitive the data in a project is, at most.
     *           - `data_risk_level`: How much risk is associated with this data.
     *           - `profile_last_generated`: When the profile was last updated in epoch
     *           seconds.
     *     @type string $filter
     *           Allows filtering.
     *
     *           Supported syntax:
     *
     *           * Filter expressions are made up of one or more restrictions.
     *           * Restrictions can be combined by `AND` or `OR` logical operators. A
     *           sequence of restrictions implicitly uses `AND`.
     *           * A restriction has the form of `{field} {operator} {value}`.
     *           * Supported fields/values:
     *           - `sensitivity_level` - HIGH|MODERATE|LOW
     *           - `data_risk_level` - HIGH|MODERATE|LOW
     *           - `status_code` - an RPC status code as defined in
     *           https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
     *           * The operator must be `=` or `!=`.
     *
     *           Examples:
     *
     *           * `project_id = 12345 AND status_code = 1`
     *           * `project_id = 12345 AND sensitivity_level = HIGH`
     *
     *           The length of this field should be no more than 500 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProjectDataProfiles($parent, array $optionalArgs = [])
    {
        $request = new ListProjectDataProfilesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListProjectDataProfiles',
            $optionalArgs,
            ListProjectDataProfilesResponse::class,
            $request
        );
    }

    /**
     * Lists stored infoTypes.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listStoredInfoTypes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listStoredInfoTypes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent resource name.
     *
     *                             The format of this value varies depending on the scope of the request
     *                             (project or organization) and whether you have [specified a processing
     *                             location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                             + Projects scope, location specified:
     *                             `projects/{project_id}/locations/{location_id}`
     *                             + Projects scope, no location specified (defaults to global):
     *                             `projects/{project_id}`
     *
     *                             The following example `parent` string specifies a parent project with the
     *                             identifier `example-project`, and specifies the `europe-west3` location
     *                             for processing data:
     *
     *                             parent=projects/example-project/locations/europe-west3
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Comma-separated list of fields to order by,
     *           followed by `asc` or `desc` postfix. This list is case insensitive. The
     *           default sorting order is ascending. Redundant space characters are
     *           insignificant.
     *
     *           Example: `name asc, display_name, create_time desc`
     *
     *           Supported fields are:
     *
     *           - `create_time`: corresponds to the time the most recent version of the
     *           resource was created.
     *           - `state`: corresponds to the state of the resource.
     *           - `name`: corresponds to resource name.
     *           - `display_name`: corresponds to info type's display name.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listStoredInfoTypes($parent, array $optionalArgs = [])
    {
        $request = new ListStoredInfoTypesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListStoredInfoTypes',
            $optionalArgs,
            ListStoredInfoTypesResponse::class,
            $request
        );
    }

    /**
     * Lists table data profiles for an organization.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->listTableDataProfiles($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->listTableDataProfiles($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the organization or project, for
     *                             example `organizations/433245324/locations/europe` or
     *                             `projects/project-id/locations/asia`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $orderBy
     *           Comma-separated list of fields to order by, followed by `asc` or `desc`
     *           postfix. This list is case insensitive. The default sorting order is
     *           ascending. Redundant space characters are insignificant. Only one order
     *           field at a time is allowed.
     *
     *           Examples:
     *           * `project_id asc`
     *           * `table_id`
     *           * `sensitivity_level desc`
     *
     *           Supported fields are:
     *
     *           - `project_id`: The Google Cloud project ID.
     *           - `dataset_id`: The ID of a BigQuery dataset.
     *           - `table_id`: The ID of a BigQuery table.
     *           - `sensitivity_level`: How sensitive the data in a table is, at most.
     *           - `data_risk_level`: How much risk is associated with this data.
     *           - `profile_last_generated`: When the profile was last updated in epoch
     *           seconds.
     *           - `last_modified`: The last time the resource was modified.
     *           - `resource_visibility`: Visibility restriction for this resource.
     *           - `row_count`: Number of rows in this resource.
     *     @type string $filter
     *           Allows filtering.
     *
     *           Supported syntax:
     *
     *           * Filter expressions are made up of one or more restrictions.
     *           * Restrictions can be combined by `AND` or `OR` logical operators. A
     *           sequence of restrictions implicitly uses `AND`.
     *           * A restriction has the form of `{field} {operator} {value}`.
     *           * Supported fields/values:
     *           - `project_id` - The Google Cloud project ID.
     *           - `dataset_id` - The BigQuery dataset ID.
     *           - `table_id` - The ID of the BigQuery table.
     *           - `sensitivity_level` - HIGH|MODERATE|LOW
     *           - `data_risk_level` - HIGH|MODERATE|LOW
     *           - `resource_visibility`: PUBLIC|RESTRICTED
     *           - `status_code` - an RPC status code as defined in
     *           https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
     *           * The operator must be `=` or `!=`.
     *
     *           Examples:
     *
     *           * `project_id = 12345 AND status_code = 1`
     *           * `project_id = 12345 AND sensitivity_level = HIGH`
     *           * `project_id = 12345 AND resource_visibility = PUBLIC`
     *
     *           The length of this field should be no more than 500 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTableDataProfiles($parent, array $optionalArgs = [])
    {
        $request = new ListTableDataProfilesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTableDataProfiles',
            $optionalArgs,
            ListTableDataProfilesResponse::class,
            $request
        );
    }

    /**
     * Redacts potentially sensitive info from an image.
     * This method has limits on input size, processing time, and output size.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/redacting-sensitive-data-images
     * to learn more.
     *
     * When no InfoTypes or CustomInfoTypes are specified in this request, the
     * system will automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $response = $dlpServiceClient->redactImage();
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $parent The parent resource name. Please note, unless you have
     *           authenticated using an API key this option will be required.
     *
     *           The format of this value varies depending on whether you have [specified a
     *           processing
     *           location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *           + Projects scope, location specified:
     *           `projects/{project_id}/locations/{location_id}`
     *           + Projects scope, no location specified (defaults to global):
     *           `projects/{project_id}`
     *
     *           The following example `parent` string specifies a parent project with the
     *           identifier `example-project`, and specifies the `europe-west3` location
     *           for processing data:
     *
     *           parent=projects/example-project/locations/europe-west3
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type InspectConfig $inspectConfig
     *           Configuration for the inspector.
     *     @type ImageRedactionConfig[] $imageRedactionConfigs
     *           The configuration for specifying what content to redact from images.
     *     @type bool $includeFindings
     *           Whether the response should include findings along with the redacted
     *           image.
     *     @type ByteContentItem $byteItem
     *           The content must be PNG, JPEG, SVG or BMP.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\RedactImageResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function redactImage(array $optionalArgs = [])
    {
        $request = new RedactImageRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        if (isset($optionalArgs['inspectConfig'])) {
            $request->setInspectConfig($optionalArgs['inspectConfig']);
        }

        if (isset($optionalArgs['imageRedactionConfigs'])) {
            $request->setImageRedactionConfigs(
                $optionalArgs['imageRedactionConfigs']
            );
        }

        if (isset($optionalArgs['includeFindings'])) {
            $request->setIncludeFindings($optionalArgs['includeFindings']);
        }

        if (isset($optionalArgs['byteItem'])) {
            $request->setByteItem($optionalArgs['byteItem']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RedactImage',
            RedactImageResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Re-identifies content that has been de-identified.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/pseudonymization#re-identification_in_free_text_code_example
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->projectName('[PROJECT]');
     *     $response = $dlpServiceClient->reidentifyContent($formattedParent);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent resource name.
     *
     *                             The format of this value varies depending on whether you have [specified a
     *                             processing
     *                             location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
     *
     *                             + Projects scope, location specified:
     *                             `projects/{project_id}/locations/{location_id}`
     *                             + Projects scope, no location specified (defaults to global):
     *                             `projects/{project_id}`
     *
     *                             The following example `parent` string specifies a parent project with the
     *                             identifier `example-project`, and specifies the `europe-west3` location
     *                             for processing data:
     *
     *                             parent=projects/example-project/locations/europe-west3
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type DeidentifyConfig $reidentifyConfig
     *           Configuration for the re-identification of the content item.
     *           This field shares the same proto message type that is used for
     *           de-identification, however its usage here is for the reversal of the
     *           previous de-identification. Re-identification is performed by examining
     *           the transformations used to de-identify the items and executing the
     *           reverse. This requires that only reversible transformations
     *           be provided here. The reversible transformations are:
     *
     *           - `CryptoDeterministicConfig`
     *           - `CryptoReplaceFfxFpeConfig`
     *     @type InspectConfig $inspectConfig
     *           Configuration for the inspector.
     *     @type ContentItem $item
     *           The item to re-identify. Will be treated as text.
     *     @type string $inspectTemplateName
     *           Template to use. Any configuration directly specified in
     *           `inspect_config` will override those set in the template. Singular fields
     *           that are set in this request will replace their corresponding fields in the
     *           template. Repeated fields are appended. Singular sub-messages and groups
     *           are recursively merged.
     *     @type string $reidentifyTemplateName
     *           Template to use. References an instance of `DeidentifyTemplate`.
     *           Any configuration directly specified in `reidentify_config` or
     *           `inspect_config` will override those set in the template. The
     *           `DeidentifyTemplate` used must include only reversible transformations.
     *           Singular fields that are set in this request will replace their
     *           corresponding fields in the template. Repeated fields are appended.
     *           Singular sub-messages and groups are recursively merged.
     *     @type string $locationId
     *           Deprecated. This field has no effect.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\ReidentifyContentResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function reidentifyContent($parent, array $optionalArgs = [])
    {
        $request = new ReidentifyContentRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['reidentifyConfig'])) {
            $request->setReidentifyConfig($optionalArgs['reidentifyConfig']);
        }

        if (isset($optionalArgs['inspectConfig'])) {
            $request->setInspectConfig($optionalArgs['inspectConfig']);
        }

        if (isset($optionalArgs['item'])) {
            $request->setItem($optionalArgs['item']);
        }

        if (isset($optionalArgs['inspectTemplateName'])) {
            $request->setInspectTemplateName(
                $optionalArgs['inspectTemplateName']
            );
        }

        if (isset($optionalArgs['reidentifyTemplateName'])) {
            $request->setReidentifyTemplateName(
                $optionalArgs['reidentifyTemplateName']
            );
        }

        if (isset($optionalArgs['locationId'])) {
            $request->setLocationId($optionalArgs['locationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReidentifyContent',
            ReidentifyContentResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Searches for Connections in a parent.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedParent = $dlpServiceClient->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dlpServiceClient->searchConnections($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dlpServiceClient->searchConnections($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Resource name of the organization or project with a wildcard
     *                             location, for example, `organizations/433245324/locations/-` or
     *                             `projects/project-id/locations/-`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Supported field/value: - `state` - MISSING|AVAILABLE|ERROR
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchConnections($parent, array $optionalArgs = [])
    {
        $request = new SearchConnectionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'SearchConnections',
            $optionalArgs,
            SearchConnectionsResponse::class,
            $request
        );
    }

    /**
     * Update a Connection.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->connectionName('[PROJECT]', '[LOCATION]', '[CONNECTION]');
     *     $connection = new Connection();
     *     $response = $dlpServiceClient->updateConnection($formattedName, $connection);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string     $name         Required. Resource name in the format:
     *                                 `projects/{project}/locations/{location}/connections/{connection}`.
     * @param Connection $connection   Required. The connection with new values for the relevant fields.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Mask to control which fields get updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\Connection
     *
     * @throws ApiException if the remote call fails
     */
    public function updateConnection(
        $name,
        $connection,
        array $optionalArgs = []
    ) {
        $request = new UpdateConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setConnection($connection);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateConnection',
            Connection::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the DeidentifyTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->deidentifyTemplateName('[ORGANIZATION]', '[DEIDENTIFY_TEMPLATE]');
     *     $response = $dlpServiceClient->updateDeidentifyTemplate($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of organization and deidentify template to be
     *                             updated, for example
     *                             `organizations/433245324/deidentifyTemplates/432452342` or
     *                             projects/project-id/deidentifyTemplates/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type DeidentifyTemplate $deidentifyTemplate
     *           New DeidentifyTemplate value.
     *     @type FieldMask $updateMask
     *           Mask to control which fields get updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DeidentifyTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDeidentifyTemplate($name, array $optionalArgs = [])
    {
        $request = new UpdateDeidentifyTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['deidentifyTemplate'])) {
            $request->setDeidentifyTemplate(
                $optionalArgs['deidentifyTemplate']
            );
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateDeidentifyTemplate',
            DeidentifyTemplate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a discovery configuration.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->discoveryConfigName('[PROJECT]', '[LOCATION]', '[DISCOVERY_CONFIG]');
     *     $discoveryConfig = new DiscoveryConfig();
     *     $response = $dlpServiceClient->updateDiscoveryConfig($formattedName, $discoveryConfig);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string          $name            Required. Resource name of the project and the configuration, for example
     *                                         `projects/dlp-test-project/discoveryConfigs/53234423`.
     * @param DiscoveryConfig $discoveryConfig Required. New DiscoveryConfig value.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Mask to control which fields get updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\DiscoveryConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDiscoveryConfig(
        $name,
        $discoveryConfig,
        array $optionalArgs = []
    ) {
        $request = new UpdateDiscoveryConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setDiscoveryConfig($discoveryConfig);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateDiscoveryConfig',
            DiscoveryConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the InspectTemplate.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-templates
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->inspectTemplateName('[ORGANIZATION]', '[INSPECT_TEMPLATE]');
     *     $response = $dlpServiceClient->updateInspectTemplate($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of organization and inspectTemplate to be updated,
     *                             for example `organizations/433245324/inspectTemplates/432452342` or
     *                             projects/project-id/inspectTemplates/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type InspectTemplate $inspectTemplate
     *           New InspectTemplate value.
     *     @type FieldMask $updateMask
     *           Mask to control which fields get updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\InspectTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function updateInspectTemplate($name, array $optionalArgs = [])
    {
        $request = new UpdateInspectTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['inspectTemplate'])) {
            $request->setInspectTemplate($optionalArgs['inspectTemplate']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateInspectTemplate',
            InspectTemplate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a job trigger.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->jobTriggerName('[PROJECT]', '[JOB_TRIGGER]');
     *     $response = $dlpServiceClient->updateJobTrigger($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the project and the triggeredJob, for example
     *                             `projects/dlp-test-project/jobTriggers/53234423`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type JobTrigger $jobTrigger
     *           New JobTrigger value.
     *     @type FieldMask $updateMask
     *           Mask to control which fields get updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\JobTrigger
     *
     * @throws ApiException if the remote call fails
     */
    public function updateJobTrigger($name, array $optionalArgs = [])
    {
        $request = new UpdateJobTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['jobTrigger'])) {
            $request->setJobTrigger($optionalArgs['jobTrigger']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateJobTrigger',
            JobTrigger::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the stored infoType by creating a new version. The existing version
     * will continue to be used until the new version is ready.
     * See
     * https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
     * to learn more.
     *
     * Sample code:
     * ```
     * $dlpServiceClient = new DlpServiceClient();
     * try {
     *     $formattedName = $dlpServiceClient->storedInfoTypeName('[ORGANIZATION]', '[STORED_INFO_TYPE]');
     *     $response = $dlpServiceClient->updateStoredInfoType($formattedName);
     * } finally {
     *     $dlpServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of organization and storedInfoType to be updated,
     *                             for example `organizations/433245324/storedInfoTypes/432452342` or
     *                             projects/project-id/storedInfoTypes/432452342.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type StoredInfoTypeConfig $config
     *           Updated configuration for the storedInfoType. If not provided, a new
     *           version of the storedInfoType will be created with the existing
     *           configuration.
     *     @type FieldMask $updateMask
     *           Mask to control which fields get updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dlp\V2\StoredInfoType
     *
     * @throws ApiException if the remote call fails
     */
    public function updateStoredInfoType($name, array $optionalArgs = [])
    {
        $request = new UpdateStoredInfoTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['config'])) {
            $request->setConfig($optionalArgs['config']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateStoredInfoType',
            StoredInfoType::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
