<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration options for private clusters.
 *
 * Generated from protobuf message <code>google.container.v1.PrivateClusterConfig</code>
 */
class PrivateClusterConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Whether nodes have internal IP addresses only. If enabled, all nodes are
     * given only RFC 1918 private addresses and communicate with the master via
     * private networking.
     *
     * Generated from protobuf field <code>bool enable_private_nodes = 1;</code>
     */
    private $enable_private_nodes = false;
    /**
     * Whether the master's internal IP address is used as the cluster endpoint.
     *
     * Generated from protobuf field <code>bool enable_private_endpoint = 2;</code>
     */
    private $enable_private_endpoint = false;
    /**
     * The IP range in CIDR notation to use for the hosted master network. This
     * range will be used for assigning internal IP addresses to the master or
     * set of masters, as well as the ILB VIP. This range must not overlap with
     * any other ranges in use within the cluster's network.
     *
     * Generated from protobuf field <code>string master_ipv4_cidr_block = 3;</code>
     */
    private $master_ipv4_cidr_block = '';
    /**
     * Output only. The internal IP address of this cluster's master endpoint.
     *
     * Generated from protobuf field <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $private_endpoint = '';
    /**
     * Output only. The external IP address of this cluster's master endpoint.
     *
     * Generated from protobuf field <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $public_endpoint = '';
    /**
     * Output only. The peering name in the customer VPC used by this cluster.
     *
     * Generated from protobuf field <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $peering_name = '';
    /**
     * Controls master global access settings.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;</code>
     */
    private $master_global_access_config = null;
    /**
     * Subnet to provision the master's private endpoint during cluster creation.
     * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     *
     * Generated from protobuf field <code>string private_endpoint_subnetwork = 10;</code>
     */
    private $private_endpoint_subnetwork = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enable_private_nodes
     *           Whether nodes have internal IP addresses only. If enabled, all nodes are
     *           given only RFC 1918 private addresses and communicate with the master via
     *           private networking.
     *     @type bool $enable_private_endpoint
     *           Whether the master's internal IP address is used as the cluster endpoint.
     *     @type string $master_ipv4_cidr_block
     *           The IP range in CIDR notation to use for the hosted master network. This
     *           range will be used for assigning internal IP addresses to the master or
     *           set of masters, as well as the ILB VIP. This range must not overlap with
     *           any other ranges in use within the cluster's network.
     *     @type string $private_endpoint
     *           Output only. The internal IP address of this cluster's master endpoint.
     *     @type string $public_endpoint
     *           Output only. The external IP address of this cluster's master endpoint.
     *     @type string $peering_name
     *           Output only. The peering name in the customer VPC used by this cluster.
     *     @type \Google\Cloud\Container\V1\PrivateClusterMasterGlobalAccessConfig $master_global_access_config
     *           Controls master global access settings.
     *     @type string $private_endpoint_subnetwork
     *           Subnet to provision the master's private endpoint during cluster creation.
     *           Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Whether nodes have internal IP addresses only. If enabled, all nodes are
     * given only RFC 1918 private addresses and communicate with the master via
     * private networking.
     *
     * Generated from protobuf field <code>bool enable_private_nodes = 1;</code>
     * @return bool
     */
    public function getEnablePrivateNodes()
    {
        return $this->enable_private_nodes;
    }

    /**
     * Whether nodes have internal IP addresses only. If enabled, all nodes are
     * given only RFC 1918 private addresses and communicate with the master via
     * private networking.
     *
     * Generated from protobuf field <code>bool enable_private_nodes = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnablePrivateNodes($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_private_nodes = $var;

        return $this;
    }

    /**
     * Whether the master's internal IP address is used as the cluster endpoint.
     *
     * Generated from protobuf field <code>bool enable_private_endpoint = 2;</code>
     * @return bool
     */
    public function getEnablePrivateEndpoint()
    {
        return $this->enable_private_endpoint;
    }

    /**
     * Whether the master's internal IP address is used as the cluster endpoint.
     *
     * Generated from protobuf field <code>bool enable_private_endpoint = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnablePrivateEndpoint($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_private_endpoint = $var;

        return $this;
    }

    /**
     * The IP range in CIDR notation to use for the hosted master network. This
     * range will be used for assigning internal IP addresses to the master or
     * set of masters, as well as the ILB VIP. This range must not overlap with
     * any other ranges in use within the cluster's network.
     *
     * Generated from protobuf field <code>string master_ipv4_cidr_block = 3;</code>
     * @return string
     */
    public function getMasterIpv4CidrBlock()
    {
        return $this->master_ipv4_cidr_block;
    }

    /**
     * The IP range in CIDR notation to use for the hosted master network. This
     * range will be used for assigning internal IP addresses to the master or
     * set of masters, as well as the ILB VIP. This range must not overlap with
     * any other ranges in use within the cluster's network.
     *
     * Generated from protobuf field <code>string master_ipv4_cidr_block = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setMasterIpv4CidrBlock($var)
    {
        GPBUtil::checkString($var, True);
        $this->master_ipv4_cidr_block = $var;

        return $this;
    }

    /**
     * Output only. The internal IP address of this cluster's master endpoint.
     *
     * Generated from protobuf field <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPrivateEndpoint()
    {
        return $this->private_endpoint;
    }

    /**
     * Output only. The internal IP address of this cluster's master endpoint.
     *
     * Generated from protobuf field <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_endpoint = $var;

        return $this;
    }

    /**
     * Output only. The external IP address of this cluster's master endpoint.
     *
     * Generated from protobuf field <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPublicEndpoint()
    {
        return $this->public_endpoint;
    }

    /**
     * Output only. The external IP address of this cluster's master endpoint.
     *
     * Generated from protobuf field <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPublicEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->public_endpoint = $var;

        return $this;
    }

    /**
     * Output only. The peering name in the customer VPC used by this cluster.
     *
     * Generated from protobuf field <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPeeringName()
    {
        return $this->peering_name;
    }

    /**
     * Output only. The peering name in the customer VPC used by this cluster.
     *
     * Generated from protobuf field <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPeeringName($var)
    {
        GPBUtil::checkString($var, True);
        $this->peering_name = $var;

        return $this;
    }

    /**
     * Controls master global access settings.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;</code>
     * @return \Google\Cloud\Container\V1\PrivateClusterMasterGlobalAccessConfig|null
     */
    public function getMasterGlobalAccessConfig()
    {
        return $this->master_global_access_config;
    }

    public function hasMasterGlobalAccessConfig()
    {
        return isset($this->master_global_access_config);
    }

    public function clearMasterGlobalAccessConfig()
    {
        unset($this->master_global_access_config);
    }

    /**
     * Controls master global access settings.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;</code>
     * @param \Google\Cloud\Container\V1\PrivateClusterMasterGlobalAccessConfig $var
     * @return $this
     */
    public function setMasterGlobalAccessConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\PrivateClusterMasterGlobalAccessConfig::class);
        $this->master_global_access_config = $var;

        return $this;
    }

    /**
     * Subnet to provision the master's private endpoint during cluster creation.
     * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     *
     * Generated from protobuf field <code>string private_endpoint_subnetwork = 10;</code>
     * @return string
     */
    public function getPrivateEndpointSubnetwork()
    {
        return $this->private_endpoint_subnetwork;
    }

    /**
     * Subnet to provision the master's private endpoint during cluster creation.
     * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     *
     * Generated from protobuf field <code>string private_endpoint_subnetwork = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateEndpointSubnetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_endpoint_subnetwork = $var;

        return $this;
    }

}

