<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/admin/v2/table.proto

namespace Google\Cloud\Bigtable\Admin\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Rule for determining which cells to delete during garbage collection.
 *
 * Generated from protobuf message <code>google.bigtable.admin.v2.GcRule</code>
 */
class GcRule extends \Google\Protobuf\Internal\Message
{
    protected $rule;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $max_num_versions
     *           Delete all cells in a column except the most recent N.
     *     @type \Google\Protobuf\Duration $max_age
     *           Delete cells in a column older than the given age.
     *           Values must be at least one millisecond, and will be truncated to
     *           microsecond granularity.
     *     @type \Google\Cloud\Bigtable\Admin\V2\GcRule\Intersection $intersection
     *           Delete cells that would be deleted by every nested rule.
     *     @type \Google\Cloud\Bigtable\Admin\V2\GcRule\Union $union
     *           Delete cells that would be deleted by any nested rule.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\Admin\V2\Table::initOnce();
        parent::__construct($data);
    }

    /**
     * Delete all cells in a column except the most recent N.
     *
     * Generated from protobuf field <code>int32 max_num_versions = 1;</code>
     * @return int
     */
    public function getMaxNumVersions()
    {
        return $this->readOneof(1);
    }

    public function hasMaxNumVersions()
    {
        return $this->hasOneof(1);
    }

    /**
     * Delete all cells in a column except the most recent N.
     *
     * Generated from protobuf field <code>int32 max_num_versions = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxNumVersions($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Delete cells in a column older than the given age.
     * Values must be at least one millisecond, and will be truncated to
     * microsecond granularity.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_age = 2;</code>
     * @return \Google\Protobuf\Duration
     */
    public function getMaxAge()
    {
        return $this->readOneof(2);
    }

    public function hasMaxAge()
    {
        return $this->hasOneof(2);
    }

    /**
     * Delete cells in a column older than the given age.
     * Values must be at least one millisecond, and will be truncated to
     * microsecond granularity.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_age = 2;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMaxAge($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Delete cells that would be deleted by every nested rule.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.GcRule.Intersection intersection = 3;</code>
     * @return \Google\Cloud\Bigtable\Admin\V2\GcRule\Intersection
     */
    public function getIntersection()
    {
        return $this->readOneof(3);
    }

    public function hasIntersection()
    {
        return $this->hasOneof(3);
    }

    /**
     * Delete cells that would be deleted by every nested rule.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.GcRule.Intersection intersection = 3;</code>
     * @param \Google\Cloud\Bigtable\Admin\V2\GcRule\Intersection $var
     * @return $this
     */
    public function setIntersection($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\Admin\V2\GcRule\Intersection::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Delete cells that would be deleted by any nested rule.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.GcRule.Union union = 4;</code>
     * @return \Google\Cloud\Bigtable\Admin\V2\GcRule\Union
     */
    public function getUnion()
    {
        return $this->readOneof(4);
    }

    public function hasUnion()
    {
        return $this->hasOneof(4);
    }

    /**
     * Delete cells that would be deleted by any nested rule.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.GcRule.Union union = 4;</code>
     * @param \Google\Cloud\Bigtable\Admin\V2\GcRule\Union $var
     * @return $this
     */
    public function setUnion($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\Admin\V2\GcRule\Union::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getRule()
    {
        return $this->whichOneof("rule");
    }

}

