<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/websecurityscanner/v1/web_security_scanner.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\WebSecurityScanner\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\WebSecurityScanner\V1\CreateScanConfigRequest;
use Google\Cloud\WebSecurityScanner\V1\DeleteScanConfigRequest;
use Google\Cloud\WebSecurityScanner\V1\Finding;
use Google\Cloud\WebSecurityScanner\V1\GetFindingRequest;
use Google\Cloud\WebSecurityScanner\V1\GetScanConfigRequest;
use Google\Cloud\WebSecurityScanner\V1\GetScanRunRequest;
use Google\Cloud\WebSecurityScanner\V1\ListCrawledUrlsRequest;
use Google\Cloud\WebSecurityScanner\V1\ListFindingTypeStatsRequest;
use Google\Cloud\WebSecurityScanner\V1\ListFindingTypeStatsResponse;
use Google\Cloud\WebSecurityScanner\V1\ListFindingsRequest;
use Google\Cloud\WebSecurityScanner\V1\ListScanConfigsRequest;
use Google\Cloud\WebSecurityScanner\V1\ListScanRunsRequest;
use Google\Cloud\WebSecurityScanner\V1\ScanConfig;
use Google\Cloud\WebSecurityScanner\V1\ScanRun;
use Google\Cloud\WebSecurityScanner\V1\StartScanRunRequest;
use Google\Cloud\WebSecurityScanner\V1\StopScanRunRequest;
use Google\Cloud\WebSecurityScanner\V1\UpdateScanConfigRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Web Security Scanner Service identifies security vulnerabilities in web
 * applications hosted on Google Cloud. It crawls your application, and
 * attempts to exercise as many user inputs and event handlers as possible.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createScanConfigAsync(CreateScanConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteScanConfigAsync(DeleteScanConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getFindingAsync(GetFindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getScanConfigAsync(GetScanConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getScanRunAsync(GetScanRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCrawledUrlsAsync(ListCrawledUrlsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listFindingTypeStatsAsync(ListFindingTypeStatsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listFindingsAsync(ListFindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listScanConfigsAsync(ListScanConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listScanRunsAsync(ListScanRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface startScanRunAsync(StartScanRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface stopScanRunAsync(StopScanRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateScanConfigAsync(UpdateScanConfigRequest $request, array $optionalArgs = [])
 */
abstract class WebSecurityScannerBaseClient
{
    use GapicClientTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.websecurityscanner.v1.WebSecurityScanner';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'websecurityscanner.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/web_security_scanner_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/web_security_scanner_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/web_security_scanner_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/web_security_scanner_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'websecurityscanner.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new ScanConfig.
     *
     * The async variant is {@see self::createScanConfigAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/create_scan_config.php
     *
     * @param CreateScanConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScanConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createScanConfig(CreateScanConfigRequest $request, array $callOptions = []): ScanConfig
    {
        return $this->startApiCall('CreateScanConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing ScanConfig and its child resources.
     *
     * The async variant is {@see self::deleteScanConfigAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/delete_scan_config.php
     *
     * @param DeleteScanConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteScanConfig(DeleteScanConfigRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteScanConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a Finding.
     *
     * The async variant is {@see self::getFindingAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/get_finding.php
     *
     * @param GetFindingRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Finding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFinding(GetFindingRequest $request, array $callOptions = []): Finding
    {
        return $this->startApiCall('GetFinding', $request, $callOptions)->wait();
    }

    /**
     * Gets a ScanConfig.
     *
     * The async variant is {@see self::getScanConfigAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/get_scan_config.php
     *
     * @param GetScanConfigRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScanConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getScanConfig(GetScanConfigRequest $request, array $callOptions = []): ScanConfig
    {
        return $this->startApiCall('GetScanConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a ScanRun.
     *
     * The async variant is {@see self::getScanRunAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/get_scan_run.php
     *
     * @param GetScanRunRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScanRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getScanRun(GetScanRunRequest $request, array $callOptions = []): ScanRun
    {
        return $this->startApiCall('GetScanRun', $request, $callOptions)->wait();
    }

    /**
     * List CrawledUrls under a given ScanRun.
     *
     * The async variant is {@see self::listCrawledUrlsAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/list_crawled_urls.php
     *
     * @param ListCrawledUrlsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCrawledUrls(ListCrawledUrlsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCrawledUrls', $request, $callOptions);
    }

    /**
     * List all FindingTypeStats under a given ScanRun.
     *
     * The async variant is {@see self::listFindingTypeStatsAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/list_finding_type_stats.php
     *
     * @param ListFindingTypeStatsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListFindingTypeStatsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFindingTypeStats(ListFindingTypeStatsRequest $request, array $callOptions = []): ListFindingTypeStatsResponse
    {
        return $this->startApiCall('ListFindingTypeStats', $request, $callOptions)->wait();
    }

    /**
     * List Findings under a given ScanRun.
     *
     * The async variant is {@see self::listFindingsAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/list_findings.php
     *
     * @param ListFindingsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFindings(ListFindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFindings', $request, $callOptions);
    }

    /**
     * Lists ScanConfigs under a given project.
     *
     * The async variant is {@see self::listScanConfigsAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/list_scan_configs.php
     *
     * @param ListScanConfigsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listScanConfigs(ListScanConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListScanConfigs', $request, $callOptions);
    }

    /**
     * Lists ScanRuns under a given ScanConfig, in descending order of ScanRun
     * stop time.
     *
     * The async variant is {@see self::listScanRunsAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/list_scan_runs.php
     *
     * @param ListScanRunsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listScanRuns(ListScanRunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListScanRuns', $request, $callOptions);
    }

    /**
     * Start a ScanRun according to the given ScanConfig.
     *
     * The async variant is {@see self::startScanRunAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/start_scan_run.php
     *
     * @param StartScanRunRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScanRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startScanRun(StartScanRunRequest $request, array $callOptions = []): ScanRun
    {
        return $this->startApiCall('StartScanRun', $request, $callOptions)->wait();
    }

    /**
     * Stops a ScanRun. The stopped ScanRun is returned.
     *
     * The async variant is {@see self::stopScanRunAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/stop_scan_run.php
     *
     * @param StopScanRunRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScanRun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopScanRun(StopScanRunRequest $request, array $callOptions = []): ScanRun
    {
        return $this->startApiCall('StopScanRun', $request, $callOptions)->wait();
    }

    /**
     * Updates a ScanConfig. This method support partial update of a ScanConfig.
     *
     * The async variant is {@see self::updateScanConfigAsync()} .
     *
     * @example samples/V1/WebSecurityScannerClient/update_scan_config.php
     *
     * @param UpdateScanConfigRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScanConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateScanConfig(UpdateScanConfigRequest $request, array $callOptions = []): ScanConfig
    {
        return $this->startApiCall('UpdateScanConfig', $request, $callOptions)->wait();
    }
}
