<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4beta1/job_service.proto

namespace Google\Cloud\Talent\V4beta1\SearchJobsRequest;

use UnexpectedValueException;

/**
 * Controls what keyword matching behavior the search has. When keyword
 * matching is enabled, a keyword match returns jobs that may not match given
 * category filters when there are matching keywords. For example, for the
 * query "program manager" with KeywordMatchMode set to KEYWORD_MATCH_ALL, a
 * job posting with the title "software developer," which doesn't fall into
 * "program manager" ontology, and "program manager" appearing in its
 * description will be surfaced.
 * For queries like "cloud" that don't contain title or
 * location specific ontology, jobs with "cloud" keyword matches are returned
 * regardless of this enum's value.
 * Use
 * [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4beta1.Company.keyword_searchable_job_custom_attributes]
 * if company-specific globally matched custom field/attribute string values
 * are needed. Enabling keyword match improves recall of subsequent search
 * requests.
 *
 * Protobuf type <code>google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode</code>
 */
class KeywordMatchMode
{
    /**
     * The keyword match option isn't specified. Defaults to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
     * behavior.
     *
     * Generated from protobuf enum <code>KEYWORD_MATCH_MODE_UNSPECIFIED = 0;</code>
     */
    const KEYWORD_MATCH_MODE_UNSPECIFIED = 0;
    /**
     * Disables keyword matching.
     *
     * Generated from protobuf enum <code>KEYWORD_MATCH_DISABLED = 1;</code>
     */
    const KEYWORD_MATCH_DISABLED = 1;
    /**
     * Enable keyword matching over
     * [Job.title][google.cloud.talent.v4beta1.Job.title],
     * [Job.description][google.cloud.talent.v4beta1.Job.description],
     * [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name],
     * [Job.addresses][google.cloud.talent.v4beta1.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications], and
     * keyword searchable
     * [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes]
     * fields.
     *
     * Generated from protobuf enum <code>KEYWORD_MATCH_ALL = 2;</code>
     */
    const KEYWORD_MATCH_ALL = 2;
    /**
     * Only enable keyword matching over
     * [Job.title][google.cloud.talent.v4beta1.Job.title].
     *
     * Generated from protobuf enum <code>KEYWORD_MATCH_TITLE_ONLY = 3;</code>
     */
    const KEYWORD_MATCH_TITLE_ONLY = 3;

    private static $valueToName = [
        self::KEYWORD_MATCH_MODE_UNSPECIFIED => 'KEYWORD_MATCH_MODE_UNSPECIFIED',
        self::KEYWORD_MATCH_DISABLED => 'KEYWORD_MATCH_DISABLED',
        self::KEYWORD_MATCH_ALL => 'KEYWORD_MATCH_ALL',
        self::KEYWORD_MATCH_TITLE_ONLY => 'KEYWORD_MATCH_TITLE_ONLY',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


