<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4/company_service.proto

namespace Google\Cloud\Talent\V4;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * List companies for which the client has ACL visibility.
 *
 * Generated from protobuf message <code>google.cloud.talent.v4.ListCompaniesRequest</code>
 */
class ListCompaniesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Resource name of the tenant under which the company is created.
     * The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * The starting indicator from which to return results.
     *
     * Generated from protobuf field <code>string page_token = 2;</code>
     */
    private $page_token = '';
    /**
     * The maximum number of companies to be returned, at most 100.
     * Default is 100 if a non-positive number is provided.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     */
    private $page_size = 0;
    /**
     * Set to true if the companies requested must have open jobs.
     * Defaults to false.
     * If true, at most
     * [page_size][google.cloud.talent.v4.ListCompaniesRequest.page_size] of
     * companies are fetched, among which only those with open jobs are returned.
     *
     * Generated from protobuf field <code>bool require_open_jobs = 4;</code>
     */
    private $require_open_jobs = false;

    /**
     * @param string $parent Required. Resource name of the tenant under which the company is created.
     *
     *                       The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     *                       "projects/foo/tenants/bar". Please see
     *                       {@see CompanyServiceClient::tenantName()} for help formatting this field.
     *
     * @return \Google\Cloud\Talent\V4\ListCompaniesRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. Resource name of the tenant under which the company is created.
     *           The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     *           "projects/foo/tenants/bar".
     *     @type string $page_token
     *           The starting indicator from which to return results.
     *     @type int $page_size
     *           The maximum number of companies to be returned, at most 100.
     *           Default is 100 if a non-positive number is provided.
     *     @type bool $require_open_jobs
     *           Set to true if the companies requested must have open jobs.
     *           Defaults to false.
     *           If true, at most
     *           [page_size][google.cloud.talent.v4.ListCompaniesRequest.page_size] of
     *           companies are fetched, among which only those with open jobs are returned.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4\CompanyService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Resource name of the tenant under which the company is created.
     * The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. Resource name of the tenant under which the company is created.
     * The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The starting indicator from which to return results.
     *
     * Generated from protobuf field <code>string page_token = 2;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * The starting indicator from which to return results.
     *
     * Generated from protobuf field <code>string page_token = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * The maximum number of companies to be returned, at most 100.
     * Default is 100 if a non-positive number is provided.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of companies to be returned, at most 100.
     * Default is 100 if a non-positive number is provided.
     *
     * Generated from protobuf field <code>int32 page_size = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Set to true if the companies requested must have open jobs.
     * Defaults to false.
     * If true, at most
     * [page_size][google.cloud.talent.v4.ListCompaniesRequest.page_size] of
     * companies are fetched, among which only those with open jobs are returned.
     *
     * Generated from protobuf field <code>bool require_open_jobs = 4;</code>
     * @return bool
     */
    public function getRequireOpenJobs()
    {
        return $this->require_open_jobs;
    }

    /**
     * Set to true if the companies requested must have open jobs.
     * Defaults to false.
     * If true, at most
     * [page_size][google.cloud.talent.v4.ListCompaniesRequest.page_size] of
     * companies are fetched, among which only those with open jobs are returned.
     *
     * Generated from protobuf field <code>bool require_open_jobs = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setRequireOpenJobs($var)
    {
        GPBUtil::checkBool($var);
        $this->require_open_jobs = $var;

        return $this;
    }

}

