<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Transfers can be scheduled to recur or to run just once.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.Schedule</code>
 */
class Schedule extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The start date of a transfer. Date boundaries are determined
     * relative to UTC time. If `schedule_start_date` and [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day]
     * are in the past relative to the job's creation time, the transfer starts
     * the day after you schedule the transfer request.
     * **Note:** When starting jobs at or near midnight UTC it is possible that
     * a job starts later than expected. For example, if you send an outbound
     * request on June 1 one millisecond prior to midnight UTC and the Storage
     * Transfer Service server receives the request on June 2, then it creates
     * a TransferJob with `schedule_start_date` set to June 2 and a
     * `start_time_of_day` set to midnight UTC. The first scheduled
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] takes place on June 3 at midnight UTC.
     *
     * Generated from protobuf field <code>.google.type.Date schedule_start_date = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $schedule_start_date = null;
    /**
     * The last day a transfer runs. Date boundaries are determined relative to
     * UTC time. A job runs once per 24 hours within the following guidelines:
     * *   If `schedule_end_date` and [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date] are the same and in
     *     the future relative to UTC, the transfer is executed only one time.
     * *   If `schedule_end_date` is later than `schedule_start_date`  and
     *     `schedule_end_date` is in the future relative to UTC, the job runs each
     *     day at [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day] through `schedule_end_date`.
     *
     * Generated from protobuf field <code>.google.type.Date schedule_end_date = 2;</code>
     */
    private $schedule_end_date = null;
    /**
     * The time in UTC that a transfer job is scheduled to run. Transfers may
     * start later than this time.
     * If `start_time_of_day` is not specified:
     * *   One-time transfers run immediately.
     * *   Recurring transfers run immediately, and each day at midnight UTC,
     *     through [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date].
     * If `start_time_of_day` is specified:
     * *   One-time transfers run at the specified time.
     * *   Recurring transfers run at the specified time each day, through
     *     `schedule_end_date`.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time_of_day = 3;</code>
     */
    private $start_time_of_day = null;
    /**
     * The time in UTC that no further transfer operations are scheduled. Combined
     * with [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date], `end_time_of_day` specifies the end date and
     * time for starting new transfer operations. This field must be greater than
     * or equal to the timestamp corresponding to the combintation of
     * [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date] and [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day], and is subject to the
     * following:
     * *   If `end_time_of_day` is not set and `schedule_end_date` is set, then
     *     a default value of `23:59:59` is used for `end_time_of_day`.
     * *   If `end_time_of_day` is set and `schedule_end_date` is not set, then
     *     [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] is returned.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay end_time_of_day = 4;</code>
     */
    private $end_time_of_day = null;
    /**
     * Interval between the start of each scheduled TransferOperation. If
     * unspecified, the default value is 24 hours. This value may not be less than
     * 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration repeat_interval = 5;</code>
     */
    private $repeat_interval = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Type\Date $schedule_start_date
     *           Required. The start date of a transfer. Date boundaries are determined
     *           relative to UTC time. If `schedule_start_date` and [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day]
     *           are in the past relative to the job's creation time, the transfer starts
     *           the day after you schedule the transfer request.
     *           **Note:** When starting jobs at or near midnight UTC it is possible that
     *           a job starts later than expected. For example, if you send an outbound
     *           request on June 1 one millisecond prior to midnight UTC and the Storage
     *           Transfer Service server receives the request on June 2, then it creates
     *           a TransferJob with `schedule_start_date` set to June 2 and a
     *           `start_time_of_day` set to midnight UTC. The first scheduled
     *           [TransferOperation][google.storagetransfer.v1.TransferOperation] takes place on June 3 at midnight UTC.
     *     @type \Google\Type\Date $schedule_end_date
     *           The last day a transfer runs. Date boundaries are determined relative to
     *           UTC time. A job runs once per 24 hours within the following guidelines:
     *           *   If `schedule_end_date` and [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date] are the same and in
     *               the future relative to UTC, the transfer is executed only one time.
     *           *   If `schedule_end_date` is later than `schedule_start_date`  and
     *               `schedule_end_date` is in the future relative to UTC, the job runs each
     *               day at [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day] through `schedule_end_date`.
     *     @type \Google\Type\TimeOfDay $start_time_of_day
     *           The time in UTC that a transfer job is scheduled to run. Transfers may
     *           start later than this time.
     *           If `start_time_of_day` is not specified:
     *           *   One-time transfers run immediately.
     *           *   Recurring transfers run immediately, and each day at midnight UTC,
     *               through [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date].
     *           If `start_time_of_day` is specified:
     *           *   One-time transfers run at the specified time.
     *           *   Recurring transfers run at the specified time each day, through
     *               `schedule_end_date`.
     *     @type \Google\Type\TimeOfDay $end_time_of_day
     *           The time in UTC that no further transfer operations are scheduled. Combined
     *           with [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date], `end_time_of_day` specifies the end date and
     *           time for starting new transfer operations. This field must be greater than
     *           or equal to the timestamp corresponding to the combintation of
     *           [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date] and [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day], and is subject to the
     *           following:
     *           *   If `end_time_of_day` is not set and `schedule_end_date` is set, then
     *               a default value of `23:59:59` is used for `end_time_of_day`.
     *           *   If `end_time_of_day` is set and `schedule_end_date` is not set, then
     *               [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] is returned.
     *     @type \Google\Protobuf\Duration $repeat_interval
     *           Interval between the start of each scheduled TransferOperation. If
     *           unspecified, the default value is 24 hours. This value may not be less than
     *           1 hour.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The start date of a transfer. Date boundaries are determined
     * relative to UTC time. If `schedule_start_date` and [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day]
     * are in the past relative to the job's creation time, the transfer starts
     * the day after you schedule the transfer request.
     * **Note:** When starting jobs at or near midnight UTC it is possible that
     * a job starts later than expected. For example, if you send an outbound
     * request on June 1 one millisecond prior to midnight UTC and the Storage
     * Transfer Service server receives the request on June 2, then it creates
     * a TransferJob with `schedule_start_date` set to June 2 and a
     * `start_time_of_day` set to midnight UTC. The first scheduled
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] takes place on June 3 at midnight UTC.
     *
     * Generated from protobuf field <code>.google.type.Date schedule_start_date = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Type\Date|null
     */
    public function getScheduleStartDate()
    {
        return $this->schedule_start_date;
    }

    public function hasScheduleStartDate()
    {
        return isset($this->schedule_start_date);
    }

    public function clearScheduleStartDate()
    {
        unset($this->schedule_start_date);
    }

    /**
     * Required. The start date of a transfer. Date boundaries are determined
     * relative to UTC time. If `schedule_start_date` and [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day]
     * are in the past relative to the job's creation time, the transfer starts
     * the day after you schedule the transfer request.
     * **Note:** When starting jobs at or near midnight UTC it is possible that
     * a job starts later than expected. For example, if you send an outbound
     * request on June 1 one millisecond prior to midnight UTC and the Storage
     * Transfer Service server receives the request on June 2, then it creates
     * a TransferJob with `schedule_start_date` set to June 2 and a
     * `start_time_of_day` set to midnight UTC. The first scheduled
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] takes place on June 3 at midnight UTC.
     *
     * Generated from protobuf field <code>.google.type.Date schedule_start_date = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setScheduleStartDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->schedule_start_date = $var;

        return $this;
    }

    /**
     * The last day a transfer runs. Date boundaries are determined relative to
     * UTC time. A job runs once per 24 hours within the following guidelines:
     * *   If `schedule_end_date` and [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date] are the same and in
     *     the future relative to UTC, the transfer is executed only one time.
     * *   If `schedule_end_date` is later than `schedule_start_date`  and
     *     `schedule_end_date` is in the future relative to UTC, the job runs each
     *     day at [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day] through `schedule_end_date`.
     *
     * Generated from protobuf field <code>.google.type.Date schedule_end_date = 2;</code>
     * @return \Google\Type\Date|null
     */
    public function getScheduleEndDate()
    {
        return $this->schedule_end_date;
    }

    public function hasScheduleEndDate()
    {
        return isset($this->schedule_end_date);
    }

    public function clearScheduleEndDate()
    {
        unset($this->schedule_end_date);
    }

    /**
     * The last day a transfer runs. Date boundaries are determined relative to
     * UTC time. A job runs once per 24 hours within the following guidelines:
     * *   If `schedule_end_date` and [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date] are the same and in
     *     the future relative to UTC, the transfer is executed only one time.
     * *   If `schedule_end_date` is later than `schedule_start_date`  and
     *     `schedule_end_date` is in the future relative to UTC, the job runs each
     *     day at [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day] through `schedule_end_date`.
     *
     * Generated from protobuf field <code>.google.type.Date schedule_end_date = 2;</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setScheduleEndDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->schedule_end_date = $var;

        return $this;
    }

    /**
     * The time in UTC that a transfer job is scheduled to run. Transfers may
     * start later than this time.
     * If `start_time_of_day` is not specified:
     * *   One-time transfers run immediately.
     * *   Recurring transfers run immediately, and each day at midnight UTC,
     *     through [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date].
     * If `start_time_of_day` is specified:
     * *   One-time transfers run at the specified time.
     * *   Recurring transfers run at the specified time each day, through
     *     `schedule_end_date`.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time_of_day = 3;</code>
     * @return \Google\Type\TimeOfDay|null
     */
    public function getStartTimeOfDay()
    {
        return $this->start_time_of_day;
    }

    public function hasStartTimeOfDay()
    {
        return isset($this->start_time_of_day);
    }

    public function clearStartTimeOfDay()
    {
        unset($this->start_time_of_day);
    }

    /**
     * The time in UTC that a transfer job is scheduled to run. Transfers may
     * start later than this time.
     * If `start_time_of_day` is not specified:
     * *   One-time transfers run immediately.
     * *   Recurring transfers run immediately, and each day at midnight UTC,
     *     through [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date].
     * If `start_time_of_day` is specified:
     * *   One-time transfers run at the specified time.
     * *   Recurring transfers run at the specified time each day, through
     *     `schedule_end_date`.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time_of_day = 3;</code>
     * @param \Google\Type\TimeOfDay $var
     * @return $this
     */
    public function setStartTimeOfDay($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\TimeOfDay::class);
        $this->start_time_of_day = $var;

        return $this;
    }

    /**
     * The time in UTC that no further transfer operations are scheduled. Combined
     * with [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date], `end_time_of_day` specifies the end date and
     * time for starting new transfer operations. This field must be greater than
     * or equal to the timestamp corresponding to the combintation of
     * [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date] and [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day], and is subject to the
     * following:
     * *   If `end_time_of_day` is not set and `schedule_end_date` is set, then
     *     a default value of `23:59:59` is used for `end_time_of_day`.
     * *   If `end_time_of_day` is set and `schedule_end_date` is not set, then
     *     [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] is returned.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay end_time_of_day = 4;</code>
     * @return \Google\Type\TimeOfDay|null
     */
    public function getEndTimeOfDay()
    {
        return $this->end_time_of_day;
    }

    public function hasEndTimeOfDay()
    {
        return isset($this->end_time_of_day);
    }

    public function clearEndTimeOfDay()
    {
        unset($this->end_time_of_day);
    }

    /**
     * The time in UTC that no further transfer operations are scheduled. Combined
     * with [schedule_end_date][google.storagetransfer.v1.Schedule.schedule_end_date], `end_time_of_day` specifies the end date and
     * time for starting new transfer operations. This field must be greater than
     * or equal to the timestamp corresponding to the combintation of
     * [schedule_start_date][google.storagetransfer.v1.Schedule.schedule_start_date] and [start_time_of_day][google.storagetransfer.v1.Schedule.start_time_of_day], and is subject to the
     * following:
     * *   If `end_time_of_day` is not set and `schedule_end_date` is set, then
     *     a default value of `23:59:59` is used for `end_time_of_day`.
     * *   If `end_time_of_day` is set and `schedule_end_date` is not set, then
     *     [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] is returned.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay end_time_of_day = 4;</code>
     * @param \Google\Type\TimeOfDay $var
     * @return $this
     */
    public function setEndTimeOfDay($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\TimeOfDay::class);
        $this->end_time_of_day = $var;

        return $this;
    }

    /**
     * Interval between the start of each scheduled TransferOperation. If
     * unspecified, the default value is 24 hours. This value may not be less than
     * 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration repeat_interval = 5;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getRepeatInterval()
    {
        return $this->repeat_interval;
    }

    public function hasRepeatInterval()
    {
        return isset($this->repeat_interval);
    }

    public function clearRepeatInterval()
    {
        unset($this->repeat_interval);
    }

    /**
     * Interval between the start of each scheduled TransferOperation. If
     * unspecified, the default value is 24 hours. This value may not be less than
     * 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration repeat_interval = 5;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setRepeatInterval($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->repeat_interval = $var;

        return $this;
    }

}

