<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/resourcemanager/v3/folders.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ResourceManager\V3\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\ResourceManager\V3\CreateFolderRequest;
use Google\Cloud\ResourceManager\V3\DeleteFolderRequest;
use Google\Cloud\ResourceManager\V3\Folder;
use Google\Cloud\ResourceManager\V3\GetFolderRequest;
use Google\Cloud\ResourceManager\V3\ListFoldersRequest;
use Google\Cloud\ResourceManager\V3\MoveFolderRequest;
use Google\Cloud\ResourceManager\V3\SearchFoldersRequest;
use Google\Cloud\ResourceManager\V3\UndeleteFolderRequest;
use Google\Cloud\ResourceManager\V3\UpdateFolderRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Manages Cloud Platform folder resources.
 * Folders can be used to organize the resources under an
 * organization and to control the policies applied to groups of resources.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\ResourceManager\V3\FoldersClient} for the stable implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createFolderAsync(CreateFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteFolderAsync(DeleteFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getFolderAsync(GetFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listFoldersAsync(ListFoldersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface moveFolderAsync(MoveFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchFoldersAsync(SearchFoldersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeleteFolderAsync(UndeleteFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateFolderAsync(UpdateFolderRequest $request, array $optionalArgs = [])
 */
abstract class FoldersBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.resourcemanager.v3.Folders';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'cloudresourcemanager.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/folders_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/folders_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/folders_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/folders_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - folder: folders/{folder}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudresourcemanager.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a folder in the resource hierarchy.
     * Returns an `Operation` which can be used to track the progress of the
     * folder creation workflow.
     * Upon success, the `Operation.response` field will be populated with the
     * created Folder.
     *
     * In order to succeed, the addition of this new folder must not violate
     * the folder naming, height, or fanout constraints.
     *
     * + The folder's `display_name` must be distinct from all other folders that
     * share its parent.
     * + The addition of the folder must not cause the active folder hierarchy
     * to exceed a height of 10. Note, the full active + deleted folder hierarchy
     * is allowed to reach a height of 20; this provides additional headroom when
     * moving folders that contain deleted folders.
     * + The addition of the folder must not cause the total number of folders
     * under its parent to exceed 300.
     *
     * If the operation fails due to a folder constraint violation, some errors
     * may be returned by the `CreateFolder` request, with status code
     * `FAILED_PRECONDITION` and an error description. Other folder constraint
     * violations will be communicated in the `Operation`, with the specific
     * `PreconditionFailure` returned in the details list in the `Operation.error`
     * field.
     *
     * The caller must have `resourcemanager.folders.create` permission on the
     * identified parent.
     *
     * The async variant is {@see self::createFolderAsync()} .
     *
     * @example samples/V3/FoldersClient/create_folder.php
     *
     * @param CreateFolderRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFolder(CreateFolderRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateFolder', $request, $callOptions)->wait();
    }

    /**
     * Requests deletion of a folder. The folder is moved into the
     * [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
     * state immediately, and is deleted approximately 30 days later. This method
     * may only be called on an empty folder, where a folder is empty if it
     * doesn't contain any folders or projects in the
     * [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. If
     * called on a folder in
     * [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
     * state the operation will result in a no-op success.
     * The caller must have `resourcemanager.folders.delete` permission on the
     * identified folder.
     *
     * The async variant is {@see self::deleteFolderAsync()} .
     *
     * @example samples/V3/FoldersClient/delete_folder.php
     *
     * @param DeleteFolderRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFolder(DeleteFolderRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteFolder', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a folder identified by the supplied resource name.
     * Valid folder resource names have the format `folders/{folder_id}`
     * (for example, `folders/1234`).
     * The caller must have `resourcemanager.folders.get` permission on the
     * identified folder.
     *
     * The async variant is {@see self::getFolderAsync()} .
     *
     * @example samples/V3/FoldersClient/get_folder.php
     *
     * @param GetFolderRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Folder
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFolder(GetFolderRequest $request, array $callOptions = []): Folder
    {
        return $this->startApiCall('GetFolder', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a folder. The returned policy may be
     * empty if no such policy or resource exists. The `resource` field should
     * be the folder's resource name, for example: "folders/1234".
     * The caller must have `resourcemanager.folders.getIamPolicy` permission
     * on the identified folder.
     *
     * The async variant is {@see self::getIamPolicyAsync()} .
     *
     * @example samples/V3/FoldersClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Lists the folders that are direct descendants of supplied parent resource.
     * `list()` provides a strongly consistent view of the folders underneath
     * the specified parent resource.
     * `list()` returns folders sorted based upon the (ascending) lexical ordering
     * of their display_name.
     * The caller must have `resourcemanager.folders.list` permission on the
     * identified parent.
     *
     * The async variant is {@see self::listFoldersAsync()} .
     *
     * @example samples/V3/FoldersClient/list_folders.php
     *
     * @param ListFoldersRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFolders(ListFoldersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFolders', $request, $callOptions);
    }

    /**
     * Moves a folder under a new resource parent.
     * Returns an `Operation` which can be used to track the progress of the
     * folder move workflow.
     * Upon success, the `Operation.response` field will be populated with the
     * moved folder.
     * Upon failure, a `FolderOperationError` categorizing the failure cause will
     * be returned - if the failure occurs synchronously then the
     * `FolderOperationError` will be returned in the `Status.details` field.
     * If it occurs asynchronously, then the FolderOperation will be returned
     * in the `Operation.error` field.
     * In addition, the `Operation.metadata` field will be populated with a
     * `FolderOperation` message as an aid to stateless clients.
     * Folder moves will be rejected if they violate either the naming, height,
     * or fanout constraints described in the
     * [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
     * documentation. The caller must have `resourcemanager.folders.move`
     * permission on the folder's current and proposed new parent.
     *
     * The async variant is {@see self::moveFolderAsync()} .
     *
     * @example samples/V3/FoldersClient/move_folder.php
     *
     * @param MoveFolderRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function moveFolder(MoveFolderRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('MoveFolder', $request, $callOptions)->wait();
    }

    /**
     * Search for folders that match specific filter criteria.
     * `search()` provides an eventually consistent view of the folders a user has
     * access to which meet the specified filter criteria.
     *
     * This will only return folders on which the caller has the
     * permission `resourcemanager.folders.get`.
     *
     * The async variant is {@see self::searchFoldersAsync()} .
     *
     * @example samples/V3/FoldersClient/search_folders.php
     *
     * @param SearchFoldersRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchFolders(SearchFoldersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchFolders', $request, $callOptions);
    }

    /**
     * Sets the access control policy on a folder, replacing any existing policy.
     * The `resource` field should be the folder's resource name, for example:
     * "folders/1234".
     * The caller must have `resourcemanager.folders.setIamPolicy` permission
     * on the identified folder.
     *
     * The async variant is {@see self::setIamPolicyAsync()} .
     *
     * @example samples/V3/FoldersClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified folder.
     * The `resource` field should be the folder's resource name,
     * for example: "folders/1234".
     *
     * There are no permissions required for making this API call.
     *
     * The async variant is {@see self::testIamPermissionsAsync()} .
     *
     * @example samples/V3/FoldersClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Cancels the deletion request for a folder. This method may be called on a
     * folder in any state. If the folder is in the
     * [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state the
     * result will be a no-op success. In order to succeed, the folder's parent
     * must be in the
     * [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. In
     * addition, reintroducing the folder into the tree must not violate folder
     * naming, height, and fanout constraints described in the
     * [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
     * documentation. The caller must have `resourcemanager.folders.undelete`
     * permission on the identified folder.
     *
     * The async variant is {@see self::undeleteFolderAsync()} .
     *
     * @example samples/V3/FoldersClient/undelete_folder.php
     *
     * @param UndeleteFolderRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeleteFolder(UndeleteFolderRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UndeleteFolder', $request, $callOptions)->wait();
    }

    /**
     * Updates a folder, changing its `display_name`.
     * Changes to the folder `display_name` will be rejected if they violate
     * either the `display_name` formatting rules or the naming constraints
     * described in the
     * [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
     * documentation.
     *
     * The folder's `display_name` must start and end with a letter or digit,
     * may contain letters, digits, spaces, hyphens and underscores and can be
     * between 3 and 30 characters. This is captured by the regular expression:
     * `[\p{L}\p{N}][\p{L}\p{N}_- ]{1,28}[\p{L}\p{N}]`.
     * The caller must have `resourcemanager.folders.update` permission on the
     * identified folder.
     *
     * If the update fails due to the unique name constraint then a
     * `PreconditionFailure` explaining this violation will be returned
     * in the Status.details field.
     *
     * The async variant is {@see self::updateFolderAsync()} .
     *
     * @example samples/V3/FoldersClient/update_folder.php
     *
     * @param UpdateFolderRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFolder(UpdateFolderRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateFolder', $request, $callOptions)->wait();
    }
}
