<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/notebooks/v1/runtime.proto

namespace Google\Cloud\Notebooks\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The config settings for virtual machine.
 *
 * Generated from protobuf message <code>google.cloud.notebooks.v1.VirtualMachineConfig</code>
 */
class VirtualMachineConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The zone where the virtual machine is located.
     * If using regional request, the notebooks service will pick a location
     * in the corresponding runtime region.
     * On a get request, zone will always be present. Example:
     * * `us-central1-b`
     *
     * Generated from protobuf field <code>string zone = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $zone = '';
    /**
     * Required. The Compute Engine machine type used for runtimes.
     * Short name is valid. Examples:
     * * `n1-standard-2`
     * * `e2-standard-8`
     *
     * Generated from protobuf field <code>string machine_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $machine_type = '';
    /**
     * Optional. Use a list of container images to use as Kernels in the notebook instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.notebooks.v1.ContainerImage container_images = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $container_images;
    /**
     * Required. Data disk option configuration settings.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.LocalDisk data_disk = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $data_disk = null;
    /**
     * Optional. Encryption settings for virtual machine data disk.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $encryption_config = null;
    /**
     * Optional. Shielded VM Instance configuration settings.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.RuntimeShieldedInstanceConfig shielded_instance_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $shielded_instance_config = null;
    /**
     * Optional. The Compute Engine accelerator configuration for this runtime.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.RuntimeAcceleratorConfig accelerator_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $accelerator_config = null;
    /**
     * Optional. The Compute Engine network to be used for machine
     * communications. Cannot be specified with subnetwork. If neither
     * `network` nor `subnet` is specified, the "default" network of
     * the project is used, if it exists.
     * A full URL or partial URI. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     * * `projects/[project_id]/global/networks/default`
     * Runtimes are managed resources inside Google Infrastructure.
     * Runtimes support the following network configurations:
     * * Google Managed Network (Network & subnet are empty)
     * * Consumer Project VPC (network & subnet are required). Requires
     * configuring Private Service Access.
     * * Shared VPC (network & subnet are required). Requires configuring Private
     * Service Access.
     *
     * Generated from protobuf field <code>string network = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $network = '';
    /**
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications. Cannot be specified with network.
     * A full URL or partial URI are valid. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0`
     * * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
     *
     * Generated from protobuf field <code>string subnet = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $subnet = '';
    /**
     * Optional. If true, runtime will only have internal IP
     * addresses. By default, runtimes are not restricted to internal IP
     * addresses, and will have ephemeral external IP addresses assigned to each
     * vm. This `internal_ip_only` restriction can only be enabled for
     * subnetwork enabled networks, and all dependencies must be
     * configured to be accessible without external IP addresses.
     *
     * Generated from protobuf field <code>bool internal_ip_only = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $internal_ip_only = false;
    /**
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     *
     * Generated from protobuf field <code>repeated string tags = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $tags;
    /**
     * Output only. The Compute Engine guest attributes. (see
     * [Project and instance
     * guest
     * attributes](https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
     *
     * Generated from protobuf field <code>map<string, string> guest_attributes = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $guest_attributes;
    /**
     * Optional. The Compute Engine metadata entries to add to virtual machine. (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     *
     * Generated from protobuf field <code>map<string, string> metadata = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $metadata;
    /**
     * Optional. The labels to associate with this runtime.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     * VirtioNet.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.VirtualMachineConfig.NicType nic_type = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $nic_type = 0;
    /**
     * Optional. Reserved IP Range name is used for VPC Peering.
     * The subnetwork allocation will use the range *name* if it's assigned.
     * Example: managed-notebooks-range-c
     *     PEERING_RANGE_NAME_3=managed-notebooks-range-c
     *     gcloud compute addresses create $PEERING_RANGE_NAME_3 \
     *       --global \
     *       --prefix-length=24 \
     *       --description="Google Cloud Managed Notebooks Range 24 c" \
     *       --network=$NETWORK \
     *       --addresses=192.168.0.0 \
     *       --purpose=VPC_PEERING
     * Field value will be: `managed-notebooks-range-c`
     *
     * Generated from protobuf field <code>string reserved_ip_range = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $reserved_ip_range = '';
    /**
     * Optional. Boot image metadata used for runtime upgradeability.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.VirtualMachineConfig.BootImage boot_image = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $boot_image = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $zone
     *           Output only. The zone where the virtual machine is located.
     *           If using regional request, the notebooks service will pick a location
     *           in the corresponding runtime region.
     *           On a get request, zone will always be present. Example:
     *           * `us-central1-b`
     *     @type string $machine_type
     *           Required. The Compute Engine machine type used for runtimes.
     *           Short name is valid. Examples:
     *           * `n1-standard-2`
     *           * `e2-standard-8`
     *     @type array<\Google\Cloud\Notebooks\V1\ContainerImage>|\Google\Protobuf\Internal\RepeatedField $container_images
     *           Optional. Use a list of container images to use as Kernels in the notebook instance.
     *     @type \Google\Cloud\Notebooks\V1\LocalDisk $data_disk
     *           Required. Data disk option configuration settings.
     *     @type \Google\Cloud\Notebooks\V1\EncryptionConfig $encryption_config
     *           Optional. Encryption settings for virtual machine data disk.
     *     @type \Google\Cloud\Notebooks\V1\RuntimeShieldedInstanceConfig $shielded_instance_config
     *           Optional. Shielded VM Instance configuration settings.
     *     @type \Google\Cloud\Notebooks\V1\RuntimeAcceleratorConfig $accelerator_config
     *           Optional. The Compute Engine accelerator configuration for this runtime.
     *     @type string $network
     *           Optional. The Compute Engine network to be used for machine
     *           communications. Cannot be specified with subnetwork. If neither
     *           `network` nor `subnet` is specified, the "default" network of
     *           the project is used, if it exists.
     *           A full URL or partial URI. Examples:
     *           * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     *           * `projects/[project_id]/global/networks/default`
     *           Runtimes are managed resources inside Google Infrastructure.
     *           Runtimes support the following network configurations:
     *           * Google Managed Network (Network & subnet are empty)
     *           * Consumer Project VPC (network & subnet are required). Requires
     *           configuring Private Service Access.
     *           * Shared VPC (network & subnet are required). Requires configuring Private
     *           Service Access.
     *     @type string $subnet
     *           Optional. The Compute Engine subnetwork to be used for machine
     *           communications. Cannot be specified with network.
     *           A full URL or partial URI are valid. Examples:
     *           * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0`
     *           * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
     *     @type bool $internal_ip_only
     *           Optional. If true, runtime will only have internal IP
     *           addresses. By default, runtimes are not restricted to internal IP
     *           addresses, and will have ephemeral external IP addresses assigned to each
     *           vm. This `internal_ip_only` restriction can only be enabled for
     *           subnetwork enabled networks, and all dependencies must be
     *           configured to be accessible without external IP addresses.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $tags
     *           Optional. The Compute Engine tags to add to runtime (see [Tagging
     *           instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     *     @type array|\Google\Protobuf\Internal\MapField $guest_attributes
     *           Output only. The Compute Engine guest attributes. (see
     *           [Project and instance
     *           guest
     *           attributes](https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
     *     @type array|\Google\Protobuf\Internal\MapField $metadata
     *           Optional. The Compute Engine metadata entries to add to virtual machine. (see
     *           [Project and instance
     *           metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. The labels to associate with this runtime.
     *           Label **keys** must contain 1 to 63 characters, and must conform to
     *           [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *           Label **values** may be empty, but, if present, must contain 1 to 63
     *           characters, and must conform to [RFC
     *           1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     *           associated with a cluster.
     *     @type int $nic_type
     *           Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     *           VirtioNet.
     *     @type string $reserved_ip_range
     *           Optional. Reserved IP Range name is used for VPC Peering.
     *           The subnetwork allocation will use the range *name* if it's assigned.
     *           Example: managed-notebooks-range-c
     *               PEERING_RANGE_NAME_3=managed-notebooks-range-c
     *               gcloud compute addresses create $PEERING_RANGE_NAME_3 \
     *                 --global \
     *                 --prefix-length=24 \
     *                 --description="Google Cloud Managed Notebooks Range 24 c" \
     *                 --network=$NETWORK \
     *                 --addresses=192.168.0.0 \
     *                 --purpose=VPC_PEERING
     *           Field value will be: `managed-notebooks-range-c`
     *     @type \Google\Cloud\Notebooks\V1\VirtualMachineConfig\BootImage $boot_image
     *           Optional. Boot image metadata used for runtime upgradeability.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Notebooks\V1\Runtime::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The zone where the virtual machine is located.
     * If using regional request, the notebooks service will pick a location
     * in the corresponding runtime region.
     * On a get request, zone will always be present. Example:
     * * `us-central1-b`
     *
     * Generated from protobuf field <code>string zone = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * Output only. The zone where the virtual machine is located.
     * If using regional request, the notebooks service will pick a location
     * in the corresponding runtime region.
     * On a get request, zone will always be present. Example:
     * * `us-central1-b`
     *
     * Generated from protobuf field <code>string zone = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

    /**
     * Required. The Compute Engine machine type used for runtimes.
     * Short name is valid. Examples:
     * * `n1-standard-2`
     * * `e2-standard-8`
     *
     * Generated from protobuf field <code>string machine_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * Required. The Compute Engine machine type used for runtimes.
     * Short name is valid. Examples:
     * * `n1-standard-2`
     * * `e2-standard-8`
     *
     * Generated from protobuf field <code>string machine_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * Optional. Use a list of container images to use as Kernels in the notebook instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.notebooks.v1.ContainerImage container_images = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContainerImages()
    {
        return $this->container_images;
    }

    /**
     * Optional. Use a list of container images to use as Kernels in the notebook instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.notebooks.v1.ContainerImage container_images = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Notebooks\V1\ContainerImage>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContainerImages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Notebooks\V1\ContainerImage::class);
        $this->container_images = $arr;

        return $this;
    }

    /**
     * Required. Data disk option configuration settings.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.LocalDisk data_disk = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Notebooks\V1\LocalDisk|null
     */
    public function getDataDisk()
    {
        return $this->data_disk;
    }

    public function hasDataDisk()
    {
        return isset($this->data_disk);
    }

    public function clearDataDisk()
    {
        unset($this->data_disk);
    }

    /**
     * Required. Data disk option configuration settings.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.LocalDisk data_disk = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Notebooks\V1\LocalDisk $var
     * @return $this
     */
    public function setDataDisk($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Notebooks\V1\LocalDisk::class);
        $this->data_disk = $var;

        return $this;
    }

    /**
     * Optional. Encryption settings for virtual machine data disk.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Notebooks\V1\EncryptionConfig|null
     */
    public function getEncryptionConfig()
    {
        return $this->encryption_config;
    }

    public function hasEncryptionConfig()
    {
        return isset($this->encryption_config);
    }

    public function clearEncryptionConfig()
    {
        unset($this->encryption_config);
    }

    /**
     * Optional. Encryption settings for virtual machine data disk.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Notebooks\V1\EncryptionConfig $var
     * @return $this
     */
    public function setEncryptionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Notebooks\V1\EncryptionConfig::class);
        $this->encryption_config = $var;

        return $this;
    }

    /**
     * Optional. Shielded VM Instance configuration settings.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.RuntimeShieldedInstanceConfig shielded_instance_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Notebooks\V1\RuntimeShieldedInstanceConfig|null
     */
    public function getShieldedInstanceConfig()
    {
        return $this->shielded_instance_config;
    }

    public function hasShieldedInstanceConfig()
    {
        return isset($this->shielded_instance_config);
    }

    public function clearShieldedInstanceConfig()
    {
        unset($this->shielded_instance_config);
    }

    /**
     * Optional. Shielded VM Instance configuration settings.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.RuntimeShieldedInstanceConfig shielded_instance_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Notebooks\V1\RuntimeShieldedInstanceConfig $var
     * @return $this
     */
    public function setShieldedInstanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Notebooks\V1\RuntimeShieldedInstanceConfig::class);
        $this->shielded_instance_config = $var;

        return $this;
    }

    /**
     * Optional. The Compute Engine accelerator configuration for this runtime.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.RuntimeAcceleratorConfig accelerator_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Notebooks\V1\RuntimeAcceleratorConfig|null
     */
    public function getAcceleratorConfig()
    {
        return $this->accelerator_config;
    }

    public function hasAcceleratorConfig()
    {
        return isset($this->accelerator_config);
    }

    public function clearAcceleratorConfig()
    {
        unset($this->accelerator_config);
    }

    /**
     * Optional. The Compute Engine accelerator configuration for this runtime.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.RuntimeAcceleratorConfig accelerator_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Notebooks\V1\RuntimeAcceleratorConfig $var
     * @return $this
     */
    public function setAcceleratorConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Notebooks\V1\RuntimeAcceleratorConfig::class);
        $this->accelerator_config = $var;

        return $this;
    }

    /**
     * Optional. The Compute Engine network to be used for machine
     * communications. Cannot be specified with subnetwork. If neither
     * `network` nor `subnet` is specified, the "default" network of
     * the project is used, if it exists.
     * A full URL or partial URI. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     * * `projects/[project_id]/global/networks/default`
     * Runtimes are managed resources inside Google Infrastructure.
     * Runtimes support the following network configurations:
     * * Google Managed Network (Network & subnet are empty)
     * * Consumer Project VPC (network & subnet are required). Requires
     * configuring Private Service Access.
     * * Shared VPC (network & subnet are required). Requires configuring Private
     * Service Access.
     *
     * Generated from protobuf field <code>string network = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Optional. The Compute Engine network to be used for machine
     * communications. Cannot be specified with subnetwork. If neither
     * `network` nor `subnet` is specified, the "default" network of
     * the project is used, if it exists.
     * A full URL or partial URI. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     * * `projects/[project_id]/global/networks/default`
     * Runtimes are managed resources inside Google Infrastructure.
     * Runtimes support the following network configurations:
     * * Google Managed Network (Network & subnet are empty)
     * * Consumer Project VPC (network & subnet are required). Requires
     * configuring Private Service Access.
     * * Shared VPC (network & subnet are required). Requires configuring Private
     * Service Access.
     *
     * Generated from protobuf field <code>string network = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications. Cannot be specified with network.
     * A full URL or partial URI are valid. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0`
     * * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
     *
     * Generated from protobuf field <code>string subnet = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSubnet()
    {
        return $this->subnet;
    }

    /**
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications. Cannot be specified with network.
     * A full URL or partial URI are valid. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0`
     * * `projects/[project_id]/regions/us-east1/subnetworks/sub0`
     *
     * Generated from protobuf field <code>string subnet = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->subnet = $var;

        return $this;
    }

    /**
     * Optional. If true, runtime will only have internal IP
     * addresses. By default, runtimes are not restricted to internal IP
     * addresses, and will have ephemeral external IP addresses assigned to each
     * vm. This `internal_ip_only` restriction can only be enabled for
     * subnetwork enabled networks, and all dependencies must be
     * configured to be accessible without external IP addresses.
     *
     * Generated from protobuf field <code>bool internal_ip_only = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getInternalIpOnly()
    {
        return $this->internal_ip_only;
    }

    /**
     * Optional. If true, runtime will only have internal IP
     * addresses. By default, runtimes are not restricted to internal IP
     * addresses, and will have ephemeral external IP addresses assigned to each
     * vm. This `internal_ip_only` restriction can only be enabled for
     * subnetwork enabled networks, and all dependencies must be
     * configured to be accessible without external IP addresses.
     *
     * Generated from protobuf field <code>bool internal_ip_only = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setInternalIpOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->internal_ip_only = $var;

        return $this;
    }

    /**
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     *
     * Generated from protobuf field <code>repeated string tags = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * Optional. The Compute Engine tags to add to runtime (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     *
     * Generated from protobuf field <code>repeated string tags = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tags = $arr;

        return $this;
    }

    /**
     * Output only. The Compute Engine guest attributes. (see
     * [Project and instance
     * guest
     * attributes](https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
     *
     * Generated from protobuf field <code>map<string, string> guest_attributes = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getGuestAttributes()
    {
        return $this->guest_attributes;
    }

    /**
     * Output only. The Compute Engine guest attributes. (see
     * [Project and instance
     * guest
     * attributes](https://cloud.google.com/compute/docs/storing-retrieving-metadata#guest_attributes)).
     *
     * Generated from protobuf field <code>map<string, string> guest_attributes = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setGuestAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->guest_attributes = $arr;

        return $this;
    }

    /**
     * Optional. The Compute Engine metadata entries to add to virtual machine. (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     *
     * Generated from protobuf field <code>map<string, string> metadata = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * Optional. The Compute Engine metadata entries to add to virtual machine. (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     *
     * Generated from protobuf field <code>map<string, string> metadata = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * Optional. The labels to associate with this runtime.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. The labels to associate with this runtime.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     * VirtioNet.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.VirtualMachineConfig.NicType nic_type = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getNicType()
    {
        return $this->nic_type;
    }

    /**
     * Optional. The type of vNIC to be used on this interface. This may be gVNIC or
     * VirtioNet.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.VirtualMachineConfig.NicType nic_type = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setNicType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Notebooks\V1\VirtualMachineConfig\NicType::class);
        $this->nic_type = $var;

        return $this;
    }

    /**
     * Optional. Reserved IP Range name is used for VPC Peering.
     * The subnetwork allocation will use the range *name* if it's assigned.
     * Example: managed-notebooks-range-c
     *     PEERING_RANGE_NAME_3=managed-notebooks-range-c
     *     gcloud compute addresses create $PEERING_RANGE_NAME_3 \
     *       --global \
     *       --prefix-length=24 \
     *       --description="Google Cloud Managed Notebooks Range 24 c" \
     *       --network=$NETWORK \
     *       --addresses=192.168.0.0 \
     *       --purpose=VPC_PEERING
     * Field value will be: `managed-notebooks-range-c`
     *
     * Generated from protobuf field <code>string reserved_ip_range = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getReservedIpRange()
    {
        return $this->reserved_ip_range;
    }

    /**
     * Optional. Reserved IP Range name is used for VPC Peering.
     * The subnetwork allocation will use the range *name* if it's assigned.
     * Example: managed-notebooks-range-c
     *     PEERING_RANGE_NAME_3=managed-notebooks-range-c
     *     gcloud compute addresses create $PEERING_RANGE_NAME_3 \
     *       --global \
     *       --prefix-length=24 \
     *       --description="Google Cloud Managed Notebooks Range 24 c" \
     *       --network=$NETWORK \
     *       --addresses=192.168.0.0 \
     *       --purpose=VPC_PEERING
     * Field value will be: `managed-notebooks-range-c`
     *
     * Generated from protobuf field <code>string reserved_ip_range = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setReservedIpRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->reserved_ip_range = $var;

        return $this;
    }

    /**
     * Optional. Boot image metadata used for runtime upgradeability.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.VirtualMachineConfig.BootImage boot_image = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Notebooks\V1\VirtualMachineConfig\BootImage|null
     */
    public function getBootImage()
    {
        return $this->boot_image;
    }

    public function hasBootImage()
    {
        return isset($this->boot_image);
    }

    public function clearBootImage()
    {
        unset($this->boot_image);
    }

    /**
     * Optional. Boot image metadata used for runtime upgradeability.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1.VirtualMachineConfig.BootImage boot_image = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Notebooks\V1\VirtualMachineConfig\BootImage $var
     * @return $this
     */
    public function setBootImage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Notebooks\V1\VirtualMachineConfig\BootImage::class);
        $this->boot_image = $var;

        return $this;
    }

}

