<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networksecurity/v1beta1/network_security.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\NetworkSecurity\V1beta1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\NetworkSecurity\V1beta1\AuthorizationPolicy;
use Google\Cloud\NetworkSecurity\V1beta1\ClientTlsPolicy;
use Google\Cloud\NetworkSecurity\V1beta1\CreateAuthorizationPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\CreateClientTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\CreateServerTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\DeleteAuthorizationPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\DeleteClientTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\DeleteServerTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\GetAuthorizationPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\GetClientTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\GetServerTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\ListAuthorizationPoliciesRequest;
use Google\Cloud\NetworkSecurity\V1beta1\ListAuthorizationPoliciesResponse;
use Google\Cloud\NetworkSecurity\V1beta1\ListClientTlsPoliciesRequest;
use Google\Cloud\NetworkSecurity\V1beta1\ListClientTlsPoliciesResponse;
use Google\Cloud\NetworkSecurity\V1beta1\ListServerTlsPoliciesRequest;
use Google\Cloud\NetworkSecurity\V1beta1\ListServerTlsPoliciesResponse;
use Google\Cloud\NetworkSecurity\V1beta1\ServerTlsPolicy;
use Google\Cloud\NetworkSecurity\V1beta1\UpdateAuthorizationPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\UpdateClientTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1beta1\UpdateServerTlsPolicyRequest;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Network Security API provides resources to configure authentication and
 * authorization policies. Refer to per API resource documentation for more
 * information.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $networkSecurityClient = new NetworkSecurityClient();
 * try {
 *     $formattedParent = $networkSecurityClient->locationName('[PROJECT]', '[LOCATION]');
 *     $authorizationPolicyId = 'authorization_policy_id';
 *     $authorizationPolicy = new AuthorizationPolicy();
 *     $operationResponse = $networkSecurityClient->createAuthorizationPolicy($formattedParent, $authorizationPolicyId, $authorizationPolicy);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $networkSecurityClient->createAuthorizationPolicy($formattedParent, $authorizationPolicyId, $authorizationPolicy);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'createAuthorizationPolicy');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $networkSecurityClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 */
class NetworkSecurityGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.networksecurity.v1beta1.NetworkSecurity';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'networksecurity.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $authorizationPolicyNameTemplate;

    private static $clientTlsPolicyNameTemplate;

    private static $locationNameTemplate;

    private static $serverTlsPolicyNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/network_security_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/network_security_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/network_security_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/network_security_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAuthorizationPolicyNameTemplate()
    {
        if (self::$authorizationPolicyNameTemplate == null) {
            self::$authorizationPolicyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/authorizationPolicies/{authorization_policy}'
            );
        }

        return self::$authorizationPolicyNameTemplate;
    }

    private static function getClientTlsPolicyNameTemplate()
    {
        if (self::$clientTlsPolicyNameTemplate == null) {
            self::$clientTlsPolicyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy}'
            );
        }

        return self::$clientTlsPolicyNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getServerTlsPolicyNameTemplate()
    {
        if (self::$serverTlsPolicyNameTemplate == null) {
            self::$serverTlsPolicyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/serverTlsPolicies/{server_tls_policy}'
            );
        }

        return self::$serverTlsPolicyNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'authorizationPolicy' => self::getAuthorizationPolicyNameTemplate(),
                'clientTlsPolicy' => self::getClientTlsPolicyNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'serverTlsPolicy' => self::getServerTlsPolicyNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * authorization_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $authorizationPolicy
     *
     * @return string The formatted authorization_policy resource.
     *
     * @experimental
     */
    public static function authorizationPolicyName(
        $project,
        $location,
        $authorizationPolicy
    ) {
        return self::getAuthorizationPolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'authorization_policy' => $authorizationPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * client_tls_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $clientTlsPolicy
     *
     * @return string The formatted client_tls_policy resource.
     *
     * @experimental
     */
    public static function clientTlsPolicyName(
        $project,
        $location,
        $clientTlsPolicy
    ) {
        return self::getClientTlsPolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'client_tls_policy' => $clientTlsPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     *
     * @experimental
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * server_tls_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serverTlsPolicy
     *
     * @return string The formatted server_tls_policy resource.
     *
     * @experimental
     */
    public static function serverTlsPolicyName(
        $project,
        $location,
        $serverTlsPolicy
    ) {
        return self::getServerTlsPolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'server_tls_policy' => $serverTlsPolicy,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - authorizationPolicy: projects/{project}/locations/{location}/authorizationPolicies/{authorization_policy}
     * - clientTlsPolicy: projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy}
     * - location: projects/{project}/locations/{location}
     * - serverTlsPolicy: projects/{project}/locations/{location}/serverTlsPolicies/{server_tls_policy}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     *
     * @experimental
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     *
     * @experimental
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networksecurity.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new AuthorizationPolicy in a given project and location.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedParent = $networkSecurityClient->locationName('[PROJECT]', '[LOCATION]');
     *     $authorizationPolicyId = 'authorization_policy_id';
     *     $authorizationPolicy = new AuthorizationPolicy();
     *     $operationResponse = $networkSecurityClient->createAuthorizationPolicy($formattedParent, $authorizationPolicyId, $authorizationPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->createAuthorizationPolicy($formattedParent, $authorizationPolicyId, $authorizationPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'createAuthorizationPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string              $parent                Required. The parent resource of the AuthorizationPolicy. Must be in the
     *                                                   format `projects/{project}/locations/{location}`.
     * @param string              $authorizationPolicyId Required. Short name of the AuthorizationPolicy resource to be created.
     *                                                   This value should be 1-63 characters long, containing only
     *                                                   letters, numbers, hyphens, and underscores, and should not start
     *                                                   with a number. E.g. "authz_policy".
     * @param AuthorizationPolicy $authorizationPolicy   Required. AuthorizationPolicy resource to be created.
     * @param array               $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createAuthorizationPolicy(
        $parent,
        $authorizationPolicyId,
        $authorizationPolicy,
        array $optionalArgs = []
    ) {
        $request = new CreateAuthorizationPolicyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAuthorizationPolicyId($authorizationPolicyId);
        $request->setAuthorizationPolicy($authorizationPolicy);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAuthorizationPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new ClientTlsPolicy in a given project and location.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedParent = $networkSecurityClient->locationName('[PROJECT]', '[LOCATION]');
     *     $clientTlsPolicyId = 'client_tls_policy_id';
     *     $clientTlsPolicy = new ClientTlsPolicy();
     *     $operationResponse = $networkSecurityClient->createClientTlsPolicy($formattedParent, $clientTlsPolicyId, $clientTlsPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->createClientTlsPolicy($formattedParent, $clientTlsPolicyId, $clientTlsPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'createClientTlsPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string          $parent            Required. The parent resource of the ClientTlsPolicy. Must be in
     *                                           the format `projects/&#42;/locations/{location}`.
     * @param string          $clientTlsPolicyId Required. Short name of the ClientTlsPolicy resource to be created. This
     *                                           value should be 1-63 characters long, containing only letters, numbers,
     *                                           hyphens, and underscores, and should not start with a number. E.g.
     *                                           "client_mtls_policy".
     * @param ClientTlsPolicy $clientTlsPolicy   Required. ClientTlsPolicy resource to be created.
     * @param array           $optionalArgs      {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createClientTlsPolicy(
        $parent,
        $clientTlsPolicyId,
        $clientTlsPolicy,
        array $optionalArgs = []
    ) {
        $request = new CreateClientTlsPolicyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setClientTlsPolicyId($clientTlsPolicyId);
        $request->setClientTlsPolicy($clientTlsPolicy);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateClientTlsPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new ServerTlsPolicy in a given project and location.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedParent = $networkSecurityClient->locationName('[PROJECT]', '[LOCATION]');
     *     $serverTlsPolicyId = 'server_tls_policy_id';
     *     $serverTlsPolicy = new ServerTlsPolicy();
     *     $operationResponse = $networkSecurityClient->createServerTlsPolicy($formattedParent, $serverTlsPolicyId, $serverTlsPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->createServerTlsPolicy($formattedParent, $serverTlsPolicyId, $serverTlsPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'createServerTlsPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string          $parent            Required. The parent resource of the ServerTlsPolicy. Must be in
     *                                           the format `projects/&#42;/locations/{location}`.
     * @param string          $serverTlsPolicyId Required. Short name of the ServerTlsPolicy resource to be created. This
     *                                           value should be 1-63 characters long, containing only letters, numbers,
     *                                           hyphens, and underscores, and should not start with a number. E.g.
     *                                           "server_mtls_policy".
     * @param ServerTlsPolicy $serverTlsPolicy   Required. ServerTlsPolicy resource to be created.
     * @param array           $optionalArgs      {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createServerTlsPolicy(
        $parent,
        $serverTlsPolicyId,
        $serverTlsPolicy,
        array $optionalArgs = []
    ) {
        $request = new CreateServerTlsPolicyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setServerTlsPolicyId($serverTlsPolicyId);
        $request->setServerTlsPolicy($serverTlsPolicy);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateServerTlsPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single AuthorizationPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedName = $networkSecurityClient->authorizationPolicyName('[PROJECT]', '[LOCATION]', '[AUTHORIZATION_POLICY]');
     *     $operationResponse = $networkSecurityClient->deleteAuthorizationPolicy($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->deleteAuthorizationPolicy($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'deleteAuthorizationPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the AuthorizationPolicy to delete. Must be in the
     *                             format `projects/{project}/locations/{location}/authorizationPolicies/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteAuthorizationPolicy($name, array $optionalArgs = [])
    {
        $request = new DeleteAuthorizationPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAuthorizationPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single ClientTlsPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedName = $networkSecurityClient->clientTlsPolicyName('[PROJECT]', '[LOCATION]', '[CLIENT_TLS_POLICY]');
     *     $operationResponse = $networkSecurityClient->deleteClientTlsPolicy($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->deleteClientTlsPolicy($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'deleteClientTlsPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the ClientTlsPolicy to delete. Must be in
     *                             the format `projects/&#42;/locations/{location}/clientTlsPolicies/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteClientTlsPolicy($name, array $optionalArgs = [])
    {
        $request = new DeleteClientTlsPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteClientTlsPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single ServerTlsPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedName = $networkSecurityClient->serverTlsPolicyName('[PROJECT]', '[LOCATION]', '[SERVER_TLS_POLICY]');
     *     $operationResponse = $networkSecurityClient->deleteServerTlsPolicy($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->deleteServerTlsPolicy($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'deleteServerTlsPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the ServerTlsPolicy to delete. Must be in
     *                             the format `projects/&#42;/locations/{location}/serverTlsPolicies/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteServerTlsPolicy($name, array $optionalArgs = [])
    {
        $request = new DeleteServerTlsPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteServerTlsPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details of a single AuthorizationPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedName = $networkSecurityClient->authorizationPolicyName('[PROJECT]', '[LOCATION]', '[AUTHORIZATION_POLICY]');
     *     $response = $networkSecurityClient->getAuthorizationPolicy($formattedName);
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the AuthorizationPolicy to get. Must be in the format
     *                             `projects/{project}/locations/{location}/authorizationPolicies/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkSecurity\V1beta1\AuthorizationPolicy
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getAuthorizationPolicy($name, array $optionalArgs = [])
    {
        $request = new GetAuthorizationPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAuthorizationPolicy',
            AuthorizationPolicy::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single ClientTlsPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedName = $networkSecurityClient->clientTlsPolicyName('[PROJECT]', '[LOCATION]', '[CLIENT_TLS_POLICY]');
     *     $response = $networkSecurityClient->getClientTlsPolicy($formattedName);
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the ClientTlsPolicy to get. Must be in the format
     *                             `projects/&#42;/locations/{location}/clientTlsPolicies/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkSecurity\V1beta1\ClientTlsPolicy
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getClientTlsPolicy($name, array $optionalArgs = [])
    {
        $request = new GetClientTlsPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetClientTlsPolicy',
            ClientTlsPolicy::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single ServerTlsPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedName = $networkSecurityClient->serverTlsPolicyName('[PROJECT]', '[LOCATION]', '[SERVER_TLS_POLICY]');
     *     $response = $networkSecurityClient->getServerTlsPolicy($formattedName);
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the ServerTlsPolicy to get. Must be in the format
     *                             `projects/&#42;/locations/{location}/serverTlsPolicies/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkSecurity\V1beta1\ServerTlsPolicy
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getServerTlsPolicy($name, array $optionalArgs = [])
    {
        $request = new GetServerTlsPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetServerTlsPolicy',
            ServerTlsPolicy::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists AuthorizationPolicies in a given project and location.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedParent = $networkSecurityClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkSecurityClient->listAuthorizationPolicies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkSecurityClient->listAuthorizationPolicies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the AuthorizationPolicies
     *                             should be listed, specified in the format
     *                             `projects/{project}/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listAuthorizationPolicies($parent, array $optionalArgs = [])
    {
        $request = new ListAuthorizationPoliciesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAuthorizationPolicies',
            $optionalArgs,
            ListAuthorizationPoliciesResponse::class,
            $request
        );
    }

    /**
     * Lists ClientTlsPolicies in a given project and location.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedParent = $networkSecurityClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkSecurityClient->listClientTlsPolicies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkSecurityClient->listClientTlsPolicies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the ClientTlsPolicies should
     *                             be listed, specified in the format `projects/&#42;/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listClientTlsPolicies($parent, array $optionalArgs = [])
    {
        $request = new ListClientTlsPoliciesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListClientTlsPolicies',
            $optionalArgs,
            ListClientTlsPoliciesResponse::class,
            $request
        );
    }

    /**
     * Lists ServerTlsPolicies in a given project and location.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $formattedParent = $networkSecurityClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkSecurityClient->listServerTlsPolicies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkSecurityClient->listServerTlsPolicies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the ServerTlsPolicies should
     *                             be listed, specified in the format `projects/&#42;/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listServerTlsPolicies($parent, array $optionalArgs = [])
    {
        $request = new ListServerTlsPoliciesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListServerTlsPolicies',
            $optionalArgs,
            ListServerTlsPoliciesResponse::class,
            $request
        );
    }

    /**
     * Updates the parameters of a single AuthorizationPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $authorizationPolicy = new AuthorizationPolicy();
     *     $operationResponse = $networkSecurityClient->updateAuthorizationPolicy($authorizationPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->updateAuthorizationPolicy($authorizationPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'updateAuthorizationPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param AuthorizationPolicy $authorizationPolicy Required. Updated AuthorizationPolicy resource.
     * @param array               $optionalArgs        {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           AuthorizationPolicy resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateAuthorizationPolicy(
        $authorizationPolicy,
        array $optionalArgs = []
    ) {
        $request = new UpdateAuthorizationPolicyRequest();
        $requestParamHeaders = [];
        $request->setAuthorizationPolicy($authorizationPolicy);
        $requestParamHeaders[
            'authorization_policy.name'
        ] = $authorizationPolicy->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateAuthorizationPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single ClientTlsPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $clientTlsPolicy = new ClientTlsPolicy();
     *     $operationResponse = $networkSecurityClient->updateClientTlsPolicy($clientTlsPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->updateClientTlsPolicy($clientTlsPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'updateClientTlsPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param ClientTlsPolicy $clientTlsPolicy Required. Updated ClientTlsPolicy resource.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           ClientTlsPolicy resource by the update.  The fields
     *           specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the
     *           mask. If the user does not provide a mask then all fields will be
     *           overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateClientTlsPolicy(
        $clientTlsPolicy,
        array $optionalArgs = []
    ) {
        $request = new UpdateClientTlsPolicyRequest();
        $requestParamHeaders = [];
        $request->setClientTlsPolicy($clientTlsPolicy);
        $requestParamHeaders[
            'client_tls_policy.name'
        ] = $clientTlsPolicy->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateClientTlsPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single ServerTlsPolicy.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $serverTlsPolicy = new ServerTlsPolicy();
     *     $operationResponse = $networkSecurityClient->updateServerTlsPolicy($serverTlsPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $networkSecurityClient->updateServerTlsPolicy($serverTlsPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $networkSecurityClient->resumeOperation($operationName, 'updateServerTlsPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param ServerTlsPolicy $serverTlsPolicy Required. Updated ServerTlsPolicy resource.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the fields to be overwritten in the
     *           ServerTlsPolicy resource by the update.  The fields
     *           specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the
     *           mask. If the user does not provide a mask then all fields will be
     *           overwritten.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateServerTlsPolicy(
        $serverTlsPolicy,
        array $optionalArgs = []
    ) {
        $request = new UpdateServerTlsPolicyRequest();
        $requestParamHeaders = [];
        $request->setServerTlsPolicy($serverTlsPolicy);
        $requestParamHeaders[
            'server_tls_policy.name'
        ] = $serverTlsPolicy->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateServerTlsPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $response = $networkSecurityClient->getLocation();
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $networkSecurityClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $networkSecurityClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $resource = 'resource';
     *     $response = $networkSecurityClient->getIamPolicy($resource);
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $networkSecurityClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $networkSecurityClient = new NetworkSecurityClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $networkSecurityClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $networkSecurityClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
