<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/gkemulticloud/v1/attached_resources.proto

namespace Google\Cloud\GkeMultiCloud\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * OIDC discovery information of the target cluster.
 * Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
 * API server. This fields indicates how Google Cloud Platform services
 * validate KSA tokens in order to allow system workloads (such as GKE Connect
 * and telemetry agents) to authenticate back to Google Cloud Platform.
 * Both clusters with public and private issuer URLs are supported.
 * Clusters with public issuers only need to specify the `issuer_url` field
 * while clusters with private issuers need to provide both
 * `issuer_url` and `oidc_jwks`.
 *
 * Generated from protobuf message <code>google.cloud.gkemulticloud.v1.AttachedOidcConfig</code>
 */
class AttachedOidcConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://`.
     *
     * Generated from protobuf field <code>string issuer_url = 1;</code>
     */
    private $issuer_url = '';
    /**
     * Optional. OIDC verification keys in JWKS format (RFC 7517).
     * It contains a list of OIDC verification keys that can be used to verify
     * OIDC JWTs.
     * This field is required for cluster that doesn't have a publicly available
     * discovery endpoint. When provided, it will be directly used
     * to verify the OIDC JWT asserted by the IDP.
     *
     * Generated from protobuf field <code>bytes jwks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $jwks = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $issuer_url
     *           A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://`.
     *     @type string $jwks
     *           Optional. OIDC verification keys in JWKS format (RFC 7517).
     *           It contains a list of OIDC verification keys that can be used to verify
     *           OIDC JWTs.
     *           This field is required for cluster that doesn't have a publicly available
     *           discovery endpoint. When provided, it will be directly used
     *           to verify the OIDC JWT asserted by the IDP.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Gkemulticloud\V1\AttachedResources::initOnce();
        parent::__construct($data);
    }

    /**
     * A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://`.
     *
     * Generated from protobuf field <code>string issuer_url = 1;</code>
     * @return string
     */
    public function getIssuerUrl()
    {
        return $this->issuer_url;
    }

    /**
     * A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://`.
     *
     * Generated from protobuf field <code>string issuer_url = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setIssuerUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->issuer_url = $var;

        return $this;
    }

    /**
     * Optional. OIDC verification keys in JWKS format (RFC 7517).
     * It contains a list of OIDC verification keys that can be used to verify
     * OIDC JWTs.
     * This field is required for cluster that doesn't have a publicly available
     * discovery endpoint. When provided, it will be directly used
     * to verify the OIDC JWT asserted by the IDP.
     *
     * Generated from protobuf field <code>bytes jwks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getJwks()
    {
        return $this->jwks;
    }

    /**
     * Optional. OIDC verification keys in JWKS format (RFC 7517).
     * It contains a list of OIDC verification keys that can be used to verify
     * OIDC JWTs.
     * This field is required for cluster that doesn't have a publicly available
     * discovery endpoint. When provided, it will be directly used
     * to verify the OIDC JWT asserted by the IDP.
     *
     * Generated from protobuf field <code>bytes jwks = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setJwks($var)
    {
        GPBUtil::checkString($var, False);
        $this->jwks = $var;

        return $this;
    }

}

