<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gaming/v1/game_server_deployments_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Gaming\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Gaming\V1\CreateGameServerDeploymentRequest;
use Google\Cloud\Gaming\V1\DeleteGameServerDeploymentRequest;
use Google\Cloud\Gaming\V1\FetchDeploymentStateRequest;
use Google\Cloud\Gaming\V1\FetchDeploymentStateResponse;
use Google\Cloud\Gaming\V1\GameServerDeployment;
use Google\Cloud\Gaming\V1\GameServerDeploymentRollout;
use Google\Cloud\Gaming\V1\GetGameServerDeploymentRequest;
use Google\Cloud\Gaming\V1\GetGameServerDeploymentRolloutRequest;
use Google\Cloud\Gaming\V1\ListGameServerDeploymentsRequest;
use Google\Cloud\Gaming\V1\PreviewGameServerDeploymentRolloutRequest;
use Google\Cloud\Gaming\V1\PreviewGameServerDeploymentRolloutResponse;
use Google\Cloud\Gaming\V1\UpdateGameServerDeploymentRequest;
use Google\Cloud\Gaming\V1\UpdateGameServerDeploymentRolloutRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The game server deployment is used to control the deployment of Agones
 * fleets.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\Gaming\V1\GameServerDeploymentsServiceClient} for the stable
 * implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createGameServerDeploymentAsync(CreateGameServerDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteGameServerDeploymentAsync(DeleteGameServerDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchDeploymentStateAsync(FetchDeploymentStateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGameServerDeploymentAsync(GetGameServerDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGameServerDeploymentRolloutAsync(GetGameServerDeploymentRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listGameServerDeploymentsAsync(ListGameServerDeploymentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface previewGameServerDeploymentRolloutAsync(PreviewGameServerDeploymentRolloutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGameServerDeploymentAsync(UpdateGameServerDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGameServerDeploymentRolloutAsync(UpdateGameServerDeploymentRolloutRequest $request, array $optionalArgs = [])
 */
abstract class GameServerDeploymentsServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.gaming.v1.GameServerDeploymentsService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'gameservices.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/game_server_deployments_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/game_server_deployments_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/game_server_deployments_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/game_server_deployments_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * game_server_deployment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deployment
     *
     * @return string The formatted game_server_deployment resource.
     */
    public static function gameServerDeploymentName(string $project, string $location, string $deployment): string
    {
        return self::getPathTemplate('gameServerDeployment')->render([
            'project' => $project,
            'location' => $location,
            'deployment' => $deployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * game_server_deployment_rollout resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deployment
     *
     * @return string The formatted game_server_deployment_rollout resource.
     */
    public static function gameServerDeploymentRolloutName(string $project, string $location, string $deployment): string
    {
        return self::getPathTemplate('gameServerDeploymentRollout')->render([
            'project' => $project,
            'location' => $location,
            'deployment' => $deployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - gameServerDeployment: projects/{project}/locations/{location}/gameServerDeployments/{deployment}
     * - gameServerDeploymentRollout: projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'gameservices.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new game server deployment in a given project and location.
     *
     * The async variant is {@see self::createGameServerDeploymentAsync()} .
     *
     * @param CreateGameServerDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGameServerDeployment(CreateGameServerDeploymentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateGameServerDeployment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single game server deployment.
     *
     * The async variant is {@see self::deleteGameServerDeploymentAsync()} .
     *
     * @param DeleteGameServerDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGameServerDeployment(DeleteGameServerDeploymentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteGameServerDeployment', $request, $callOptions)->wait();
    }

    /**
     * Retrieves information about the current state of the game server
     * deployment. Gathers all the Agones fleets and Agones autoscalers,
     * including fleets running an older version of the game server deployment.
     *
     * The async variant is {@see self::fetchDeploymentStateAsync()} .
     *
     * @param FetchDeploymentStateRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchDeploymentStateResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchDeploymentState(FetchDeploymentStateRequest $request, array $callOptions = []): FetchDeploymentStateResponse
    {
        return $this->startApiCall('FetchDeploymentState', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single game server deployment.
     *
     * The async variant is {@see self::getGameServerDeploymentAsync()} .
     *
     * @param GetGameServerDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GameServerDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGameServerDeployment(GetGameServerDeploymentRequest $request, array $callOptions = []): GameServerDeployment
    {
        return $this->startApiCall('GetGameServerDeployment', $request, $callOptions)->wait();
    }

    /**
     * Gets details a single game server deployment rollout.
     *
     * The async variant is {@see self::getGameServerDeploymentRolloutAsync()} .
     *
     * @param GetGameServerDeploymentRolloutRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GameServerDeploymentRollout
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGameServerDeploymentRollout(GetGameServerDeploymentRolloutRequest $request, array $callOptions = []): GameServerDeploymentRollout
    {
        return $this->startApiCall('GetGameServerDeploymentRollout', $request, $callOptions)->wait();
    }

    /**
     * Lists game server deployments in a given project and location.
     *
     * The async variant is {@see self::listGameServerDeploymentsAsync()} .
     *
     * @param ListGameServerDeploymentsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGameServerDeployments(ListGameServerDeploymentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGameServerDeployments', $request, $callOptions);
    }

    /**
     * Previews the game server deployment rollout. This API does not mutate the
     * rollout resource.
     *
     * The async variant is {@see self::previewGameServerDeploymentRolloutAsync()} .
     *
     * @param PreviewGameServerDeploymentRolloutRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PreviewGameServerDeploymentRolloutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function previewGameServerDeploymentRollout(PreviewGameServerDeploymentRolloutRequest $request, array $callOptions = []): PreviewGameServerDeploymentRolloutResponse
    {
        return $this->startApiCall('PreviewGameServerDeploymentRollout', $request, $callOptions)->wait();
    }

    /**
     * Patches a game server deployment.
     *
     * The async variant is {@see self::updateGameServerDeploymentAsync()} .
     *
     * @param UpdateGameServerDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGameServerDeployment(UpdateGameServerDeploymentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGameServerDeployment', $request, $callOptions)->wait();
    }

    /**
     * Patches a single game server deployment rollout.
     * The method will not return an error if the update does not affect any
     * existing realms. For example - if the default_game_server_config is changed
     * but all existing realms use the override, that is valid. Similarly, if a
     * non existing realm is explicitly called out in game_server_config_overrides
     * field, that will also not result in an error.
     *
     * The async variant is {@see self::updateGameServerDeploymentRolloutAsync()} .
     *
     * @param UpdateGameServerDeploymentRolloutRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGameServerDeploymentRollout(UpdateGameServerDeploymentRolloutRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGameServerDeploymentRollout', $request, $callOptions)->wait();
    }
}
