<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/documentai/v1/processor_type.proto

namespace Google\Cloud\DocumentAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A processor type is responsible for performing a certain document
 * understanding task on a certain type of document.
 *
 * Generated from protobuf message <code>google.cloud.documentai.v1.ProcessorType</code>
 */
class ProcessorType extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the processor type.
     * Format: `projects/{project}/processorTypes/{processor_type}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     *
     * Generated from protobuf field <code>string type = 2;</code>
     */
    private $type = '';
    /**
     * The processor category, used by UI to group processor types.
     *
     * Generated from protobuf field <code>string category = 3;</code>
     */
    private $category = '';
    /**
     * The locations in which this processor is available.
     *
     * Generated from protobuf field <code>repeated .google.cloud.documentai.v1.ProcessorType.LocationInfo available_locations = 4;</code>
     */
    private $available_locations;
    /**
     * Whether the processor type allows creation. If true, users can create a
     * processor of this processor type. Otherwise, users need to request access.
     *
     * Generated from protobuf field <code>bool allow_creation = 6;</code>
     */
    private $allow_creation = false;
    /**
     * Launch stage of the processor type
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 8;</code>
     */
    private $launch_stage = 0;
    /**
     * A set of Cloud Storage URIs of sample documents for this processor.
     *
     * Generated from protobuf field <code>repeated string sample_document_uris = 9;</code>
     */
    private $sample_document_uris;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the processor type.
     *           Format: `projects/{project}/processorTypes/{processor_type}`
     *     @type string $type
     *           The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     *     @type string $category
     *           The processor category, used by UI to group processor types.
     *     @type array<\Google\Cloud\DocumentAI\V1\ProcessorType\LocationInfo>|\Google\Protobuf\Internal\RepeatedField $available_locations
     *           The locations in which this processor is available.
     *     @type bool $allow_creation
     *           Whether the processor type allows creation. If true, users can create a
     *           processor of this processor type. Otherwise, users need to request access.
     *     @type int $launch_stage
     *           Launch stage of the processor type
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $sample_document_uris
     *           A set of Cloud Storage URIs of sample documents for this processor.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Documentai\V1\ProcessorType::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the processor type.
     * Format: `projects/{project}/processorTypes/{processor_type}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the processor type.
     * Format: `projects/{project}/processorTypes/{processor_type}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     *
     * Generated from protobuf field <code>string type = 2;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     *
     * Generated from protobuf field <code>string type = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * The processor category, used by UI to group processor types.
     *
     * Generated from protobuf field <code>string category = 3;</code>
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * The processor category, used by UI to group processor types.
     *
     * Generated from protobuf field <code>string category = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setCategory($var)
    {
        GPBUtil::checkString($var, True);
        $this->category = $var;

        return $this;
    }

    /**
     * The locations in which this processor is available.
     *
     * Generated from protobuf field <code>repeated .google.cloud.documentai.v1.ProcessorType.LocationInfo available_locations = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAvailableLocations()
    {
        return $this->available_locations;
    }

    /**
     * The locations in which this processor is available.
     *
     * Generated from protobuf field <code>repeated .google.cloud.documentai.v1.ProcessorType.LocationInfo available_locations = 4;</code>
     * @param array<\Google\Cloud\DocumentAI\V1\ProcessorType\LocationInfo>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAvailableLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DocumentAI\V1\ProcessorType\LocationInfo::class);
        $this->available_locations = $arr;

        return $this;
    }

    /**
     * Whether the processor type allows creation. If true, users can create a
     * processor of this processor type. Otherwise, users need to request access.
     *
     * Generated from protobuf field <code>bool allow_creation = 6;</code>
     * @return bool
     */
    public function getAllowCreation()
    {
        return $this->allow_creation;
    }

    /**
     * Whether the processor type allows creation. If true, users can create a
     * processor of this processor type. Otherwise, users need to request access.
     *
     * Generated from protobuf field <code>bool allow_creation = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowCreation($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_creation = $var;

        return $this;
    }

    /**
     * Launch stage of the processor type
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 8;</code>
     * @return int
     */
    public function getLaunchStage()
    {
        return $this->launch_stage;
    }

    /**
     * Launch stage of the processor type
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setLaunchStage($var)
    {
        GPBUtil::checkEnum($var, \Google\Api\LaunchStage::class);
        $this->launch_stage = $var;

        return $this;
    }

    /**
     * A set of Cloud Storage URIs of sample documents for this processor.
     *
     * Generated from protobuf field <code>repeated string sample_document_uris = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSampleDocumentUris()
    {
        return $this->sample_document_uris;
    }

    /**
     * A set of Cloud Storage URIs of sample documents for this processor.
     *
     * Generated from protobuf field <code>repeated string sample_document_uris = 9;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSampleDocumentUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->sample_document_uris = $arr;

        return $this;
    }

}

