<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1beta/search_service.proto

namespace Google\Cloud\DiscoveryEngine\V1beta\SearchRequest\ContentSearchSpec;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The specification that configs the extractive content in search results.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec</code>
 */
class ExtractiveContentSpec extends \Google\Protobuf\Internal\Message
{
    /**
     * The max number of extractive answers returned in each search result.
     * An extractive answer is a verbatim answer extracted from the original
     * document, which provides precise and contextually relevant answer to
     * the search query.
     * If the number of matching answers is less than the
     * extractive_answer_count, return all of the answers; otherwise, return
     * the extractive_answer_count.
     * At most 5 answers will be returned for each SearchResult.
     *
     * Generated from protobuf field <code>int32 max_extractive_answer_count = 1;</code>
     */
    protected $max_extractive_answer_count = 0;
    /**
     * The max number of extractive segments returned in each search result.
     * An extractive segment is a text segment extracted from the original
     * document which is relevant to the search query and in general more
     * verbose than an extrative answer. The segment could then be used as
     * input for LLMs to generate summaries and answers.
     * If the number of matching segments is less than the
     * max_extractive_segment_count, return all of the segments; otherwise,
     * return the max_extractive_segment_count.
     * Currently one segment will be returned for each SearchResult.
     *
     * Generated from protobuf field <code>int32 max_extractive_segment_count = 2;</code>
     */
    protected $max_extractive_segment_count = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $max_extractive_answer_count
     *           The max number of extractive answers returned in each search result.
     *           An extractive answer is a verbatim answer extracted from the original
     *           document, which provides precise and contextually relevant answer to
     *           the search query.
     *           If the number of matching answers is less than the
     *           extractive_answer_count, return all of the answers; otherwise, return
     *           the extractive_answer_count.
     *           At most 5 answers will be returned for each SearchResult.
     *     @type int $max_extractive_segment_count
     *           The max number of extractive segments returned in each search result.
     *           An extractive segment is a text segment extracted from the original
     *           document which is relevant to the search query and in general more
     *           verbose than an extrative answer. The segment could then be used as
     *           input for LLMs to generate summaries and answers.
     *           If the number of matching segments is less than the
     *           max_extractive_segment_count, return all of the segments; otherwise,
     *           return the max_extractive_segment_count.
     *           Currently one segment will be returned for each SearchResult.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1Beta\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * The max number of extractive answers returned in each search result.
     * An extractive answer is a verbatim answer extracted from the original
     * document, which provides precise and contextually relevant answer to
     * the search query.
     * If the number of matching answers is less than the
     * extractive_answer_count, return all of the answers; otherwise, return
     * the extractive_answer_count.
     * At most 5 answers will be returned for each SearchResult.
     *
     * Generated from protobuf field <code>int32 max_extractive_answer_count = 1;</code>
     * @return int
     */
    public function getMaxExtractiveAnswerCount()
    {
        return $this->max_extractive_answer_count;
    }

    /**
     * The max number of extractive answers returned in each search result.
     * An extractive answer is a verbatim answer extracted from the original
     * document, which provides precise and contextually relevant answer to
     * the search query.
     * If the number of matching answers is less than the
     * extractive_answer_count, return all of the answers; otherwise, return
     * the extractive_answer_count.
     * At most 5 answers will be returned for each SearchResult.
     *
     * Generated from protobuf field <code>int32 max_extractive_answer_count = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxExtractiveAnswerCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_extractive_answer_count = $var;

        return $this;
    }

    /**
     * The max number of extractive segments returned in each search result.
     * An extractive segment is a text segment extracted from the original
     * document which is relevant to the search query and in general more
     * verbose than an extrative answer. The segment could then be used as
     * input for LLMs to generate summaries and answers.
     * If the number of matching segments is less than the
     * max_extractive_segment_count, return all of the segments; otherwise,
     * return the max_extractive_segment_count.
     * Currently one segment will be returned for each SearchResult.
     *
     * Generated from protobuf field <code>int32 max_extractive_segment_count = 2;</code>
     * @return int
     */
    public function getMaxExtractiveSegmentCount()
    {
        return $this->max_extractive_segment_count;
    }

    /**
     * The max number of extractive segments returned in each search result.
     * An extractive segment is a text segment extracted from the original
     * document which is relevant to the search query and in general more
     * verbose than an extrative answer. The segment could then be used as
     * input for LLMs to generate summaries and answers.
     * If the number of matching segments is less than the
     * max_extractive_segment_count, return all of the segments; otherwise,
     * return the max_extractive_segment_count.
     * Currently one segment will be returned for each SearchResult.
     *
     * Generated from protobuf field <code>int32 max_extractive_segment_count = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxExtractiveSegmentCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_extractive_segment_count = $var;

        return $this;
    }

}


