<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/datalabeling/v1beta1/data_labeling_service.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\DataLabeling\V1beta1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DataLabeling\V1beta1\AnnotatedDataset;
use Google\Cloud\DataLabeling\V1beta1\AnnotationSpecSet;
use Google\Cloud\DataLabeling\V1beta1\CreateAnnotationSpecSetRequest;
use Google\Cloud\DataLabeling\V1beta1\CreateDatasetRequest;
use Google\Cloud\DataLabeling\V1beta1\CreateEvaluationJobRequest;
use Google\Cloud\DataLabeling\V1beta1\CreateInstructionRequest;
use Google\Cloud\DataLabeling\V1beta1\DataItem;
use Google\Cloud\DataLabeling\V1beta1\Dataset;
use Google\Cloud\DataLabeling\V1beta1\DeleteAnnotatedDatasetRequest;
use Google\Cloud\DataLabeling\V1beta1\DeleteAnnotationSpecSetRequest;
use Google\Cloud\DataLabeling\V1beta1\DeleteDatasetRequest;
use Google\Cloud\DataLabeling\V1beta1\DeleteEvaluationJobRequest;
use Google\Cloud\DataLabeling\V1beta1\DeleteInstructionRequest;
use Google\Cloud\DataLabeling\V1beta1\Evaluation;
use Google\Cloud\DataLabeling\V1beta1\EvaluationJob;
use Google\Cloud\DataLabeling\V1beta1\Example;
use Google\Cloud\DataLabeling\V1beta1\ExportDataRequest;
use Google\Cloud\DataLabeling\V1beta1\GetAnnotatedDatasetRequest;
use Google\Cloud\DataLabeling\V1beta1\GetAnnotationSpecSetRequest;
use Google\Cloud\DataLabeling\V1beta1\GetDataItemRequest;
use Google\Cloud\DataLabeling\V1beta1\GetDatasetRequest;
use Google\Cloud\DataLabeling\V1beta1\GetEvaluationJobRequest;
use Google\Cloud\DataLabeling\V1beta1\GetEvaluationRequest;
use Google\Cloud\DataLabeling\V1beta1\GetExampleRequest;
use Google\Cloud\DataLabeling\V1beta1\GetInstructionRequest;
use Google\Cloud\DataLabeling\V1beta1\ImportDataRequest;
use Google\Cloud\DataLabeling\V1beta1\Instruction;
use Google\Cloud\DataLabeling\V1beta1\LabelImageRequest;
use Google\Cloud\DataLabeling\V1beta1\LabelTextRequest;
use Google\Cloud\DataLabeling\V1beta1\LabelVideoRequest;
use Google\Cloud\DataLabeling\V1beta1\ListAnnotatedDatasetsRequest;
use Google\Cloud\DataLabeling\V1beta1\ListAnnotationSpecSetsRequest;
use Google\Cloud\DataLabeling\V1beta1\ListDataItemsRequest;
use Google\Cloud\DataLabeling\V1beta1\ListDatasetsRequest;
use Google\Cloud\DataLabeling\V1beta1\ListEvaluationJobsRequest;
use Google\Cloud\DataLabeling\V1beta1\ListExamplesRequest;
use Google\Cloud\DataLabeling\V1beta1\ListInstructionsRequest;
use Google\Cloud\DataLabeling\V1beta1\PauseEvaluationJobRequest;
use Google\Cloud\DataLabeling\V1beta1\ResumeEvaluationJobRequest;
use Google\Cloud\DataLabeling\V1beta1\SearchEvaluationsRequest;
use Google\Cloud\DataLabeling\V1beta1\SearchExampleComparisonsRequest;
use Google\Cloud\DataLabeling\V1beta1\UpdateEvaluationJobRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service for the AI Platform Data Labeling API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createAnnotationSpecSetAsync(CreateAnnotationSpecSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDatasetAsync(CreateDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createEvaluationJobAsync(CreateEvaluationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createInstructionAsync(CreateInstructionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAnnotatedDatasetAsync(DeleteAnnotatedDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAnnotationSpecSetAsync(DeleteAnnotationSpecSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDatasetAsync(DeleteDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteEvaluationJobAsync(DeleteEvaluationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteInstructionAsync(DeleteInstructionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface exportDataAsync(ExportDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAnnotatedDatasetAsync(GetAnnotatedDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAnnotationSpecSetAsync(GetAnnotationSpecSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDataItemAsync(GetDataItemRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDatasetAsync(GetDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEvaluationAsync(GetEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEvaluationJobAsync(GetEvaluationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getExampleAsync(GetExampleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getInstructionAsync(GetInstructionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface importDataAsync(ImportDataRequest $request, array $optionalArgs = [])
 * @method PromiseInterface labelImageAsync(LabelImageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface labelTextAsync(LabelTextRequest $request, array $optionalArgs = [])
 * @method PromiseInterface labelVideoAsync(LabelVideoRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAnnotatedDatasetsAsync(ListAnnotatedDatasetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAnnotationSpecSetsAsync(ListAnnotationSpecSetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDataItemsAsync(ListDataItemsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDatasetsAsync(ListDatasetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEvaluationJobsAsync(ListEvaluationJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listExamplesAsync(ListExamplesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listInstructionsAsync(ListInstructionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface pauseEvaluationJobAsync(PauseEvaluationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resumeEvaluationJobAsync(ResumeEvaluationJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchEvaluationsAsync(SearchEvaluationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchExampleComparisonsAsync(SearchExampleComparisonsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateEvaluationJobAsync(UpdateEvaluationJobRequest $request, array $optionalArgs = [])
 */
abstract class DataLabelingServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.datalabeling.v1beta1.DataLabelingService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'datalabeling.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/data_labeling_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/data_labeling_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/data_labeling_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/data_labeling_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     *
     * @experimental
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     *
     * @experimental
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * annotated_dataset resource.
     *
     * @param string $project
     * @param string $dataset
     * @param string $annotatedDataset
     *
     * @return string The formatted annotated_dataset resource.
     *
     * @experimental
     */
    public static function annotatedDatasetName(string $project, string $dataset, string $annotatedDataset): string
    {
        return self::getPathTemplate('annotatedDataset')->render([
            'project' => $project,
            'dataset' => $dataset,
            'annotated_dataset' => $annotatedDataset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * annotation_spec_set resource.
     *
     * @param string $project
     * @param string $annotationSpecSet
     *
     * @return string The formatted annotation_spec_set resource.
     *
     * @experimental
     */
    public static function annotationSpecSetName(string $project, string $annotationSpecSet): string
    {
        return self::getPathTemplate('annotationSpecSet')->render([
            'project' => $project,
            'annotation_spec_set' => $annotationSpecSet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_item
     * resource.
     *
     * @param string $project
     * @param string $dataset
     * @param string $dataItem
     *
     * @return string The formatted data_item resource.
     *
     * @experimental
     */
    public static function dataItemName(string $project, string $dataset, string $dataItem): string
    {
        return self::getPathTemplate('dataItem')->render([
            'project' => $project,
            'dataset' => $dataset,
            'data_item' => $dataItem,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dataset
     * resource.
     *
     * @param string $project
     * @param string $dataset
     *
     * @return string The formatted dataset resource.
     *
     * @experimental
     */
    public static function datasetName(string $project, string $dataset): string
    {
        return self::getPathTemplate('dataset')->render([
            'project' => $project,
            'dataset' => $dataset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a evaluation
     * resource.
     *
     * @param string $project
     * @param string $dataset
     * @param string $evaluation
     *
     * @return string The formatted evaluation resource.
     *
     * @experimental
     */
    public static function evaluationName(string $project, string $dataset, string $evaluation): string
    {
        return self::getPathTemplate('evaluation')->render([
            'project' => $project,
            'dataset' => $dataset,
            'evaluation' => $evaluation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * evaluation_job resource.
     *
     * @param string $project
     * @param string $evaluationJob
     *
     * @return string The formatted evaluation_job resource.
     *
     * @experimental
     */
    public static function evaluationJobName(string $project, string $evaluationJob): string
    {
        return self::getPathTemplate('evaluationJob')->render([
            'project' => $project,
            'evaluation_job' => $evaluationJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a example
     * resource.
     *
     * @param string $project
     * @param string $dataset
     * @param string $annotatedDataset
     * @param string $example
     *
     * @return string The formatted example resource.
     *
     * @experimental
     */
    public static function exampleName(string $project, string $dataset, string $annotatedDataset, string $example): string
    {
        return self::getPathTemplate('example')->render([
            'project' => $project,
            'dataset' => $dataset,
            'annotated_dataset' => $annotatedDataset,
            'example' => $example,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instruction
     * resource.
     *
     * @param string $project
     * @param string $instruction
     *
     * @return string The formatted instruction resource.
     *
     * @experimental
     */
    public static function instructionName(string $project, string $instruction): string
    {
        return self::getPathTemplate('instruction')->render([
            'project' => $project,
            'instruction' => $instruction,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     *
     * @experimental
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - annotatedDataset: projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}
     * - annotationSpecSet: projects/{project}/annotationSpecSets/{annotation_spec_set}
     * - dataItem: projects/{project}/datasets/{dataset}/dataItems/{data_item}
     * - dataset: projects/{project}/datasets/{dataset}
     * - evaluation: projects/{project}/datasets/{dataset}/evaluations/{evaluation}
     * - evaluationJob: projects/{project}/evaluationJobs/{evaluation_job}
     * - example: projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}/examples/{example}
     * - instruction: projects/{project}/instructions/{instruction}
     * - project: projects/{project}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datalabeling.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an annotation spec set by providing a set of labels.
     *
     * The async variant is {@see self::createAnnotationSpecSetAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/create_annotation_spec_set.php
     *
     * @param CreateAnnotationSpecSetRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnnotationSpecSet
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createAnnotationSpecSet(CreateAnnotationSpecSetRequest $request, array $callOptions = []): AnnotationSpecSet
    {
        return $this->startApiCall('CreateAnnotationSpecSet', $request, $callOptions)->wait();
    }

    /**
     * Creates dataset. If success return a Dataset resource.
     *
     * The async variant is {@see self::createDatasetAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/create_dataset.php
     *
     * @param CreateDatasetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Dataset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createDataset(CreateDatasetRequest $request, array $callOptions = []): Dataset
    {
        return $this->startApiCall('CreateDataset', $request, $callOptions)->wait();
    }

    /**
     * Creates an evaluation job.
     *
     * The async variant is {@see self::createEvaluationJobAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/create_evaluation_job.php
     *
     * @param CreateEvaluationJobRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationJob
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createEvaluationJob(CreateEvaluationJobRequest $request, array $callOptions = []): EvaluationJob
    {
        return $this->startApiCall('CreateEvaluationJob', $request, $callOptions)->wait();
    }

    /**
     * Creates an instruction for how data should be labeled.
     *
     * The async variant is {@see self::createInstructionAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/create_instruction.php
     *
     * @param CreateInstructionRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createInstruction(CreateInstructionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstruction', $request, $callOptions)->wait();
    }

    /**
     * Deletes an annotated dataset by resource name.
     *
     * The async variant is {@see self::deleteAnnotatedDatasetAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/delete_annotated_dataset.php
     *
     * @param DeleteAnnotatedDatasetRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteAnnotatedDataset(DeleteAnnotatedDatasetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAnnotatedDataset', $request, $callOptions)->wait();
    }

    /**
     * Deletes an annotation spec set by resource name.
     *
     * The async variant is {@see self::deleteAnnotationSpecSetAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/delete_annotation_spec_set.php
     *
     * @param DeleteAnnotationSpecSetRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteAnnotationSpecSet(DeleteAnnotationSpecSetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAnnotationSpecSet', $request, $callOptions)->wait();
    }

    /**
     * Deletes a dataset by resource name.
     *
     * The async variant is {@see self::deleteDatasetAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/delete_dataset.php
     *
     * @param DeleteDatasetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteDataset(DeleteDatasetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDataset', $request, $callOptions)->wait();
    }

    /**
     * Stops and deletes an evaluation job.
     *
     * The async variant is {@see self::deleteEvaluationJobAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/delete_evaluation_job.php
     *
     * @param DeleteEvaluationJobRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteEvaluationJob(DeleteEvaluationJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEvaluationJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes an instruction object by resource name.
     *
     * The async variant is {@see self::deleteInstructionAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/delete_instruction.php
     *
     * @param DeleteInstructionRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteInstruction(DeleteInstructionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteInstruction', $request, $callOptions)->wait();
    }

    /**
     * Exports data and annotations from dataset.
     *
     * The async variant is {@see self::exportDataAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/export_data.php
     *
     * @param ExportDataRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function exportData(ExportDataRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportData', $request, $callOptions)->wait();
    }

    /**
     * Gets an annotated dataset by resource name.
     *
     * The async variant is {@see self::getAnnotatedDatasetAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/get_annotated_dataset.php
     *
     * @param GetAnnotatedDatasetRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnnotatedDataset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAnnotatedDataset(GetAnnotatedDatasetRequest $request, array $callOptions = []): AnnotatedDataset
    {
        return $this->startApiCall('GetAnnotatedDataset', $request, $callOptions)->wait();
    }

    /**
     * Gets an annotation spec set by resource name.
     *
     * The async variant is {@see self::getAnnotationSpecSetAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/get_annotation_spec_set.php
     *
     * @param GetAnnotationSpecSetRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnnotationSpecSet
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAnnotationSpecSet(GetAnnotationSpecSetRequest $request, array $callOptions = []): AnnotationSpecSet
    {
        return $this->startApiCall('GetAnnotationSpecSet', $request, $callOptions)->wait();
    }

    /**
     * Gets a data item in a dataset by resource name. This API can be
     * called after data are imported into dataset.
     *
     * The async variant is {@see self::getDataItemAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/get_data_item.php
     *
     * @param GetDataItemRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataItem
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataItem(GetDataItemRequest $request, array $callOptions = []): DataItem
    {
        return $this->startApiCall('GetDataItem', $request, $callOptions)->wait();
    }

    /**
     * Gets dataset by resource name.
     *
     * The async variant is {@see self::getDatasetAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/get_dataset.php
     *
     * @param GetDatasetRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Dataset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataset(GetDatasetRequest $request, array $callOptions = []): Dataset
    {
        return $this->startApiCall('GetDataset', $request, $callOptions)->wait();
    }

    /**
     * Gets an evaluation by resource name (to search, use
     * [projects.evaluations.search][google.cloud.datalabeling.v1beta1.DataLabelingService.SearchEvaluations]).
     *
     * The async variant is {@see self::getEvaluationAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/get_evaluation.php
     *
     * @param GetEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Evaluation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEvaluation(GetEvaluationRequest $request, array $callOptions = []): Evaluation
    {
        return $this->startApiCall('GetEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Gets an evaluation job by resource name.
     *
     * The async variant is {@see self::getEvaluationJobAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/get_evaluation_job.php
     *
     * @param GetEvaluationJobRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationJob
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEvaluationJob(GetEvaluationJobRequest $request, array $callOptions = []): EvaluationJob
    {
        return $this->startApiCall('GetEvaluationJob', $request, $callOptions)->wait();
    }

    /**
     * Gets an example by resource name, including both data and annotation.
     *
     * The async variant is {@see self::getExampleAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/get_example.php
     *
     * @param GetExampleRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Example
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getExample(GetExampleRequest $request, array $callOptions = []): Example
    {
        return $this->startApiCall('GetExample', $request, $callOptions)->wait();
    }

    /**
     * Gets an instruction by resource name.
     *
     * The async variant is {@see self::getInstructionAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/get_instruction.php
     *
     * @param GetInstructionRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instruction
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getInstruction(GetInstructionRequest $request, array $callOptions = []): Instruction
    {
        return $this->startApiCall('GetInstruction', $request, $callOptions)->wait();
    }

    /**
     * Imports data into dataset based on source locations defined in request.
     * It can be called multiple times for the same dataset. Each dataset can
     * only have one long running operation running on it. For example, no
     * labeling task (also long running operation) can be started while
     * importing is still ongoing. Vice versa.
     *
     * The async variant is {@see self::importDataAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/import_data.php
     *
     * @param ImportDataRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function importData(ImportDataRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportData', $request, $callOptions)->wait();
    }

    /**
     * Starts a labeling task for image. The type of image labeling task is
     * configured by feature in the request.
     *
     * The async variant is {@see self::labelImageAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/label_image.php
     *
     * @param LabelImageRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function labelImage(LabelImageRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('LabelImage', $request, $callOptions)->wait();
    }

    /**
     * Starts a labeling task for text. The type of text labeling task is
     * configured by feature in the request.
     *
     * The async variant is {@see self::labelTextAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/label_text.php
     *
     * @param LabelTextRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function labelText(LabelTextRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('LabelText', $request, $callOptions)->wait();
    }

    /**
     * Starts a labeling task for video. The type of video labeling task is
     * configured by feature in the request.
     *
     * The async variant is {@see self::labelVideoAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/label_video.php
     *
     * @param LabelVideoRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function labelVideo(LabelVideoRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('LabelVideo', $request, $callOptions)->wait();
    }

    /**
     * Lists annotated datasets for a dataset. Pagination is supported.
     *
     * The async variant is {@see self::listAnnotatedDatasetsAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/list_annotated_datasets.php
     *
     * @param ListAnnotatedDatasetsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAnnotatedDatasets(ListAnnotatedDatasetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAnnotatedDatasets', $request, $callOptions);
    }

    /**
     * Lists annotation spec sets for a project. Pagination is supported.
     *
     * The async variant is {@see self::listAnnotationSpecSetsAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/list_annotation_spec_sets.php
     *
     * @param ListAnnotationSpecSetsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAnnotationSpecSets(ListAnnotationSpecSetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAnnotationSpecSets', $request, $callOptions);
    }

    /**
     * Lists data items in a dataset. This API can be called after data
     * are imported into dataset. Pagination is supported.
     *
     * The async variant is {@see self::listDataItemsAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/list_data_items.php
     *
     * @param ListDataItemsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listDataItems(ListDataItemsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDataItems', $request, $callOptions);
    }

    /**
     * Lists datasets under a project. Pagination is supported.
     *
     * The async variant is {@see self::listDatasetsAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/list_datasets.php
     *
     * @param ListDatasetsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listDatasets(ListDatasetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDatasets', $request, $callOptions);
    }

    /**
     * Lists all evaluation jobs within a project with possible filters.
     * Pagination is supported.
     *
     * The async variant is {@see self::listEvaluationJobsAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/list_evaluation_jobs.php
     *
     * @param ListEvaluationJobsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listEvaluationJobs(ListEvaluationJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEvaluationJobs', $request, $callOptions);
    }

    /**
     * Lists examples in an annotated dataset. Pagination is supported.
     *
     * The async variant is {@see self::listExamplesAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/list_examples.php
     *
     * @param ListExamplesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listExamples(ListExamplesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListExamples', $request, $callOptions);
    }

    /**
     * Lists instructions for a project. Pagination is supported.
     *
     * The async variant is {@see self::listInstructionsAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/list_instructions.php
     *
     * @param ListInstructionsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listInstructions(ListInstructionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInstructions', $request, $callOptions);
    }

    /**
     * Pauses an evaluation job. Pausing an evaluation job that is already in a
     * `PAUSED` state is a no-op.
     *
     * The async variant is {@see self::pauseEvaluationJobAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/pause_evaluation_job.php
     *
     * @param PauseEvaluationJobRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function pauseEvaluationJob(PauseEvaluationJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('PauseEvaluationJob', $request, $callOptions)->wait();
    }

    /**
     * Resumes a paused evaluation job. A deleted evaluation job can't be resumed.
     * Resuming a running or scheduled evaluation job is a no-op.
     *
     * The async variant is {@see self::resumeEvaluationJobAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/resume_evaluation_job.php
     *
     * @param ResumeEvaluationJobRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function resumeEvaluationJob(ResumeEvaluationJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('ResumeEvaluationJob', $request, $callOptions)->wait();
    }

    /**
     * Searches [evaluations][google.cloud.datalabeling.v1beta1.Evaluation] within a project.
     *
     * The async variant is {@see self::searchEvaluationsAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/search_evaluations.php
     *
     * @param SearchEvaluationsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function searchEvaluations(SearchEvaluationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchEvaluations', $request, $callOptions);
    }

    /**
     * Searches example comparisons from an evaluation. The return format is a
     * list of example comparisons that show ground truth and prediction(s) for
     * a single input. Search by providing an evaluation ID.
     *
     * The async variant is {@see self::searchExampleComparisonsAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/search_example_comparisons.php
     *
     * @param SearchExampleComparisonsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function searchExampleComparisons(SearchExampleComparisonsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchExampleComparisons', $request, $callOptions);
    }

    /**
     * Updates an evaluation job. You can only update certain fields of the job's
     * [EvaluationJobConfig][google.cloud.datalabeling.v1beta1.EvaluationJobConfig]: `humanAnnotationConfig.instruction`,
     * `exampleCount`, and `exampleSamplePercentage`.
     *
     * If you want to change any other aspect of the evaluation job, you must
     * delete the job and create a new one.
     *
     * The async variant is {@see self::updateEvaluationJobAsync()} .
     *
     * @example samples/V1beta1/DataLabelingServiceClient/update_evaluation_job.php
     *
     * @param UpdateEvaluationJobRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationJob
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateEvaluationJob(UpdateEvaluationJobRequest $request, array $callOptions = []): EvaluationJob
    {
        return $this->startApiCall('UpdateEvaluationJob', $request, $callOptions)->wait();
    }
}
