<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/batch/v1/task.proto

namespace Google\Cloud\Batch\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Runnable describes instructions for executing a specific script or container
 * as part of a Task.
 *
 * Generated from protobuf message <code>google.cloud.batch.v1.Runnable</code>
 */
class Runnable extends \Google\Protobuf\Internal\Message
{
    /**
     * Normally, a non-zero exit status causes the Task to fail. This flag allows
     * execution of other Runnables to continue instead.
     *
     * Generated from protobuf field <code>bool ignore_exit_status = 3;</code>
     */
    private $ignore_exit_status = false;
    /**
     * This flag allows a Runnable to continue running in the background while the
     * Task executes subsequent Runnables. This is useful to provide services to
     * other Runnables (or to provide debugging support tools like SSH servers).
     *
     * Generated from protobuf field <code>bool background = 4;</code>
     */
    private $background = false;
    /**
     * By default, after a Runnable fails, no further Runnable are executed. This
     * flag indicates that this Runnable must be run even if the Task has already
     * failed. This is useful for Runnables that copy output files off of the VM
     * or for debugging.
     * The always_run flag does not override the Task's overall max_run_duration.
     * If the max_run_duration has expired then no further Runnables will execute,
     * not even always_run Runnables.
     *
     * Generated from protobuf field <code>bool always_run = 5;</code>
     */
    private $always_run = false;
    /**
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Environment environment = 7;</code>
     */
    private $environment = null;
    /**
     * Timeout for this Runnable.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 8;</code>
     */
    private $timeout = null;
    /**
     * Labels for this Runnable.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     */
    private $labels;
    protected $executable;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Batch\V1\Runnable\Container $container
     *           Container runnable.
     *     @type \Google\Cloud\Batch\V1\Runnable\Script $script
     *           Script runnable.
     *     @type \Google\Cloud\Batch\V1\Runnable\Barrier $barrier
     *           Barrier runnable.
     *     @type bool $ignore_exit_status
     *           Normally, a non-zero exit status causes the Task to fail. This flag allows
     *           execution of other Runnables to continue instead.
     *     @type bool $background
     *           This flag allows a Runnable to continue running in the background while the
     *           Task executes subsequent Runnables. This is useful to provide services to
     *           other Runnables (or to provide debugging support tools like SSH servers).
     *     @type bool $always_run
     *           By default, after a Runnable fails, no further Runnable are executed. This
     *           flag indicates that this Runnable must be run even if the Task has already
     *           failed. This is useful for Runnables that copy output files off of the VM
     *           or for debugging.
     *           The always_run flag does not override the Task's overall max_run_duration.
     *           If the max_run_duration has expired then no further Runnables will execute,
     *           not even always_run Runnables.
     *     @type \Google\Cloud\Batch\V1\Environment $environment
     *           Environment variables for this Runnable (overrides variables set for the
     *           whole Task or TaskGroup).
     *     @type \Google\Protobuf\Duration $timeout
     *           Timeout for this Runnable.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels for this Runnable.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Batch\V1\Task::initOnce();
        parent::__construct($data);
    }

    /**
     * Container runnable.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Runnable.Container container = 1;</code>
     * @return \Google\Cloud\Batch\V1\Runnable\Container|null
     */
    public function getContainer()
    {
        return $this->readOneof(1);
    }

    public function hasContainer()
    {
        return $this->hasOneof(1);
    }

    /**
     * Container runnable.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Runnable.Container container = 1;</code>
     * @param \Google\Cloud\Batch\V1\Runnable\Container $var
     * @return $this
     */
    public function setContainer($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\Runnable\Container::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Script runnable.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Runnable.Script script = 2;</code>
     * @return \Google\Cloud\Batch\V1\Runnable\Script|null
     */
    public function getScript()
    {
        return $this->readOneof(2);
    }

    public function hasScript()
    {
        return $this->hasOneof(2);
    }

    /**
     * Script runnable.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Runnable.Script script = 2;</code>
     * @param \Google\Cloud\Batch\V1\Runnable\Script $var
     * @return $this
     */
    public function setScript($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\Runnable\Script::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Barrier runnable.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Runnable.Barrier barrier = 6;</code>
     * @return \Google\Cloud\Batch\V1\Runnable\Barrier|null
     */
    public function getBarrier()
    {
        return $this->readOneof(6);
    }

    public function hasBarrier()
    {
        return $this->hasOneof(6);
    }

    /**
     * Barrier runnable.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Runnable.Barrier barrier = 6;</code>
     * @param \Google\Cloud\Batch\V1\Runnable\Barrier $var
     * @return $this
     */
    public function setBarrier($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\Runnable\Barrier::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Normally, a non-zero exit status causes the Task to fail. This flag allows
     * execution of other Runnables to continue instead.
     *
     * Generated from protobuf field <code>bool ignore_exit_status = 3;</code>
     * @return bool
     */
    public function getIgnoreExitStatus()
    {
        return $this->ignore_exit_status;
    }

    /**
     * Normally, a non-zero exit status causes the Task to fail. This flag allows
     * execution of other Runnables to continue instead.
     *
     * Generated from protobuf field <code>bool ignore_exit_status = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreExitStatus($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_exit_status = $var;

        return $this;
    }

    /**
     * This flag allows a Runnable to continue running in the background while the
     * Task executes subsequent Runnables. This is useful to provide services to
     * other Runnables (or to provide debugging support tools like SSH servers).
     *
     * Generated from protobuf field <code>bool background = 4;</code>
     * @return bool
     */
    public function getBackground()
    {
        return $this->background;
    }

    /**
     * This flag allows a Runnable to continue running in the background while the
     * Task executes subsequent Runnables. This is useful to provide services to
     * other Runnables (or to provide debugging support tools like SSH servers).
     *
     * Generated from protobuf field <code>bool background = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setBackground($var)
    {
        GPBUtil::checkBool($var);
        $this->background = $var;

        return $this;
    }

    /**
     * By default, after a Runnable fails, no further Runnable are executed. This
     * flag indicates that this Runnable must be run even if the Task has already
     * failed. This is useful for Runnables that copy output files off of the VM
     * or for debugging.
     * The always_run flag does not override the Task's overall max_run_duration.
     * If the max_run_duration has expired then no further Runnables will execute,
     * not even always_run Runnables.
     *
     * Generated from protobuf field <code>bool always_run = 5;</code>
     * @return bool
     */
    public function getAlwaysRun()
    {
        return $this->always_run;
    }

    /**
     * By default, after a Runnable fails, no further Runnable are executed. This
     * flag indicates that this Runnable must be run even if the Task has already
     * failed. This is useful for Runnables that copy output files off of the VM
     * or for debugging.
     * The always_run flag does not override the Task's overall max_run_duration.
     * If the max_run_duration has expired then no further Runnables will execute,
     * not even always_run Runnables.
     *
     * Generated from protobuf field <code>bool always_run = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setAlwaysRun($var)
    {
        GPBUtil::checkBool($var);
        $this->always_run = $var;

        return $this;
    }

    /**
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Environment environment = 7;</code>
     * @return \Google\Cloud\Batch\V1\Environment|null
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    public function hasEnvironment()
    {
        return isset($this->environment);
    }

    public function clearEnvironment()
    {
        unset($this->environment);
    }

    /**
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.Environment environment = 7;</code>
     * @param \Google\Cloud\Batch\V1\Environment $var
     * @return $this
     */
    public function setEnvironment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\Environment::class);
        $this->environment = $var;

        return $this;
    }

    /**
     * Timeout for this Runnable.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 8;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * Timeout for this Runnable.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 8;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * Labels for this Runnable.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels for this Runnable.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getExecutable()
    {
        return $this->whichOneof("executable");
    }

}

