<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/metadata_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\AddContextArtifactsAndExecutionsRequest;
use Google\Cloud\AIPlatform\V1\AddContextArtifactsAndExecutionsResponse;
use Google\Cloud\AIPlatform\V1\AddContextChildrenRequest;
use Google\Cloud\AIPlatform\V1\AddContextChildrenResponse;
use Google\Cloud\AIPlatform\V1\AddExecutionEventsRequest;
use Google\Cloud\AIPlatform\V1\AddExecutionEventsResponse;
use Google\Cloud\AIPlatform\V1\Artifact;
use Google\Cloud\AIPlatform\V1\Context;
use Google\Cloud\AIPlatform\V1\CreateArtifactRequest;
use Google\Cloud\AIPlatform\V1\CreateContextRequest;
use Google\Cloud\AIPlatform\V1\CreateExecutionRequest;
use Google\Cloud\AIPlatform\V1\CreateMetadataSchemaRequest;
use Google\Cloud\AIPlatform\V1\CreateMetadataStoreRequest;
use Google\Cloud\AIPlatform\V1\DeleteArtifactRequest;
use Google\Cloud\AIPlatform\V1\DeleteContextRequest;
use Google\Cloud\AIPlatform\V1\DeleteExecutionRequest;
use Google\Cloud\AIPlatform\V1\DeleteMetadataStoreRequest;
use Google\Cloud\AIPlatform\V1\Event;
use Google\Cloud\AIPlatform\V1\Execution;
use Google\Cloud\AIPlatform\V1\GetArtifactRequest;
use Google\Cloud\AIPlatform\V1\GetContextRequest;
use Google\Cloud\AIPlatform\V1\GetExecutionRequest;
use Google\Cloud\AIPlatform\V1\GetMetadataSchemaRequest;
use Google\Cloud\AIPlatform\V1\GetMetadataStoreRequest;
use Google\Cloud\AIPlatform\V1\LineageSubgraph;
use Google\Cloud\AIPlatform\V1\ListArtifactsRequest;
use Google\Cloud\AIPlatform\V1\ListArtifactsResponse;
use Google\Cloud\AIPlatform\V1\ListContextsRequest;
use Google\Cloud\AIPlatform\V1\ListContextsResponse;
use Google\Cloud\AIPlatform\V1\ListExecutionsRequest;
use Google\Cloud\AIPlatform\V1\ListExecutionsResponse;
use Google\Cloud\AIPlatform\V1\ListMetadataSchemasRequest;
use Google\Cloud\AIPlatform\V1\ListMetadataSchemasResponse;
use Google\Cloud\AIPlatform\V1\ListMetadataStoresRequest;
use Google\Cloud\AIPlatform\V1\ListMetadataStoresResponse;
use Google\Cloud\AIPlatform\V1\MetadataSchema;
use Google\Cloud\AIPlatform\V1\MetadataStore;
use Google\Cloud\AIPlatform\V1\PurgeArtifactsRequest;
use Google\Cloud\AIPlatform\V1\PurgeContextsRequest;
use Google\Cloud\AIPlatform\V1\PurgeExecutionsRequest;
use Google\Cloud\AIPlatform\V1\QueryArtifactLineageSubgraphRequest;
use Google\Cloud\AIPlatform\V1\QueryContextLineageSubgraphRequest;
use Google\Cloud\AIPlatform\V1\QueryExecutionInputsAndOutputsRequest;
use Google\Cloud\AIPlatform\V1\RemoveContextChildrenRequest;
use Google\Cloud\AIPlatform\V1\RemoveContextChildrenResponse;
use Google\Cloud\AIPlatform\V1\UpdateArtifactRequest;
use Google\Cloud\AIPlatform\V1\UpdateContextRequest;
use Google\Cloud\AIPlatform\V1\UpdateExecutionRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Service for reading and writing metadata entries.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $metadataServiceClient = new MetadataServiceClient();
 * try {
 *     $formattedContext = $metadataServiceClient->contextName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[CONTEXT]');
 *     $response = $metadataServiceClient->addContextArtifactsAndExecutions($formattedContext);
 * } finally {
 *     $metadataServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\AIPlatform\V1\Client\MetadataServiceClient} to use the new
 * surface.
 */
class MetadataServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.MetadataService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $artifactNameTemplate;

    private static $contextNameTemplate;

    private static $executionNameTemplate;

    private static $locationNameTemplate;

    private static $metadataSchemaNameTemplate;

    private static $metadataStoreNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/metadata_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/metadata_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/metadata_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/metadata_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getArtifactNameTemplate()
    {
        if (self::$artifactNameTemplate == null) {
            self::$artifactNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}'
            );
        }

        return self::$artifactNameTemplate;
    }

    private static function getContextNameTemplate()
    {
        if (self::$contextNameTemplate == null) {
            self::$contextNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}/contexts/{context}'
            );
        }

        return self::$contextNameTemplate;
    }

    private static function getExecutionNameTemplate()
    {
        if (self::$executionNameTemplate == null) {
            self::$executionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}/executions/{execution}'
            );
        }

        return self::$executionNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getMetadataSchemaNameTemplate()
    {
        if (self::$metadataSchemaNameTemplate == null) {
            self::$metadataSchemaNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}/metadataSchemas/{metadata_schema}'
            );
        }

        return self::$metadataSchemaNameTemplate;
    }

    private static function getMetadataStoreNameTemplate()
    {
        if (self::$metadataStoreNameTemplate == null) {
            self::$metadataStoreNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}'
            );
        }

        return self::$metadataStoreNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'artifact' => self::getArtifactNameTemplate(),
                'context' => self::getContextNameTemplate(),
                'execution' => self::getExecutionNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'metadataSchema' => self::getMetadataSchemaNameTemplate(),
                'metadataStore' => self::getMetadataStoreNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a artifact
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $artifact
     *
     * @return string The formatted artifact resource.
     */
    public static function artifactName(
        $project,
        $location,
        $metadataStore,
        $artifact
    ) {
        return self::getArtifactNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a context
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $context
     *
     * @return string The formatted context resource.
     */
    public static function contextName(
        $project,
        $location,
        $metadataStore,
        $context
    ) {
        return self::getContextNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a execution
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $execution
     *
     * @return string The formatted execution resource.
     */
    public static function executionName(
        $project,
        $location,
        $metadataStore,
        $execution
    ) {
        return self::getExecutionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'execution' => $execution,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * metadata_schema resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $metadataSchema
     *
     * @return string The formatted metadata_schema resource.
     */
    public static function metadataSchemaName(
        $project,
        $location,
        $metadataStore,
        $metadataSchema
    ) {
        return self::getMetadataSchemaNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'metadata_schema' => $metadataSchema,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * metadata_store resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     *
     * @return string The formatted metadata_store resource.
     */
    public static function metadataStoreName(
        $project,
        $location,
        $metadataStore
    ) {
        return self::getMetadataStoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - artifact: projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}
     * - context: projects/{project}/locations/{location}/metadataStores/{metadata_store}/contexts/{context}
     * - execution: projects/{project}/locations/{location}/metadataStores/{metadata_store}/executions/{execution}
     * - location: projects/{project}/locations/{location}
     * - metadataSchema: projects/{project}/locations/{location}/metadataStores/{metadata_store}/metadataSchemas/{metadata_schema}
     * - metadataStore: projects/{project}/locations/{location}/metadataStores/{metadata_store}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Adds a set of Artifacts and Executions to a Context. If any of the
     * Artifacts or Executions have already been added to a Context, they are
     * simply skipped.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedContext = $metadataServiceClient->contextName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[CONTEXT]');
     *     $response = $metadataServiceClient->addContextArtifactsAndExecutions($formattedContext);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $context      Required. The resource name of the Context that the Artifacts and
     *                             Executions belong to. Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $artifacts
     *           The resource names of the Artifacts to attribute to the Context.
     *
     *           Format:
     *           `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
     *     @type string[] $executions
     *           The resource names of the Executions to associate with the
     *           Context.
     *
     *           Format:
     *           `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\AddContextArtifactsAndExecutionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function addContextArtifactsAndExecutions(
        $context,
        array $optionalArgs = []
    ) {
        $request = new AddContextArtifactsAndExecutionsRequest();
        $requestParamHeaders = [];
        $request->setContext($context);
        $requestParamHeaders['context'] = $context;
        if (isset($optionalArgs['artifacts'])) {
            $request->setArtifacts($optionalArgs['artifacts']);
        }

        if (isset($optionalArgs['executions'])) {
            $request->setExecutions($optionalArgs['executions']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'AddContextArtifactsAndExecutions',
            AddContextArtifactsAndExecutionsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Adds a set of Contexts as children to a parent Context. If any of the
     * child Contexts have already been added to the parent Context, they are
     * simply skipped. If this call would create a cycle or cause any Context to
     * have more than 10 parents, the request will fail with an INVALID_ARGUMENT
     * error.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedContext = $metadataServiceClient->contextName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[CONTEXT]');
     *     $response = $metadataServiceClient->addContextChildren($formattedContext);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $context      Required. The resource name of the parent Context.
     *
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $childContexts
     *           The resource names of the child Contexts.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\AddContextChildrenResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function addContextChildren($context, array $optionalArgs = [])
    {
        $request = new AddContextChildrenRequest();
        $requestParamHeaders = [];
        $request->setContext($context);
        $requestParamHeaders['context'] = $context;
        if (isset($optionalArgs['childContexts'])) {
            $request->setChildContexts($optionalArgs['childContexts']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'AddContextChildren',
            AddContextChildrenResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Adds Events to the specified Execution. An Event indicates whether an
     * Artifact was used as an input or output for an Execution. If an Event
     * already exists between the Execution and the Artifact, the Event is
     * skipped.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedExecution = $metadataServiceClient->executionName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[EXECUTION]');
     *     $response = $metadataServiceClient->addExecutionEvents($formattedExecution);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $execution    Required. The resource name of the Execution that the Events connect
     *                             Artifacts with.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type Event[] $events
     *           The Events to create and add.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\AddExecutionEventsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function addExecutionEvents($execution, array $optionalArgs = [])
    {
        $request = new AddExecutionEventsRequest();
        $requestParamHeaders = [];
        $request->setExecution($execution);
        $requestParamHeaders['execution'] = $execution;
        if (isset($optionalArgs['events'])) {
            $request->setEvents($optionalArgs['events']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'AddExecutionEvents',
            AddExecutionEventsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates an Artifact associated with a MetadataStore.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $artifact = new Artifact();
     *     $response = $metadataServiceClient->createArtifact($formattedParent, $artifact);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The resource name of the MetadataStore where the Artifact should
     *                               be created.
     *                               Format:
     *                               `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param Artifact $artifact     Required. The Artifact to create.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type string $artifactId
     *           The {artifact} portion of the resource name with the format:
     *           `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
     *           If not provided, the Artifact's ID will be a UUID generated by the service.
     *           Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
     *           Must be unique across all Artifacts in the parent MetadataStore. (Otherwise
     *           the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
     *           caller can't view the preexisting Artifact.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Artifact
     *
     * @throws ApiException if the remote call fails
     */
    public function createArtifact($parent, $artifact, array $optionalArgs = [])
    {
        $request = new CreateArtifactRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setArtifact($artifact);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['artifactId'])) {
            $request->setArtifactId($optionalArgs['artifactId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateArtifact',
            Artifact::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a Context associated with a MetadataStore.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $context = new Context();
     *     $response = $metadataServiceClient->createContext($formattedParent, $context);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The resource name of the MetadataStore where the Context should
     *                              be created. Format:
     *                              `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param Context $context      Required. The Context to create.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $contextId
     *           The {context} portion of the resource name with the format:
     *           `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`.
     *           If not provided, the Context's ID will be a UUID generated by the service.
     *           Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
     *           Must be unique across all Contexts in the parent MetadataStore. (Otherwise
     *           the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
     *           caller can't view the preexisting Context.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Context
     *
     * @throws ApiException if the remote call fails
     */
    public function createContext($parent, $context, array $optionalArgs = [])
    {
        $request = new CreateContextRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setContext($context);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['contextId'])) {
            $request->setContextId($optionalArgs['contextId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateContext',
            Context::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates an Execution associated with a MetadataStore.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $execution = new Execution();
     *     $response = $metadataServiceClient->createExecution($formattedParent, $execution);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. The resource name of the MetadataStore where the Execution should
     *                                be created.
     *                                Format:
     *                                `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param Execution $execution    Required. The Execution to create.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $executionId
     *           The {execution} portion of the resource name with the format:
     *           `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
     *           If not provided, the Execution's ID will be a UUID generated by the
     *           service.
     *           Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
     *           Must be unique across all Executions in the parent MetadataStore.
     *           (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
     *           if the caller can't view the preexisting Execution.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Execution
     *
     * @throws ApiException if the remote call fails
     */
    public function createExecution(
        $parent,
        $execution,
        array $optionalArgs = []
    ) {
        $request = new CreateExecutionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setExecution($execution);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['executionId'])) {
            $request->setExecutionId($optionalArgs['executionId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateExecution',
            Execution::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a MetadataSchema.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $metadataSchema = new MetadataSchema();
     *     $response = $metadataServiceClient->createMetadataSchema($formattedParent, $metadataSchema);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string         $parent         Required. The resource name of the MetadataStore where the MetadataSchema
     *                                       should be created. Format:
     *                                       `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param MetadataSchema $metadataSchema Required. The MetadataSchema to create.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type string $metadataSchemaId
     *           The {metadata_schema} portion of the resource name with the format:
     *           `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
     *           If not provided, the MetadataStore's ID will be a UUID generated by the
     *           service.
     *           Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
     *           Must be unique across all MetadataSchemas in the parent Location.
     *           (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
     *           if the caller can't view the preexisting MetadataSchema.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\MetadataSchema
     *
     * @throws ApiException if the remote call fails
     */
    public function createMetadataSchema(
        $parent,
        $metadataSchema,
        array $optionalArgs = []
    ) {
        $request = new CreateMetadataSchemaRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setMetadataSchema($metadataSchema);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['metadataSchemaId'])) {
            $request->setMetadataSchemaId($optionalArgs['metadataSchemaId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateMetadataSchema',
            MetadataSchema::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Initializes a MetadataStore, including allocation of resources.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $metadataStore = new MetadataStore();
     *     $operationResponse = $metadataServiceClient->createMetadataStore($formattedParent, $metadataStore);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $metadataServiceClient->createMetadataStore($formattedParent, $metadataStore);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $metadataServiceClient->resumeOperation($operationName, 'createMetadataStore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string        $parent        Required. The resource name of the Location where the MetadataStore should
     *                                     be created.
     *                                     Format: `projects/{project}/locations/{location}/`
     * @param MetadataStore $metadataStore Required. The MetadataStore to create.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type string $metadataStoreId
     *           The {metadatastore} portion of the resource name with the format:
     *           `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     *           If not provided, the MetadataStore's ID will be a UUID generated by the
     *           service.
     *           Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
     *           Must be unique across all MetadataStores in the parent Location.
     *           (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
     *           if the caller can't view the preexisting MetadataStore.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createMetadataStore(
        $parent,
        $metadataStore,
        array $optionalArgs = []
    ) {
        $request = new CreateMetadataStoreRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setMetadataStore($metadataStore);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['metadataStoreId'])) {
            $request->setMetadataStoreId($optionalArgs['metadataStoreId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateMetadataStore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an Artifact.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->artifactName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[ARTIFACT]');
     *     $operationResponse = $metadataServiceClient->deleteArtifact($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $metadataServiceClient->deleteArtifact($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $metadataServiceClient->resumeOperation($operationName, 'deleteArtifact');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Artifact to delete.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. The etag of the Artifact to delete.
     *           If this is provided, it must match the server's etag. Otherwise, the
     *           request will fail with a FAILED_PRECONDITION.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteArtifact($name, array $optionalArgs = [])
    {
        $request = new DeleteArtifactRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteArtifact',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a stored Context.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->contextName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[CONTEXT]');
     *     $operationResponse = $metadataServiceClient->deleteContext($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $metadataServiceClient->deleteContext($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $metadataServiceClient->resumeOperation($operationName, 'deleteContext');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Context to delete.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           The force deletion semantics is still undefined.
     *           Users should not use this field.
     *     @type string $etag
     *           Optional. The etag of the Context to delete.
     *           If this is provided, it must match the server's etag. Otherwise, the
     *           request will fail with a FAILED_PRECONDITION.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteContext($name, array $optionalArgs = [])
    {
        $request = new DeleteContextRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteContext',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an Execution.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->executionName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[EXECUTION]');
     *     $operationResponse = $metadataServiceClient->deleteExecution($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $metadataServiceClient->deleteExecution($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $metadataServiceClient->resumeOperation($operationName, 'deleteExecution');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Execution to delete.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. The etag of the Execution to delete.
     *           If this is provided, it must match the server's etag. Otherwise, the
     *           request will fail with a FAILED_PRECONDITION.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteExecution($name, array $optionalArgs = [])
    {
        $request = new DeleteExecutionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteExecution',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single MetadataStore and all its child resources (Artifacts,
     * Executions, and Contexts).
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $operationResponse = $metadataServiceClient->deleteMetadataStore($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $metadataServiceClient->deleteMetadataStore($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $metadataServiceClient->resumeOperation($operationName, 'deleteMetadataStore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the MetadataStore to delete.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           Deprecated: Field is no longer supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteMetadataStore($name, array $optionalArgs = [])
    {
        $request = new DeleteMetadataStoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteMetadataStore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Retrieves a specific Artifact.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->artifactName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[ARTIFACT]');
     *     $response = $metadataServiceClient->getArtifact($formattedName);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Artifact to retrieve.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Artifact
     *
     * @throws ApiException if the remote call fails
     */
    public function getArtifact($name, array $optionalArgs = [])
    {
        $request = new GetArtifactRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetArtifact',
            Artifact::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a specific Context.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->contextName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[CONTEXT]');
     *     $response = $metadataServiceClient->getContext($formattedName);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Context to retrieve.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Context
     *
     * @throws ApiException if the remote call fails
     */
    public function getContext($name, array $optionalArgs = [])
    {
        $request = new GetContextRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetContext',
            Context::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a specific Execution.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->executionName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[EXECUTION]');
     *     $response = $metadataServiceClient->getExecution($formattedName);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Execution to retrieve.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Execution
     *
     * @throws ApiException if the remote call fails
     */
    public function getExecution($name, array $optionalArgs = [])
    {
        $request = new GetExecutionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetExecution',
            Execution::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a specific MetadataSchema.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->metadataSchemaName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[METADATA_SCHEMA]');
     *     $response = $metadataServiceClient->getMetadataSchema($formattedName);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the MetadataSchema to retrieve.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\MetadataSchema
     *
     * @throws ApiException if the remote call fails
     */
    public function getMetadataSchema($name, array $optionalArgs = [])
    {
        $request = new GetMetadataSchemaRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetMetadataSchema',
            MetadataSchema::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a specific MetadataStore.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedName = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $response = $metadataServiceClient->getMetadataStore($formattedName);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the MetadataStore to retrieve.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\MetadataStore
     *
     * @throws ApiException if the remote call fails
     */
    public function getMetadataStore($name, array $optionalArgs = [])
    {
        $request = new GetMetadataStoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetMetadataStore',
            MetadataStore::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists Artifacts in the MetadataStore.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $metadataServiceClient->listArtifacts($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $metadataServiceClient->listArtifacts($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The MetadataStore whose Artifacts should be listed.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter specifying the boolean condition for the Artifacts to satisfy in
     *           order to be part of the result set.
     *           The syntax to define filter query is based on https://google.aip.dev/160.
     *           The supported set of filters include the following:
     *
     *           *   **Attribute filtering**:
     *           For example: `display_name = "test"`.
     *           Supported fields include: `name`, `display_name`, `uri`, `state`,
     *           `schema_title`, `create_time`, and `update_time`.
     *           Time fields, such as `create_time` and `update_time`, require values
     *           specified in RFC-3339 format.
     *           For example: `create_time = "2020-11-19T11:30:00-04:00"`
     *           *   **Metadata field**:
     *           To filter on metadata fields use traversal operation as follows:
     *           `metadata.<field_name>.<type_value>`.
     *           For example: `metadata.field_1.number_value = 10.0`
     *           In case the field name contains special characters (such as colon), one
     *           can embed it inside double quote.
     *           For example: `metadata."field:1".number_value = 10.0`
     *           *   **Context based filtering**:
     *           To filter Artifacts based on the contexts to which they belong, use the
     *           function operator with the full resource name
     *           `in_context(<context-name>)`.
     *           For example:
     *           `in_context("projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context-id>")`
     *
     *           Each of the above supported filter types can be combined together using
     *           logical operators (`AND` & `OR`). Maximum nested expression depth allowed
     *           is 5.
     *
     *           For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     *     @type string $orderBy
     *           How the list of messages is ordered. Specify the values to order by and an
     *           ordering operation. The default sorting order is ascending. To specify
     *           descending order for a field, users append a " desc" suffix; for example:
     *           "foo desc, bar".
     *           Subfields are specified with a `.` character, such as foo.bar.
     *           see https://google.aip.dev/132#ordering for more details.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listArtifacts($parent, array $optionalArgs = [])
    {
        $request = new ListArtifactsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListArtifacts',
            $optionalArgs,
            ListArtifactsResponse::class,
            $request
        );
    }

    /**
     * Lists Contexts on the MetadataStore.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $metadataServiceClient->listContexts($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $metadataServiceClient->listContexts($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The MetadataStore whose Contexts should be listed.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter specifying the boolean condition for the Contexts to satisfy in
     *           order to be part of the result set.
     *           The syntax to define filter query is based on https://google.aip.dev/160.
     *           Following are the supported set of filters:
     *
     *           *  **Attribute filtering**:
     *           For example: `display_name = "test"`.
     *           Supported fields include: `name`, `display_name`, `schema_title`,
     *           `create_time`, and `update_time`.
     *           Time fields, such as `create_time` and `update_time`, require values
     *           specified in RFC-3339 format.
     *           For example: `create_time = "2020-11-19T11:30:00-04:00"`.
     *           *  **Metadata field**:
     *           To filter on metadata fields use traversal operation as follows:
     *           `metadata.<field_name>.<type_value>`.
     *           For example: `metadata.field_1.number_value = 10.0`.
     *           In case the field name contains special characters (such as colon), one
     *           can embed it inside double quote.
     *           For example: `metadata."field:1".number_value = 10.0`
     *           *  **Parent Child filtering**:
     *           To filter Contexts based on parent-child relationship use the HAS
     *           operator as follows:
     *
     *           ```
     *           parent_contexts:
     *           "projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context_id>"
     *           child_contexts:
     *           "projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context_id>"
     *           ```
     *
     *           Each of the above supported filters can be combined together using
     *           logical operators (`AND` & `OR`). Maximum nested expression depth allowed
     *           is 5.
     *
     *           For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     *     @type string $orderBy
     *           How the list of messages is ordered. Specify the values to order by and an
     *           ordering operation. The default sorting order is ascending. To specify
     *           descending order for a field, users append a " desc" suffix; for example:
     *           "foo desc, bar".
     *           Subfields are specified with a `.` character, such as foo.bar.
     *           see https://google.aip.dev/132#ordering for more details.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listContexts($parent, array $optionalArgs = [])
    {
        $request = new ListContextsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListContexts',
            $optionalArgs,
            ListContextsResponse::class,
            $request
        );
    }

    /**
     * Lists Executions in the MetadataStore.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $metadataServiceClient->listExecutions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $metadataServiceClient->listExecutions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The MetadataStore whose Executions should be listed.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter specifying the boolean condition for the Executions to satisfy in
     *           order to be part of the result set.
     *           The syntax to define filter query is based on https://google.aip.dev/160.
     *           Following are the supported set of filters:
     *
     *           *  **Attribute filtering**:
     *           For example: `display_name = "test"`.
     *           Supported fields include: `name`, `display_name`, `state`,
     *           `schema_title`, `create_time`, and `update_time`.
     *           Time fields, such as `create_time` and `update_time`, require values
     *           specified in RFC-3339 format.
     *           For example: `create_time = "2020-11-19T11:30:00-04:00"`.
     *           *  **Metadata field**:
     *           To filter on metadata fields use traversal operation as follows:
     *           `metadata.<field_name>.<type_value>`
     *           For example: `metadata.field_1.number_value = 10.0`
     *           In case the field name contains special characters (such as colon), one
     *           can embed it inside double quote.
     *           For example: `metadata."field:1".number_value = 10.0`
     *           *  **Context based filtering**:
     *           To filter Executions based on the contexts to which they belong use
     *           the function operator with the full resource name:
     *           `in_context(<context-name>)`.
     *           For example:
     *           `in_context("projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context-id>")`
     *
     *           Each of the above supported filters can be combined together using
     *           logical operators (`AND` & `OR`). Maximum nested expression depth allowed
     *           is 5.
     *
     *           For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     *     @type string $orderBy
     *           How the list of messages is ordered. Specify the values to order by and an
     *           ordering operation. The default sorting order is ascending. To specify
     *           descending order for a field, users append a " desc" suffix; for example:
     *           "foo desc, bar".
     *           Subfields are specified with a `.` character, such as foo.bar.
     *           see https://google.aip.dev/132#ordering for more details.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listExecutions($parent, array $optionalArgs = [])
    {
        $request = new ListExecutionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListExecutions',
            $optionalArgs,
            ListExecutionsResponse::class,
            $request
        );
    }

    /**
     * Lists MetadataSchemas.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $metadataServiceClient->listMetadataSchemas($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $metadataServiceClient->listMetadataSchemas($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The MetadataStore whose MetadataSchemas should be listed.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A query to filter available MetadataSchemas for matching results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listMetadataSchemas($parent, array $optionalArgs = [])
    {
        $request = new ListMetadataSchemasRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListMetadataSchemas',
            $optionalArgs,
            ListMetadataSchemasResponse::class,
            $request
        );
    }

    /**
     * Lists MetadataStores for a Location.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $metadataServiceClient->listMetadataStores($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $metadataServiceClient->listMetadataStores($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The Location whose MetadataStores should be listed.
     *                             Format:
     *                             `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listMetadataStores($parent, array $optionalArgs = [])
    {
        $request = new ListMetadataStoresRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListMetadataStores',
            $optionalArgs,
            ListMetadataStoresResponse::class,
            $request
        );
    }

    /**
     * Purges Artifacts.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $filter = 'filter';
     *     $operationResponse = $metadataServiceClient->purgeArtifacts($formattedParent, $filter);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $metadataServiceClient->purgeArtifacts($formattedParent, $filter);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $metadataServiceClient->resumeOperation($operationName, 'purgeArtifacts');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The metadata store to purge Artifacts from.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param string $filter       Required. A required filter matching the Artifacts to be purged.
     *                             E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           Optional. Flag to indicate to actually perform the purge.
     *           If `force` is set to false, the method will return a sample of
     *           Artifact names that would be deleted.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function purgeArtifacts($parent, $filter, array $optionalArgs = [])
    {
        $request = new PurgeArtifactsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFilter($filter);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'PurgeArtifacts',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Purges Contexts.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $filter = 'filter';
     *     $operationResponse = $metadataServiceClient->purgeContexts($formattedParent, $filter);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $metadataServiceClient->purgeContexts($formattedParent, $filter);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $metadataServiceClient->resumeOperation($operationName, 'purgeContexts');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The metadata store to purge Contexts from.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param string $filter       Required. A required filter matching the Contexts to be purged.
     *                             E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           Optional. Flag to indicate to actually perform the purge.
     *           If `force` is set to false, the method will return a sample of
     *           Context names that would be deleted.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function purgeContexts($parent, $filter, array $optionalArgs = [])
    {
        $request = new PurgeContextsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFilter($filter);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'PurgeContexts',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Purges Executions.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedParent = $metadataServiceClient->metadataStoreName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]');
     *     $filter = 'filter';
     *     $operationResponse = $metadataServiceClient->purgeExecutions($formattedParent, $filter);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $metadataServiceClient->purgeExecutions($formattedParent, $filter);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $metadataServiceClient->resumeOperation($operationName, 'purgeExecutions');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The metadata store to purge Executions from.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
     * @param string $filter       Required. A required filter matching the Executions to be purged.
     *                             E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           Optional. Flag to indicate to actually perform the purge.
     *           If `force` is set to false, the method will return a sample of
     *           Execution names that would be deleted.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function purgeExecutions($parent, $filter, array $optionalArgs = [])
    {
        $request = new PurgeExecutionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFilter($filter);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'PurgeExecutions',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Retrieves lineage of an Artifact represented through Artifacts and
     * Executions connected by Event edges and returned as a LineageSubgraph.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedArtifact = $metadataServiceClient->artifactName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[ARTIFACT]');
     *     $response = $metadataServiceClient->queryArtifactLineageSubgraph($formattedArtifact);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $artifact     Required. The resource name of the Artifact whose Lineage needs to be
     *                             retrieved as a LineageSubgraph. Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
     *
     *                             The request may error with FAILED_PRECONDITION if the number of Artifacts,
     *                             the number of Executions, or the number of Events that would be returned
     *                             for the Context exceeds 1000.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $maxHops
     *           Specifies the size of the lineage graph in terms of number of hops from the
     *           specified artifact.
     *           Negative Value: INVALID_ARGUMENT error is returned
     *           0: Only input artifact is returned.
     *           No value: Transitive closure is performed to return the complete graph.
     *     @type string $filter
     *           Filter specifying the boolean condition for the Artifacts to satisfy in
     *           order to be part of the Lineage Subgraph.
     *           The syntax to define filter query is based on https://google.aip.dev/160.
     *           The supported set of filters include the following:
     *
     *           *  **Attribute filtering**:
     *           For example: `display_name = "test"`
     *           Supported fields include: `name`, `display_name`, `uri`, `state`,
     *           `schema_title`, `create_time`, and `update_time`.
     *           Time fields, such as `create_time` and `update_time`, require values
     *           specified in RFC-3339 format.
     *           For example: `create_time = "2020-11-19T11:30:00-04:00"`
     *           *  **Metadata field**:
     *           To filter on metadata fields use traversal operation as follows:
     *           `metadata.<field_name>.<type_value>`.
     *           For example: `metadata.field_1.number_value = 10.0`
     *           In case the field name contains special characters (such as colon), one
     *           can embed it inside double quote.
     *           For example: `metadata."field:1".number_value = 10.0`
     *
     *           Each of the above supported filter types can be combined together using
     *           logical operators (`AND` & `OR`). Maximum nested expression depth allowed
     *           is 5.
     *
     *           For example: `display_name = "test" AND metadata.field1.bool_value = true`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\LineageSubgraph
     *
     * @throws ApiException if the remote call fails
     */
    public function queryArtifactLineageSubgraph(
        $artifact,
        array $optionalArgs = []
    ) {
        $request = new QueryArtifactLineageSubgraphRequest();
        $requestParamHeaders = [];
        $request->setArtifact($artifact);
        $requestParamHeaders['artifact'] = $artifact;
        if (isset($optionalArgs['maxHops'])) {
            $request->setMaxHops($optionalArgs['maxHops']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'QueryArtifactLineageSubgraph',
            LineageSubgraph::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves Artifacts and Executions within the specified Context, connected
     * by Event edges and returned as a LineageSubgraph.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedContext = $metadataServiceClient->contextName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[CONTEXT]');
     *     $response = $metadataServiceClient->queryContextLineageSubgraph($formattedContext);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $context      Required. The resource name of the Context whose Artifacts and Executions
     *                             should be retrieved as a LineageSubgraph.
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
     *
     *                             The request may error with FAILED_PRECONDITION if the number of Artifacts,
     *                             the number of Executions, or the number of Events that would be returned
     *                             for the Context exceeds 1000.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\LineageSubgraph
     *
     * @throws ApiException if the remote call fails
     */
    public function queryContextLineageSubgraph(
        $context,
        array $optionalArgs = []
    ) {
        $request = new QueryContextLineageSubgraphRequest();
        $requestParamHeaders = [];
        $request->setContext($context);
        $requestParamHeaders['context'] = $context;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'QueryContextLineageSubgraph',
            LineageSubgraph::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Obtains the set of input and output Artifacts for this Execution, in the
     * form of LineageSubgraph that also contains the Execution and connecting
     * Events.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedExecution = $metadataServiceClient->executionName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[EXECUTION]');
     *     $response = $metadataServiceClient->queryExecutionInputsAndOutputs($formattedExecution);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $execution    Required. The resource name of the Execution whose input and output
     *                             Artifacts should be retrieved as a LineageSubgraph. Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\LineageSubgraph
     *
     * @throws ApiException if the remote call fails
     */
    public function queryExecutionInputsAndOutputs(
        $execution,
        array $optionalArgs = []
    ) {
        $request = new QueryExecutionInputsAndOutputsRequest();
        $requestParamHeaders = [];
        $request->setExecution($execution);
        $requestParamHeaders['execution'] = $execution;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'QueryExecutionInputsAndOutputs',
            LineageSubgraph::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Remove a set of children contexts from a parent Context. If any of the
     * child Contexts were NOT added to the parent Context, they are
     * simply skipped.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $formattedContext = $metadataServiceClient->contextName('[PROJECT]', '[LOCATION]', '[METADATA_STORE]', '[CONTEXT]');
     *     $response = $metadataServiceClient->removeContextChildren($formattedContext);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $context      Required. The resource name of the parent Context.
     *
     *                             Format:
     *                             `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $childContexts
     *           The resource names of the child Contexts.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\RemoveContextChildrenResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function removeContextChildren($context, array $optionalArgs = [])
    {
        $request = new RemoveContextChildrenRequest();
        $requestParamHeaders = [];
        $request->setContext($context);
        $requestParamHeaders['context'] = $context;
        if (isset($optionalArgs['childContexts'])) {
            $request->setChildContexts($optionalArgs['childContexts']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RemoveContextChildren',
            RemoveContextChildrenResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a stored Artifact.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $artifact = new Artifact();
     *     $response = $metadataServiceClient->updateArtifact($artifact);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param Artifact $artifact     Required. The Artifact containing updates.
     *                               The Artifact's [Artifact.name][google.cloud.aiplatform.v1.Artifact.name]
     *                               field is used to identify the Artifact to be updated. Format:
     *                               `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. A FieldMask indicating which fields should be updated.
     *     @type bool $allowMissing
     *           If set to true, and the [Artifact][google.cloud.aiplatform.v1.Artifact] is
     *           not found, a new [Artifact][google.cloud.aiplatform.v1.Artifact] is
     *           created.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Artifact
     *
     * @throws ApiException if the remote call fails
     */
    public function updateArtifact($artifact, array $optionalArgs = [])
    {
        $request = new UpdateArtifactRequest();
        $requestParamHeaders = [];
        $request->setArtifact($artifact);
        $requestParamHeaders['artifact.name'] = $artifact->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateArtifact',
            Artifact::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a stored Context.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $context = new Context();
     *     $response = $metadataServiceClient->updateContext($context);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param Context $context      Required. The Context containing updates.
     *                              The Context's [Context.name][google.cloud.aiplatform.v1.Context.name] field
     *                              is used to identify the Context to be updated. Format:
     *                              `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. A FieldMask indicating which fields should be updated.
     *     @type bool $allowMissing
     *           If set to true, and the [Context][google.cloud.aiplatform.v1.Context] is
     *           not found, a new [Context][google.cloud.aiplatform.v1.Context] is created.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Context
     *
     * @throws ApiException if the remote call fails
     */
    public function updateContext($context, array $optionalArgs = [])
    {
        $request = new UpdateContextRequest();
        $requestParamHeaders = [];
        $request->setContext($context);
        $requestParamHeaders['context.name'] = $context->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateContext',
            Context::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a stored Execution.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $execution = new Execution();
     *     $response = $metadataServiceClient->updateExecution($execution);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param Execution $execution    Required. The Execution containing updates.
     *                                The Execution's [Execution.name][google.cloud.aiplatform.v1.Execution.name]
     *                                field is used to identify the Execution to be updated. Format:
     *                                `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. A FieldMask indicating which fields should be updated.
     *     @type bool $allowMissing
     *           If set to true, and the [Execution][google.cloud.aiplatform.v1.Execution]
     *           is not found, a new [Execution][google.cloud.aiplatform.v1.Execution] is
     *           created.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Execution
     *
     * @throws ApiException if the remote call fails
     */
    public function updateExecution($execution, array $optionalArgs = [])
    {
        $request = new UpdateExecutionRequest();
        $requestParamHeaders = [];
        $request->setExecution($execution);
        $requestParamHeaders['execution.name'] = $execution->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateExecution',
            Execution::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $response = $metadataServiceClient->getLocation();
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $metadataServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $metadataServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $metadataServiceClient->getIamPolicy($resource);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $metadataServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $metadataServiceClient = new MetadataServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $metadataServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $metadataServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
