<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/lifesciences/v2beta/workflows.proto

namespace Google\Cloud\LifeSciences\V2beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Carries information about a Compute Engine VM resource.
 *
 * Generated from protobuf message <code>google.cloud.lifesciences.v2beta.VirtualMachine</code>
 */
class VirtualMachine extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The machine type of the virtual machine to create. Must be the short name
     * of a standard machine type (such as "n1-standard-1") or a custom machine
     * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     * "4096" indicates the memory in MB). See
     * [Creating an instance with a custom machine
     * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     * for more specifications on creating a custom machine type.
     *
     * Generated from protobuf field <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $machine_type = '';
    /**
     * If true, allocate a preemptible VM.
     *
     * Generated from protobuf field <code>bool preemptible = 2;</code>
     */
    private $preemptible = false;
    /**
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     */
    private $labels;
    /**
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    private $disks;
    /**
     * The VM network configuration.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     */
    private $network = null;
    /**
     * The list of accelerators to attach to the VM.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    private $accelerators;
    /**
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     */
    private $service_account = null;
    /**
     * The size of the boot disk, in GB. The boot disk must be large
     * enough to accommodate all of the Docker images from each action in the
     * pipeline at the same time. If not specified, a small but reasonable
     * default value is used.
     *
     * Generated from protobuf field <code>int32 boot_disk_size_gb = 8;</code>
     */
    private $boot_disk_size_gb = 0;
    /**
     * The CPU platform to request. An instance based on a newer platform can be
     * allocated, but never one with fewer capabilities. The value of this
     * parameter must be a valid Compute Engine CPU platform name (such as "Intel
     * Skylake"). This parameter is only useful for carefully optimized work
     * loads where the CPU platform has a significant impact.
     * For more information about the effect of this parameter, see
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     *
     * Generated from protobuf field <code>string cpu_platform = 9;</code>
     */
    private $cpu_platform = '';
    /**
     * The host operating system image to use.
     * Currently, only Container-Optimized OS images can be used.
     * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     * which selects the latest stable release of Container-Optimized OS.
     * This option is provided to allow testing against the beta release of the
     * operating system to ensure that the new version does not interact
     * negatively with production pipelines.
     * To test a pipeline against the beta release of Container-Optimized OS,
     * use the value `projects/cos-cloud/global/images/family/cos-beta`.
     *
     * Generated from protobuf field <code>string boot_image = 10;</code>
     */
    private $boot_image = '';
    /**
     * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     * The version specified here must be compatible with the GPU libraries
     * contained in the container being executed, and must be one of the drivers
     * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     *
     * Generated from protobuf field <code>string nvidia_driver_version = 11 [deprecated = true];</code>
     * @deprecated
     */
    protected $nvidia_driver_version = '';
    /**
     * Whether Stackdriver monitoring should be enabled on the VM.
     *
     * Generated from protobuf field <code>bool enable_stackdriver_monitoring = 12;</code>
     */
    private $enable_stackdriver_monitoring = false;
    /**
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     *
     * Generated from protobuf field <code>repeated string docker_cache_images = 13;</code>
     */
    private $docker_cache_images;
    /**
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    private $volumes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $machine_type
     *           Required. The machine type of the virtual machine to create. Must be the short name
     *           of a standard machine type (such as "n1-standard-1") or a custom machine
     *           type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     *           "4096" indicates the memory in MB). See
     *           [Creating an instance with a custom machine
     *           type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     *           for more specifications on creating a custom machine type.
     *     @type bool $preemptible
     *           If true, allocate a preemptible VM.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional set of labels to apply to the VM and any attached disk resources.
     *           These labels must adhere to the [name and value
     *           restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     *           VM labels imposed by Compute Engine.
     *           Labels keys with the prefix 'google-' are reserved for use by Google.
     *           Labels applied at creation time to the VM. Applied on a best-effort basis
     *           to attached disk resources shortly after VM creation.
     *     @type array<\Google\Cloud\LifeSciences\V2beta\Disk>|\Google\Protobuf\Internal\RepeatedField $disks
     *           The list of disks to create and attach to the VM.
     *           Specify either the `volumes[]` field or the `disks[]` field, but not both.
     *     @type \Google\Cloud\LifeSciences\V2beta\Network $network
     *           The VM network configuration.
     *     @type array<\Google\Cloud\LifeSciences\V2beta\Accelerator>|\Google\Protobuf\Internal\RepeatedField $accelerators
     *           The list of accelerators to attach to the VM.
     *     @type \Google\Cloud\LifeSciences\V2beta\ServiceAccount $service_account
     *           The service account to install on the VM. This account does not need
     *           any permissions other than those required by the pipeline.
     *     @type int $boot_disk_size_gb
     *           The size of the boot disk, in GB. The boot disk must be large
     *           enough to accommodate all of the Docker images from each action in the
     *           pipeline at the same time. If not specified, a small but reasonable
     *           default value is used.
     *     @type string $cpu_platform
     *           The CPU platform to request. An instance based on a newer platform can be
     *           allocated, but never one with fewer capabilities. The value of this
     *           parameter must be a valid Compute Engine CPU platform name (such as "Intel
     *           Skylake"). This parameter is only useful for carefully optimized work
     *           loads where the CPU platform has a significant impact.
     *           For more information about the effect of this parameter, see
     *           https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     *     @type string $boot_image
     *           The host operating system image to use.
     *           Currently, only Container-Optimized OS images can be used.
     *           The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     *           which selects the latest stable release of Container-Optimized OS.
     *           This option is provided to allow testing against the beta release of the
     *           operating system to ensure that the new version does not interact
     *           negatively with production pipelines.
     *           To test a pipeline against the beta release of Container-Optimized OS,
     *           use the value `projects/cos-cloud/global/images/family/cos-beta`.
     *     @type string $nvidia_driver_version
     *           The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     *           The version specified here must be compatible with the GPU libraries
     *           contained in the container being executed, and must be one of the drivers
     *           hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     *     @type bool $enable_stackdriver_monitoring
     *           Whether Stackdriver monitoring should be enabled on the VM.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $docker_cache_images
     *           The Compute Engine Disk Images to use as a Docker cache. The disks will be
     *           mounted into the Docker folder in a way that the images present in the
     *           cache will not need to be pulled. The digests of the cached images must
     *           match those of the tags used or the latest version will still be pulled.
     *           The root directory of the ext4 image must contain `image` and `overlay2`
     *           directories copied from the Docker directory of a VM where the desired
     *           Docker images have already been pulled. Any images pulled that are not
     *           cached will be stored on the first cache disk instead of the boot disk.
     *           Only a single image is supported.
     *     @type array<\Google\Cloud\LifeSciences\V2beta\Volume>|\Google\Protobuf\Internal\RepeatedField $volumes
     *           The list of disks and other storage to create or attach to the VM.
     *           Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Lifesciences\V2Beta\Workflows::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The machine type of the virtual machine to create. Must be the short name
     * of a standard machine type (such as "n1-standard-1") or a custom machine
     * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     * "4096" indicates the memory in MB). See
     * [Creating an instance with a custom machine
     * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     * for more specifications on creating a custom machine type.
     *
     * Generated from protobuf field <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * Required. The machine type of the virtual machine to create. Must be the short name
     * of a standard machine type (such as "n1-standard-1") or a custom machine
     * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     * "4096" indicates the memory in MB). See
     * [Creating an instance with a custom machine
     * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     * for more specifications on creating a custom machine type.
     *
     * Generated from protobuf field <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * If true, allocate a preemptible VM.
     *
     * Generated from protobuf field <code>bool preemptible = 2;</code>
     * @return bool
     */
    public function getPreemptible()
    {
        return $this->preemptible;
    }

    /**
     * If true, allocate a preemptible VM.
     *
     * Generated from protobuf field <code>bool preemptible = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setPreemptible($var)
    {
        GPBUtil::checkBool($var);
        $this->preemptible = $var;

        return $this;
    }

    /**
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDisks()
    {
        return $this->disks;
    }

    /**
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     * @param array<\Google\Cloud\LifeSciences\V2beta\Disk>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDisks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\LifeSciences\V2beta\Disk::class);
        $this->disks = $arr;

        return $this;
    }

    /**
     * The VM network configuration.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     * @return \Google\Cloud\LifeSciences\V2beta\Network|null
     */
    public function getNetwork()
    {
        return $this->network;
    }

    public function hasNetwork()
    {
        return isset($this->network);
    }

    public function clearNetwork()
    {
        unset($this->network);
    }

    /**
     * The VM network configuration.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     * @param \Google\Cloud\LifeSciences\V2beta\Network $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\LifeSciences\V2beta\Network::class);
        $this->network = $var;

        return $this;
    }

    /**
     * The list of accelerators to attach to the VM.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAccelerators()
    {
        return $this->accelerators;
    }

    /**
     * The list of accelerators to attach to the VM.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     * @param array<\Google\Cloud\LifeSciences\V2beta\Accelerator>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAccelerators($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\LifeSciences\V2beta\Accelerator::class);
        $this->accelerators = $arr;

        return $this;
    }

    /**
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     * @return \Google\Cloud\LifeSciences\V2beta\ServiceAccount|null
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    public function hasServiceAccount()
    {
        return isset($this->service_account);
    }

    public function clearServiceAccount()
    {
        unset($this->service_account);
    }

    /**
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     *
     * Generated from protobuf field <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     * @param \Google\Cloud\LifeSciences\V2beta\ServiceAccount $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\LifeSciences\V2beta\ServiceAccount::class);
        $this->service_account = $var;

        return $this;
    }

    /**
     * The size of the boot disk, in GB. The boot disk must be large
     * enough to accommodate all of the Docker images from each action in the
     * pipeline at the same time. If not specified, a small but reasonable
     * default value is used.
     *
     * Generated from protobuf field <code>int32 boot_disk_size_gb = 8;</code>
     * @return int
     */
    public function getBootDiskSizeGb()
    {
        return $this->boot_disk_size_gb;
    }

    /**
     * The size of the boot disk, in GB. The boot disk must be large
     * enough to accommodate all of the Docker images from each action in the
     * pipeline at the same time. If not specified, a small but reasonable
     * default value is used.
     *
     * Generated from protobuf field <code>int32 boot_disk_size_gb = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setBootDiskSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->boot_disk_size_gb = $var;

        return $this;
    }

    /**
     * The CPU platform to request. An instance based on a newer platform can be
     * allocated, but never one with fewer capabilities. The value of this
     * parameter must be a valid Compute Engine CPU platform name (such as "Intel
     * Skylake"). This parameter is only useful for carefully optimized work
     * loads where the CPU platform has a significant impact.
     * For more information about the effect of this parameter, see
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     *
     * Generated from protobuf field <code>string cpu_platform = 9;</code>
     * @return string
     */
    public function getCpuPlatform()
    {
        return $this->cpu_platform;
    }

    /**
     * The CPU platform to request. An instance based on a newer platform can be
     * allocated, but never one with fewer capabilities. The value of this
     * parameter must be a valid Compute Engine CPU platform name (such as "Intel
     * Skylake"). This parameter is only useful for carefully optimized work
     * loads where the CPU platform has a significant impact.
     * For more information about the effect of this parameter, see
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     *
     * Generated from protobuf field <code>string cpu_platform = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setCpuPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->cpu_platform = $var;

        return $this;
    }

    /**
     * The host operating system image to use.
     * Currently, only Container-Optimized OS images can be used.
     * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     * which selects the latest stable release of Container-Optimized OS.
     * This option is provided to allow testing against the beta release of the
     * operating system to ensure that the new version does not interact
     * negatively with production pipelines.
     * To test a pipeline against the beta release of Container-Optimized OS,
     * use the value `projects/cos-cloud/global/images/family/cos-beta`.
     *
     * Generated from protobuf field <code>string boot_image = 10;</code>
     * @return string
     */
    public function getBootImage()
    {
        return $this->boot_image;
    }

    /**
     * The host operating system image to use.
     * Currently, only Container-Optimized OS images can be used.
     * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     * which selects the latest stable release of Container-Optimized OS.
     * This option is provided to allow testing against the beta release of the
     * operating system to ensure that the new version does not interact
     * negatively with production pipelines.
     * To test a pipeline against the beta release of Container-Optimized OS,
     * use the value `projects/cos-cloud/global/images/family/cos-beta`.
     *
     * Generated from protobuf field <code>string boot_image = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setBootImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->boot_image = $var;

        return $this;
    }

    /**
     * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     * The version specified here must be compatible with the GPU libraries
     * contained in the container being executed, and must be one of the drivers
     * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     *
     * Generated from protobuf field <code>string nvidia_driver_version = 11 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getNvidiaDriverVersion()
    {
        @trigger_error('nvidia_driver_version is deprecated.', E_USER_DEPRECATED);
        return $this->nvidia_driver_version;
    }

    /**
     * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     * The version specified here must be compatible with the GPU libraries
     * contained in the container being executed, and must be one of the drivers
     * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     *
     * Generated from protobuf field <code>string nvidia_driver_version = 11 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setNvidiaDriverVersion($var)
    {
        @trigger_error('nvidia_driver_version is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->nvidia_driver_version = $var;

        return $this;
    }

    /**
     * Whether Stackdriver monitoring should be enabled on the VM.
     *
     * Generated from protobuf field <code>bool enable_stackdriver_monitoring = 12;</code>
     * @return bool
     */
    public function getEnableStackdriverMonitoring()
    {
        return $this->enable_stackdriver_monitoring;
    }

    /**
     * Whether Stackdriver monitoring should be enabled on the VM.
     *
     * Generated from protobuf field <code>bool enable_stackdriver_monitoring = 12;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableStackdriverMonitoring($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_stackdriver_monitoring = $var;

        return $this;
    }

    /**
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     *
     * Generated from protobuf field <code>repeated string docker_cache_images = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDockerCacheImages()
    {
        return $this->docker_cache_images;
    }

    /**
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     *
     * Generated from protobuf field <code>repeated string docker_cache_images = 13;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDockerCacheImages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->docker_cache_images = $arr;

        return $this;
    }

    /**
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVolumes()
    {
        return $this->volumes;
    }

    /**
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     *
     * Generated from protobuf field <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     * @param array<\Google\Cloud\LifeSciences\V2beta\Volume>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVolumes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\LifeSciences\V2beta\Volume::class);
        $this->volumes = $arr;

        return $this;
    }

}

