<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataproc/v1/batches.proto

namespace Google\Cloud\Dataproc\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A configuration for running an [Apache Spark](http://spark.apache.org/)
 * batch workload.
 *
 * Generated from protobuf message <code>google.cloud.dataproc.v1.SparkBatch</code>
 */
class SparkBatch extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     *
     * Generated from protobuf field <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $args;
    /**
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     *
     * Generated from protobuf field <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $jar_file_uris;
    /**
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     *
     * Generated from protobuf field <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $file_uris;
    /**
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     *
     * Generated from protobuf field <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $archive_uris;
    protected $driver;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $main_jar_file_uri
     *           Optional. The HCFS URI of the jar file that contains the main class.
     *     @type string $main_class
     *           Optional. The name of the driver main class. The jar file that contains the class
     *           must be in the classpath or specified in `jar_file_uris`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $args
     *           Optional. The arguments to pass to the driver. Do not include arguments
     *           that can be set as batch properties, such as `--conf`, since a collision
     *           can occur that causes an incorrect batch submission.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $jar_file_uris
     *           Optional. HCFS URIs of jar files to add to the classpath of the
     *           Spark driver and tasks.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $file_uris
     *           Optional. HCFS URIs of files to be placed in the working directory of
     *           each executor.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $archive_uris
     *           Optional. HCFS URIs of archives to be extracted into the working directory
     *           of each executor. Supported file types:
     *           `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataproc\V1\Batches::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The HCFS URI of the jar file that contains the main class.
     *
     * Generated from protobuf field <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getMainJarFileUri()
    {
        return $this->readOneof(1);
    }

    public function hasMainJarFileUri()
    {
        return $this->hasOneof(1);
    }

    /**
     * Optional. The HCFS URI of the jar file that contains the main class.
     *
     * Generated from protobuf field <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setMainJarFileUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Optional. The name of the driver main class. The jar file that contains the class
     * must be in the classpath or specified in `jar_file_uris`.
     *
     * Generated from protobuf field <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getMainClass()
    {
        return $this->readOneof(2);
    }

    public function hasMainClass()
    {
        return $this->hasOneof(2);
    }

    /**
     * Optional. The name of the driver main class. The jar file that contains the class
     * must be in the classpath or specified in `jar_file_uris`.
     *
     * Generated from protobuf field <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setMainClass($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     *
     * Generated from protobuf field <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getArgs()
    {
        return $this->args;
    }

    /**
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     *
     * Generated from protobuf field <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setArgs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->args = $arr;

        return $this;
    }

    /**
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     *
     * Generated from protobuf field <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getJarFileUris()
    {
        return $this->jar_file_uris;
    }

    /**
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     *
     * Generated from protobuf field <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setJarFileUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->jar_file_uris = $arr;

        return $this;
    }

    /**
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     *
     * Generated from protobuf field <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFileUris()
    {
        return $this->file_uris;
    }

    /**
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     *
     * Generated from protobuf field <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFileUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->file_uris = $arr;

        return $this;
    }

    /**
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     *
     * Generated from protobuf field <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getArchiveUris()
    {
        return $this->archive_uris;
    }

    /**
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     *
     * Generated from protobuf field <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setArchiveUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->archive_uris = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getDriver()
    {
        return $this->whichOneof("driver");
    }

}

