<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/batch/v1/volume.proto

namespace Google\Cloud\Batch\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Volume and mount parameters to be associated with a TaskSpec. A TaskSpec
 * might describe zero, one, or multiple volumes to be mounted as part of the
 * task.
 *
 * Generated from protobuf message <code>google.cloud.batch.v1.Volume</code>
 */
class Volume extends \Google\Protobuf\Internal\Message
{
    /**
     * Mount path for the volume, e.g. /mnt/share
     *
     * Generated from protobuf field <code>string mount_path = 4;</code>
     */
    private $mount_path = '';
    /**
     * Mount options
     * For Google Cloud Storage, mount options are the global options supported by
     * gcsfuse tool. Batch will use them to mount the volume with the following
     * command:
     * "gcsfuse [global options] bucket mountpoint".
     * For PD, NFS, mount options are these supported by /etc/fstab. Batch will
     * use Fstab to mount such volumes.
     * https://help.ubuntu.com/community/Fstab
     *
     * Generated from protobuf field <code>repeated string mount_options = 5;</code>
     */
    private $mount_options;
    protected $source;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Batch\V1\NFS $nfs
     *           An NFS source for the volume (could be a Filestore, for example).
     *     @type \Google\Cloud\Batch\V1\GCS $gcs
     *           A Google Cloud Storage source for the volume.
     *     @type string $device_name
     *           Device name of an attached disk
     *     @type string $mount_path
     *           Mount path for the volume, e.g. /mnt/share
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $mount_options
     *           Mount options
     *           For Google Cloud Storage, mount options are the global options supported by
     *           gcsfuse tool. Batch will use them to mount the volume with the following
     *           command:
     *           "gcsfuse [global options] bucket mountpoint".
     *           For PD, NFS, mount options are these supported by /etc/fstab. Batch will
     *           use Fstab to mount such volumes.
     *           https://help.ubuntu.com/community/Fstab
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Batch\V1\Volume::initOnce();
        parent::__construct($data);
    }

    /**
     * An NFS source for the volume (could be a Filestore, for example).
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     * @return \Google\Cloud\Batch\V1\NFS|null
     */
    public function getNfs()
    {
        return $this->readOneof(1);
    }

    public function hasNfs()
    {
        return $this->hasOneof(1);
    }

    /**
     * An NFS source for the volume (could be a Filestore, for example).
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     * @param \Google\Cloud\Batch\V1\NFS $var
     * @return $this
     */
    public function setNfs($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\NFS::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * A Google Cloud Storage source for the volume.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     * @return \Google\Cloud\Batch\V1\GCS|null
     */
    public function getGcs()
    {
        return $this->readOneof(3);
    }

    public function hasGcs()
    {
        return $this->hasOneof(3);
    }

    /**
     * A Google Cloud Storage source for the volume.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     * @param \Google\Cloud\Batch\V1\GCS $var
     * @return $this
     */
    public function setGcs($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\GCS::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Device name of an attached disk
     *
     * Generated from protobuf field <code>string device_name = 6;</code>
     * @return string
     */
    public function getDeviceName()
    {
        return $this->readOneof(6);
    }

    public function hasDeviceName()
    {
        return $this->hasOneof(6);
    }

    /**
     * Device name of an attached disk
     *
     * Generated from protobuf field <code>string device_name = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDeviceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Mount path for the volume, e.g. /mnt/share
     *
     * Generated from protobuf field <code>string mount_path = 4;</code>
     * @return string
     */
    public function getMountPath()
    {
        return $this->mount_path;
    }

    /**
     * Mount path for the volume, e.g. /mnt/share
     *
     * Generated from protobuf field <code>string mount_path = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setMountPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->mount_path = $var;

        return $this;
    }

    /**
     * Mount options
     * For Google Cloud Storage, mount options are the global options supported by
     * gcsfuse tool. Batch will use them to mount the volume with the following
     * command:
     * "gcsfuse [global options] bucket mountpoint".
     * For PD, NFS, mount options are these supported by /etc/fstab. Batch will
     * use Fstab to mount such volumes.
     * https://help.ubuntu.com/community/Fstab
     *
     * Generated from protobuf field <code>repeated string mount_options = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMountOptions()
    {
        return $this->mount_options;
    }

    /**
     * Mount options
     * For Google Cloud Storage, mount options are the global options supported by
     * gcsfuse tool. Batch will use them to mount the volume with the following
     * command:
     * "gcsfuse [global options] bucket mountpoint".
     * For PD, NFS, mount options are these supported by /etc/fstab. Batch will
     * use Fstab to mount such volumes.
     * https://help.ubuntu.com/community/Fstab
     *
     * Generated from protobuf field <code>repeated string mount_options = 5;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMountOptions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->mount_options = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

}

