<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/documentai/v1/document_processor_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\DocumentAI\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DocumentAI\V1\BatchProcessRequest;
use Google\Cloud\DocumentAI\V1\CreateProcessorRequest;
use Google\Cloud\DocumentAI\V1\DeleteProcessorRequest;
use Google\Cloud\DocumentAI\V1\DeleteProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\DeployProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\DisableProcessorRequest;
use Google\Cloud\DocumentAI\V1\EnableProcessorRequest;
use Google\Cloud\DocumentAI\V1\EvaluateProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\Evaluation;
use Google\Cloud\DocumentAI\V1\FetchProcessorTypesRequest;
use Google\Cloud\DocumentAI\V1\FetchProcessorTypesResponse;
use Google\Cloud\DocumentAI\V1\GetEvaluationRequest;
use Google\Cloud\DocumentAI\V1\GetProcessorRequest;
use Google\Cloud\DocumentAI\V1\GetProcessorTypeRequest;
use Google\Cloud\DocumentAI\V1\GetProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\ListEvaluationsRequest;
use Google\Cloud\DocumentAI\V1\ListProcessorTypesRequest;
use Google\Cloud\DocumentAI\V1\ListProcessorVersionsRequest;
use Google\Cloud\DocumentAI\V1\ListProcessorsRequest;
use Google\Cloud\DocumentAI\V1\ProcessRequest;
use Google\Cloud\DocumentAI\V1\ProcessResponse;
use Google\Cloud\DocumentAI\V1\Processor;
use Google\Cloud\DocumentAI\V1\ProcessorType;
use Google\Cloud\DocumentAI\V1\ProcessorVersion;
use Google\Cloud\DocumentAI\V1\ReviewDocumentRequest;
use Google\Cloud\DocumentAI\V1\SetDefaultProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\TrainProcessorVersionMetadata;
use Google\Cloud\DocumentAI\V1\TrainProcessorVersionRequest;
use Google\Cloud\DocumentAI\V1\UndeployProcessorVersionRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service to call Document AI to process documents according to the
 * processor's definition. Processors are built using state-of-the-art Google
 * AI such as natural language, computer vision, and translation to extract
 * structured information from unstructured or semi-structured documents.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\DocumentAI\V1\DocumentProcessorServiceClient} for the stable
 * implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface batchProcessDocumentsAsync(BatchProcessRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createProcessorAsync(CreateProcessorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteProcessorAsync(DeleteProcessorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteProcessorVersionAsync(DeleteProcessorVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deployProcessorVersionAsync(DeployProcessorVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface disableProcessorAsync(DisableProcessorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface enableProcessorAsync(EnableProcessorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface evaluateProcessorVersionAsync(EvaluateProcessorVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchProcessorTypesAsync(FetchProcessorTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEvaluationAsync(GetEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getProcessorAsync(GetProcessorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getProcessorTypeAsync(GetProcessorTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getProcessorVersionAsync(GetProcessorVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEvaluationsAsync(ListEvaluationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listProcessorTypesAsync(ListProcessorTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listProcessorVersionsAsync(ListProcessorVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listProcessorsAsync(ListProcessorsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface processDocumentAsync(ProcessRequest $request, array $optionalArgs = [])
 * @method PromiseInterface reviewDocumentAsync(ReviewDocumentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setDefaultProcessorVersionAsync(SetDefaultProcessorVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface trainProcessorVersionAsync(TrainProcessorVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeployProcessorVersionAsync(UndeployProcessorVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
abstract class DocumentProcessorServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.documentai.v1.DocumentProcessorService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'documentai.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/document_processor_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/document_processor_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/document_processor_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/document_processor_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a evaluation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processor
     * @param string $processorVersion
     * @param string $evaluation
     *
     * @return string The formatted evaluation resource.
     */
    public static function evaluationName(string $project, string $location, string $processor, string $processorVersion, string $evaluation): string
    {
        return self::getPathTemplate('evaluation')->render([
            'project' => $project,
            'location' => $location,
            'processor' => $processor,
            'processor_version' => $processorVersion,
            'evaluation' => $evaluation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * human_review_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processor
     *
     * @return string The formatted human_review_config resource.
     */
    public static function humanReviewConfigName(string $project, string $location, string $processor): string
    {
        return self::getPathTemplate('humanReviewConfig')->render([
            'project' => $project,
            'location' => $location,
            'processor' => $processor,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a processor
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processor
     *
     * @return string The formatted processor resource.
     */
    public static function processorName(string $project, string $location, string $processor): string
    {
        return self::getPathTemplate('processor')->render([
            'project' => $project,
            'location' => $location,
            'processor' => $processor,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * processor_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processorType
     *
     * @return string The formatted processor_type resource.
     */
    public static function processorTypeName(string $project, string $location, string $processorType): string
    {
        return self::getPathTemplate('processorType')->render([
            'project' => $project,
            'location' => $location,
            'processor_type' => $processorType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * processor_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $processor
     * @param string $processorVersion
     *
     * @return string The formatted processor_version resource.
     */
    public static function processorVersionName(string $project, string $location, string $processor, string $processorVersion): string
    {
        return self::getPathTemplate('processorVersion')->render([
            'project' => $project,
            'location' => $location,
            'processor' => $processor,
            'processor_version' => $processorVersion,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - evaluation: projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}
     * - humanReviewConfig: projects/{project}/locations/{location}/processors/{processor}/humanReviewConfig
     * - location: projects/{project}/locations/{location}
     * - processor: projects/{project}/locations/{location}/processors/{processor}
     * - processorType: projects/{project}/locations/{location}/processorTypes/{processor_type}
     * - processorVersion: projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'documentai.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * LRO endpoint to batch process many documents. The output is written
     * to Cloud Storage as JSON in the [Document] format.
     *
     * The async variant is {@see self::batchProcessDocumentsAsync()} .
     *
     * @param BatchProcessRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchProcessDocuments(BatchProcessRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BatchProcessDocuments', $request, $callOptions)->wait();
    }

    /**
     * Creates a processor from the
     * [ProcessorType][google.cloud.documentai.v1.ProcessorType] provided. The
     * processor will be at `ENABLED` state by default after its creation.
     *
     * The async variant is {@see self::createProcessorAsync()} .
     *
     * @param CreateProcessorRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Processor
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createProcessor(CreateProcessorRequest $request, array $callOptions = []): Processor
    {
        return $this->startApiCall('CreateProcessor', $request, $callOptions)->wait();
    }

    /**
     * Deletes the processor, unloads all deployed model artifacts if it was
     * enabled and then deletes all artifacts associated with this processor.
     *
     * The async variant is {@see self::deleteProcessorAsync()} .
     *
     * @param DeleteProcessorRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteProcessor(DeleteProcessorRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteProcessor', $request, $callOptions)->wait();
    }

    /**
     * Deletes the processor version, all artifacts under the processor version
     * will be deleted.
     *
     * The async variant is {@see self::deleteProcessorVersionAsync()} .
     *
     * @param DeleteProcessorVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteProcessorVersion(DeleteProcessorVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteProcessorVersion', $request, $callOptions)->wait();
    }

    /**
     * Deploys the processor version.
     *
     * The async variant is {@see self::deployProcessorVersionAsync()} .
     *
     * @param DeployProcessorVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deployProcessorVersion(DeployProcessorVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeployProcessorVersion', $request, $callOptions)->wait();
    }

    /**
     * Disables a processor
     *
     * The async variant is {@see self::disableProcessorAsync()} .
     *
     * @param DisableProcessorRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function disableProcessor(DisableProcessorRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DisableProcessor', $request, $callOptions)->wait();
    }

    /**
     * Enables a processor
     *
     * The async variant is {@see self::enableProcessorAsync()} .
     *
     * @param EnableProcessorRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enableProcessor(EnableProcessorRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EnableProcessor', $request, $callOptions)->wait();
    }

    /**
     * Evaluates a ProcessorVersion against annotated documents, producing an
     * Evaluation.
     *
     * The async variant is {@see self::evaluateProcessorVersionAsync()} .
     *
     * @param EvaluateProcessorVersionRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function evaluateProcessorVersion(EvaluateProcessorVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EvaluateProcessorVersion', $request, $callOptions)->wait();
    }

    /**
     * Fetches processor types. Note that we don't use
     * [ListProcessorTypes][google.cloud.documentai.v1.DocumentProcessorService.ListProcessorTypes]
     * here, because it isn't paginated.
     *
     * The async variant is {@see self::fetchProcessorTypesAsync()} .
     *
     * @param FetchProcessorTypesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchProcessorTypesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchProcessorTypes(FetchProcessorTypesRequest $request, array $callOptions = []): FetchProcessorTypesResponse
    {
        return $this->startApiCall('FetchProcessorTypes', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a specific evaluation.
     *
     * The async variant is {@see self::getEvaluationAsync()} .
     *
     * @param GetEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Evaluation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEvaluation(GetEvaluationRequest $request, array $callOptions = []): Evaluation
    {
        return $this->startApiCall('GetEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Gets a processor detail.
     *
     * The async variant is {@see self::getProcessorAsync()} .
     *
     * @param GetProcessorRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Processor
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProcessor(GetProcessorRequest $request, array $callOptions = []): Processor
    {
        return $this->startApiCall('GetProcessor', $request, $callOptions)->wait();
    }

    /**
     * Gets a processor type detail.
     *
     * The async variant is {@see self::getProcessorTypeAsync()} .
     *
     * @param GetProcessorTypeRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProcessorType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProcessorType(GetProcessorTypeRequest $request, array $callOptions = []): ProcessorType
    {
        return $this->startApiCall('GetProcessorType', $request, $callOptions)->wait();
    }

    /**
     * Gets a processor version detail.
     *
     * The async variant is {@see self::getProcessorVersionAsync()} .
     *
     * @param GetProcessorVersionRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProcessorVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProcessorVersion(GetProcessorVersionRequest $request, array $callOptions = []): ProcessorVersion
    {
        return $this->startApiCall('GetProcessorVersion', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a set of evaluations for a given processor version.
     *
     * The async variant is {@see self::listEvaluationsAsync()} .
     *
     * @param ListEvaluationsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEvaluations(ListEvaluationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEvaluations', $request, $callOptions);
    }

    /**
     * Lists the processor types that exist.
     *
     * The async variant is {@see self::listProcessorTypesAsync()} .
     *
     * @param ListProcessorTypesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProcessorTypes(ListProcessorTypesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProcessorTypes', $request, $callOptions);
    }

    /**
     * Lists all versions of a processor.
     *
     * The async variant is {@see self::listProcessorVersionsAsync()} .
     *
     * @param ListProcessorVersionsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProcessorVersions(ListProcessorVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProcessorVersions', $request, $callOptions);
    }

    /**
     * Lists all processors which belong to this project.
     *
     * The async variant is {@see self::listProcessorsAsync()} .
     *
     * @param ListProcessorsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProcessors(ListProcessorsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProcessors', $request, $callOptions);
    }

    /**
     * Processes a single document.
     *
     * The async variant is {@see self::processDocumentAsync()} .
     *
     * @param ProcessRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProcessResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function processDocument(ProcessRequest $request, array $callOptions = []): ProcessResponse
    {
        return $this->startApiCall('ProcessDocument', $request, $callOptions)->wait();
    }

    /**
     * Send a document for Human Review. The input document should be processed by
     * the specified processor.
     *
     * The async variant is {@see self::reviewDocumentAsync()} .
     *
     * @param ReviewDocumentRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function reviewDocument(ReviewDocumentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ReviewDocument', $request, $callOptions)->wait();
    }

    /**
     * Set the default (active) version of a
     * [Processor][google.cloud.documentai.v1.Processor] that will be used in
     * [ProcessDocument][google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument]
     * and
     * [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments].
     *
     * The async variant is {@see self::setDefaultProcessorVersionAsync()} .
     *
     * @param SetDefaultProcessorVersionRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setDefaultProcessorVersion(SetDefaultProcessorVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetDefaultProcessorVersion', $request, $callOptions)->wait();
    }

    /**
     * Trains a new processor version.
     * Operation metadata is returned as
     * [TrainProcessorVersionMetadata][google.cloud.documentai.v1.TrainProcessorVersionMetadata].
     *
     * The async variant is {@see self::trainProcessorVersionAsync()} .
     *
     * @param TrainProcessorVersionRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function trainProcessorVersion(TrainProcessorVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('TrainProcessorVersion', $request, $callOptions)->wait();
    }

    /**
     * Undeploys the processor version.
     *
     * The async variant is {@see self::undeployProcessorVersionAsync()} .
     *
     * @param UndeployProcessorVersionRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeployProcessorVersion(UndeployProcessorVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UndeployProcessorVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see self::getLocationAsync()} .
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see self::listLocationsAsync()} .
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
