<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/schedule_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\CreateScheduleRequest;
use Google\Cloud\AIPlatform\V1\DeleteScheduleRequest;
use Google\Cloud\AIPlatform\V1\GetScheduleRequest;
use Google\Cloud\AIPlatform\V1\ListSchedulesRequest;
use Google\Cloud\AIPlatform\V1\ListSchedulesResponse;
use Google\Cloud\AIPlatform\V1\PauseScheduleRequest;
use Google\Cloud\AIPlatform\V1\ResumeScheduleRequest;
use Google\Cloud\AIPlatform\V1\Schedule;
use Google\Cloud\AIPlatform\V1\UpdateScheduleRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: A service for creating and managing Vertex AI's Schedule resources to
 * periodically launch shceudled runs to make API calls.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $scheduleServiceClient = new ScheduleServiceClient();
 * try {
 *     $formattedParent = $scheduleServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $schedule = new Schedule();
 *     $response = $scheduleServiceClient->createSchedule($formattedParent, $schedule);
 * } finally {
 *     $scheduleServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\AIPlatform\V1\Client\ScheduleServiceClient} to use the new
 * surface.
 */
class ScheduleServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.ScheduleService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $artifactNameTemplate;

    private static $contextNameTemplate;

    private static $customJobNameTemplate;

    private static $executionNameTemplate;

    private static $locationNameTemplate;

    private static $metadataStoreNameTemplate;

    private static $networkNameTemplate;

    private static $pipelineJobNameTemplate;

    private static $scheduleNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/schedule_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/schedule_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/schedule_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/schedule_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getArtifactNameTemplate()
    {
        if (self::$artifactNameTemplate == null) {
            self::$artifactNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}'
            );
        }

        return self::$artifactNameTemplate;
    }

    private static function getContextNameTemplate()
    {
        if (self::$contextNameTemplate == null) {
            self::$contextNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}/contexts/{context}'
            );
        }

        return self::$contextNameTemplate;
    }

    private static function getCustomJobNameTemplate()
    {
        if (self::$customJobNameTemplate == null) {
            self::$customJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/customJobs/{custom_job}'
            );
        }

        return self::$customJobNameTemplate;
    }

    private static function getExecutionNameTemplate()
    {
        if (self::$executionNameTemplate == null) {
            self::$executionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}/executions/{execution}'
            );
        }

        return self::$executionNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getMetadataStoreNameTemplate()
    {
        if (self::$metadataStoreNameTemplate == null) {
            self::$metadataStoreNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/metadataStores/{metadata_store}'
            );
        }

        return self::$metadataStoreNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate(
                'projects/{project}/global/networks/{network}'
            );
        }

        return self::$networkNameTemplate;
    }

    private static function getPipelineJobNameTemplate()
    {
        if (self::$pipelineJobNameTemplate == null) {
            self::$pipelineJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}'
            );
        }

        return self::$pipelineJobNameTemplate;
    }

    private static function getScheduleNameTemplate()
    {
        if (self::$scheduleNameTemplate == null) {
            self::$scheduleNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/schedules/{schedule}'
            );
        }

        return self::$scheduleNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'artifact' => self::getArtifactNameTemplate(),
                'context' => self::getContextNameTemplate(),
                'customJob' => self::getCustomJobNameTemplate(),
                'execution' => self::getExecutionNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'metadataStore' => self::getMetadataStoreNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'pipelineJob' => self::getPipelineJobNameTemplate(),
                'schedule' => self::getScheduleNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a artifact
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $artifact
     *
     * @return string The formatted artifact resource.
     */
    public static function artifactName(
        $project,
        $location,
        $metadataStore,
        $artifact
    ) {
        return self::getArtifactNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a context
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $context
     *
     * @return string The formatted context resource.
     */
    public static function contextName(
        $project,
        $location,
        $metadataStore,
        $context
    ) {
        return self::getContextNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a custom_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $customJob
     *
     * @return string The formatted custom_job resource.
     */
    public static function customJobName($project, $location, $customJob)
    {
        return self::getCustomJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'custom_job' => $customJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a execution
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $execution
     *
     * @return string The formatted execution resource.
     */
    public static function executionName(
        $project,
        $location,
        $metadataStore,
        $execution
    ) {
        return self::getExecutionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'execution' => $execution,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * metadata_store resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     *
     * @return string The formatted metadata_store resource.
     */
    public static function metadataStoreName(
        $project,
        $location,
        $metadataStore
    ) {
        return self::getMetadataStoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a pipeline_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $pipelineJob
     *
     * @return string The formatted pipeline_job resource.
     */
    public static function pipelineJobName($project, $location, $pipelineJob)
    {
        return self::getPipelineJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'pipeline_job' => $pipelineJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a schedule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schedule
     *
     * @return string The formatted schedule resource.
     */
    public static function scheduleName($project, $location, $schedule)
    {
        return self::getScheduleNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'schedule' => $schedule,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - artifact: projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}
     * - context: projects/{project}/locations/{location}/metadataStores/{metadata_store}/contexts/{context}
     * - customJob: projects/{project}/locations/{location}/customJobs/{custom_job}
     * - execution: projects/{project}/locations/{location}/metadataStores/{metadata_store}/executions/{execution}
     * - location: projects/{project}/locations/{location}
     * - metadataStore: projects/{project}/locations/{location}/metadataStores/{metadata_store}
     * - network: projects/{project}/global/networks/{network}
     * - pipelineJob: projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}
     * - schedule: projects/{project}/locations/{location}/schedules/{schedule}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a Schedule.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $formattedParent = $scheduleServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $schedule = new Schedule();
     *     $response = $scheduleServiceClient->createSchedule($formattedParent, $schedule);
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The resource name of the Location to create the Schedule in.
     *                               Format: `projects/{project}/locations/{location}`
     * @param Schedule $schedule     Required. The Schedule to create.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Schedule
     *
     * @throws ApiException if the remote call fails
     */
    public function createSchedule($parent, $schedule, array $optionalArgs = [])
    {
        $request = new CreateScheduleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSchedule($schedule);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateSchedule',
            Schedule::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a Schedule.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $formattedName = $scheduleServiceClient->scheduleName('[PROJECT]', '[LOCATION]', '[SCHEDULE]');
     *     $operationResponse = $scheduleServiceClient->deleteSchedule($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $scheduleServiceClient->deleteSchedule($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $scheduleServiceClient->resumeOperation($operationName, 'deleteSchedule');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Schedule resource to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/schedules/{schedule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSchedule($name, array $optionalArgs = [])
    {
        $request = new DeleteScheduleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteSchedule',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets a Schedule.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $formattedName = $scheduleServiceClient->scheduleName('[PROJECT]', '[LOCATION]', '[SCHEDULE]');
     *     $response = $scheduleServiceClient->getSchedule($formattedName);
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Schedule resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/schedules/{schedule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Schedule
     *
     * @throws ApiException if the remote call fails
     */
    public function getSchedule($name, array $optionalArgs = [])
    {
        $request = new GetScheduleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSchedule',
            Schedule::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists Schedules in a Location.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $formattedParent = $scheduleServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $scheduleServiceClient->listSchedules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $scheduleServiceClient->listSchedules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list the Schedules from.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the Schedules that match the filter expression. The following
     *           fields are supported:
     *
     *           * `display_name`: Supports `=`, `!=` comparisons, and `:` wildcard.
     *           * `state`: Supports `=` and `!=` comparisons.
     *           * `request`: Supports existence of the <request_type> check.
     *           (e.g. `create_pipeline_job_request:*` --> Schedule has
     *           create_pipeline_job_request).
     *           * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `start_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`, `>=` comparisons and `:*`
     *           existence check. Values must be in RFC 3339 format.
     *           * `next_run_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
     *           comparisons. Values must be in RFC 3339 format.
     *
     *
     *           Filter expressions can be combined together using logical operators
     *           (`NOT`, `AND` & `OR`).
     *           The syntax to define filter expression is based on
     *           https://google.aip.dev/160.
     *
     *           Examples:
     *
     *           * `state="ACTIVE" AND display_name:"my_schedule_*"`
     *           * `NOT display_name="my_schedule"`
     *           * `create_time>"2021-05-18T00:00:00Z"`
     *           * `end_time>"2021-05-18T00:00:00Z" OR NOT end_time:*`
     *           * `create_pipeline_job_request:*`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by. The default sort order is in
     *           ascending order. Use "desc" after a field name for descending. You can have
     *           multiple order_by fields provided.
     *
     *           For example, using "create_time desc, end_time" will order results by
     *           create time in descending order, and if there are multiple schedules having
     *           the same create time, order them by the end time in ascending order.
     *
     *           If order_by is not specified, it will order by default with create_time in
     *           descending order.
     *
     *           Supported fields:
     *           * `create_time`
     *           * `start_time`
     *           * `end_time`
     *           * `next_run_time`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSchedules($parent, array $optionalArgs = [])
    {
        $request = new ListSchedulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSchedules',
            $optionalArgs,
            ListSchedulesResponse::class,
            $request
        );
    }

    /**
     * Pauses a Schedule. Will mark
     * [Schedule.state][google.cloud.aiplatform.v1.Schedule.state] to 'PAUSED'. If
     * the schedule is paused, no new runs will be created. Already created runs
     * will NOT be paused or canceled.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $formattedName = $scheduleServiceClient->scheduleName('[PROJECT]', '[LOCATION]', '[SCHEDULE]');
     *     $scheduleServiceClient->pauseSchedule($formattedName);
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Schedule resource to be paused.
     *                             Format:
     *                             `projects/{project}/locations/{location}/schedules/{schedule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function pauseSchedule($name, array $optionalArgs = [])
    {
        $request = new PauseScheduleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'PauseSchedule',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Resumes a paused Schedule to start scheduling new runs. Will mark
     * [Schedule.state][google.cloud.aiplatform.v1.Schedule.state] to 'ACTIVE'.
     * Only paused Schedule can be resumed.
     *
     * When the Schedule is resumed, new runs will be scheduled starting from the
     * next execution time after the current time based on the time_specification
     * in the Schedule. If [Schedule.catchUp][] is set up true, all
     * missed runs will be scheduled for backfill first.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $formattedName = $scheduleServiceClient->scheduleName('[PROJECT]', '[LOCATION]', '[SCHEDULE]');
     *     $scheduleServiceClient->resumeSchedule($formattedName);
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Schedule resource to be resumed.
     *                             Format:
     *                             `projects/{project}/locations/{location}/schedules/{schedule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $catchUp
     *           Optional. Whether to backfill missed runs when the schedule is resumed from
     *           PAUSED state. If set to true, all missed runs will be scheduled. New runs
     *           will be scheduled after the backfill is complete. This will also update
     *           [Schedule.catch_up][google.cloud.aiplatform.v1.Schedule.catch_up] field.
     *           Default to false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function resumeSchedule($name, array $optionalArgs = [])
    {
        $request = new ResumeScheduleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['catchUp'])) {
            $request->setCatchUp($optionalArgs['catchUp']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ResumeSchedule',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates an active or paused Schedule.
     *
     * When the Schedule is updated, new runs will be scheduled starting from the
     * updated next execution time after the update time based on the
     * time_specification in the updated Schedule. All unstarted runs before the
     * update time will be skipped while already created runs will NOT be paused
     * or canceled.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $schedule = new Schedule();
     *     $updateMask = new FieldMask();
     *     $response = $scheduleServiceClient->updateSchedule($schedule, $updateMask);
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param Schedule  $schedule     Required. The Schedule which replaces the resource on the server.
     *                                The following restrictions will be applied:
     *                                * The scheduled request type cannot be changed.
     *                                * The output_only fields will be ignored if specified.
     * @param FieldMask $updateMask   Required. The update mask applies to the resource. See
     *                                [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Schedule
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSchedule(
        $schedule,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateScheduleRequest();
        $requestParamHeaders = [];
        $request->setSchedule($schedule);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['schedule.name'] = $schedule->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateSchedule',
            Schedule::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $response = $scheduleServiceClient->getLocation();
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $scheduleServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $scheduleServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $scheduleServiceClient->getIamPolicy($resource);
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $scheduleServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $scheduleServiceClient = new ScheduleServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $scheduleServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $scheduleServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
