<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/privacy/dlp/v2/dlp.proto

namespace Google\Cloud\Dlp\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for discovery to scan resources for profile generation.
 * Only one discovery configuration may exist per organization, folder,
 * or project.
 * The generated data profiles are retained according to the
 * [data retention policy]
 * (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
 *
 * Generated from protobuf message <code>google.privacy.dlp.v2.DiscoveryConfig</code>
 */
class DiscoveryConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Unique resource name for the DiscoveryConfig, assigned by the service when
     * the DiscoveryConfig is created, for example
     * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Display name (max 100 chars)
     *
     * Generated from protobuf field <code>string display_name = 11;</code>
     */
    protected $display_name = '';
    /**
     * Only set when the parent is an org.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     */
    protected $org_config = null;
    /**
     * Detection logic for profile generation.
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     *
     * Generated from protobuf field <code>repeated string inspect_templates = 3;</code>
     */
    private $inspect_templates;
    /**
     * Actions to execute at the completion of scanning.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     */
    private $actions;
    /**
     * Target to match against for determining what to scan and how frequently.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     */
    private $targets;
    /**
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $errors;
    /**
     * Output only. The creation timestamp of a DiscoveryConfig.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The last update timestamp of a DiscoveryConfig.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The timestamp of the last time this config was executed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_run_time = null;
    /**
     * Required. A status for this configuration.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $status = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Unique resource name for the DiscoveryConfig, assigned by the service when
     *           the DiscoveryConfig is created, for example
     *           `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     *     @type string $display_name
     *           Display name (max 100 chars)
     *     @type \Google\Cloud\Dlp\V2\DiscoveryConfig\OrgConfig $org_config
     *           Only set when the parent is an org.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $inspect_templates
     *           Detection logic for profile generation.
     *           Not all template features are used by Discovery. FindingLimits,
     *           include_quote and exclude_info_types have no impact on
     *           Discovery.
     *           Multiple templates may be provided if there is data in multiple regions.
     *           At most one template must be specified per-region (including "global").
     *           Each region is scanned using the applicable template. If no region-specific
     *           template is specified, but a "global" template is specified, it will be
     *           copied to that region and used instead. If no global or region-specific
     *           template is provided for a region with data, that region's data will not be
     *           scanned.
     *           For more information, see
     *           https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     *     @type array<\Google\Cloud\Dlp\V2\DataProfileAction>|\Google\Protobuf\Internal\RepeatedField $actions
     *           Actions to execute at the completion of scanning.
     *     @type array<\Google\Cloud\Dlp\V2\DiscoveryTarget>|\Google\Protobuf\Internal\RepeatedField $targets
     *           Target to match against for determining what to scan and how frequently.
     *     @type array<\Google\Cloud\Dlp\V2\Error>|\Google\Protobuf\Internal\RepeatedField $errors
     *           Output only. A stream of errors encountered when the config was activated.
     *           Repeated errors may result in the config automatically being paused. Output
     *           only field. Will return the last 100 errors. Whenever the config is
     *           modified this list will be cleared.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation timestamp of a DiscoveryConfig.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last update timestamp of a DiscoveryConfig.
     *     @type \Google\Protobuf\Timestamp $last_run_time
     *           Output only. The timestamp of the last time this config was executed.
     *     @type int $status
     *           Required. A status for this configuration.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Privacy\Dlp\V2\Dlp::initOnce();
        parent::__construct($data);
    }

    /**
     * Unique resource name for the DiscoveryConfig, assigned by the service when
     * the DiscoveryConfig is created, for example
     * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Unique resource name for the DiscoveryConfig, assigned by the service when
     * the DiscoveryConfig is created, for example
     * `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Display name (max 100 chars)
     *
     * Generated from protobuf field <code>string display_name = 11;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Display name (max 100 chars)
     *
     * Generated from protobuf field <code>string display_name = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Only set when the parent is an org.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     * @return \Google\Cloud\Dlp\V2\DiscoveryConfig\OrgConfig|null
     */
    public function getOrgConfig()
    {
        return $this->org_config;
    }

    public function hasOrgConfig()
    {
        return isset($this->org_config);
    }

    public function clearOrgConfig()
    {
        unset($this->org_config);
    }

    /**
     * Only set when the parent is an org.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.DiscoveryConfig.OrgConfig org_config = 2;</code>
     * @param \Google\Cloud\Dlp\V2\DiscoveryConfig\OrgConfig $var
     * @return $this
     */
    public function setOrgConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\DiscoveryConfig\OrgConfig::class);
        $this->org_config = $var;

        return $this;
    }

    /**
     * Detection logic for profile generation.
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     *
     * Generated from protobuf field <code>repeated string inspect_templates = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInspectTemplates()
    {
        return $this->inspect_templates;
    }

    /**
     * Detection logic for profile generation.
     * Not all template features are used by Discovery. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * Discovery.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
     *
     * Generated from protobuf field <code>repeated string inspect_templates = 3;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInspectTemplates($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->inspect_templates = $arr;

        return $this;
    }

    /**
     * Actions to execute at the completion of scanning.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getActions()
    {
        return $this->actions;
    }

    /**
     * Actions to execute at the completion of scanning.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.DataProfileAction actions = 4;</code>
     * @param array<\Google\Cloud\Dlp\V2\DataProfileAction>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setActions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dlp\V2\DataProfileAction::class);
        $this->actions = $arr;

        return $this;
    }

    /**
     * Target to match against for determining what to scan and how frequently.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTargets()
    {
        return $this->targets;
    }

    /**
     * Target to match against for determining what to scan and how frequently.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.DiscoveryTarget targets = 5;</code>
     * @param array<\Google\Cloud\Dlp\V2\DiscoveryTarget>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTargets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dlp\V2\DiscoveryTarget::class);
        $this->targets = $arr;

        return $this;
    }

    /**
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * Output only. A stream of errors encountered when the config was activated.
     * Repeated errors may result in the config automatically being paused. Output
     * only field. Will return the last 100 errors. Whenever the config is
     * modified this list will be cleared.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.Error errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Dlp\V2\Error>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setErrors($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dlp\V2\Error::class);
        $this->errors = $arr;

        return $this;
    }

    /**
     * Output only. The creation timestamp of a DiscoveryConfig.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation timestamp of a DiscoveryConfig.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last update timestamp of a DiscoveryConfig.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last update timestamp of a DiscoveryConfig.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp of the last time this config was executed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastRunTime()
    {
        return $this->last_run_time;
    }

    public function hasLastRunTime()
    {
        return isset($this->last_run_time);
    }

    public function clearLastRunTime()
    {
        unset($this->last_run_time);
    }

    /**
     * Output only. The timestamp of the last time this config was executed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_run_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastRunTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_run_time = $var;

        return $this;
    }

    /**
     * Required. A status for this configuration.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Required. A status for this configuration.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.DiscoveryConfig.Status status = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dlp\V2\DiscoveryConfig\Status::class);
        $this->status = $var;

        return $this;
    }

}

