<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/space.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A space in Google Chat. Spaces are conversations between two or more users
 * or 1:1 messages between a user and a Chat app.
 *
 * Generated from protobuf message <code>google.chat.v1.Space</code>
 */
class Space extends \Google\Protobuf\Internal\Message
{
    /**
     * Resource name of the space.
     * Format: `spaces/{space}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @deprecated
     */
    protected $type = 0;
    /**
     * The type of space. Required when creating a space or updating the space
     * type of a space. Output only for other usage.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
     */
    protected $space_type = 0;
    /**
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     *
     * Generated from protobuf field <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $single_user_bot_dm = false;
    /**
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     *
     * Generated from protobuf field <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @deprecated
     */
    protected $threaded = false;
    /**
     * The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     * If you receive the error message `ALREADY_EXISTS` when creating a space or
     * updating the `displayName`, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use
     * this display name.
     * For direct messages, this field might be empty.
     * Supports up to 128 characters.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     */
    protected $display_name = '';
    /**
     * Immutable. Whether this space permits any Google Chat user as a member.
     * Input when creating a space in a Google Workspace organization. Omit this
     * field when creating spaces in the following conditions:
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *   * The space is used to [import data to Google Chat]
     *     (https://developers.google.com/chat/api/guides/import-data-overview)
     *     because import mode spaces must only permit members from the same
     *     Google Workspace organization. However, as part of the [Google
     *     Workspace Developer Preview
     *     Program](https://developers.google.com/workspace/preview), import mode
     *     spaces can permit any Google Chat user so this field can then be set
     *     for import mode spaces.
     * For existing spaces, this field is output only.
     *
     * Generated from protobuf field <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $external_user_allowed = false;
    /**
     * Output only. The threading state in the Chat space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $space_threading_state = 0;
    /**
     * Details about the space including description and rules.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     */
    protected $space_details = null;
    /**
     * The message history state for messages and threads in this space.
     *
     * Generated from protobuf field <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
     */
    protected $space_history_state = 0;
    /**
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     *
     * Generated from protobuf field <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $import_mode = false;
    /**
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Timestamp of the last message in the space.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_active_time = null;
    /**
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     * To support admin install, your Chat app must feature direct messaging.
     *
     * Generated from protobuf field <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $admin_installed = false;
    /**
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $membership_count = null;
    /**
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $access_settings = null;
    /**
     * Output only. The URI for a user to access the space.
     *
     * Generated from protobuf field <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $space_uri = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Resource name of the space.
     *           Format: `spaces/{space}`
     *     @type int $type
     *           Output only. Deprecated: Use `space_type` instead.
     *           The type of a space.
     *     @type int $space_type
     *           The type of space. Required when creating a space or updating the space
     *           type of a space. Output only for other usage.
     *     @type bool $single_user_bot_dm
     *           Optional. Whether the space is a DM between a Chat app and a single
     *           human.
     *     @type bool $threaded
     *           Output only. Deprecated: Use `spaceThreadingState` instead.
     *           Whether messages are threaded in this space.
     *     @type string $display_name
     *           The space's display name. Required when [creating a
     *           space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     *           If you receive the error message `ALREADY_EXISTS` when creating a space or
     *           updating the `displayName`, try a different `displayName`. An
     *           existing space within the Google Workspace organization might already use
     *           this display name.
     *           For direct messages, this field might be empty.
     *           Supports up to 128 characters.
     *     @type bool $external_user_allowed
     *           Immutable. Whether this space permits any Google Chat user as a member.
     *           Input when creating a space in a Google Workspace organization. Omit this
     *           field when creating spaces in the following conditions:
     *             * The authenticated user uses a consumer account (unmanaged user
     *               account). By default, a space created by a consumer account permits any
     *               Google Chat user.
     *             * The space is used to [import data to Google Chat]
     *               (https://developers.google.com/chat/api/guides/import-data-overview)
     *               because import mode spaces must only permit members from the same
     *               Google Workspace organization. However, as part of the [Google
     *               Workspace Developer Preview
     *               Program](https://developers.google.com/workspace/preview), import mode
     *               spaces can permit any Google Chat user so this field can then be set
     *               for import mode spaces.
     *           For existing spaces, this field is output only.
     *     @type int $space_threading_state
     *           Output only. The threading state in the Chat space.
     *     @type \Google\Apps\Chat\V1\Space\SpaceDetails $space_details
     *           Details about the space including description and rules.
     *     @type int $space_history_state
     *           The message history state for messages and threads in this space.
     *     @type bool $import_mode
     *           Optional. Whether this space is created in `Import Mode` as part of a data
     *           migration into Google Workspace. While spaces are being imported, they
     *           aren't visible to users until the import is complete.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Optional. Immutable. For spaces created in Chat, the time the space was
     *           created. This field is output only, except when used in import mode spaces.
     *           For import mode spaces, set this field to the historical timestamp at which
     *           the space was created in the source in order to preserve the original
     *           creation time.
     *           Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     *     @type \Google\Protobuf\Timestamp $last_active_time
     *           Output only. Timestamp of the last message in the space.
     *     @type bool $admin_installed
     *           Output only. For direct message (DM) spaces with a Chat app, whether the
     *           space was created by a Google Workspace administrator. Administrators can
     *           install and set up a direct message with a Chat app on behalf of users in
     *           their organization.
     *           To support admin install, your Chat app must feature direct messaging.
     *     @type \Google\Apps\Chat\V1\Space\MembershipCount $membership_count
     *           Output only. The count of joined memberships grouped by member type.
     *           Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     *           `GROUP_CHAT`.
     *     @type \Google\Apps\Chat\V1\Space\AccessSettings $access_settings
     *           Optional. Specifies the [access
     *           setting](https://support.google.com/chat/answer/11971020) of the space.
     *           Only populated when the `space_type` is `SPACE`.
     *     @type string $space_uri
     *           Output only. The URI for a user to access the space.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Space::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name of the space.
     * Format: `spaces/{space}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Resource name of the space.
     * Format: `spaces/{space}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     * @deprecated
     */
    public function getType()
    {
        @trigger_error('type is deprecated.', E_USER_DEPRECATED);
        return $this->type;
    }

    /**
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setType($var)
    {
        @trigger_error('type is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\Space\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * The type of space. Required when creating a space or updating the space
     * type of a space. Output only for other usage.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
     * @return int
     */
    public function getSpaceType()
    {
        return $this->space_type;
    }

    /**
     * The type of space. Required when creating a space or updating the space
     * type of a space. Output only for other usage.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceType space_type = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setSpaceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\Space\SpaceType::class);
        $this->space_type = $var;

        return $this;
    }

    /**
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     *
     * Generated from protobuf field <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getSingleUserBotDm()
    {
        return $this->single_user_bot_dm;
    }

    /**
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     *
     * Generated from protobuf field <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setSingleUserBotDm($var)
    {
        GPBUtil::checkBool($var);
        $this->single_user_bot_dm = $var;

        return $this;
    }

    /**
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     *
     * Generated from protobuf field <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     * @deprecated
     */
    public function getThreaded()
    {
        @trigger_error('threaded is deprecated.', E_USER_DEPRECATED);
        return $this->threaded;
    }

    /**
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     *
     * Generated from protobuf field <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setThreaded($var)
    {
        @trigger_error('threaded is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->threaded = $var;

        return $this;
    }

    /**
     * The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     * If you receive the error message `ALREADY_EXISTS` when creating a space or
     * updating the `displayName`, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use
     * this display name.
     * For direct messages, this field might be empty.
     * Supports up to 128 characters.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
     * If you receive the error message `ALREADY_EXISTS` when creating a space or
     * updating the `displayName`, try a different `displayName`. An
     * existing space within the Google Workspace organization might already use
     * this display name.
     * For direct messages, this field might be empty.
     * Supports up to 128 characters.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Immutable. Whether this space permits any Google Chat user as a member.
     * Input when creating a space in a Google Workspace organization. Omit this
     * field when creating spaces in the following conditions:
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *   * The space is used to [import data to Google Chat]
     *     (https://developers.google.com/chat/api/guides/import-data-overview)
     *     because import mode spaces must only permit members from the same
     *     Google Workspace organization. However, as part of the [Google
     *     Workspace Developer Preview
     *     Program](https://developers.google.com/workspace/preview), import mode
     *     spaces can permit any Google Chat user so this field can then be set
     *     for import mode spaces.
     * For existing spaces, this field is output only.
     *
     * Generated from protobuf field <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return bool
     */
    public function getExternalUserAllowed()
    {
        return $this->external_user_allowed;
    }

    /**
     * Immutable. Whether this space permits any Google Chat user as a member.
     * Input when creating a space in a Google Workspace organization. Omit this
     * field when creating spaces in the following conditions:
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     *   * The space is used to [import data to Google Chat]
     *     (https://developers.google.com/chat/api/guides/import-data-overview)
     *     because import mode spaces must only permit members from the same
     *     Google Workspace organization. However, as part of the [Google
     *     Workspace Developer Preview
     *     Program](https://developers.google.com/workspace/preview), import mode
     *     spaces can permit any Google Chat user so this field can then be set
     *     for import mode spaces.
     * For existing spaces, this field is output only.
     *
     * Generated from protobuf field <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param bool $var
     * @return $this
     */
    public function setExternalUserAllowed($var)
    {
        GPBUtil::checkBool($var);
        $this->external_user_allowed = $var;

        return $this;
    }

    /**
     * Output only. The threading state in the Chat space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getSpaceThreadingState()
    {
        return $this->space_threading_state;
    }

    /**
     * Output only. The threading state in the Chat space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setSpaceThreadingState($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\Space\SpaceThreadingState::class);
        $this->space_threading_state = $var;

        return $this;
    }

    /**
     * Details about the space including description and rules.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     * @return \Google\Apps\Chat\V1\Space\SpaceDetails|null
     */
    public function getSpaceDetails()
    {
        return $this->space_details;
    }

    public function hasSpaceDetails()
    {
        return isset($this->space_details);
    }

    public function clearSpaceDetails()
    {
        unset($this->space_details);
    }

    /**
     * Details about the space including description and rules.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceDetails space_details = 11;</code>
     * @param \Google\Apps\Chat\V1\Space\SpaceDetails $var
     * @return $this
     */
    public function setSpaceDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space\SpaceDetails::class);
        $this->space_details = $var;

        return $this;
    }

    /**
     * The message history state for messages and threads in this space.
     *
     * Generated from protobuf field <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
     * @return int
     */
    public function getSpaceHistoryState()
    {
        return $this->space_history_state;
    }

    /**
     * The message history state for messages and threads in this space.
     *
     * Generated from protobuf field <code>.google.chat.v1.HistoryState space_history_state = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setSpaceHistoryState($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\HistoryState::class);
        $this->space_history_state = $var;

        return $this;
    }

    /**
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     *
     * Generated from protobuf field <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getImportMode()
    {
        return $this->import_mode;
    }

    /**
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     *
     * Generated from protobuf field <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setImportMode($var)
    {
        GPBUtil::checkBool($var);
        $this->import_mode = $var;

        return $this;
    }

    /**
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp of the last message in the space.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastActiveTime()
    {
        return $this->last_active_time;
    }

    public function hasLastActiveTime()
    {
        return isset($this->last_active_time);
    }

    public function clearLastActiveTime()
    {
        unset($this->last_active_time);
    }

    /**
     * Output only. Timestamp of the last message in the space.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastActiveTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_active_time = $var;

        return $this;
    }

    /**
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     * To support admin install, your Chat app must feature direct messaging.
     *
     * Generated from protobuf field <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getAdminInstalled()
    {
        return $this->admin_installed;
    }

    /**
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     * To support admin install, your Chat app must feature direct messaging.
     *
     * Generated from protobuf field <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setAdminInstalled($var)
    {
        GPBUtil::checkBool($var);
        $this->admin_installed = $var;

        return $this;
    }

    /**
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\Space\MembershipCount|null
     */
    public function getMembershipCount()
    {
        return $this->membership_count;
    }

    public function hasMembershipCount()
    {
        return isset($this->membership_count);
    }

    public function clearMembershipCount()
    {
        unset($this->membership_count);
    }

    /**
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\Space\MembershipCount $var
     * @return $this
     */
    public function setMembershipCount($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space\MembershipCount::class);
        $this->membership_count = $var;

        return $this;
    }

    /**
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Apps\Chat\V1\Space\AccessSettings|null
     */
    public function getAccessSettings()
    {
        return $this->access_settings;
    }

    public function hasAccessSettings()
    {
        return isset($this->access_settings);
    }

    public function clearAccessSettings()
    {
        unset($this->access_settings);
    }

    /**
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Apps\Chat\V1\Space\AccessSettings $var
     * @return $this
     */
    public function setAccessSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space\AccessSettings::class);
        $this->access_settings = $var;

        return $this;
    }

    /**
     * Output only. The URI for a user to access the space.
     *
     * Generated from protobuf field <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSpaceUri()
    {
        return $this->space_uri;
    }

    /**
     * Output only. The URI for a user to access the space.
     *
     * Generated from protobuf field <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSpaceUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->space_uri = $var;

        return $this;
    }

}

