<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/analytics/data/v1alpha/analytics_data_api.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Analytics\Data\V1alpha\Client;

use Google\Analytics\Data\V1alpha\AudienceList;
use Google\Analytics\Data\V1alpha\CreateAudienceListRequest;
use Google\Analytics\Data\V1alpha\CreateRecurringAudienceListRequest;
use Google\Analytics\Data\V1alpha\GetAudienceListRequest;
use Google\Analytics\Data\V1alpha\GetRecurringAudienceListRequest;
use Google\Analytics\Data\V1alpha\ListAudienceListsRequest;
use Google\Analytics\Data\V1alpha\ListRecurringAudienceListsRequest;
use Google\Analytics\Data\V1alpha\QueryAudienceListRequest;
use Google\Analytics\Data\V1alpha\QueryAudienceListResponse;
use Google\Analytics\Data\V1alpha\RecurringAudienceList;
use Google\Analytics\Data\V1alpha\RunFunnelReportRequest;
use Google\Analytics\Data\V1alpha\RunFunnelReportResponse;
use Google\Analytics\Data\V1alpha\Segment;
use Google\Analytics\Data\V1alpha\SheetExportAudienceListRequest;
use Google\Analytics\Data\V1alpha\SheetExportAudienceListResponse;
use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Google Analytics reporting data service.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @method PromiseInterface createAudienceListAsync(CreateAudienceListRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRecurringAudienceListAsync(CreateRecurringAudienceListRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAudienceListAsync(GetAudienceListRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRecurringAudienceListAsync(GetRecurringAudienceListRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAudienceListsAsync(ListAudienceListsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRecurringAudienceListsAsync(ListRecurringAudienceListsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface queryAudienceListAsync(QueryAudienceListRequest $request, array $optionalArgs = [])
 * @method PromiseInterface runFunnelReportAsync(RunFunnelReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface sheetExportAudienceListAsync(SheetExportAudienceListRequest $request, array $optionalArgs = [])
 */
final class AlphaAnalyticsDataClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.analytics.data.v1alpha.AlphaAnalyticsData';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'analyticsdata.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'analyticsdata.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/analytics',
        'https://www.googleapis.com/auth/analytics.readonly',
        'https://www.googleapis.com/auth/drive',
        'https://www.googleapis.com/auth/drive.file',
        'https://www.googleapis.com/auth/spreadsheets',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/alpha_analytics_data_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/alpha_analytics_data_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/alpha_analytics_data_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/alpha_analytics_data_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     *
     * @experimental
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     *
     * @experimental
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * audience_list resource.
     *
     * @param string $property
     * @param string $audienceList
     *
     * @return string The formatted audience_list resource.
     *
     * @experimental
     */
    public static function audienceListName(string $property, string $audienceList): string
    {
        return self::getPathTemplate('audienceList')->render([
            'property' => $property,
            'audience_list' => $audienceList,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a property
     * resource.
     *
     * @param string $property
     *
     * @return string The formatted property resource.
     *
     * @experimental
     */
    public static function propertyName(string $property): string
    {
        return self::getPathTemplate('property')->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * recurring_audience_list resource.
     *
     * @param string $property
     * @param string $recurringAudienceList
     *
     * @return string The formatted recurring_audience_list resource.
     *
     * @experimental
     */
    public static function recurringAudienceListName(string $property, string $recurringAudienceList): string
    {
        return self::getPathTemplate('recurringAudienceList')->render([
            'property' => $property,
            'recurring_audience_list' => $recurringAudienceList,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - audienceList: properties/{property}/audienceLists/{audience_list}
     * - property: properties/{property}
     * - recurringAudienceList: properties/{property}/recurringAudienceLists/{recurring_audience_list}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'analyticsdata.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an audience list for later retrieval. This method quickly returns
     * the audience list's resource name and initiates a long running asynchronous
     * request to form an audience list. To list the users in an audience list,
     * first create the audience list through this method and then send the
     * audience resource name to the `QueryAudienceList` method.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * An audience list is a snapshot of the users currently in the audience at
     * the time of audience list creation. Creating audience lists for one
     * audience on different days will return different results as users enter and
     * exit the audience.
     *
     * Audiences in Google Analytics 4 allow you to segment your users in the ways
     * that are important to your business. To learn more, see
     * https://support.google.com/analytics/answer/9267572. Audience lists contain
     * the users in each audience.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * The async variant is {@see AlphaAnalyticsDataClient::createAudienceListAsync()}
     * .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/create_audience_list.php
     *
     * @param CreateAudienceListRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createAudienceList(CreateAudienceListRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAudienceList', $request, $callOptions)->wait();
    }

    /**
     * Creates a recurring audience list. Recurring audience lists produces new
     * audience lists each day. Audience lists are users in an audience at the
     * time of the list's creation.
     *
     * A recurring audience list ensures that you have audience list based on the
     * most recent data available for use each day. If you manually create
     * audience list, you don't know when an audience list based on an additional
     * day's data is available. This recurring audience list automates the
     * creation of an audience list when an additional day's data is available.
     * You will consume fewer quota tokens by using recurring audience list versus
     * manually creating audience list at various times of day trying to guess
     * when an additional day's data is ready.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * The async variant is
     * {@see AlphaAnalyticsDataClient::createRecurringAudienceListAsync()} .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/create_recurring_audience_list.php
     *
     * @param CreateRecurringAudienceListRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RecurringAudienceList
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createRecurringAudienceList(CreateRecurringAudienceListRequest $request, array $callOptions = []): RecurringAudienceList
    {
        return $this->startApiCall('CreateRecurringAudienceList', $request, $callOptions)->wait();
    }

    /**
     * Gets configuration metadata about a specific audience list. This method
     * can be used to understand an audience list after it has been created.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * The async variant is {@see AlphaAnalyticsDataClient::getAudienceListAsync()} .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/get_audience_list.php
     *
     * @param GetAudienceListRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AudienceList
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAudienceList(GetAudienceListRequest $request, array $callOptions = []): AudienceList
    {
        return $this->startApiCall('GetAudienceList', $request, $callOptions)->wait();
    }

    /**
     * Gets configuration metadata about a specific recurring audience list. This
     * method can be used to understand a recurring audience list's state after it
     * has been created. For example, a recurring audience list resource will
     * generate audience list instances for each day, and this method can be used
     * to get the resource name of the most recent audience list instance.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * The async variant is
     * {@see AlphaAnalyticsDataClient::getRecurringAudienceListAsync()} .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/get_recurring_audience_list.php
     *
     * @param GetRecurringAudienceListRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RecurringAudienceList
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getRecurringAudienceList(GetRecurringAudienceListRequest $request, array $callOptions = []): RecurringAudienceList
    {
        return $this->startApiCall('GetRecurringAudienceList', $request, $callOptions)->wait();
    }

    /**
     * Lists all audience lists for a property. This method can be used for you to
     * find and reuse existing audience lists rather than creating unnecessary new
     * audience lists. The same audience can have multiple audience lists that
     * represent the list of users that were in an audience on different days.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * The async variant is {@see AlphaAnalyticsDataClient::listAudienceListsAsync()} .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/list_audience_lists.php
     *
     * @param ListAudienceListsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAudienceLists(ListAudienceListsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAudienceLists', $request, $callOptions);
    }

    /**
     * Lists all recurring audience lists for a property. This method can be used
     * for you to find and reuse existing recurring audience lists rather than
     * creating unnecessary new recurring audience lists. The same audience can
     * have multiple recurring audience lists that represent different dimension
     * combinations; for example, just the dimension `deviceId` or both the
     * dimensions `deviceId` and `userId`.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * The async variant is
     * {@see AlphaAnalyticsDataClient::listRecurringAudienceListsAsync()} .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/list_recurring_audience_lists.php
     *
     * @param ListRecurringAudienceListsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listRecurringAudienceLists(ListRecurringAudienceListsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRecurringAudienceLists', $request, $callOptions);
    }

    /**
     * Retrieves an audience list of users. After creating an audience, the users
     * are not immediately available for listing. First, a request to
     * `CreateAudienceList` is necessary to create an audience list of users, and
     * then second, this method is used to retrieve the users in the audience
     * list.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * Audiences in Google Analytics 4 allow you to segment your users in the ways
     * that are important to your business. To learn more, see
     * https://support.google.com/analytics/answer/9267572.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * The async variant is {@see AlphaAnalyticsDataClient::queryAudienceListAsync()} .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/query_audience_list.php
     *
     * @param QueryAudienceListRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return QueryAudienceListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function queryAudienceList(QueryAudienceListRequest $request, array $callOptions = []): QueryAudienceListResponse
    {
        return $this->startApiCall('QueryAudienceList', $request, $callOptions)->wait();
    }

    /**
     * Returns a customized funnel report of your Google Analytics event data. The
     * data returned from the API is as a table with columns for the requested
     * dimensions and metrics.
     *
     * Funnel exploration lets you visualize the steps your users take to complete
     * a task and quickly see how well they are succeeding or failing at each
     * step. For example, how do prospects become shoppers and then become buyers?
     * How do one time buyers become repeat buyers? With this information, you can
     * improve inefficient or abandoned customer journeys. To learn more, see [GA4
     * Funnel Explorations](https://support.google.com/analytics/answer/9327974).
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the [Google Analytics Data API Funnel
     * Reporting
     * Feedback](https://docs.google.com/forms/d/e/1FAIpQLSdwOlQDJAUoBiIgUZZ3S_Lwi8gr7Bb0k1jhvc-DEg7Rol3UjA/viewform).
     *
     * The async variant is {@see AlphaAnalyticsDataClient::runFunnelReportAsync()} .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/run_funnel_report.php
     *
     * @param RunFunnelReportRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RunFunnelReportResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function runFunnelReport(RunFunnelReportRequest $request, array $callOptions = []): RunFunnelReportResponse
    {
        return $this->startApiCall('RunFunnelReport', $request, $callOptions)->wait();
    }

    /**
     * Exports an audience list of users to a Google Sheet. After creating an
     * audience, the users are not immediately available for listing. First, a
     * request to `CreateAudienceList` is necessary to create an audience list of
     * users, and then second, this method is used to export those users in the
     * audience list to a Google Sheet.
     *
     * See [Creating an Audience
     * List](https://developers.google.com/analytics/devguides/reporting/data/v1/audience-list-basics)
     * for an introduction to Audience Lists with examples.
     *
     * Audiences in Google Analytics 4 allow you to segment your users in the ways
     * that are important to your business. To learn more, see
     * https://support.google.com/analytics/answer/9267572.
     *
     * This method is introduced at alpha stability with the intention of
     * gathering feedback on syntax and capabilities before entering beta. To give
     * your feedback on this API, complete the
     * [Google Analytics Audience Export API
     * Feedback](https://forms.gle/EeA5u5LW6PEggtCEA) form.
     *
     * The async variant is
     * {@see AlphaAnalyticsDataClient::sheetExportAudienceListAsync()} .
     *
     * @example samples/V1alpha/AlphaAnalyticsDataClient/sheet_export_audience_list.php
     *
     * @param SheetExportAudienceListRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SheetExportAudienceListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function sheetExportAudienceList(SheetExportAudienceListRequest $request, array $callOptions = []): SheetExportAudienceListResponse
    {
        return $this->startApiCall('SheetExportAudienceList', $request, $callOptions)->wait();
    }
}
